/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.configuration;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.tags.Tag;
import jakarta.annotation.PostConstruct;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0017J\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/sip3/twig/ce/configuration/SwaggerCustomization;", "", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "applySecurityConfiguration", "", "openApi", "Lio/swagger/v3/oas/models/OpenAPI;", "init", "tagOrder", "", "tag", "Lio/swagger/v3/oas/models/tags/Tag;", "(Lio/swagger/v3/oas/models/tags/Tag;)Ljava/lang/Integer;", "sip3-twig-ce"})
public class SwaggerCustomization {
    public String description;

    @NotNull
    public final String getDescription() {
        String string = this.description;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"description");
        return null;
    }

    public final void setDescription(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.description = string;
    }

    @PostConstruct
    public void init() {
        String string;
        URL uRL = this.getClass().getClassLoader().getResource("description/twig-api.md");
        if (uRL != null) {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            string = new String(byArray, charset);
        } else {
            string = "";
        }
        this.setDescription(string);
    }

    public void applySecurityConfiguration(@NotNull OpenAPI openApi) {
        Intrinsics.checkNotNullParameter((Object)openApi, (String)"openApi");
        openApi.components(new Components().addSecuritySchemes("Authorization", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic")));
        openApi.addSecurityItem(new SecurityRequirement().addList("Authorization"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Integer tagOrder(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String string = tag.getName();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 1347517393: {
                if (string.equals("Attributes API")) {
                    n = 1;
                }
                break;
            }
            case 1302629381: {
                if (string.equals("Hosts API")) {
                    n = 2;
                }
                break;
            }
            case 1281406882: {
                if (string.equals("Search API")) {
                    n = 3;
                }
                break;
            }
            case 1643805008: {
                if (string.equals("Session API")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                Integer n2 = 100;
                return n2;
            }
            case 2: {
                Integer n2 = 200;
                return n2;
            }
            case 3: {
                Integer n2 = 300;
                return n2;
            }
            case 4: {
                Integer n2 = 400;
                return n2;
            }
            default: {
                return null;
            }
        }
    }
}

