/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.controller;

import io.sip3.twig.ce.controller.SearchController;
import io.sip3.twig.ce.controller.SearchRequestValidator;
import io.sip3.twig.ce.domain.SearchRequest;
import io.sip3.twig.ce.domain.SearchResponse;
import io.sip3.twig.ce.service.SearchService;
import io.sip3.twig.ce.service.ServiceLocator;
import io.sip3.twig.ce.util.IteratorUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Search API", description="Search Controller")
@RestController
@RequestMapping(value={"/search"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0001\u0010\f\u001a\u00020\rH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/sip3/twig/ce/controller/SearchController;", "", "()V", "defaultLimit", "", "searchRequestValidator", "Lio/sip3/twig/ce/controller/SearchRequestValidator;", "serviceLocator", "Lio/sip3/twig/ce/service/ServiceLocator;", "search", "", "Lio/sip3/twig/ce/domain/SearchResponse;", "request", "Lio/sip3/twig/ce/domain/SearchRequest;", "Companion", "sip3-twig-ce"})
public final class SearchController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Value(value="${session.default-limit:${session.default_limit:50}}")
    private int defaultLimit = 50;
    @Autowired
    private ServiceLocator serviceLocator;
    @Autowired
    private SearchRequestValidator searchRequestValidator;
    @NotNull
    private static final Regex SIP_METHOD_REGEX = new Regex("sip.method=(\\w*)");

    @Operation(summary="Search sessions")
    @ApiResponses(value={@ApiResponse(description="Returns search results", responseCode="200"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PostMapping(consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public final List<SearchResponse> search(@Valid @RequestBody @NotNull SearchRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        SearchRequestValidator searchRequestValidator = this.searchRequestValidator;
        if (searchRequestValidator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchRequestValidator");
            searchRequestValidator = null;
        }
        searchRequestValidator.validate(request);
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.ifEmpty((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)SIP_METHOD_REGEX, (CharSequence)request.getQuery(), (int)0, (int)2, null), (Function1)search.searches.1.INSTANCE), (Function1)((Function1)new Function1<String, SearchService>(this){
            final /* synthetic */ SearchController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final SearchService invoke(@NotNull String method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                ServiceLocator serviceLocator = SearchController.access$getServiceLocator$p(this.this$0);
                if (serviceLocator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serviceLocator");
                    serviceLocator = null;
                }
                return serviceLocator.searchService(method);
            }
        })), (Function0)((Function0)new Function0<Sequence<? extends SearchService>>(this){
            final /* synthetic */ SearchController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Sequence<SearchService> invoke() {
                ServiceLocator serviceLocator = SearchController.access$getServiceLocator$p(this.this$0);
                if (serviceLocator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serviceLocator");
                    serviceLocator = null;
                }
                return CollectionsKt.asSequence((Iterable)serviceLocator.searchServices());
            }
        })), (Function1)((Function1)new Function1<SearchService, Iterator<? extends SearchResponse>>(request){
            final /* synthetic */ SearchRequest $request;
            {
                this.$request = $request;
                super(1);
            }

            @NotNull
            public final Iterator<SearchResponse> invoke(@NotNull SearchService service) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                return service.search(this.$request);
            }
        })));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Iterator[] searches2 = thisCollection$iv.toArray(new Iterator[0]);
        Integer n = request.getLimit();
        Sequence $this$sortedBy$iv = SequencesKt.take((Sequence)SequencesKt.asSequence(IteratorUtil.INSTANCE.merge(Arrays.copyOf(searches2, searches2.length))), (int)(n != null ? n : this.defaultLimit));
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SearchResponse p0 = (SearchResponse)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(p0.getCreatedAt());
                p0 = (SearchResponse)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getCreatedAt()));
            }
        }));
    }

    public static final /* synthetic */ ServiceLocator access$getServiceLocator$p(SearchController $this) {
        return $this.serviceLocator;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/sip3/twig/ce/controller/SearchController$Companion;", "", "()V", "SIP_METHOD_REGEX", "Lkotlin/text/Regex;", "getSIP_METHOD_REGEX", "()Lkotlin/text/Regex;", "sip3-twig-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSIP_METHOD_REGEX() {
            return SIP_METHOD_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

