/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.configuration;

import io.sip3.twig.ce.configuration.SecurityConfiguration;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.web.context.WebApplicationContext;

@Configuration
@ConditionalOnProperty(prefix="security.oauth2", name={"client_id"}, matchIfMissing=true)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/sip3/twig/ce/configuration/SecurityConfiguration;", "", "()V", "context", "Lorg/springframework/web/context/WebApplicationContext;", "getContext", "()Lorg/springframework/web/context/WebApplicationContext;", "setContext", "(Lorg/springframework/web/context/WebApplicationContext;)V", "logger", "Lmu/KLogger;", "securityEnabled", "", "filterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "sip3-twig-ce"})
public class SecurityConfiguration {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Autowired
    public WebApplicationContext context;
    @Value(value="${security.enabled:false}")
    private boolean securityEnabled;

    @NotNull
    public final WebApplicationContext getContext() {
        WebApplicationContext webApplicationContext = this.context;
        if (webApplicationContext != null) {
            return webApplicationContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        return null;
    }

    public final void setContext(@NotNull WebApplicationContext webApplicationContext) {
        Intrinsics.checkNotNullParameter((Object)webApplicationContext, (String)"<set-?>");
        this.context = webApplicationContext;
    }

    @Bean
    @NotNull
    public SecurityFilterChain filterChain(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        if (this.securityEnabled) {
            Object object = http.getSharedObject(AuthenticationManagerBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"http.getSharedObject(Aut\u2026nagerBuilder::class.java)");
            AuthenticationManagerBuilder auth = (AuthenticationManagerBuilder)object;
            Map map2 = this.getContext().getBeansOfType(AuthenticationProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"context.getBeansOfType(A\u2026tionProvider::class.java)");
            Map $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String name = (String)entry.getKey();
                AuthenticationProvider provider = (AuthenticationProvider)entry.getValue();
                auth.authenticationProvider(provider);
                this.logger.info((Function0)new Function0<Object>(name){
                    final /* synthetic */ String $name;
                    {
                        this.$name = $name;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Authentication provider '" + this.$name + "' added.";
                    }
                });
            }
        }
        Object object = http.csrf(SecurityConfiguration::filterChain$lambda$1).authorizeHttpRequests(arg_0 -> SecurityConfiguration.filterChain$lambda$8(this, http, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"http.csrf { it.disable()\u2026  }\n            }.build()");
        return (SecurityFilterChain)object;
    }

    private static final void filterChain$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void filterChain$lambda$8$lambda$7$lambda$4$lambda$2(SecurityConfiguration this$0, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.logger.info((Function0)new Function0<Object>(authentication){
            final /* synthetic */ Authentication $authentication;
            {
                this.$authentication = $authentication;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Login attempt. User: " + this.$authentication.getPrincipal() + ", State: SUCCESSFUL";
            }
        });
    }

    private static final void filterChain$lambda$8$lambda$7$lambda$4$lambda$3(SecurityConfiguration this$0, HttpServletRequest httpServletRequest, HttpServletResponse response, AuthenticationException exception) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.logger.info((Function0)new Function0<Object>(exception){
            final /* synthetic */ AuthenticationException $exception;
            {
                this.$exception = $exception;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Login attempt. User: " + this.$exception.getMessage() + ", State: FAILED";
            }
        });
        response.sendError(HttpStatus.FORBIDDEN.value());
    }

    private static final void filterChain$lambda$8$lambda$7$lambda$4(SecurityConfiguration this$0, FormLoginConfigurer formLogin) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        formLogin.successHandler((arg_0, arg_1, arg_2) -> SecurityConfiguration.filterChain$lambda$8$lambda$7$lambda$4$lambda$2(this$0, arg_0, arg_1, arg_2));
        formLogin.failureHandler((arg_0, arg_1, arg_2) -> SecurityConfiguration.filterChain$lambda$8$lambda$7$lambda$4$lambda$3(this$0, arg_0, arg_1, arg_2));
    }

    private static final void filterChain$lambda$8$lambda$7$lambda$5(HttpBasicConfigurer it) {
    }

    private static final void filterChain$lambda$8$lambda$7$lambda$6(ExceptionHandlingConfigurer exceptionHandlingCustomizer) {
        exceptionHandlingCustomizer.authenticationEntryPoint((AuthenticationEntryPoint)new Http403ForbiddenEntryPoint());
    }

    private static final void filterChain$lambda$8(SecurityConfiguration this$0, HttpSecurity $http, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authz) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$http, (String)"$http");
        Object object = new String[]{"/swagger-resources/**"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(object)).permitAll();
        object = new String[]{"/swagger-ui/**"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry2 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(object)).permitAll();
        object = new String[]{"/v3/api-docs/**"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry3 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry2.requestMatchers(object)).permitAll();
        object = new String[]{"/management/configuration/hoof"};
        object = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry3.requestMatchers(object)).permitAll().anyRequest();
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl $this$filterChain_u24lambda_u248_u24lambda_u247 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)object;
        boolean bl = false;
        if (this$0.securityEnabled) {
            $http.formLogin(arg_0 -> SecurityConfiguration.filterChain$lambda$8$lambda$7$lambda$4(this$0, arg_0)).httpBasic(SecurityConfiguration::filterChain$lambda$8$lambda$7$lambda$5).exceptionHandling(SecurityConfiguration::filterChain$lambda$8$lambda$7$lambda$6);
            $this$filterChain_u24lambda_u248_u24lambda_u247.authenticated();
        } else {
            $this$filterChain_u24lambda_u248_u24lambda_u247.permitAll();
        }
    }
}

