/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.util;

import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.Content;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import io.sip3.twig.ce.util.SessionDescriptionParser;
import java.util.Iterator;
import java.util.Locale;
import javax.sip.address.Address;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.restcomm.media.sdp.SessionDescription;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0011\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0002\u001a\u0012\u0010\n\u001a\u00020\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0002\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0013"}, d2={"branchId", "", "Lgov/nist/javax/sip/message/SIPMessage;", "callId", "cseqNumber", "", "(Lgov/nist/javax/sip/message/SIPMessage;)Ljava/lang/Long;", "fromUri", "hasSdp", "", "matches", "Lgov/nist/javax/sip/message/Content;", "proto", "method", "requestUri", "sessionDescription", "Lorg/restcomm/media/sdp/SessionDescription;", "toUri", "transactionId", "sip3-twig-ce"})
public final class SipMessageUtilKt {
    @Nullable
    public static final String callId(@NotNull SIPMessage $this$callId) {
        Intrinsics.checkNotNullParameter((Object)$this$callId, (String)"<this>");
        CallIdHeader callIdHeader = $this$callId.getCallId();
        return callIdHeader != null ? callIdHeader.getCallId() : null;
    }

    @Nullable
    public static final String branchId(@NotNull SIPMessage $this$branchId) {
        Intrinsics.checkNotNullParameter((Object)$this$branchId, (String)"<this>");
        Via via = $this$branchId.getTopmostVia();
        return via != null ? via.getBranch() : null;
    }

    @Nullable
    public static final Long cseqNumber(@NotNull SIPMessage $this$cseqNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$cseqNumber, (String)"<this>");
        CSeqHeader cSeqHeader = $this$cseqNumber.getCSeq();
        return cSeqHeader != null ? Long.valueOf(cSeqHeader.getSeqNumber()) : null;
    }

    @Nullable
    public static final String requestUri(@NotNull SIPMessage $this$requestUri) {
        GenericURI genericURI;
        RequestLine requestLine;
        Intrinsics.checkNotNullParameter((Object)$this$requestUri, (String)"<this>");
        SIPRequest sIPRequest = $this$requestUri instanceof SIPRequest ? (SIPRequest)$this$requestUri : null;
        return sIPRequest != null && (requestLine = sIPRequest.getRequestLine()) != null && (genericURI = requestLine.getUri()) != null ? genericURI.toString() : null;
    }

    @Nullable
    public static final String fromUri(@NotNull SIPMessage $this$fromUri) {
        URI uRI;
        Address address;
        Intrinsics.checkNotNullParameter((Object)$this$fromUri, (String)"<this>");
        FromHeader fromHeader = $this$fromUri.getFrom();
        return fromHeader != null && (address = fromHeader.getAddress()) != null && (uRI = address.getURI()) != null ? uRI.toString() : null;
    }

    @Nullable
    public static final String toUri(@NotNull SIPMessage $this$toUri) {
        URI uRI;
        Address address;
        Intrinsics.checkNotNullParameter((Object)$this$toUri, (String)"<this>");
        ToHeader toHeader = $this$toUri.getTo();
        return toHeader != null && (address = toHeader.getAddress()) != null && (uRI = address.getURI()) != null ? uRI.toString() : null;
    }

    @Nullable
    public static final String method(@NotNull SIPMessage $this$method) {
        Intrinsics.checkNotNullParameter((Object)$this$method, (String)"<this>");
        SIPRequest sIPRequest = $this$method instanceof SIPRequest ? (SIPRequest)$this$method : null;
        return sIPRequest != null && (sIPRequest = sIPRequest.getRequestLine()) != null ? sIPRequest.getMethod() : null;
    }

    @NotNull
    public static final String transactionId(@NotNull SIPMessage $this$transactionId) {
        Intrinsics.checkNotNullParameter((Object)$this$transactionId, (String)"<this>");
        return SipMessageUtilKt.callId($this$transactionId) + ":" + SipMessageUtilKt.branchId($this$transactionId) + ":" + SipMessageUtilKt.cseqNumber($this$transactionId);
    }

    public static final boolean hasSdp(@NotNull SIPMessage $this$hasSdp) {
        block3: {
            Iterator iterator;
            Intrinsics.checkNotNullParameter((Object)$this$hasSdp, (String)"<this>");
            ContentType contentType = $this$hasSdp.getContentTypeHeader();
            if (contentType == null) break block3;
            ContentType contentType2 = contentType;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)contentType2.getMediaSubType(), (Object)"sdp")) {
                return true;
            }
            Object object = $this$hasSdp.getMultipartMimeContent();
            if (object != null && (object = (iterator = object.getContents())) != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"contents");
                Iterator $this$forEach$iv = iterator;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv;
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    Content mimeContent = (Content)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)mimeContent, (String)"mimeContent");
                    if (!SipMessageUtilKt.matches(mimeContent, "sdp")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static final SessionDescription sessionDescription(@NotNull SIPMessage $this$sessionDescription) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$sessionDescription, (String)"<this>");
            ContentType contentType = $this$sessionDescription.getContentTypeHeader();
            if (Intrinsics.areEqual((Object)(contentType != null ? contentType.getMediaSubType() : null), (Object)"sdp")) {
                return SessionDescriptionParser.INSTANCE.parse($this$sessionDescription.getMessageContent());
            }
            Object object = $this$sessionDescription.getMultipartMimeContent();
            if (object == null || (object = object.getContents()) == null) break block2;
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Object object2 = $this$forEach$iv;
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                Content mimeContent = (Content)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)mimeContent, (String)"mimeContent");
                if (!SipMessageUtilKt.matches(mimeContent, "sdp")) continue;
                return SessionDescriptionParser.INSTANCE.parse(mimeContent.getContent().toString());
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean matches(@NotNull Content $this$matches, @NotNull String proto) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        ContentTypeHeader contentTypeHeader = $this$matches.getContentTypeHeader();
        Object object = contentTypeHeader;
        if (contentTypeHeader == null) return false;
        String string = object.getContentSubType();
        object = string;
        if (string == null) return false;
        String string2 = ((String)object).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        object = string2;
        if (string2 == null) return false;
        CharSequence charSequence = (CharSequence)object;
        String string3 = proto.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        boolean bl = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null);
        return bl;
    }
}

