/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.security;

import io.sip3.twig.ce.security.GrafanaAuthenticationProvider;
import io.sip3.twig.ce.security.GrafanaSecurityConfiguration;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component(value="grafana")
@ConditionalOnProperty(prefix="security.grafana", name={"url"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/sip3/twig/ce/security/GrafanaAuthenticationProvider;", "Lorg/springframework/security/authentication/AuthenticationProvider;", "config", "Lio/sip3/twig/ce/security/GrafanaSecurityConfiguration;", "(Lio/sip3/twig/ce/security/GrafanaSecurityConfiguration;)V", "logger", "Lmu/KLogger;", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "authenticate", "Lorg/springframework/security/core/Authentication;", "auth", "supports", "", "Ljava/lang/Class;", "sip3-twig-ce"})
public final class GrafanaAuthenticationProvider
implements AuthenticationProvider {
    @NotNull
    private final GrafanaSecurityConfiguration config;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final RestTemplate restTemplate;

    public GrafanaAuthenticationProvider(@NotNull GrafanaSecurityConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.restTemplate = new RestTemplate();
    }

    @NotNull
    public Authentication authenticate(@Nullable Authentication auth) {
        if (auth == null) {
            boolean $i$a$-requireNotNull-GrafanaAuthenticationProvider$authenticate$22 = false;
            String $i$a$-requireNotNull-GrafanaAuthenticationProvider$authenticate$22 = "Authentication data required.";
            throw new IllegalArgumentException($i$a$-requireNotNull-GrafanaAuthenticationProvider$authenticate$22.toString());
        }
        String username = auth.getName();
        Object object = auth.getCredentials();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String password = (String)object;
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(username, password);
        try {
            HttpStatusCode statusCode = this.restTemplate.exchange(this.config.getUrl(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]).getStatusCode();
            if (statusCode.is2xxSuccessful()) {
                return (Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password, (Collection)CollectionsKt.emptyList());
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, (Function0)authenticate.2.INSTANCE);
        }
        throw new BadCredentialsException(username);
    }

    public boolean supports(@Nullable Class<?> auth) {
        Class<?> clazz = auth;
        return clazz != null ? clazz.equals(UsernamePasswordAuthenticationToken.class) : false;
    }
}

