/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.mongo;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.WriteModel;
import io.sip3.commons.util.DateTimeFormatterUtilKt;
import io.sip3.twig.ce.mongo.MongoClient;
import jakarta.annotation.PostConstruct;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000e2\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0-0,H\u0016JO\u0010/\u001a\b\u0012\u0004\u0012\u00020.002\u0006\u00101\u001a\u00020\u000e2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016032\u0006\u00104\u001a\u0002052\n\b\u0002\u00106\u001a\u0004\u0018\u0001052\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u00108JE\u0010/\u001a\b\u0012\u0004\u0012\u00020.002\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000e0:2\n\b\u0002\u00104\u001a\u0004\u0018\u0001052\n\b\u0002\u00106\u001a\u0004\u0018\u0001052\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020)H\u0017J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000e0:H\u0017J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000e0:2\u0006\u00101\u001a\u00020\u000eH\u0017J*\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000e0:2\u0006\u00101\u001a\u00020\u000e2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001603H\u0016R\u0016\u0010\u0003\u001a\u00020\u00048\u0004X\u0085D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0094.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00168\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u00008\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0094.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\u000e8\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010\u0012R\u001e\u0010%\u001a\u00020\u000e8\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0010\"\u0004\b'\u0010\u0012\u00a8\u0006>"}, d2={"Lio/sip3/twig/ce/mongo/MongoClient;", "", "()V", "batchSize", "", "getBatchSize", "()I", "client", "Lcom/mongodb/client/MongoClient;", "getClient", "()Lcom/mongodb/client/MongoClient;", "setClient", "(Lcom/mongodb/client/MongoClient;)V", "db", "", "getDb", "()Ljava/lang/String;", "setDb", "(Ljava/lang/String;)V", "logger", "Lmu/KLogger;", "maxExecutionTime", "", "getMaxExecutionTime", "()J", "setMaxExecutionTime", "(J)V", "proxy", "suffix", "Ljava/time/format/DateTimeFormatter;", "getSuffix", "()Ljava/time/format/DateTimeFormatter;", "setSuffix", "(Ljava/time/format/DateTimeFormatter;)V", "timeSuffix", "getTimeSuffix", "setTimeSuffix", "uri", "getUri", "setUri", "bulkWrite", "", "collection", "operations", "", "Lcom/mongodb/client/model/WriteModel;", "Lorg/bson/Document;", "find", "", "prefix", "timeRange", "Lkotlin/Pair;", "filter", "Lorg/bson/conversions/Bson;", "sort", "limit", "(Ljava/lang/String;Lkotlin/Pair;Lorg/bson/conversions/Bson;Lorg/bson/conversions/Bson;Ljava/lang/Integer;)Ljava/util/Iterator;", "collections", "", "(Ljava/util/Collection;Lorg/bson/conversions/Bson;Lorg/bson/conversions/Bson;Ljava/lang/Integer;)Ljava/util/Iterator;", "init", "listCollectionNames", "sip3-twig-ce"})
public class MongoClient {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Autowired
    private MongoClient proxy;
    @Value(value="${time-suffix:${time_suffix:yyyyMMdd}}")
    protected String timeSuffix;
    @Value(value="${mongo.uri}")
    protected String uri;
    @Value(value="${mongo.db}")
    protected String db;
    @Value(value="${mongo.max-execution-time:${mongo.max_execution_time:30000}}")
    private long maxExecutionTime = 30000L;
    @Value(value="${mongo.batch-size:${mongo.batch_size:1}}")
    private final int batchSize;
    protected DateTimeFormatter suffix;
    protected com.mongodb.client.MongoClient client;

    public MongoClient() {
        this.batchSize = 1;
    }

    @NotNull
    protected final String getTimeSuffix() {
        String string = this.timeSuffix;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"timeSuffix");
        return null;
    }

    protected final void setTimeSuffix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.timeSuffix = string;
    }

    @NotNull
    protected final String getUri() {
        String string = this.uri;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
        return null;
    }

    protected final void setUri(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.uri = string;
    }

    @NotNull
    protected final String getDb() {
        String string = this.db;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"db");
        return null;
    }

    protected final void setDb(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.db = string;
    }

    protected final long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    protected final void setMaxExecutionTime(long l) {
        this.maxExecutionTime = l;
    }

    protected final int getBatchSize() {
        return this.batchSize;
    }

    @NotNull
    protected DateTimeFormatter getSuffix() {
        DateTimeFormatter dateTimeFormatter = this.suffix;
        if (dateTimeFormatter != null) {
            return dateTimeFormatter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"suffix");
        return null;
    }

    protected void setSuffix(@NotNull DateTimeFormatter dateTimeFormatter) {
        Intrinsics.checkNotNullParameter((Object)dateTimeFormatter, (String)"<set-?>");
        this.suffix = dateTimeFormatter;
    }

    @NotNull
    protected com.mongodb.client.MongoClient getClient() {
        com.mongodb.client.MongoClient mongoClient = this.client;
        if (mongoClient != null) {
            return mongoClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        return null;
    }

    protected void setClient(@NotNull com.mongodb.client.MongoClient mongoClient) {
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"<set-?>");
        this.client = mongoClient;
    }

    @PostConstruct
    public void init() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.getTimeSuffix());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(timeSuffix)");
        this.setSuffix(dateTimeFormatter);
        com.mongodb.client.MongoClient mongoClient = MongoClients.create((String)this.getUri());
        Intrinsics.checkNotNullExpressionValue((Object)mongoClient, (String)"create(uri)");
        this.setClient(mongoClient);
    }

    @NotNull
    public Iterator<Document> find(@NotNull String prefix, @NotNull Pair<Long, Long> timeRange, @NotNull Bson filter2, @Nullable Bson sort, @Nullable Integer limit) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(timeRange, (String)"timeRange");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Collection<String> collections = this.listCollectionNames(prefix, timeRange);
        return this.find(collections, filter2, sort, limit);
    }

    public static /* synthetic */ Iterator find$default(MongoClient mongoClient, String string, Pair pair, Bson bson, Bson bson2, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: find");
        }
        if ((n2 & 8) != 0) {
            bson2 = null;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        return mongoClient.find(string, (Pair<Long, Long>)pair, bson, bson2, n);
    }

    @NotNull
    public Iterator<Document> find(@NotNull Collection<String> collections, @Nullable Bson filter2, @Nullable Bson sort, @Nullable Integer limit) {
        Intrinsics.checkNotNullParameter(collections, (String)"collections");
        Iterator<String> collectionNames = collections.iterator();
        return new Iterator<Document>(collectionNames, this, filter2, limit, sort){
            @Nullable
            private MongoCursor<Document> cursor;
            final /* synthetic */ Iterator<String> $collectionNames;
            final /* synthetic */ MongoClient this$0;
            final /* synthetic */ Bson $filter;
            final /* synthetic */ Integer $limit;
            final /* synthetic */ Bson $sort;
            {
                this.$collectionNames = $collectionNames;
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$limit = $limit;
                this.$sort = $sort;
            }

            @Nullable
            public final MongoCursor<Document> getCursor() {
                return this.cursor;
            }

            public final void setCursor(@Nullable MongoCursor<Document> mongoCursor) {
                this.cursor = mongoCursor;
            }

            /*
             * WARNING - void declaration
             */
            public boolean hasNext() {
                block6: {
                    void $this$hasNext_u24lambda_u243;
                    Bson it;
                    Object object;
                    Object object2;
                    Object object3;
                    MongoCollection mongoCollection;
                    block8: {
                        void $this$hasNext_u24lambda_u241;
                        block7: {
                            MongoCursor<Document> mongoCursor = this.cursor;
                            boolean bl = mongoCursor != null ? mongoCursor.hasNext() : false;
                            if (bl) {
                                return true;
                            }
                            if (!this.$collectionNames.hasNext()) break block6;
                            mongoCollection = this.this$0.getClient().getDatabase(this.this$0.getDb()).getCollection(this.$collectionNames.next());
                            object3 = this.$filter;
                            object2 = mongoCollection;
                            find.1 var9_4 = this;
                            boolean bl2 = false;
                            object = object3;
                            if (object == null) break block7;
                            it = object;
                            boolean bl3 = false;
                            FindIterable findIterable = $this$hasNext_u24lambda_u241.find((Bson)object3);
                            object = findIterable;
                            if (findIterable != null) break block8;
                        }
                        object = $this$hasNext_u24lambda_u241.find();
                    }
                    mongoCollection = object;
                    object3 = this.this$0;
                    object2 = this.$limit;
                    Bson bson = this.$sort;
                    it = mongoCollection;
                    boolean bl = false;
                    $this$hasNext_u24lambda_u243.maxTime(((MongoClient)object3).getMaxExecutionTime(), TimeUnit.MILLISECONDS);
                    Object object4 = object2;
                    $this$hasNext_u24lambda_u243.batchSize(object4 != null ? ((Integer)object4).intValue() : ((MongoClient)object3).getBatchSize());
                    Bson bson2 = bson;
                    if (bson2 != null) {
                        Bson it2 = bson2;
                        boolean bl4 = false;
                        $this$hasNext_u24lambda_u243.sort(it2);
                    }
                    var9_4.cursor = mongoCollection.iterator();
                    return this.hasNext();
                }
                return false;
            }

            @NotNull
            public Document next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                MongoCursor<Document> mongoCursor = this.cursor;
                Intrinsics.checkNotNull(mongoCursor);
                Object object = mongoCursor.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cursor!!.next()");
                return (Document)object;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public static /* synthetic */ Iterator find$default(MongoClient mongoClient, Collection collection, Bson bson, Bson bson2, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: find");
        }
        if ((n2 & 2) != 0) {
            bson = null;
        }
        if ((n2 & 4) != 0) {
            bson2 = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return mongoClient.find(collection, bson, bson2, n);
    }

    public void bulkWrite(@NotNull String collection, @NotNull List<? extends WriteModel<Document>> operations) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        this.getClient().getDatabase(this.getDb()).getCollection(collection).bulkWrite(operations);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> listCollectionNames(@NotNull String prefix, @NotNull Pair<Long, Long> timeRange) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(timeRange, (String)"timeRange");
        ClosedRange range = RangesKt.rangeTo((Comparable)((Comparable)((Object)(prefix + "_" + DateTimeFormatterUtilKt.format((DateTimeFormatter)this.getSuffix(), (long)((Number)timeRange.getFirst()).longValue())))), (Comparable)((Comparable)((Object)(prefix + "_" + DateTimeFormatterUtilKt.format((DateTimeFormatter)this.getSuffix(), (long)((Number)timeRange.getSecond()).longValue())))));
        MongoClient mongoClient = this.proxy;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"proxy");
            mongoClient = null;
        }
        Iterable iterable = mongoClient.listCollectionNames(prefix);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String name = (String)element$iv$iv;
            boolean bl = false;
            if (!range.contains((Comparable)((Object)name))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Cacheable(value={"listCollectionNamesByPrefix"}, key="#prefix")
    @NotNull
    public Collection<String> listCollectionNames(@NotNull String prefix) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        MongoClient mongoClient = this.proxy;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"proxy");
            mongoClient = null;
        }
        Iterable $this$filter$iv = mongoClient.listCollectionNames();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String name = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
    }

    @Cacheable(value={"listCollectionNames"})
    @NotNull
    public Collection<String> listCollectionNames() {
        MongoIterable mongoIterable = this.getClient().getDatabase(this.getDb()).listCollectionNames();
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"client.getDatabase(db).listCollectionNames()");
        return CollectionsKt.toList((Iterable)((Iterable)mongoIterable));
    }
}

