/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service.media;

import com.mongodb.client.model.Filters;
import io.sip3.twig.ce.domain.SessionRequest;
import io.sip3.twig.ce.mongo.MongoClient;
import io.sip3.twig.ce.service.media.MediaSessionService;
import io.sip3.twig.ce.service.media.domain.LegSession;
import io.sip3.twig.ce.service.media.domain.MediaSession;
import io.sip3.twig.ce.service.media.domain.MediaStatistic;
import io.sip3.twig.ce.service.media.util.LegSessionUtil;
import io.sip3.twig.ce.service.media.util.MediaStatisticUtil;
import io.sip3.twig.ce.service.media.util.ReportUtil;
import io.sip3.twig.ce.util.IteratorUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J4\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0016JD\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0016J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/sip3/twig/ce/service/media/MediaSessionService;", "", "()V", "blockCount", "", "logger", "Lmu/KLogger;", "mongoClient", "Lio/sip3/twig/ce/mongo/MongoClient;", "terminationTimeout", "", "details", "", "", "", "Lio/sip3/twig/ce/service/media/domain/LegSession;", "req", "Lio/sip3/twig/ce/domain/SessionRequest;", "dtmf", "", "Lorg/bson/Document;", "find", "prefix", "createdAt", "terminatedAt", "callId", "findLegSessions", "source", "withBlocks", "", "updateMediaSession", "", "legSession", "reports", "sip3-twig-ce"})
public class MediaSessionService {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Value(value="${session.media.block-count:${session.media.block_count:28}}")
    private int blockCount = 28;
    @Value(value="${session.media.termination-timeout:${session.media.termination_timeout:60000}}")
    private long terminationTimeout = 60000L;
    @Autowired
    private MongoClient mongoClient;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Map<String, LegSession>> details(@NotNull SessionRequest req) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        if (req.getCreatedAt() == null) {
            boolean $i$a$-requireNotNull-MediaSessionService$details$42 = false;
            String $i$a$-requireNotNull-MediaSessionService$details$42 = "created_at";
            throw new IllegalArgumentException($i$a$-requireNotNull-MediaSessionService$details$42.toString());
        }
        if (req.getTerminatedAt() == null) {
            boolean $i$a$-requireNotNull-MediaSessionService$details$52 = false;
            String $i$a$-requireNotNull-MediaSessionService$details$52 = "terminated_at";
            throw new IllegalArgumentException($i$a$-requireNotNull-MediaSessionService$details$52.toString());
        }
        if (req.getCallId() == null) {
            boolean $i$a$-requireNotNull-MediaSessionService$details$62 = false;
            String $i$a$-requireNotNull-MediaSessionService$details$62 = "call_id";
            throw new IllegalArgumentException($i$a$-requireNotNull-MediaSessionService$details$62.toString());
        }
        Long l = req.getCreatedAt();
        Intrinsics.checkNotNull((Object)l);
        long l2 = l;
        Long l3 = req.getTerminatedAt();
        Intrinsics.checkNotNull((Object)l3);
        long l4 = l3;
        List<String> list = req.getCallId();
        Intrinsics.checkNotNull(list);
        Map rtp = MediaSessionService.findLegSessions$default(this, "rtp", l2, l4, list, false, 16, null);
        Long l5 = req.getCreatedAt();
        Intrinsics.checkNotNull((Object)l5);
        long l6 = l5;
        Long l7 = req.getTerminatedAt();
        Intrinsics.checkNotNull((Object)l7);
        long l8 = l7;
        List<String> list2 = req.getCallId();
        Intrinsics.checkNotNull(list2);
        Map rtcp = MediaSessionService.findLegSessions$default(this, "rtcp", l6, l8, list2, false, 16, null);
        Iterable iterable = SetsKt.plus(rtp.keySet(), (Iterable)rtcp.keySet());
        boolean $i$f$map = false;
        void var6_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"rtp", rtp.get(it)), TuplesKt.to((Object)"rtcp", rtcp.get(it))};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Iterator<Document> dtmf(@NotNull SessionRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        if (req.getCreatedAt() == null) {
            boolean $i$a$-requireNotNull-MediaSessionService$dtmf$42 = false;
            String $i$a$-requireNotNull-MediaSessionService$dtmf$42 = "created_at";
            throw new IllegalArgumentException($i$a$-requireNotNull-MediaSessionService$dtmf$42.toString());
        }
        if (req.getTerminatedAt() == null) {
            boolean $i$a$-requireNotNull-MediaSessionService$dtmf$52 = false;
            String $i$a$-requireNotNull-MediaSessionService$dtmf$52 = "terminated_at";
            throw new IllegalArgumentException($i$a$-requireNotNull-MediaSessionService$dtmf$52.toString());
        }
        if (req.getCallId() == null) {
            boolean bl = false;
            String string = "call_id";
            throw new IllegalArgumentException(string.toString());
        }
        Long l = req.getCreatedAt();
        Intrinsics.checkNotNull((Object)l);
        long l2 = l;
        Long l3 = req.getTerminatedAt();
        Intrinsics.checkNotNull((Object)l3);
        long l4 = l3;
        List<String> list = req.getCallId();
        Intrinsics.checkNotNull(list);
        return this.find("dtmf_index", l2, l4, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, LegSession> findLegSessions(@NotNull String source, long createdAt, long terminatedAt, @NotNull List<String> callId, boolean withBlocks) {
        String legId;
        Map.Entry element$iv;
        Object $this$forEach$iv;
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(callId, (String)"callId");
        Map sessions = new LinkedHashMap();
        List reports = new ArrayList();
        Sequence sequence = SequencesKt.asSequence(this.find("rtpr_" + source + "_index", createdAt, terminatedAt, callId));
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Document it = (Document)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = LegSessionUtil.INSTANCE.generateLegId(it);
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry $i$f$groupByTo2 = element$iv = iterator.next();
            boolean bl = false;
            legId = (String)$i$f$groupByTo2.getKey();
            List documents = (List)$i$f$groupByTo2.getValue();
            try {
                sessions.put(legId, LegSessionUtil.INSTANCE.createLegSession((Document)CollectionsKt.first((List)documents), this.blockCount));
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, (Function0)new Function0<Object>(legId){
                    final /* synthetic */ String $legId;
                    {
                        this.$legId = $legId;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "MediaSessionService `createLegSession()` failed. LegId: " + this.$legId;
                    }
                });
                this.logger.trace((Function0)new Function0<Object>((List<? extends Document>)documents){
                    final /* synthetic */ List<Document> $documents;
                    {
                        this.$documents = $documents;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Documents: " + this.$documents;
                    }
                });
            }
        }
        $this$forEach$iv = sessions;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$groupByTo$iv$iv2;
            Object $this$groupBy$iv2;
            Iterable $this$forEach$iv2;
            boolean $i$f$forEach2;
            Object it;
            Object element$iv$iv2;
            Object $this$filterTo$iv$iv;
            Map.Entry $i$f$groupByTo2 = element$iv = iterator.next();
            boolean bl = false;
            legId = (String)$i$f$groupByTo2.getKey();
            LegSession legSession = (LegSession)$i$f$groupByTo2.getValue();
            Iterable $this$filter$iv = reports;
            boolean $i$f$filter = false;
            $this$getOrPut$iv$iv$iv = $this$filter$iv;
            Object destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator answer$iv$iv$iv = $this$filterTo$iv$iv.iterator();
            while (answer$iv$iv$iv.hasNext()) {
                element$iv$iv2 = answer$iv$iv$iv.next();
                it = (Document)element$iv$iv2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)LegSessionUtil.INSTANCE.generateLegId((Document)it), (Object)legId)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List legReports = (List)destination$iv$iv2;
            if (legReports.isEmpty()) {
                $this$filter$iv = SequencesKt.asSequence(this.find("rtpr_" + source + "_raw", legSession.getCreatedAt(), legSession.getTerminatedAt(), CollectionsKt.listOf((Object)legSession.getCallId())));
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Document document = (Document)element$iv2;
                    boolean bl4 = false;
                    Object object = element$iv$iv2 = document.getList((Object)"reports", Document.class);
                    if (object != null) {
                        Intrinsics.checkNotNullExpressionValue(object, (String)"getList(\"reports\", Document::class.java)");
                        Iterable $this$forEach$iv3 = (Iterable)element$iv$iv2;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv3 : $this$forEach$iv3) {
                            Document report = (Document)element$iv3;
                            boolean bl5 = false;
                            report.put("src_addr", (Object)document.getString((Object)"src_addr"));
                            report.put("src_port", (Object)document.getInteger((Object)"src_port"));
                            report.put("dst_addr", (Object)document.getString((Object)"dst_addr"));
                            report.put("dst_port", (Object)document.getInteger((Object)"dst_port"));
                            report.put("call_id", (Object)document.getString((Object)"call_id"));
                            Intrinsics.checkNotNullExpressionValue((Object)report, (String)"report");
                            reports.add(report);
                        }
                        continue;
                    }
                    reports.add(document);
                }
                $this$filter$iv = reports;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                $i$f$filterTo = false;
                Iterator bl4 = $this$filterTo$iv$iv.iterator();
                while (bl4.hasNext()) {
                    element$iv$iv2 = bl4.next();
                    it = (Document)element$iv$iv2;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)LegSessionUtil.INSTANCE.generateLegId((Document)it), (Object)legId)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                legReports = (List)destination$iv$iv2;
            }
            if (!withBlocks) continue;
            $this$filter$iv = legReports;
            boolean $i$f$groupBy2 = false;
            $this$filterTo$iv$iv = $this$groupBy$iv2;
            destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo32 = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv2) {
                Object object;
                it = (Document)element$iv$iv2;
                boolean bl7 = false;
                String key$iv$iv = LegSessionUtil.INSTANCE.generatePartyId((Document)it);
                Object $this$getOrPut$iv$iv$iv2 = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl8 = false;
                    List answer$iv$iv$iv2 = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv2);
                    object = answer$iv$iv$iv2;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv2);
            }
            $this$groupBy$iv2 = destination$iv$iv2;
            $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object element$iv2;
                Object $i$f$groupByTo32 = element$iv2 = iterator2.next();
                boolean bl9 = false;
                List reports2 = (List)$i$f$groupByTo32.getValue();
                try {
                    Iterable $this$sortedBy$iv = reports2;
                    boolean $i$f$sortedBy = false;
                    this.updateMediaSession(source, legSession, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Document it = (Document)a;
                            boolean bl = false;
                            Comparable comparable = it.getLong((Object)"created_at");
                            it = (Document)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getLong((Object)"created_at"));
                        }
                    }));
                }
                catch (Exception e) {
                    legSession.setInvalid(true);
                    this.logger.error((Throwable)e, (Function0)new Function0<Object>(legId){
                        final /* synthetic */ String $legId;
                        {
                            this.$legId = $legId;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "MediaSessionService `updateMediaSession()` failed. LegId: " + this.$legId;
                        }
                    });
                    this.logger.trace((Function0)new Function0<Object>((List<? extends Document>)reports2){
                        final /* synthetic */ List<Document> $reports;
                        {
                            this.$reports = $reports;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Reports: " + this.$reports;
                        }
                    });
                }
            }
            $this$forEach$iv2 = sessions.values();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                LegSession session = (LegSession)element$iv2;
                boolean bl10 = false;
                MediaSession mediaSession = IteratorUtilKt.firstOrNull(IteratorUtilKt.merge(session.getIn().iterator(), session.getOut().iterator(), null), (Function1)new Function1<MediaSession, Boolean>(this){
                    final /* synthetic */ MediaSessionService this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull MediaSession mediaSession) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)mediaSession, (String)"mediaSession");
                        if (mediaSession.getBlocks().size() <= MediaSessionService.access$getBlockCount$p(this.this$0)) {
                            boolean bl2;
                            block5: {
                                Iterable $this$any$iv = mediaSession.getBlocks();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        MediaStatistic it = (MediaStatistic)element$iv;
                                        boolean bl3 = false;
                                        if (!(it.getJitter().getMax() >= 10000.0)) continue;
                                        bl2 = true;
                                        break block5;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                });
                if (mediaSession == null) continue;
                it = mediaSession;
                boolean bl11 = false;
                session.setInvalid(true);
            }
        }
        if (withBlocks) {
            $this$forEach$iv = sessions.values();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                LegSession it = (LegSession)((Object)element$iv);
                boolean bl = false;
                it.updateTimestamps();
            }
        }
        return sessions;
    }

    public static /* synthetic */ Map findLegSessions$default(MediaSessionService mediaSessionService, String string, long l, long l2, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findLegSessions");
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return mediaSessionService.findLegSessions(string, l, l2, list, bl);
    }

    /*
     * WARNING - void declaration
     */
    public void updateMediaSession(@NotNull String source, @NotNull LegSession legSession, @NotNull List<? extends Document> reports) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        List chunks2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)legSession, (String)"legSession");
        Intrinsics.checkNotNullParameter(reports, (String)"reports");
        Document firstReport = (Document)CollectionsKt.first(reports);
        boolean isForward = Intrinsics.areEqual((Object)source, (Object)"rtp") ? Intrinsics.areEqual((Object)firstReport.getString((Object)"src_addr"), (Object)legSession.getSrcAddr()) : Intrinsics.areEqual((Object)firstReport.getString((Object)"src_addr"), (Object)legSession.getDstAddr());
        MediaSession mediaSession = (MediaSession)CollectionsKt.firstOrNull(isForward ? legSession.getOut() : legSession.getIn());
        if (mediaSession == null) {
            return;
        }
        MediaSession mediaSession2 = mediaSession;
        ArrayList<MediaStatistic> blocks = new ArrayList<MediaStatistic>(this.blockCount);
        int blockDuration = legSession.getDuration() / this.blockCount > 0 ? legSession.getDuration() / this.blockCount : legSession.getDuration();
        int remainingDuration = 0;
        MediaStatistic currentBlock = null;
        currentBlock = new MediaStatistic();
        Long l = ((Document)CollectionsKt.first(reports)).getLong((Object)"created_at");
        long l2 = legSession.getCreatedAt();
        if (l != null && l == l2) {
            remainingDuration = blockDuration;
        } else {
            int startDiff = (int)(((Document)CollectionsKt.first(reports)).getLong((Object)"created_at") - legSession.getCreatedAt());
            int n = startDiff / blockDuration;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                blocks.add(new MediaStatistic());
            }
            remainingDuration = blockDuration - startDiff % blockDuration;
        }
        Iterable $this$forEach$iv = reports;
        int $i$f$forEach = 0;
        for (Object element$iv : $this$forEach$iv) {
            Document report = (Document)element$iv;
            boolean bl = false;
            Integer reportDuration = report.getInteger((Object)"duration");
            Intrinsics.checkNotNullExpressionValue((Object)reportDuration, (String)"reportDuration");
            if (reportDuration < remainingDuration) {
                MediaStatisticUtil.INSTANCE.updateMediaStatistic(currentBlock, report);
                remainingDuration -= reportDuration.intValue();
                continue;
            }
            if (reportDuration > remainingDuration) {
                chunks2 = new ArrayList();
                ReportUtil.INSTANCE.splitReport(chunks2, report, remainingDuration, blockDuration, this.blockCount);
                Iterator iterator = chunks2.iterator();
                MediaStatisticUtil.INSTANCE.updateMediaStatistic(currentBlock, (Document)iterator.next());
                while (iterator.hasNext()) {
                    blocks.add(currentBlock);
                    currentBlock = MediaStatisticUtil.INSTANCE.createMediaStatistic((Document)iterator.next());
                }
                Integer n = ((Document)CollectionsKt.last((List)chunks2)).getInteger((Object)"duration");
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"chunks.last().getInteger(\"duration\")");
                remainingDuration = blockDuration - ((Number)n).intValue();
                continue;
            }
            int chunks2 = remainingDuration;
            if (reportDuration != chunks2) continue;
            MediaStatisticUtil.INSTANCE.updateMediaStatistic(currentBlock, report);
            blocks.add(currentBlock);
            currentBlock = new MediaStatistic();
            remainingDuration = blockDuration;
        }
        if (currentBlock.getPackets().getExpected() != 0 && blocks.size() < this.blockCount) {
            blocks.add(currentBlock);
        }
        while (blocks.size() < this.blockCount) {
            blocks.add(new MediaStatistic());
        }
        mediaSession2.getBlocks().addAll((Collection<MediaStatistic>)blocks);
        if (mediaSession2.getDuration() == 0) {
            int n;
            $this$forEach$iv = blocks;
            object = mediaSession2;
            $i$f$forEach = 0;
            for (Object element$iv : $this$forEach$iv) {
                void it;
                MediaStatistic report = (MediaStatistic)element$iv;
                n = $i$f$forEach;
                boolean bl = false;
                int n3 = it.getDuration();
                $i$f$forEach = n + n3;
            }
            n = $i$f$forEach;
            ((MediaStatistic)object).setDuration(n);
        }
        Long l3 = firstReport.getLong((Object)"created_at");
        Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"firstReport.getLong(\"created_at\")");
        mediaSession2.setCreatedAt(((Number)l3).longValue());
        mediaSession2.setTerminatedAt(mediaSession2.getCreatedAt() + (long)mediaSession2.getDuration());
        $this$forEach$iv = reports;
        object = legSession.getCodecs();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            chunks2 = (Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getString((Object)"codec");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.getString(\"codec\")");
            Integer n = it.getInteger((Object)"payload_type");
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"it.getInteger(\"payload_type\")");
            collection.add(new LegSession.Codec(string, ((Number)n).intValue()));
        }
        object.addAll((List)destination$iv$iv);
    }

    @NotNull
    public Iterator<Document> find(@NotNull String prefix, long createdAt, long terminatedAt, @NotNull List<String> callId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(callId, (String)"callId");
        List $this$find_u24lambda_u2424 = list = (List)new ArrayList();
        boolean bl = false;
        Bson bson = Filters.gte((String)"created_at", (Object)createdAt);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"gte(\"created_at\", createdAt)");
        $this$find_u24lambda_u2424.add(bson);
        Bson bson2 = Filters.lte((String)"created_at", (Object)(terminatedAt + this.terminationTimeout));
        Intrinsics.checkNotNullExpressionValue((Object)bson2, (String)"lte(\"created_at\", termin\u2026dAt + terminationTimeout)");
        $this$find_u24lambda_u2424.add(bson2);
        Bson bson3 = Filters.in((String)"call_id", (Iterable)callId);
        Intrinsics.checkNotNullExpressionValue((Object)bson3, (String)"`in`(\"call_id\", callId)");
        $this$find_u24lambda_u2424.add(bson3);
        List filters2 = list;
        MongoClient mongoClient = this.mongoClient;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongoClient");
            mongoClient = null;
        }
        Pair pair = new Pair((Object)createdAt, (Object)(terminatedAt + this.terminationTimeout));
        Bson bson4 = Filters.and((Iterable)filters2);
        Intrinsics.checkNotNullExpressionValue((Object)bson4, (String)"and(filters)");
        return MongoClient.find$default(mongoClient, prefix, pair, bson4, null, null, 24, null);
    }

    public static final /* synthetic */ int access$getBlockCount$p(MediaSessionService $this) {
        return $this.blockCount;
    }
}

