/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service.media.util;

import io.sip3.twig.ce.service.media.domain.LegSession;
import io.sip3.twig.ce.service.media.domain.MediaSession;
import io.sip3.twig.ce.service.media.domain.MediaStatistic;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u001c\u0010\r\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lio/sip3/twig/ce/service/media/util/LegSessionUtil;", "", "()V", "createLegSession", "Lio/sip3/twig/ce/service/media/domain/LegSession;", "document", "Lorg/bson/Document;", "blockCount", "", "generateLegId", "", "report", "generatePartyId", "fillMediaSession", "", "sip3-twig-ce"})
public final class LegSessionUtil {
    @NotNull
    public static final LegSessionUtil INSTANCE = new LegSessionUtil();

    private LegSessionUtil() {
    }

    @NotNull
    public final String generateLegId(@NotNull Document report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        String callId = report.getString((Object)"call_id");
        String srcAddr = report.getString((Object)"src_addr");
        String dstAddr = report.getString((Object)"dst_addr");
        Intrinsics.checkNotNullExpressionValue((Object)dstAddr, (String)"dstAddr");
        return srcAddr.compareTo(dstAddr) > 0 ? callId + ":" + srcAddr + ":" + dstAddr : callId + ":" + dstAddr + ":" + srcAddr;
    }

    @NotNull
    public final String generatePartyId(@NotNull Document report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        return report.getString((Object)"src_addr") + ":" + report.getString((Object)"dst_addr");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LegSession createLegSession(@NotNull Document document, int blockCount) {
        String it;
        String string;
        LegSession legSession;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Long legCreatedAt = document.getLong((Object)"created_at");
        Long legTerminatedAt = document.getLong((Object)"terminated_at");
        LegSession $this$createLegSession_u24lambda_u244 = legSession = new LegSession();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)legCreatedAt, (String)"legCreatedAt");
        $this$createLegSession_u24lambda_u244.setCreatedAt(legCreatedAt);
        Intrinsics.checkNotNullExpressionValue((Object)legTerminatedAt, (String)"legTerminatedAt");
        $this$createLegSession_u24lambda_u244.setTerminatedAt(legTerminatedAt);
        $this$createLegSession_u24lambda_u244.setDuration((int)(legTerminatedAt - legCreatedAt));
        String string2 = document.getString((Object)"call_id");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.getString(\"call_id\")");
        $this$createLegSession_u24lambda_u244.setCallId(string2);
        String string3 = document.getString((Object)"src_addr");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"document.getString(\"src_addr\")");
        $this$createLegSession_u24lambda_u244.setSrcAddr(string3);
        Integer n = document.getInteger((Object)"src_port");
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"document.getInteger(\"src_port\")");
        $this$createLegSession_u24lambda_u244.setSrcPort(((Number)n).intValue());
        String string4 = string = document.getString((Object)"src_host");
        if (string4 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(\"src_host\")");
            it = string;
            boolean bl2 = false;
            $this$createLegSession_u24lambda_u244.setSrcHost(it);
        }
        String string5 = document.getString((Object)"dst_addr");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"document.getString(\"dst_addr\")");
        $this$createLegSession_u24lambda_u244.setDstAddr(string5);
        Integer n2 = document.getInteger((Object)"dst_port");
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"document.getInteger(\"dst_port\")");
        $this$createLegSession_u24lambda_u244.setDstPort(((Number)n2).intValue());
        String string6 = string = document.getString((Object)"dst_host");
        if (string6 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(\"dst_host\")");
            it = string;
            boolean bl3 = false;
            $this$createLegSession_u24lambda_u244.setDstHost(it);
        }
        Object object = document.get((Object)"payload_type");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
        List payloadTypes = (List)object;
        List codecNames = document.getList((Object)"codec", String.class);
        Iterable $this$forEachIndexed$iv = payloadTypes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void payloadType;
            Object object2;
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n4 = ((Number)item$iv).intValue();
            int index = n3;
            boolean bl4 = false;
            Set<LegSession.Codec> set = $this$createLegSession_u24lambda_u244.getCodecs();
            Intrinsics.checkNotNullExpressionValue((Object)codecNames, (String)"codecNames");
            List list = codecNames;
            if (index >= 0 && index <= CollectionsKt.getLastIndex((List)list)) {
                object2 = list.get(index);
            } else {
                int n5 = index;
                Set<LegSession.Codec> set2 = set;
                boolean bl5 = false;
                object2 = "UNDEFINED(" + (int)payloadType + ")";
                set = set2;
            }
            Intrinsics.checkNotNullExpressionValue(object2, (String)"codecNames.getOrElse(ind\u2026NDEFINED($payloadType)\" }");
            void var23_23 = payloadType;
            String string7 = (String)object2;
            set.add(new LegSession.Codec(string7, (int)var23_23));
        }
        INSTANCE.fillMediaSession($this$createLegSession_u24lambda_u244, document, blockCount);
        return legSession;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillMediaSession(LegSession $this$fillMediaSession, Document document, int blockCount) {
        List directions = document.getList((Object)"direction", String.class);
        Document reportPackets = (Document)document.get((Object)"packets", Document.class);
        Object object = document.get((Object)"mos");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Double>");
        List mos = (List)object;
        Object object2 = document.get((Object)"r_factor");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Double>");
        List rFactor = (List)object2;
        Document jitters = (Document)document.get((Object)"jitter", Document.class);
        Intrinsics.checkNotNullExpressionValue((Object)directions, (String)"directions");
        Iterable $this$forEachIndexed$iv = directions;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void direction;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            MediaSession mediaSession = new MediaSession(blockCount);
            Object object3 = mediaSession.getPackets();
            MediaStatistic.Packets $this$fillMediaSession_u24lambda_u247_u24lambda_u245 = object3;
            boolean bl2 = false;
            Object object4 = reportPackets.get((Object)"expected");
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
            $this$fillMediaSession_u24lambda_u247_u24lambda_u245.setExpected(((Number)((List)object4).get(index)).intValue());
            Object object5 = reportPackets.get((Object)"received");
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
            $this$fillMediaSession_u24lambda_u247_u24lambda_u245.setReceived(((Number)((List)object5).get(index)).intValue());
            Object object6 = reportPackets.get((Object)"rejected");
            Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
            $this$fillMediaSession_u24lambda_u247_u24lambda_u245.setRejected(((Number)((List)object6).get(index)).intValue());
            $this$fillMediaSession_u24lambda_u247_u24lambda_u245.setLost($this$fillMediaSession_u24lambda_u247_u24lambda_u245.getExpected() - $this$fillMediaSession_u24lambda_u247_u24lambda_u245.getReceived());
            mediaSession.setMos(((Number)mos.get(index)).doubleValue());
            mediaSession.setRFactor(((Number)rFactor.get(index)).doubleValue());
            Object $this$fillMediaSession_u24lambda_u247_u24lambda_u246 = object3 = mediaSession.getJitter();
            boolean bl3 = false;
            Object object7 = jitters.get((Object)"min");
            Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Double>");
            ((MediaStatistic.Jitter)$this$fillMediaSession_u24lambda_u247_u24lambda_u246).setMin(((Number)((List)object7).get(index)).doubleValue());
            Object object8 = jitters.get((Object)"max");
            Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Double>");
            ((MediaStatistic.Jitter)$this$fillMediaSession_u24lambda_u247_u24lambda_u246).setMax(((Number)((List)object8).get(index)).doubleValue());
            Object object9 = jitters.get((Object)"avg");
            Intrinsics.checkNotNull((Object)object9, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Double>");
            ((MediaStatistic.Jitter)$this$fillMediaSession_u24lambda_u247_u24lambda_u246).setAvg(((Number)((List)object9).get(index)).doubleValue());
            if (Intrinsics.areEqual((Object)direction, (Object)"out")) {
                $this$fillMediaSession.getOut().add(mediaSession);
                continue;
            }
            $this$fillMediaSession.getIn().add(mediaSession);
        }
    }
}

