/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.rtcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.sip3.commons.domain.payload.RtpReportPayload;
import io.sip3.commons.util.MediaUtil;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.rtcp.RtcpHandler;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Counter;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/sip3/salto/ce/rtcp/RtcpHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "aggregationTimeout", "", "expirationDelay", "instances", "", "logger", "Lmu/KLogger;", "streams", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "Lio/sip3/salto/ce/rtcp/RtcpHandler$RtcpStream;", "handleHep", "", "packet", "Lio/sip3/salto/ce/domain/Packet;", "handleRaw", "handleSenderReport", "senderReport", "Lio/sip3/salto/ce/rtcp/RtcpHandler$SenderReport;", "onSenderReport", "readSenderReport", "headerByte", "", "buffer", "Lio/netty/buffer/ByteBuf;", "start", "Companion", "RtcpReportBlock", "RtcpStream", "SenderReport", "sip3-salto-ce"})
public class RtcpHandler
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private long expirationDelay = 4000L;
    private long aggregationTimeout = 30000L;
    private int instances = 1;
    private PeriodicallyExpiringHashMap<Long, RtcpStream> streams;
    public static final int MAX_VALID_JITTER = 10000;
    public static final int THRESHOLD_COEFFICIENT = 2;

    public void start() {
        Object object;
        JsonObject jsonObject = this.context.config().getJsonObject("media");
        if (jsonObject != null && (jsonObject = jsonObject.getJsonObject("rtcp")) != null) {
            long it;
            Long l;
            JsonObject config = jsonObject;
            boolean bl = false;
            Long l2 = l = config.getLong("expiration_delay");
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getLong(\"expiration_delay\")");
                it = ((Number)l).longValue();
                boolean bl2 = false;
                this.expirationDelay = it;
            }
            Long l3 = l = config.getLong("aggregation_timeout");
            if (l3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getLong(\"aggregation_timeout\")");
                it = ((Number)l).longValue();
                boolean bl3 = false;
                this.aggregationTimeout = it;
            }
        }
        if ((object = this.config().getJsonObject("vertx")) != null && (object = object.getInteger("instances")) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            this.instances = it;
        }
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<Long, RtcpStream, Long>(this){
            final /* synthetic */ RtcpHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(long l, @NotNull RtcpStream stream2) {
                Intrinsics.checkNotNullParameter((Object)stream2, (String)"stream");
                return stream2.getLastPacketTimestamp() + RtcpHandler.access$getAggregationTimeout$p(this.this$0);
            }
        });
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
        this.streams = builder.build(vertx);
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getRtcp(), arg_0 -> RtcpHandler.start$lambda$4(this, arg_0));
        CoroutineScope coroutineScope = (CoroutineScope)GlobalScope.INSTANCE;
        Vertx vertx2 = this.vertx;
        Intrinsics.checkNotNullExpressionValue((Object)vertx2, (String)"vertx");
        CoroutineDispatcher coroutineDispatcher = VertxCoroutineKt.dispatcher((Vertx)vertx2);
        Intrinsics.checkNotNull((Object)coroutineDispatcher, (String)"null cannot be cast to non-null type kotlin.coroutines.CoroutineContext");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)coroutineDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ RtcpHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = RtcpHandler.access$getVertx$p$s-1207500293(this.this$0).sharedData().getLocalCounter(RoutesCE.Companion.getRtcp());
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"vertx.sharedData().getLocalCounter(RoutesCE.rtcp)");
                        this.label = 1;
                        v1 = VertxCoroutineKt.coAwait((Future)v0, (Continuation)((Continuation)this));
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        index = (Counter)v1;
                        var5_4 = RoutesCE.Companion.getRtcp();
                        var4_5 = RtcpHandler.access$getVertx$p$s-1207500293(this.this$0).eventBus();
                        var3_6 = index.getAndIncrement();
                        Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"index.andIncrement");
                        this.L$0 = var4_5;
                        this.L$1 = var5_4;
                        this.label = 2;
                        v2 = VertxCoroutineKt.coAwait((Future)var3_6, (Continuation)((Continuation)this));
                        if (v2 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        var5_4 = (String)this.L$1;
                        var4_5 = (EventBus)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        var6_7 = v2;
                        var4_5.localConsumer(var5_4 + "_" + var6_7, (Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$0(io.sip3.salto.ce.rtcp.RtcpHandler io.vertx.core.eventbus.Message ), (Lio/vertx/core/eventbus/Message;)V)((RtcpHandler)this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(RtcpHandler this$0, Message event) {
                Pair pair = (Pair)event.body();
                Packet packet = (Packet)pair.component1();
                SenderReport senderReport = (SenderReport)pair.component2();
                try {
                    RtcpHandler.access$handleSenderReport(this$0, packet, senderReport);
                }
                catch (Exception e) {
                    RtcpHandler.access$getLogger$p(this$0).error((Throwable)e, (Function0)new Function0<Object>(senderReport){
                        final /* synthetic */ SenderReport $senderReport;
                        {
                            this.$senderReport = $senderReport;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "RtcpHandler 'handleSenderReport()' failed. Sender report: " + JsonObject.mapFrom((Object)this.$senderReport);
                        }
                    });
                }
            }
        }), (int)2, null);
    }

    public void handleRaw(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])packet.getPayload());
        while (payload.readableBytes() > 4) {
            int nextIndex;
            int offset = payload.readerIndex();
            byte headerByte = payload.readByte();
            short payloadType = payload.readUnsignedByte();
            int reportLength = payload.readUnsignedShort() * 4;
            if (offset + reportLength > payload.capacity()) {
                return;
            }
            if (payloadType == 200) {
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)payload, (String)"payload");
                    SenderReport report = this.readSenderReport(headerByte, payload);
                    this.onSenderReport(packet, report);
                }
                catch (Exception e) {
                    this.logger.trace((Throwable)e, (Function0)handleRaw.1.INSTANCE);
                }
            }
            if ((nextIndex = offset + reportLength + 4) <= payload.capacity()) {
                payload.readerIndex(nextIndex);
                continue;
            }
            this.logger.debug((Function0)new Function0<Object>(packet, payload){
                final /* synthetic */ Packet $packet;
                final /* synthetic */ ByteBuf $payload;
                {
                    this.$packet = $packet;
                    this.$payload = $payload;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    Address $this$invoke_u24lambda_u240 = this.$packet.getSrcAddr();
                    boolean bl = false;
                    String src = $this$invoke_u24lambda_u240.getAddr() + ":" + $this$invoke_u24lambda_u240.getPort();
                    Address $this$invoke_u24lambda_u241 = this.$packet.getDstAddr();
                    boolean bl2 = false;
                    String dst = $this$invoke_u24lambda_u241.getAddr() + ":" + $this$invoke_u24lambda_u241.getPort();
                    String packetPayload = ByteBufUtil.prettyHexDump((ByteBuf)this.$payload.readerIndex(0));
                    return "Invalid RTCP packet. Source: " + src + ", Destination: " + dst + ", Packet payload:\n " + packetPayload;
                }
            });
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void handleHep(@NotNull Packet packet) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            var3_2 = packet.getPayload();
            v0 = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"defaultCharset()");
            var4_3 = v0;
            json = new JsonObject(new String(var3_2, var4_3));
            v1 = json.getJsonObject("sender_information");
            if (v1 == null) break block7;
            senderInfo = v1;
            $i$a$-let-RtcpHandler$handleHep$1 = false;
            var7_7 = senderInfo.getString("ntp_timestamp_sec");
            v2 = var7_7;
            if (v2 == null) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getString(\"ntp_timestamp_sec\")");
            v2 = StringsKt.toLongOrNull((String)var7_7);
            if (v2 != null) {
                v3 = v2.longValue();
            } else lbl-1000:
            // 2 sources

            {
                v3 = sec = 0L;
            }
            if ((v4 = (var10_9 = senderInfo.getString("ntp_timestamp_usec"))) == null) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getString(\"ntp_timestamp_usec\")");
            v4 = StringsKt.toLongOrNull((String)var10_9);
            if (v4 != null) {
                v5 = v4.longValue();
            } else lbl-1000:
            // 2 sources

            {
                v5 = usec = 0L;
            }
            if (sec == 0L || usec == 0L) break block7;
            $this$handleHep_u24lambda_u248_u24lambda_u247 = var13_11 = new SenderReport();
            $i$a$-apply-RtcpHandler$handleHep$1$report$1 = false;
            $this$handleHep_u24lambda_u248_u24lambda_u247.setReportBlockCount((byte)json.getInteger("report_count").intValue());
            v6 = json.getLong("ssrc");
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"json.getLong(\"ssrc\")");
            $this$handleHep_u24lambda_u248_u24lambda_u247.setSenderSsrc(((Number)v6).longValue());
            $this$handleHep_u24lambda_u248_u24lambda_u247.setNtpTimestampMsw(sec);
            $this$handleHep_u24lambda_u248_u24lambda_u247.setNtpTimestampLsw(usec);
            v7 = senderInfo.getLong("packets");
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"senderInfo.getLong(\"packets\")");
            $this$handleHep_u24lambda_u248_u24lambda_u247.setSenderPacketCount(((Number)v7).longValue());
            v8 = json.getJsonArray("report_blocks");
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"json.getJsonArray(\"report_blocks\")");
            var16_14 = (Iterable)v8;
            $i$f$forEach = false;
            var18_16 = $this$forEach$iv.iterator();
            while (var18_16.hasNext()) {
                blockReport = element$iv = var18_16.next();
                $i$a$-forEach-RtcpHandler$handleHep$1$report$1$1 = false;
                Intrinsics.checkNotNull(blockReport, (String)"null cannot be cast to non-null type io.vertx.core.json.JsonObject");
                (JsonObject)blockReport;
                var23_21 = var22_20 = new RtcpReportBlock();
                var24_22 = $this$handleHep_u24lambda_u248_u24lambda_u247.getReportBlocks();
                $i$a$-apply-RtcpHandler$handleHep$1$report$1$1$1 = false;
                v9 = ((JsonObject)blockReport).getLong("source_ssrc");
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"blockReport.getLong(\"source_ssrc\")");
                $this$handleHep_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setSsrc(((Number)v9).longValue());
                $this$handleHep_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setFractionLost((short)((JsonObject)blockReport).getInteger("fraction_lost").intValue());
                v10 = ((JsonObject)blockReport).getLong("packets_lost");
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"blockReport.getLong(\"packets_lost\")");
                $this$handleHep_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setCumulativePacketLost(((Number)v10).longValue());
                v11 = ((JsonObject)blockReport).getLong("highest_seq_no");
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"blockReport.getLong(\"highest_seq_no\")");
                $this$handleHep_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setExtendedSeqNumber(((Number)v11).longValue());
                v12 = ((JsonObject)blockReport).getLong("ia_jitter");
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"blockReport.getLong(\"ia_jitter\")");
                $this$handleHep_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setInterarrivalJitter(((Number)v12).longValue());
                var26_24 = ((JsonObject)blockReport).getString("lsr");
                v13 = var26_24;
                if (v13 == null) ** GOTO lbl-1000
                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"getString(\"lsr\")");
                v13 = StringsKt.toLongOrNull((String)var26_24);
                if (v13 != null) {
                    v14 = v13.longValue();
                } else lbl-1000:
                // 2 sources

                {
                    v14 = 0L;
                }
                $this$handleHep_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setLsrTimestamp(v14);
                var24_22.add(var22_20);
            }
            report = var13_11;
            this.onSenderReport(packet, report);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SenderReport readSenderReport(byte headerByte, ByteBuf buffer) {
        SenderReport senderReport;
        SenderReport $this$readSenderReport_u24lambda_u2412 = senderReport = new SenderReport();
        boolean bl = false;
        $this$readSenderReport_u24lambda_u2412.setReportBlockCount((byte)(headerByte & 0x1F));
        $this$readSenderReport_u24lambda_u2412.setSenderSsrc(buffer.readUnsignedInt());
        $this$readSenderReport_u24lambda_u2412.setNtpTimestampMsw(buffer.readUnsignedInt());
        $this$readSenderReport_u24lambda_u2412.setNtpTimestampLsw(buffer.readUnsignedInt());
        buffer.skipBytes(4);
        $this$readSenderReport_u24lambda_u2412.setSenderPacketCount(buffer.readUnsignedInt());
        buffer.skipBytes(4);
        int n = $this$readSenderReport_u24lambda_u2412.getReportBlockCount();
        int n2 = 0;
        while (n2 < n) {
            void $this$readSenderReport_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
            RtcpReportBlock rtcpReportBlock;
            int it = n2++;
            boolean bl2 = false;
            RtcpReportBlock rtcpReportBlock2 = rtcpReportBlock = new RtcpReportBlock();
            List<RtcpReportBlock> list = $this$readSenderReport_u24lambda_u2412.getReportBlocks();
            boolean bl3 = false;
            $this$readSenderReport_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setSsrc(buffer.readUnsignedInt());
            long value = buffer.readUnsignedInt();
            boolean bl4 = false;
            $this$readSenderReport_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setFractionLost((short)((value & 0xF000L) >> 24));
            $this$readSenderReport_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setCumulativePacketLost(value & 0xFFFL);
            $this$readSenderReport_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setExtendedSeqNumber(buffer.readUnsignedInt());
            $this$readSenderReport_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setInterarrivalJitter(buffer.readUnsignedInt());
            $this$readSenderReport_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setLsrTimestamp(buffer.readUnsignedInt());
            buffer.skipBytes(4);
            list.add(rtcpReportBlock);
        }
        return senderReport;
    }

    private final void onSenderReport(Packet packet, SenderReport senderReport) {
        int index = Integer.hashCode(packet.getSrcAddr().getPort() * packet.getDstAddr().getPort()) % this.instances;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
        EventBusUtilKt.localSend$default((EventBus)eventBus, (String)(RoutesCE.Companion.getRtcp() + "_" + index), (Object)new Pair((Object)packet, (Object)senderReport), null, (int)4, null);
    }

    private final void handleSenderReport(Packet packet, SenderReport senderReport) {
        long streamId = MediaUtil.INSTANCE.rtpStreamId(packet.getSrcAddr().getPort(), packet.getDstAddr().getPort(), senderReport.getSenderSsrc());
        PeriodicallyExpiringHashMap<Long, RtcpStream> periodicallyExpiringHashMap = this.streams;
        if (periodicallyExpiringHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streams");
            periodicallyExpiringHashMap = null;
        }
        RtcpStream stream2 = (RtcpStream)periodicallyExpiringHashMap.getOrPut((Object)streamId, (Function0)new Function0<RtcpStream>(packet){
            final /* synthetic */ Packet $packet;
            {
                this.$packet = $packet;
                super(0);
            }

            @NotNull
            public final RtcpStream invoke() {
                RtcpStream rtcpStream = new RtcpStream();
                Packet packet = this.$packet;
                RtcpStream $this$invoke_u24lambda_u240 = rtcpStream;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setCreatedAt(packet.getCreatedAt());
                $this$invoke_u24lambda_u240.setDstAddr(packet.getDstAddr());
                $this$invoke_u24lambda_u240.setSrcAddr(packet.getSrcAddr());
                return rtcpStream;
            }
        });
        Iterable $this$forEach$iv = senderReport.getReportBlocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpReportPayload rtpReportPayload;
            RtcpReportBlock report = (RtcpReportBlock)element$iv;
            boolean bl = false;
            if (report.getInterarrivalJitter() < 10000L) {
                stream2.setLastJitter(report.getInterarrivalJitter());
            }
            int packetCount = (int)senderReport.getSenderPacketCount();
            RtpReportPayload $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413 = rtpReportPayload = new RtpReportPayload();
            boolean bl2 = false;
            $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setReportedAt(System.currentTimeMillis());
            $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setCreatedAt(stream2.getLastPacketTimestamp() > 0L ? stream2.getLastPacketTimestamp() : $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.getReportedAt());
            $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setSource((byte)1);
            $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setSsrc(report.getSsrc());
            $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setLastJitter(stream2.getLastJitter());
            $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setAvgJitter(stream2.getLastJitter());
            $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setMinJitter(stream2.getLastJitter());
            $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setMaxJitter(stream2.getLastJitter());
            if (stream2.getPreviousReport() == null) {
                $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setLostPacketCount((int)report.getCumulativePacketLost());
                $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setExpectedPacketCount(packetCount);
                $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setReceivedPacketCount(packetCount - $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.getLostPacketCount());
                $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setFractionLost((float)$this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.getLostPacketCount() / (float)$this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.getExpectedPacketCount());
            } else {
                long l = report.getCumulativePacketLost();
                RtcpReportBlock rtcpReportBlock = stream2.getPreviousReport();
                Intrinsics.checkNotNull((Object)rtcpReportBlock);
                $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setLostPacketCount((int)(l - rtcpReportBlock.getCumulativePacketLost()));
                long l2 = report.getExtendedSeqNumber();
                RtcpReportBlock rtcpReportBlock2 = stream2.getPreviousReport();
                Intrinsics.checkNotNull((Object)rtcpReportBlock2);
                $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setExpectedPacketCount((int)(l2 - rtcpReportBlock2.getExtendedSeqNumber()));
                int n = $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.getExpectedPacketCount();
                Integer n2 = stream2.getPreviousPacketCount();
                Intrinsics.checkNotNull((Object)n2);
                if (n > (packetCount - n2) * 2 || $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.getExpectedPacketCount() <= 0) {
                    Integer n3 = stream2.getPreviousPacketCount();
                    Intrinsics.checkNotNull((Object)n3);
                    $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setExpectedPacketCount(packetCount - n3);
                }
                $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setReceivedPacketCount($this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.getExpectedPacketCount() - $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.getLostPacketCount());
                $this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.setFractionLost((float)$this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.getLostPacketCount() / (float)$this$handleSenderReport_u24lambda_u2414_u24lambda_u2413.getExpectedPacketCount());
            }
            RtpReportPayload payload = rtpReportPayload;
            stream2.setPreviousReport(report);
            stream2.setPreviousPacketCount(packetCount);
            EventBus eventBus = this.vertx.eventBus();
            Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
            EventBusUtilKt.localSend$default((EventBus)eventBus, (String)(RoutesCE.Companion.getRtpr() + "_rtcp"), (Object)new Pair((Object)packet, (Object)payload), null, (int)4, null);
        }
        stream2.setLastPacketTimestamp(packet.getCreatedAt());
    }

    private static final void start$lambda$4(RtcpHandler this$0, Message event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Packet packet = (Packet)event.body();
        String string = packet.getSource();
        if (Intrinsics.areEqual((Object)string, (Object)"sip3")) {
            try {
                Intrinsics.checkNotNullExpressionValue((Object)packet, (String)"packet");
                this$0.handleRaw(packet);
            }
            catch (Exception e) {
                this$0.logger.error((Throwable)e, (Function0)start.4.1.INSTANCE);
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"hep3")) {
            try {
                Intrinsics.checkNotNullExpressionValue((Object)packet, (String)"packet");
                this$0.handleHep(packet);
            }
            catch (Exception e) {
                this$0.logger.error((Throwable)e, (Function0)start.4.2.INSTANCE);
            }
        }
    }

    public static final /* synthetic */ long access$getAggregationTimeout$p(RtcpHandler $this) {
        return $this.aggregationTimeout;
    }

    public static final /* synthetic */ Vertx access$getVertx$p$s-1207500293(RtcpHandler $this) {
        return $this.vertx;
    }

    public static final /* synthetic */ void access$handleSenderReport(RtcpHandler $this, Packet packet, SenderReport senderReport) {
        $this.handleSenderReport(packet, senderReport);
    }

    public static final /* synthetic */ KLogger access$getLogger$p(RtcpHandler $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/sip3/salto/ce/rtcp/RtcpHandler$Companion;", "", "()V", "MAX_VALID_JITTER", "", "THRESHOLD_COEFFICIENT", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\f\"\u0004\b'\u0010\u000e\u00a8\u0006("}, d2={"Lio/sip3/salto/ce/rtcp/RtcpHandler$RtcpStream;", "", "()V", "createdAt", "", "getCreatedAt", "()J", "setCreatedAt", "(J)V", "dstAddr", "Lio/sip3/salto/ce/domain/Address;", "getDstAddr", "()Lio/sip3/salto/ce/domain/Address;", "setDstAddr", "(Lio/sip3/salto/ce/domain/Address;)V", "lastJitter", "", "getLastJitter", "()F", "setLastJitter", "(F)V", "lastPacketTimestamp", "getLastPacketTimestamp", "setLastPacketTimestamp", "previousPacketCount", "", "getPreviousPacketCount", "()Ljava/lang/Integer;", "setPreviousPacketCount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "previousReport", "Lio/sip3/salto/ce/rtcp/RtcpHandler$RtcpReportBlock;", "getPreviousReport", "()Lio/sip3/salto/ce/rtcp/RtcpHandler$RtcpReportBlock;", "setPreviousReport", "(Lio/sip3/salto/ce/rtcp/RtcpHandler$RtcpReportBlock;)V", "srcAddr", "getSrcAddr", "setSrcAddr", "sip3-salto-ce"})
    public static final class RtcpStream {
        private long createdAt;
        public Address dstAddr;
        public Address srcAddr;
        private float lastJitter;
        @Nullable
        private RtcpReportBlock previousReport;
        @Nullable
        private Integer previousPacketCount;
        private long lastPacketTimestamp;

        public final long getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(long l) {
            this.createdAt = l;
        }

        @NotNull
        public final Address getDstAddr() {
            Address address = this.dstAddr;
            if (address != null) {
                return address;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"dstAddr");
            return null;
        }

        public final void setDstAddr(@NotNull Address address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"<set-?>");
            this.dstAddr = address;
        }

        @NotNull
        public final Address getSrcAddr() {
            Address address = this.srcAddr;
            if (address != null) {
                return address;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"srcAddr");
            return null;
        }

        public final void setSrcAddr(@NotNull Address address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"<set-?>");
            this.srcAddr = address;
        }

        public final float getLastJitter() {
            return this.lastJitter;
        }

        public final void setLastJitter(float f) {
            this.lastJitter = f;
        }

        @Nullable
        public final RtcpReportBlock getPreviousReport() {
            return this.previousReport;
        }

        public final void setPreviousReport(@Nullable RtcpReportBlock rtcpReportBlock) {
            this.previousReport = rtcpReportBlock;
        }

        @Nullable
        public final Integer getPreviousPacketCount() {
            return this.previousPacketCount;
        }

        public final void setPreviousPacketCount(@Nullable Integer n) {
            this.previousPacketCount = n;
        }

        public final long getLastPacketTimestamp() {
            return this.lastPacketTimestamp;
        }

        public final void setLastPacketTimestamp(long l) {
            this.lastPacketTimestamp = l;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\f\"\u0004\b!\u0010\u000eR\u001a\u0010\"\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\f\"\u0004\b$\u0010\u000e\u00a8\u0006%"}, d2={"Lio/sip3/salto/ce/rtcp/RtcpHandler$SenderReport;", "", "()V", "length", "", "getLength", "()I", "setLength", "(I)V", "ntpTimestampLsw", "", "getNtpTimestampLsw", "()J", "setNtpTimestampLsw", "(J)V", "ntpTimestampMsw", "getNtpTimestampMsw", "setNtpTimestampMsw", "reportBlockCount", "", "getReportBlockCount", "()B", "setReportBlockCount", "(B)V", "reportBlocks", "", "Lio/sip3/salto/ce/rtcp/RtcpHandler$RtcpReportBlock;", "getReportBlocks", "()Ljava/util/List;", "setReportBlocks", "(Ljava/util/List;)V", "senderPacketCount", "getSenderPacketCount", "setSenderPacketCount", "senderSsrc", "getSenderSsrc", "setSenderSsrc", "sip3-salto-ce"})
    public static final class SenderReport {
        private byte reportBlockCount;
        private int length;
        private long senderSsrc;
        private long ntpTimestampMsw;
        private long ntpTimestampLsw;
        private long senderPacketCount;
        @NotNull
        private List<RtcpReportBlock> reportBlocks = new ArrayList();

        public final byte getReportBlockCount() {
            return this.reportBlockCount;
        }

        public final void setReportBlockCount(byte by) {
            this.reportBlockCount = by;
        }

        public final int getLength() {
            return this.length;
        }

        public final void setLength(int n) {
            this.length = n;
        }

        public final long getSenderSsrc() {
            return this.senderSsrc;
        }

        public final void setSenderSsrc(long l) {
            this.senderSsrc = l;
        }

        public final long getNtpTimestampMsw() {
            return this.ntpTimestampMsw;
        }

        public final void setNtpTimestampMsw(long l) {
            this.ntpTimestampMsw = l;
        }

        public final long getNtpTimestampLsw() {
            return this.ntpTimestampLsw;
        }

        public final void setNtpTimestampLsw(long l) {
            this.ntpTimestampLsw = l;
        }

        public final long getSenderPacketCount() {
            return this.senderPacketCount;
        }

        public final void setSenderPacketCount(long l) {
            this.senderPacketCount = l;
        }

        @NotNull
        public final List<RtcpReportBlock> getReportBlocks() {
            return this.reportBlocks;
        }

        public final void setReportBlocks(@NotNull List<RtcpReportBlock> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.reportBlocks = list;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\n\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\b\u00a8\u0006\u001b"}, d2={"Lio/sip3/salto/ce/rtcp/RtcpHandler$RtcpReportBlock;", "", "()V", "cumulativePacketLost", "", "getCumulativePacketLost", "()J", "setCumulativePacketLost", "(J)V", "extendedSeqNumber", "getExtendedSeqNumber", "setExtendedSeqNumber", "fractionLost", "", "getFractionLost", "()S", "setFractionLost", "(S)V", "interarrivalJitter", "getInterarrivalJitter", "setInterarrivalJitter", "lsrTimestamp", "getLsrTimestamp", "setLsrTimestamp", "ssrc", "getSsrc", "setSsrc", "sip3-salto-ce"})
    public static final class RtcpReportBlock {
        private long ssrc;
        private short fractionLost;
        private long cumulativePacketLost;
        private long extendedSeqNumber;
        private long interarrivalJitter;
        private long lsrTimestamp;

        public final long getSsrc() {
            return this.ssrc;
        }

        public final void setSsrc(long l) {
            this.ssrc = l;
        }

        public final short getFractionLost() {
            return this.fractionLost;
        }

        public final void setFractionLost(short s) {
            this.fractionLost = s;
        }

        public final long getCumulativePacketLost() {
            return this.cumulativePacketLost;
        }

        public final void setCumulativePacketLost(long l) {
            this.cumulativePacketLost = l;
        }

        public final long getExtendedSeqNumber() {
            return this.extendedSeqNumber;
        }

        public final void setExtendedSeqNumber(long l) {
            this.extendedSeqNumber = l;
        }

        public final long getInterarrivalJitter() {
            return this.interarrivalJitter;
        }

        public final void setInterarrivalJitter(long l) {
            this.interarrivalJitter = l;
        }

        public final long getLsrTimestamp() {
            return this.lsrTimestamp;
        }

        public final void setLsrTimestamp(long l) {
            this.lsrTimestamp = l;
        }
    }
}

