/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.management.host;

import io.sip3.salto.ce.management.host.HostRegistry;
import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.kotlin.ext.mongo.UpdateOptionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.commons.net.util.SubnetUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u000bJ\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u000bJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u000bJ\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\bJ\b\u0010\u001f\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/sip3/salto/ce/management/host/HostRegistry;", "", "()V", "checkPeriod", "", "client", "Lio/vertx/ext/mongo/MongoClient;", "config", "Lio/vertx/core/json/JsonObject;", "features", "", "", "", "hosts", "logger", "Lmu/KLogger;", "mappings", "vertx", "Lio/vertx/core/Vertx;", "getAddrMapping", "addr", "getFeatures", "name", "getHostName", "port", "", "getInstance", "init", "", "save", "host", "updateHosts", "sip3-salto-ce"})
public final class HostRegistry {
    @NotNull
    public static final HostRegistry INSTANCE = new HostRegistry();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static long checkPeriod = 30000L;
    @Nullable
    private static Vertx vertx;
    private static JsonObject config;
    private static MongoClient client;
    @NotNull
    private static Map<String, String> hosts;
    @NotNull
    private static Map<String, String> mappings;
    @NotNull
    private static Map<String, ? extends Set<String>> features;

    private HostRegistry() {
    }

    @NotNull
    public final synchronized HostRegistry getInstance(@NotNull Vertx vertx, @NotNull JsonObject config) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (HostRegistry.vertx == null) {
            HostRegistry.vertx = vertx;
            HostRegistry.config = config;
            this.init();
        }
        return this;
    }

    private final void init() {
        JsonObject jsonObject;
        Object object;
        JsonObject jsonObject2 = config;
        if (jsonObject2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            jsonObject2 = null;
        }
        if ((object = jsonObject2.getJsonObject("hosts")) != null && (object = object.getLong("check_period")) != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            checkPeriod = it;
        }
        if ((jsonObject = config) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            jsonObject = null;
        }
        JsonObject it = jsonObject.getJsonObject("mongo");
        boolean bl = false;
        Vertx vertx = HostRegistry.vertx;
        Intrinsics.checkNotNull((Object)vertx);
        JsonObject jsonObject3 = it.getJsonObject("management");
        if (jsonObject3 == null) {
            jsonObject3 = it;
        }
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"it.getJsonObject(\"management\") ?: it");
        client = io.sip3.commons.mongo.MongoClient.INSTANCE.createShared(vertx, jsonObject3);
        Vertx vertx2 = HostRegistry.vertx;
        Intrinsics.checkNotNull((Object)vertx2);
        vertx2.setPeriodic(0L, checkPeriod, HostRegistry::init$lambda$2);
    }

    @Nullable
    public final String getHostName(@NotNull String addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        return hosts.get(addr);
    }

    @Nullable
    public final String getHostName(@NotNull String addr, int port) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        String string = hosts.get(addr);
        if (string == null) {
            string = hosts.get(addr + ":" + port);
        }
        return string;
    }

    @Nullable
    public final String getAddrMapping(@NotNull String addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        return mappings.get(addr);
    }

    @Nullable
    public final Set<String> getFeatures(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return features.get(name);
    }

    public final void save(@NotNull JsonObject host) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        JsonObject $this$save_u24lambda_u243 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$save_u24lambda_u243.put("name", (Object)host.getString("name"));
        JsonObject query = jsonObject;
        MongoClient mongoClient = client;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            mongoClient = null;
        }
        mongoClient.replaceDocumentsWithOptions("hosts", query, host, UpdateOptionsKt.updateOptionsOf$default(null, null, null, null, null, null, (Boolean)true, null, (int)191, null), HostRegistry::save$lambda$4);
    }

    private final void updateHosts() {
        MongoClient mongoClient = client;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            mongoClient = null;
        }
        mongoClient.find("hosts", new JsonObject()).onFailure(HostRegistry::updateHosts$lambda$5).onSuccess(HostRegistry::updateHosts$lambda$15);
    }

    private static final void init$lambda$2(Long it) {
        INSTANCE.updateHosts();
    }

    private static final void save$lambda$4(AsyncResult asr) {
        if (asr.failed()) {
            logger.error(asr.cause(), (Function0)save.1.1.INSTANCE);
        }
    }

    private static final void updateHosts$lambda$5(Throwable it) {
        logger.error(it, (Function0)updateHosts.1.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private static final void updateHosts$lambda$15(List result) {
        Map tmpHosts = new LinkedHashMap();
        Map tmpMappings = new LinkedHashMap();
        Map tmpFeatures = new LinkedHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        Iterable $this$forEach$iv = result;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonObject host = (JsonObject)element$iv;
            boolean bl = false;
            String name = host.getString("name");
            try {
                Object element$iv2;
                Iterable $this$forEach$iv2;
                boolean $i$f$forEach2;
                Collection collection;
                Iterator iterator;
                Iterator $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Collection destination$iv$iv;
                Iterable $this$map$iv;
                boolean $i$f$map;
                Iterable iterable;
                JsonArray jsonArray = host.getJsonArray("addr");
                if (jsonArray != null) {
                    iterable = (Iterable)jsonArray;
                    $i$f$map = false;
                    void var14_15 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Object item$iv$iv;
                        Object t = item$iv$iv = iterator.next();
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)it);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$forEach2 = false;
                    $this$mapTo$iv$iv = $this$forEach$iv2.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        void $this$forEach$iv3;
                        SubnetUtils item$iv$iv;
                        element$iv2 = $this$mapTo$iv$iv.next();
                        String addr = (String)element$iv2;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                        tmpHosts.put(addr, name);
                        if (!StringsKt.contains$default((CharSequence)addr, (CharSequence)"/", (boolean)false, (int)2, null)) continue;
                        SubnetUtils $this$updateHosts_u24lambda_u2415_u24lambda_u2414_u24lambda_u249_u24lambda_u247 = item$iv$iv = new SubnetUtils(addr);
                        int n = 0;
                        $this$updateHosts_u24lambda_u2415_u24lambda_u2414_u24lambda_u249_u24lambda_u247.setInclusiveHostCount(true);
                        String[] stringArray = item$iv$iv.getInfo().getAllAddresses();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"SubnetUtils(addr).apply \u2026            .allAddresses");
                        Object[] objectArray = stringArray;
                        boolean $i$f$forEach3 = false;
                        for (void element$iv3 : $this$forEach$iv3) {
                            String it = (String)element$iv3;
                            boolean bl4 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            tmpHosts.put(it, name);
                        }
                    }
                }
                if ((jsonArray = host.getJsonArray("mapping")) != null) {
                    $this$forEach$iv2 = (Iterable)jsonArray;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    Iterator bl3 = $this$mapTo$iv$iv.iterator();
                    while (bl3.hasNext()) {
                        void it;
                        Object item$iv$iv;
                        Object $this$updateHosts_u24lambda_u2415_u24lambda_u2414_u24lambda_u249_u24lambda_u247 = item$iv$iv = bl3.next();
                        collection = destination$iv$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type io.vertx.core.json.JsonObject");
                        collection.add((JsonObject)it);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$forEach2 = false;
                    $this$mapTo$iv$iv = $this$forEach$iv2.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        String bl5;
                        String it;
                        element$iv2 = $this$mapTo$iv$iv.next();
                        JsonObject it2 = (JsonObject)element$iv2;
                        boolean bl6 = false;
                        Map item$iv$iv = tmpMappings;
                        Intrinsics.checkNotNullExpressionValue((Object)it2.getString("source"), (String)"it.getString(\"source\")");
                        Intrinsics.checkNotNullExpressionValue((Object)it2.getString("target"), (String)"it.getString(\"target\")");
                        item$iv$iv.put(it, bl5);
                    }
                }
                if ((jsonArray = host.getJsonArray("feature")) == null) continue;
                $this$forEach$iv2 = (Iterable)jsonArray;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv;
                    Object it = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.String");
                    collection.add((String)it);
                }
                iterable = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (iterable == null) continue;
                Iterable it = iterable;
                boolean bl8 = false;
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                tmpFeatures.put(name, it);
            }
            catch (Exception e) {
                logger.error((Throwable)e, (Function0)new Function0<Object>(host){
                    final /* synthetic */ JsonObject $host;
                    {
                        this.$host = $host;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Router `mapHostToAddr()` failed. Host: " + this.$host;
                    }
                });
            }
        }
        hosts = tmpHosts;
        mappings = tmpMappings;
        features = tmpFeatures;
    }

    static {
        hosts = MapsKt.emptyMap();
        mappings = MapsKt.emptyMap();
        features = MapsKt.emptyMap();
    }
}

