/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.util;

import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.Content;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import io.sip3.salto.ce.sdp.SessionDescriptionParser;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.sip.address.TelURL;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.restcomm.media.sdp.SessionDescription;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u00a2\u0006\u0002\u0010\u0007\u001a\u0011\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0002\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u000e*\u00020\u0002\u001a\u0016\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0011*\u00020\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u000e*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0002\u001a\u0011\u0010\u0018\u001a\u0004\u0018\u00010\t*\u00020\u0002\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u000e\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0002\u001a\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0001*\u00020\u001d2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u001e"}, d2={"branchId", "", "Lgov/nist/javax/sip/message/SIPMessage;", "callId", "cseqMethod", "cseqNumber", "", "(Lgov/nist/javax/sip/message/SIPMessage;)Ljava/lang/Long;", "expires", "", "(Lgov/nist/javax/sip/message/SIPMessage;)Ljava/lang/Integer;", "fromUri", "fromUserOrNumber", "allowEmptyUser", "", "hasSdp", "headersMap", "", "matches", "Lgov/nist/javax/sip/message/Content;", "proto", "method", "sessionDescription", "Lorg/restcomm/media/sdp/SessionDescription;", "statusCode", "toUri", "toUserOrNumber", "transactionId", "userOrNumber", "Ljavax/sip/address/URI;", "sip3-salto-ce"})
public final class SIPMessageUtilKt {
    @Nullable
    public static final String callId(@NotNull SIPMessage $this$callId) {
        Intrinsics.checkNotNullParameter((Object)$this$callId, (String)"<this>");
        CallIdHeader callIdHeader = $this$callId.getCallId();
        return callIdHeader != null ? callIdHeader.getCallId() : null;
    }

    @Nullable
    public static final String branchId(@NotNull SIPMessage $this$branchId) {
        Intrinsics.checkNotNullParameter((Object)$this$branchId, (String)"<this>");
        Via via = $this$branchId.getTopmostVia();
        return via != null ? via.getBranch() : null;
    }

    @Nullable
    public static final String toUri(@NotNull SIPMessage $this$toUri) {
        Intrinsics.checkNotNullParameter((Object)$this$toUri, (String)"<this>");
        ToHeader toHeader = $this$toUri.getTo();
        return toHeader != null && (toHeader = toHeader.getAddress()) != null && (toHeader = toHeader.getURI()) != null ? toHeader.toString() : null;
    }

    @Nullable
    public static final String toUserOrNumber(@NotNull SIPMessage $this$toUserOrNumber, boolean allowEmptyUser) {
        Intrinsics.checkNotNullParameter((Object)$this$toUserOrNumber, (String)"<this>");
        ToHeader toHeader = $this$toUserOrNumber.getTo();
        return toHeader != null && (toHeader = toHeader.getAddress()) != null && (toHeader = toHeader.getURI()) != null ? SIPMessageUtilKt.userOrNumber((URI)toHeader, allowEmptyUser) : null;
    }

    public static /* synthetic */ String toUserOrNumber$default(SIPMessage sIPMessage, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SIPMessageUtilKt.toUserOrNumber(sIPMessage, bl);
    }

    @Nullable
    public static final String fromUri(@NotNull SIPMessage $this$fromUri) {
        Intrinsics.checkNotNullParameter((Object)$this$fromUri, (String)"<this>");
        FromHeader fromHeader = $this$fromUri.getFrom();
        return fromHeader != null && (fromHeader = fromHeader.getAddress()) != null && (fromHeader = fromHeader.getURI()) != null ? fromHeader.toString() : null;
    }

    @Nullable
    public static final String fromUserOrNumber(@NotNull SIPMessage $this$fromUserOrNumber, boolean allowEmptyUser) {
        Intrinsics.checkNotNullParameter((Object)$this$fromUserOrNumber, (String)"<this>");
        FromHeader fromHeader = $this$fromUserOrNumber.getFrom();
        return fromHeader != null && (fromHeader = fromHeader.getAddress()) != null && (fromHeader = fromHeader.getURI()) != null ? SIPMessageUtilKt.userOrNumber((URI)fromHeader, allowEmptyUser) : null;
    }

    public static /* synthetic */ String fromUserOrNumber$default(SIPMessage sIPMessage, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SIPMessageUtilKt.fromUserOrNumber(sIPMessage, bl);
    }

    @Nullable
    public static final String cseqMethod(@NotNull SIPMessage $this$cseqMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$cseqMethod, (String)"<this>");
        CSeqHeader cSeqHeader = $this$cseqMethod.getCSeq();
        return cSeqHeader != null ? cSeqHeader.getMethod() : null;
    }

    @Nullable
    public static final Long cseqNumber(@NotNull SIPMessage $this$cseqNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$cseqNumber, (String)"<this>");
        CSeqHeader cSeqHeader = $this$cseqNumber.getCSeq();
        return cSeqHeader != null ? Long.valueOf(cSeqHeader.getSeqNumber()) : null;
    }

    @Nullable
    public static final String method(@NotNull SIPMessage $this$method) {
        Intrinsics.checkNotNullParameter((Object)$this$method, (String)"<this>");
        SIPRequest sIPRequest = $this$method instanceof SIPRequest ? (SIPRequest)$this$method : null;
        return sIPRequest != null && (sIPRequest = sIPRequest.getRequestLine()) != null ? sIPRequest.getMethod() : null;
    }

    @Nullable
    public static final Integer statusCode(@NotNull SIPMessage $this$statusCode) {
        Intrinsics.checkNotNullParameter((Object)$this$statusCode, (String)"<this>");
        SIPResponse sIPResponse = $this$statusCode instanceof SIPResponse ? (SIPResponse)$this$statusCode : null;
        return sIPResponse != null ? Integer.valueOf(sIPResponse.getStatusCode()) : null;
    }

    @NotNull
    public static final String transactionId(@NotNull SIPMessage $this$transactionId) {
        Intrinsics.checkNotNullParameter((Object)$this$transactionId, (String)"<this>");
        return SIPMessageUtilKt.callId($this$transactionId) + ":" + SIPMessageUtilKt.branchId($this$transactionId) + ":" + SIPMessageUtilKt.cseqNumber($this$transactionId);
    }

    @NotNull
    public static final Map<String, String> headersMap(@NotNull SIPMessage $this$headersMap) {
        SIPRequest it;
        Map map;
        Intrinsics.checkNotNullParameter((Object)$this$headersMap, (String)"<this>");
        Map $this$headersMap_u24lambda_u243 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        SIPRequest sIPRequest = $this$headersMap instanceof SIPRequest ? (SIPRequest)$this$headersMap : null;
        if (sIPRequest != null) {
            it = sIPRequest;
            boolean bl2 = false;
            String string = it.getRequestLine().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.requestLine.toString()");
            $this$headersMap_u24lambda_u243.put("request-line", StringsKt.replace$default((String)string, (String)"\r\n", (String)"", (boolean)false, (int)4, null));
        }
        SIPResponse sIPResponse = $this$headersMap instanceof SIPResponse ? (SIPResponse)$this$headersMap : null;
        if (sIPResponse != null) {
            it = sIPResponse;
            boolean bl3 = false;
            String string = it.getStatusLine().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.statusLine.toString()");
            $this$headersMap_u24lambda_u243.put("status-line", StringsKt.replace$default((String)string, (String)"\r\n", (String)"", (boolean)false, (int)4, null));
        }
        Iterator iterator = $this$headersMap.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"headers");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            SIPHeader header = (SIPHeader)element$iv;
            boolean bl4 = false;
            String string = header.getHeaderName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"header.headerName");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String string3 = header.getHeaderValue();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"header.headerValue");
            $this$headersMap_u24lambda_u243.put(string2, string3);
        }
        return map;
    }

    public static final boolean hasSdp(@NotNull SIPMessage $this$hasSdp) {
        block3: {
            Iterator iterator;
            Intrinsics.checkNotNullParameter((Object)$this$hasSdp, (String)"<this>");
            ContentType contentType = $this$hasSdp.getContentTypeHeader();
            if (contentType == null) break block3;
            ContentType contentType2 = contentType;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)contentType2.getMediaSubType(), (Object)"sdp")) {
                return true;
            }
            Object object = $this$hasSdp.getMultipartMimeContent();
            if (object != null && (object = (iterator = object.getContents())) != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"contents");
                Iterator $this$forEach$iv = iterator;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv;
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    Content mimeContent = (Content)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)mimeContent, (String)"mimeContent");
                    if (!SIPMessageUtilKt.matches(mimeContent, "sdp")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static final SessionDescription sessionDescription(@NotNull SIPMessage $this$sessionDescription) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$sessionDescription, (String)"<this>");
            ContentType contentType = $this$sessionDescription.getContentTypeHeader();
            if (Intrinsics.areEqual((Object)(contentType != null ? contentType.getMediaSubType() : null), (Object)"sdp")) {
                return SessionDescriptionParser.INSTANCE.parse($this$sessionDescription.getMessageContent());
            }
            Object object = $this$sessionDescription.getMultipartMimeContent();
            if (object == null || (object = object.getContents()) == null) break block2;
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Object object2 = $this$forEach$iv;
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                Content mimeContent = (Content)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)mimeContent, (String)"mimeContent");
                if (!SIPMessageUtilKt.matches(mimeContent, "sdp")) continue;
                return SessionDescriptionParser.INSTANCE.parse(mimeContent.getContent().toString());
            }
        }
        return null;
    }

    @Nullable
    public static final Integer expires(@NotNull SIPMessage $this$expires) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$expires, (String)"<this>");
        ExpiresHeader expiresHeader = $this$expires.getExpires();
        return expiresHeader != null ? Integer.valueOf(expiresHeader.getExpires()) : ((object = $this$expires.getContactHeader()) != null && (object = object.getContactParms()) != null && (object = object.getValue("expires")) != null && (object = object.toString()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null);
    }

    @Nullable
    public static final String userOrNumber(@NotNull URI $this$userOrNumber, boolean allowEmptyUser) {
        String string;
        block8: {
            URI uRI;
            block6: {
                block7: {
                    CharSequence charSequence;
                    Intrinsics.checkNotNullParameter((Object)$this$userOrNumber, (String)"<this>");
                    uRI = $this$userOrNumber;
                    if (!(uRI instanceof SipUri)) break block6;
                    string = ((SipUri)$this$userOrNumber).getUser();
                    if (string == null) break block7;
                    CharSequence charSequence2 = string;
                    if (StringsKt.isBlank((CharSequence)charSequence2)) {
                        boolean bl = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    if ((string = (String)charSequence) != null) break block8;
                }
                string = allowEmptyUser ? ((SipUri)$this$userOrNumber).getHost() : null;
                break block8;
            }
            if (uRI instanceof TelURL) {
                string = ((TelURL)$this$userOrNumber).getPhoneNumber();
            } else {
                throw new IllegalArgumentException("Unsupported URI format: '" + $this$userOrNumber + "'");
            }
        }
        return string;
    }

    public static /* synthetic */ String userOrNumber$default(URI uRI, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SIPMessageUtilKt.userOrNumber(uRI, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean matches(@NotNull Content $this$matches, @NotNull String proto) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        ContentTypeHeader contentTypeHeader = $this$matches.getContentTypeHeader();
        Object object = contentTypeHeader;
        if (contentTypeHeader == null) return false;
        String string = object.getContentSubType();
        object = string;
        if (string == null) return false;
        String string2 = ((String)object).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        object = string2;
        if (string2 == null) return false;
        CharSequence charSequence = (CharSequence)object;
        String string3 = proto.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        boolean bl = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null);
        return bl;
    }
}

