/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.server;

import io.micrometer.core.instrument.Counter;
import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.server.AbstractServer;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH&J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/sip3/salto/ce/server/AbstractServer;", "Lio/vertx/core/AbstractVerticle;", "()V", "logger", "Lmu/KLogger;", "packetsReceived", "Lio/micrometer/core/instrument/Counter;", "onRawPacket", "", "sender", "Lio/sip3/salto/ce/domain/Address;", "buffer", "Lio/vertx/core/buffer/Buffer;", "readConfig", "start", "startServer", "Companion", "sip3-salto-ce"})
public abstract class AbstractServer
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private final Counter packetsReceived = Metrics.counter$default((Metrics)Metrics.INSTANCE, (String)"packets_received", null, (int)2, null);
    @NotNull
    public static final String PROTO_SIP3 = "SIP3";
    @NotNull
    public static final String PROTO_HEP3 = "HEP3";
    @NotNull
    private static final byte[] PROTO_HEP2;

    public void start() {
        this.readConfig();
        this.startServer();
    }

    public abstract void readConfig();

    public abstract void startServer();

    public void onRawPacket(@NotNull Address sender, @NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.packetsReceived.increment();
        if (buffer.length() < 4) {
            return;
        }
        String string = buffer.getString(0, 4);
        if (Intrinsics.areEqual((Object)string, (Object)PROTO_SIP3)) {
            EventBus eventBus = this.vertx.eventBus();
            Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
            EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getSip3(), (Object)new Pair((Object)sender, (Object)buffer), null, (int)4, null);
        } else if (Intrinsics.areEqual((Object)string, (Object)PROTO_HEP3)) {
            EventBus eventBus = this.vertx.eventBus();
            Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
            EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getHep3(), (Object)new Pair((Object)sender, (Object)buffer), null, (int)4, null);
        } else {
            byte[] prefix = buffer.getBytes(0, 3);
            if (Arrays.equals(prefix, PROTO_HEP2)) {
                EventBus eventBus = this.vertx.eventBus();
                Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
                EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getHep2(), (Object)new Pair((Object)sender, (Object)buffer), null, (int)4, null);
            }
        }
    }

    static {
        byte[] byArray = new byte[]{2, 16, 2};
        PROTO_HEP2 = byArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/sip3/salto/ce/server/AbstractServer$Companion;", "", "()V", "PROTO_HEP2", "", "getPROTO_HEP2", "()[B", "PROTO_HEP3", "", "PROTO_SIP3", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getPROTO_HEP2() {
            return PROTO_HEP2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

