/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.sip;

import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.util.DateTimeFormatterUtilKt;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.attributes.AttributesRegistry;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.sip.SipTransaction;
import io.sip3.salto.ce.sip.SipTransactionHandler;
import io.sip3.salto.ce.util.AttributeUtilKt;
import io.sip3.salto.ce.util.SIPMessageUtilKt;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Counter;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.invoke.LambdaMetafactory;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/sip3/salto/ce/sip/SipTransactionHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "aggregationTimeout", "", "attributesRegistry", "Lio/sip3/salto/ce/attributes/AttributesRegistry;", "expirationDelay", "instances", "", "logger", "Lmu/KLogger;", "recordCallUsersAttributes", "", "recordIpAddressesAttributes", "responseTimeout", "saveSipMessagePayloadMode", "terminationTimeout", "timeSuffix", "Ljava/time/format/DateTimeFormatter;", "transactions", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "", "Lio/sip3/salto/ce/sip/SipTransaction;", "calculateTransactionMetrics", "", "prefix", "transaction", "handle", "packet", "Lio/sip3/salto/ce/domain/Packet;", "message", "Lgov/nist/javax/sip/message/SIPMessage;", "routeTransaction", "start", "terminateTransactionAt", "writeAttributes", "writeToDatabase", "Companion", "sip3-salto-ce"})
public class SipTransactionHandler
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private DateTimeFormatter timeSuffix;
    private long expirationDelay;
    private long responseTimeout;
    private long aggregationTimeout;
    private long terminationTimeout;
    private int saveSipMessagePayloadMode;
    private boolean recordIpAddressesAttributes;
    private boolean recordCallUsersAttributes;
    private int instances;
    private PeriodicallyExpiringHashMap<String, SipTransaction> transactions;
    private AttributesRegistry attributesRegistry;
    @NotNull
    private static final List<String> EXCLUDED_ATTRIBUTES;
    @NotNull
    private static final String PREFIX;
    @NotNull
    public static final String RESPONSE_DELAY = "response-delay";
    @NotNull
    private static final List<String> EXCLUDED_METHODS;

    public SipTransactionHandler() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyyMMdd\")");
        this.timeSuffix = dateTimeFormatter;
        this.expirationDelay = 1000L;
        this.responseTimeout = 3000L;
        this.aggregationTimeout = 60000L;
        this.terminationTimeout = 4500L;
        this.instances = 1;
    }

    public void start() {
        Object object;
        JsonObject jsonObject;
        String string = this.config().getString("time_suffix");
        if (string != null) {
            String it = string;
            boolean bl = false;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(it);
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(it)");
            this.timeSuffix = dateTimeFormatter;
        }
        if ((jsonObject = this.config().getJsonObject("sip")) != null && (jsonObject = jsonObject.getJsonObject("transaction")) != null) {
            long it;
            Number number;
            JsonObject config = jsonObject;
            boolean bl = false;
            Long l = number = config.getLong("expiration_delay");
            if (l != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getLong(\"expiration_delay\")");
                it = ((Number)number).longValue();
                boolean bl2 = false;
                this.expirationDelay = it;
            }
            Long l2 = number = config.getLong("response_timeout");
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getLong(\"response_timeout\")");
                it = ((Number)number).longValue();
                boolean bl3 = false;
                this.responseTimeout = it;
            }
            Long l3 = number = config.getLong("aggregation_timeout");
            if (l3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getLong(\"aggregation_timeout\")");
                it = ((Number)number).longValue();
                boolean bl4 = false;
                this.aggregationTimeout = it;
            }
            Long l4 = number = config.getLong("termination_timeout");
            if (l4 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l4, (String)"getLong(\"termination_timeout\")");
                it = ((Number)number).longValue();
                boolean bl5 = false;
                this.terminationTimeout = it;
            }
            Number number2 = number = config.getInteger("save_sip_message_payload_mode");
            if (number2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)number2, (String)"getInteger(\"save_sip_message_payload_mode\")");
                int it2 = ((Number)number).intValue();
                boolean bl6 = false;
                this.saveSipMessagePayloadMode = it2;
            }
        }
        JsonObject jsonObject2 = this.config().getJsonObject("attributes");
        if (jsonObject2 != null) {
            Boolean bl;
            JsonObject config = jsonObject2;
            boolean bl7 = false;
            Boolean bl8 = bl = config.getBoolean("record_ip_addresses");
            if (bl8 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)bl8, (String)"getBoolean(\"record_ip_addresses\")");
                boolean it = bl;
                boolean bl9 = false;
                this.recordIpAddressesAttributes = it;
            }
            Boolean bl10 = bl = config.getBoolean("record_call_users");
            if (bl10 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)bl10, (String)"getBoolean(\"record_call_users\")");
                boolean it = bl;
                boolean bl11 = false;
                this.recordCallUsersAttributes = it;
            }
        }
        if ((object = this.config().getJsonObject("vertx")) != null && (object = object.getInteger("instances")) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            this.instances = it;
        }
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
        JsonObject jsonObject3 = this.config();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"config()");
        this.attributesRegistry = new AttributesRegistry(vertx, jsonObject3);
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, SipTransaction, Long>(this){
            final /* synthetic */ SipTransactionHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull SipTransaction transaction2) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                return this.this$0.terminateTransactionAt(transaction2);
            }
        }).onExpire((Function2)new Function2<String, SipTransaction, Unit>(this){
            final /* synthetic */ SipTransactionHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull SipTransaction transaction2) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                this.this$0.routeTransaction(transaction2);
            }
        });
        Vertx vertx2 = this.vertx;
        Intrinsics.checkNotNullExpressionValue((Object)vertx2, (String)"vertx");
        this.transactions = builder.build(vertx2);
        CoroutineScope coroutineScope = (CoroutineScope)GlobalScope.INSTANCE;
        Vertx vertx3 = this.vertx;
        Intrinsics.checkNotNullExpressionValue((Object)vertx3, (String)"vertx");
        CoroutineDispatcher coroutineDispatcher = VertxCoroutineKt.dispatcher((Vertx)vertx3);
        Intrinsics.checkNotNull((Object)coroutineDispatcher, (String)"null cannot be cast to non-null type kotlin.coroutines.CoroutineContext");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)coroutineDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ SipTransactionHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = SipTransactionHandler.access$getVertx$p$s-2076259098(this.this$0).sharedData().getLocalCounter(SipTransactionHandler.Companion.getPREFIX());
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"vertx.sharedData().getLocalCounter(PREFIX)");
                        this.label = 1;
                        v1 = VertxCoroutineKt.coAwait((Future)v0, (Continuation)((Continuation)this));
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        index = (Counter)v1;
                        var5_4 = SipTransactionHandler.Companion.getPREFIX();
                        var4_5 = SipTransactionHandler.access$getVertx$p$s-2076259098(this.this$0).eventBus();
                        var3_6 = index.getAndIncrement();
                        Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"index.andIncrement");
                        this.L$0 = var4_5;
                        this.L$1 = var5_4;
                        this.label = 2;
                        v2 = VertxCoroutineKt.coAwait((Future)var3_6, (Continuation)((Continuation)this));
                        if (v2 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        var5_4 = (String)this.L$1;
                        var4_5 = (EventBus)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        var6_7 = v2;
                        var4_5.localConsumer(var5_4 + "_" + var6_7, (Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$0(io.sip3.salto.ce.sip.SipTransactionHandler io.vertx.core.eventbus.Message ), (Lio/vertx/core/eventbus/Message;)V)((SipTransactionHandler)this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(SipTransactionHandler this$0, Message event) {
                try {
                    Pair pair = (Pair)event.body();
                    Packet packet = (Packet)pair.component1();
                    SIPMessage message = (SIPMessage)pair.component2();
                    this$0.handle(packet, message);
                }
                catch (Exception e) {
                    SipTransactionHandler.access$getLogger$p(this$0).error("SipTransactionHandler 'handle()' failed.", (Throwable)e);
                }
            }
        }), (int)2, null);
    }

    public void handle(@NotNull Packet packet, @NotNull SIPMessage message) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (CollectionsKt.contains((Iterable)EXCLUDED_METHODS, (Object)SIPMessageUtilKt.cseqMethod(message))) {
            return;
        }
        String transactionId = SIPMessageUtilKt.transactionId(message);
        PeriodicallyExpiringHashMap<String, SipTransaction> periodicallyExpiringHashMap = this.transactions;
        if (periodicallyExpiringHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transactions");
            periodicallyExpiringHashMap = null;
        }
        SipTransaction transaction2 = (SipTransaction)periodicallyExpiringHashMap.getOrPut((Object)transactionId, (Function0)handle.transaction.1.INSTANCE);
        PeriodicallyExpiringHashMap<String, SipTransaction> periodicallyExpiringHashMap2 = this.transactions;
        if (periodicallyExpiringHashMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transactions");
            periodicallyExpiringHashMap2 = null;
        }
        periodicallyExpiringHashMap2.touch((Object)transactionId);
        boolean extend = this.saveSipMessagePayloadMode == 0 || this.saveSipMessagePayloadMode == 1 && message instanceof SIPRequest;
        transaction2.addMessage(packet, message, extend);
        if (Intrinsics.areEqual((Object)transaction2.getCseqMethod(), (Object)"INVITE")) {
            SIPRequest sIPRequest = transaction2.getRequest();
            boolean bl = sIPRequest != null ? SIPMessageUtilKt.hasSdp((SIPMessage)sIPRequest) : false;
            if (bl) {
                SIPResponse sIPResponse = transaction2.getResponse();
                boolean bl2 = sIPResponse != null ? SIPMessageUtilKt.hasSdp((SIPMessage)sIPResponse) : false;
                if (bl2) {
                    EventBus eventBus = this.vertx.eventBus();
                    Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
                    EventBusUtilKt.localSend$default((EventBus)eventBus, (String)(RoutesCE.Companion.getMedia() + "_sdp"), (Object)transaction2, null, (int)4, null);
                }
            }
        }
    }

    public long terminateTransactionAt(@NotNull SipTransaction transaction2) {
        long l;
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        Long l2 = transaction2.getTerminatedAt();
        if (l2 != null) {
            long it = ((Number)l2).longValue();
            boolean bl = false;
            l = it + this.terminationTimeout;
        } else {
            long l3;
            long l4 = transaction2.getCreatedAt();
            Long l5 = transaction2.getEstablishedAt();
            if (l5 != null) {
                long l6 = ((Number)l5).longValue();
                long l7 = l4;
                boolean bl = false;
                long l8 = this.aggregationTimeout;
                l4 = l7;
                l3 = l8;
            } else {
                l3 = this.responseTimeout;
            }
            l = l4 + l3;
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    public void routeTransaction(@NotNull SipTransaction transaction) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            var3_2 = transaction.getCseqMethod();
            switch (var3_2.hashCode()) {
                case 92413603: {
                    if (!var3_2.equals("REGISTER")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case 1672907751: {
                    if (!var3_2.equals("MESSAGE")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case -1986360503: {
                    if (!var3_2.equals("NOTIFY")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case -531492226: {
                    if (!var3_2.equals("OPTIONS")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case -993530582: {
                    if (!var3_2.equals("SUBSCRIBE")) break;
lbl22:
                    // 5 sources

                    v0 = RoutesCE.Companion.getSip();
                    v1 = transaction.getCseqMethod().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    v2 = v0 + "_" + v1;
                    break block13;
                }
            }
            v2 = RoutesCE.Companion.getSip() + "_call";
        }
        prefix = v2;
        var3_2 = prefix;
        if (Intrinsics.areEqual((Object)var3_2, (Object)(RoutesCE.Companion.getSip() + "_call")) != false ? true : Intrinsics.areEqual((Object)var3_2, (Object)(RoutesCE.Companion.getSip() + "_register"))) {
            index = transaction.getCallId().hashCode();
            route = prefix + "_" + Math.abs(index % this.instances);
            v3 = this.vertx.eventBus();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"vertx.eventBus()");
            EventBusUtilKt.localSend$default((EventBus)v3, (String)route, (Object)transaction, null, (int)4, null);
        } else {
            this.writeAttributes(transaction);
            this.writeToDatabase(prefix, transaction);
            this.calculateTransactionMetrics(prefix, transaction);
        }
    }

    private final void calculateTransactionMetrics(String prefix, SipTransaction transaction2) {
        block2: {
            String it;
            Map<String, Object> map;
            Long l = transaction2.getTerminatedAt();
            if (l == null) break block2;
            long terminatedAt = ((Number)l).longValue();
            boolean bl = false;
            Map<String, Object> $this$calculateTransactionMetrics_u24lambda_u2416_u24lambda_u2415 = map = AttributeUtilKt.toMetricsAttributes(transaction2.getAttributes(), EXCLUDED_ATTRIBUTES);
            boolean bl2 = false;
            String string = transaction2.getSrcAddr().getHost();
            if (string != null) {
                it = string;
                boolean bl3 = false;
                $this$calculateTransactionMetrics_u24lambda_u2416_u24lambda_u2415.put("src_host", it);
            }
            String string2 = transaction2.getDstAddr().getHost();
            if (string2 != null) {
                it = string2;
                boolean bl4 = false;
                $this$calculateTransactionMetrics_u24lambda_u2416_u24lambda_u2415.put("dst_host", it);
            }
            Map<String, Object> attributes = map;
            Metrics.INSTANCE.timer(prefix + "_response-delay", attributes).record(terminatedAt - transaction2.getCreatedAt(), TimeUnit.MILLISECONDS);
        }
    }

    public void writeAttributes(@NotNull SipTransaction transaction2) {
        String it;
        Object object;
        Map map;
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        Map $this$writeAttributes_u24lambda_u2421 = map = AttributeUtilKt.toAttributes$default(transaction2.getAttributes(), null, 1, null);
        boolean bl = false;
        $this$writeAttributes_u24lambda_u2421.put("method", transaction2.getCseqMethod());
        $this$writeAttributes_u24lambda_u2421.put("state", transaction2.getState());
        Address src = transaction2.getSrcAddr();
        $this$writeAttributes_u24lambda_u2421.put("src_addr", this.recordIpAddressesAttributes ? src.getAddr() : "");
        String string = src.getHost();
        if (string != null) {
            String it2 = string;
            boolean bl2 = false;
            $this$writeAttributes_u24lambda_u2421.put("src_host", it2);
        }
        Address dst = transaction2.getDstAddr();
        $this$writeAttributes_u24lambda_u2421.put("dst_addr", this.recordIpAddressesAttributes ? dst.getAddr() : "");
        String string2 = dst.getHost();
        if (string2 != null) {
            String it3 = string2;
            boolean bl3 = false;
            $this$writeAttributes_u24lambda_u2421.put("dst_host", it3);
        }
        if ((object = $this$writeAttributes_u24lambda_u2421.get("caller")) == null) {
            object = transaction2.getCaller();
        }
        Object caller = object;
        $this$writeAttributes_u24lambda_u2421.put("caller", this.recordCallUsersAttributes ? caller : "");
        Object object2 = $this$writeAttributes_u24lambda_u2421.get("callee");
        if (object2 == null) {
            object2 = transaction2.getCallee();
        }
        Object callee = object2;
        $this$writeAttributes_u24lambda_u2421.put("callee", this.recordCallUsersAttributes ? callee : "");
        $this$writeAttributes_u24lambda_u2421.put("call_id", "");
        String string3 = transaction2.getErrorCode();
        if (string3 != null) {
            it = string3;
            boolean bl4 = false;
            $this$writeAttributes_u24lambda_u2421.put("error_code", it);
        }
        String string4 = transaction2.getErrorType();
        if (string4 != null) {
            it = string4;
            boolean bl5 = false;
            $this$writeAttributes_u24lambda_u2421.put("error_type", it);
        }
        $this$writeAttributes_u24lambda_u2421.put("retransmits", transaction2.getRetransmits());
        $this$writeAttributes_u24lambda_u2421.remove("x_call_id");
        $this$writeAttributes_u24lambda_u2421.remove("recording_mode");
        Map attributes = map;
        AttributesRegistry attributesRegistry = this.attributesRegistry;
        if (attributesRegistry == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attributesRegistry");
            attributesRegistry = null;
        }
        attributesRegistry.handle("sip", attributes);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToDatabase(@NotNull String prefix, @NotNull SipTransaction transaction2) {
        void $this$forEach$iv;
        Object object;
        void $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427;
        JsonObject jsonObject;
        JsonObject jsonObject2;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        String collection = prefix + "_index_" + DateTimeFormatterUtilKt.format((DateTimeFormatter)this.timeSuffix, (long)transaction2.getCreatedAt());
        JsonObject $this$writeToDatabase_u24lambda_u2428 = jsonObject2 = new JsonObject();
        boolean bl = false;
        JsonObject jsonObject3 = jsonObject = new JsonObject();
        String string = "document";
        JsonObject jsonObject4 = $this$writeToDatabase_u24lambda_u2428;
        boolean bl2 = false;
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("state", (Object)transaction2.getState());
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("created_at", (Object)transaction2.getCreatedAt());
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("terminated_at", (Object)transaction2.getTerminatedAt());
        Address src = transaction2.getSrcAddr();
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("src_addr", (Object)src.getAddr());
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("src_port", (Object)src.getPort());
        String string2 = src.getHost();
        if (string2 != null) {
            String it = string2;
            boolean bl3 = false;
            $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("src_host", (Object)it);
        }
        Address dst = transaction2.getDstAddr();
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("dst_addr", (Object)dst.getAddr());
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("dst_port", (Object)dst.getPort());
        String string3 = dst.getHost();
        if (string3 != null) {
            String it = string3;
            boolean bl4 = false;
            $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("dst_host", (Object)it);
        }
        if ((object = transaction2.getAttributes().remove("caller")) == null) {
            object = transaction2.getCaller();
        }
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("caller", object);
        Object object2 = transaction2.getAttributes().remove("callee");
        if (object2 == null) {
            object2 = transaction2.getCallee();
        }
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("callee", object2);
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("call_id", (Object)transaction2.getCallId());
        String string4 = transaction2.getErrorCode();
        if (string4 != null) {
            String it = string4;
            boolean bl5 = false;
            $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("error_code", (Object)it);
        }
        String string5 = transaction2.getErrorType();
        if (string5 != null) {
            String it = string5;
            boolean bl6 = false;
            $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("error_type", (Object)it);
        }
        $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put("retransmits", (Object)transaction2.getRetransmits());
        Map map = AttributeUtilKt.toDatabaseAttributes$default(transaction2.getAttributes(), null, 1, null);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl7 = false;
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            $this$writeToDatabase_u24lambda_u2428_u24lambda_u2427.put(name, value);
        }
        Unit unit = Unit.INSTANCE;
        jsonObject4.put(string, (Object)jsonObject);
        JsonObject document = jsonObject2;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
        EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getMongo_bulk_writer(), (Object)new Pair((Object)collection, (Object)document), null, (int)4, null);
    }

    public static final /* synthetic */ Vertx access$getVertx$p$s-2076259098(SipTransactionHandler $this) {
        return $this.vertx;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(SipTransactionHandler $this) {
        return $this.logger;
    }

    static {
        Object[] objectArray = new String[]{"caller", "callee", "x_call_id", "recording_mode", "debug"};
        EXCLUDED_ATTRIBUTES = CollectionsKt.listOf((Object[])objectArray);
        PREFIX = RoutesCE.Companion.getSip() + "_transaction";
        objectArray = new String[]{"ACK", "CANCEL"};
        EXCLUDED_METHODS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/sip3/salto/ce/sip/SipTransactionHandler$Companion;", "", "()V", "EXCLUDED_ATTRIBUTES", "", "", "getEXCLUDED_ATTRIBUTES", "()Ljava/util/List;", "EXCLUDED_METHODS", "getEXCLUDED_METHODS", "PREFIX", "getPREFIX", "()Ljava/lang/String;", "RESPONSE_DELAY", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getEXCLUDED_ATTRIBUTES() {
            return EXCLUDED_ATTRIBUTES;
        }

        @NotNull
        public final String getPREFIX() {
            return PREFIX;
        }

        @NotNull
        public final List<String> getEXCLUDED_METHODS() {
            return EXCLUDED_METHODS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

