/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.sip;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.CallIDParser;
import io.micrometer.core.instrument.Counter;
import io.sip3.commons.SipMethods;
import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.util.DateTimeFormatterUtilKt;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.sip.SipMessageHandler;
import io.sip3.salto.ce.sip.SipMessageParser;
import io.sip3.salto.ce.udf.UdfExecutor;
import io.sip3.salto.ce.util.AttributeUtilKt;
import io.sip3.salto.ce.util.SIPMessageUtilKt;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sip.header.ExtensionHeader;
import javax.sip.header.Header;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/sip3/salto/ce/sip/SipMessageHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "extensionHeaders", "", "", "instances", "", "logger", "Lmu/KLogger;", "packetsProcessed", "Lio/micrometer/core/instrument/Counter;", "parser", "Lio/sip3/salto/ce/sip/SipMessageParser;", "sipMessageParserMode", "timeSuffix", "Ljava/time/format/DateTimeFormatter;", "udfExecutor", "Lio/sip3/salto/ce/udf/UdfExecutor;", "xCorrelationHeader", "calculateSipMessageMetrics", "", "prefix", "packet", "Lio/sip3/salto/ce/domain/Packet;", "message", "Lgov/nist/javax/sip/message/SIPMessage;", "handle", "handleSipMessage", "handleUnparsed", "routeSipMessage", "start", "validate", "", "writeToDatabase", "Companion", "sip3-salto-ce"})
public class SipMessageHandler
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private int instances = 1;
    @NotNull
    private DateTimeFormatter timeSuffix;
    @NotNull
    private String xCorrelationHeader;
    private int sipMessageParserMode;
    @NotNull
    private Set<String> extensionHeaders;
    @NotNull
    private final Counter packetsProcessed;
    private SipMessageParser parser;
    private UdfExecutor udfExecutor;
    @NotNull
    private static final Set<String> SUPPORTED_SIP_METHODS;

    public SipMessageHandler() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyyMMdd\")");
        this.timeSuffix = dateTimeFormatter;
        this.xCorrelationHeader = "X-Call-ID";
        this.sipMessageParserMode = 1;
        this.extensionHeaders = new LinkedHashSet();
        this.packetsProcessed = Metrics.INSTANCE.counter("packets_processed", MapsKt.mapOf((Pair)TuplesKt.to((Object)"proto", (Object)"sip")));
    }

    /*
     * WARNING - void declaration
     */
    public void start() {
        JsonObject jsonObject;
        Object object = this.config().getJsonObject("vertx");
        if (object != null && (object = object.getInteger("instances")) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            this.instances = it;
        }
        String string = this.config().getString("time_suffix");
        if (string != null) {
            String it = string;
            boolean bl = false;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(it);
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(it)");
            this.timeSuffix = dateTimeFormatter;
        }
        if ((jsonObject = this.config().getJsonObject("sip")) != null && (jsonObject = jsonObject.getJsonObject("message")) != null) {
            Object object2;
            Iterator iterator;
            Iterable $this$mapTo$iv$iv;
            Object object3;
            JsonArray it;
            Object object4;
            JsonObject config = jsonObject;
            boolean bl = false;
            JsonArray jsonArray = object4 = config.getJsonArray("exclusions");
            if (jsonArray != null) {
                void $this$map$iv;
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getJsonArray(\"exclusions\")");
                it = object4;
                boolean bl2 = false;
                object3 = (Iterable)it;
                Set<String> set = SUPPORTED_SIP_METHODS;
                boolean $i$f$map = false;
                void var10_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void p0;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    object2 = destination$iv$iv;
                    boolean bl3 = false;
                    object2.add(p0.toString());
                }
                set.removeAll((List)destination$iv$iv);
            }
            Object object5 = object4 = config.getString("x_correlation_header");
            if (object5 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"getString(\"x_correlation_header\")");
                it = object4;
                boolean bl4 = false;
                this.xCorrelationHeader = it;
            }
            Object object6 = object4 = config.getJsonObject("parser");
            if (object6 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"getJsonObject(\"parser\")");
                Object parserConfig = object4;
                boolean bl5 = false;
                Object object7 = object3 = parserConfig.getInteger("mode");
                if (object7 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"getInteger(\"mode\")");
                    int it2 = ((Number)object3).intValue();
                    boolean bl6 = false;
                    this.sipMessageParserMode = it2;
                }
                Object object8 = object3 = parserConfig.getJsonArray("extension_headers");
                if (object8 != null) {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"getJsonArray(\"extension_headers\")");
                    Object it3 = object3;
                    boolean bl7 = false;
                    $this$mapTo$iv$iv = (Iterable)it3;
                    SipMessageHandler sipMessageHandler = this;
                    boolean $i$f$map = false;
                    iterator = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    object2 = $this$mapTo$iv$iv2.iterator();
                    while (object2.hasNext()) {
                        void p0;
                        Object item$iv$iv;
                        Object e = item$iv$iv = object2.next();
                        Collection collection = destination$iv$iv;
                        boolean bl8 = false;
                        collection.add(p0.toString());
                    }
                    sipMessageHandler.extensionHeaders = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
                }
            }
        }
        this.extensionHeaders.add(this.xCorrelationHeader);
        this.parser = new SipMessageParser(SUPPORTED_SIP_METHODS, this.sipMessageParserMode, this.extensionHeaders);
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
        this.udfExecutor = new UdfExecutor(vertx);
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getSip(), arg_0 -> SipMessageHandler.start$lambda$9(this, arg_0));
    }

    public void handle(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this.packetsProcessed.increment();
        SipMessageParser sipMessageParser = this.parser;
        if (sipMessageParser == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parser");
            sipMessageParser = null;
        }
        Iterable $this$forEach$iv = sipMessageParser.parse(packet);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Packet pkt = (Packet)pair.component1();
            SIPMessage message = (SIPMessage)pair.component2();
            if (this.validate(message)) {
                this.handleSipMessage(pkt, message);
                continue;
            }
            this.calculateSipMessageMetrics(RoutesCE.Companion.getSip() + "_invalid", pkt, message);
        }
    }

    public boolean validate(@NotNull SIPMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return SIPMessageUtilKt.cseqMethod(message) != null && SIPMessageUtilKt.callId(message) != null && SIPMessageUtilKt.toUserOrNumber(message) != null && SIPMessageUtilKt.fromUserOrNumber(message) != null;
    }

    public void handleSipMessage(@NotNull Packet packet, @NotNull SIPMessage message) {
        UdfExecutor udfExecutor;
        Header header;
        Object object;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (packet.getAttributes() == null) {
            packet.setAttributes(new LinkedHashMap());
        }
        if ((object = (header = message.getHeader(this.xCorrelationHeader)) instanceof ExtensionHeader ? (ExtensionHeader)header : null) != null && (object = object.getValue()) != null) {
            Object value = object;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)((CharSequence)value))) {
                Map<String, Object> map = packet.getAttributes();
                Intrinsics.checkNotNull(map);
                map.put("x_call_id", value);
            }
        }
        if ((udfExecutor = this.udfExecutor) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udfExecutor");
            udfExecutor = null;
        }
        udfExecutor.execute(RoutesCE.Companion.getSip_message_udf(), (Function0<? extends Map<String, Object>>)((Function0)new Function0<Map<String, Object>>(packet, message){
            final /* synthetic */ Packet $packet;
            final /* synthetic */ SIPMessage $message;
            {
                this.$packet = $packet;
                this.$message = $message;
                super(0);
            }

            @NotNull
            public final Map<String, Object> invoke() {
                Map map = new LinkedHashMap<K, V>();
                Packet packet = this.$packet;
                SIPMessage sIPMessage = this.$message;
                Map $this$invoke_u24lambda_u242 = map;
                boolean bl = false;
                Address src = packet.getSrcAddr();
                $this$invoke_u24lambda_u242.put("src_addr", src.getAddr());
                $this$invoke_u24lambda_u242.put("src_port", src.getPort());
                String string = src.getHost();
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u242.put("src_host", it);
                }
                Address dst = packet.getDstAddr();
                $this$invoke_u24lambda_u242.put("dst_addr", dst.getAddr());
                $this$invoke_u24lambda_u242.put("dst_port", dst.getPort());
                String string2 = dst.getHost();
                if (string2 != null) {
                    String it = string2;
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u242.put("dst_host", it);
                }
                $this$invoke_u24lambda_u242.put("payload", SIPMessageUtilKt.headersMap(sIPMessage));
                return map;
            }
        }), (Function1<? super AsyncResult<Pair<Boolean, Map<String, Object>>>, Unit>)((Function1)new Function1<AsyncResult<Pair<? extends Boolean, ? extends Map<String, ? extends Object>>>, Unit>(message, this, packet){
            final /* synthetic */ SIPMessage $message;
            final /* synthetic */ SipMessageHandler this$0;
            final /* synthetic */ Packet $packet;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                this.$packet = $packet;
                super(1);
            }

            /*
             * Unable to fully structure code
             */
            public final void invoke(@NotNull AsyncResult<Pair<Boolean, Map<String, Object>>> asr) {
                block12: {
                    block14: {
                        block13: {
                            Intrinsics.checkNotNullParameter(asr, (String)"asr");
                            var2_2 = (Pair)asr.result();
                            result = (Boolean)var2_2.component1();
                            attributes = (Map)var2_2.component2();
                            if (!result) break block12;
                            var5_5 = attributes;
                            var6_6 = this.$packet;
                            $i$f$forEach = false;
                            var8_9 = $this$forEach$iv.entrySet().iterator();
                            while (var8_9.hasNext()) {
                                var10_11 = element$iv = var8_9.next();
                                $i$a$-forEach-SipMessageHandler$handleSipMessage$3$1 = false;
                                k = (String)var10_11.getKey();
                                v = var10_11.getValue();
                                v0 = var6_6.getAttributes();
                                Intrinsics.checkNotNull(v0);
                                v0.put(k, v);
                            }
                            cseqMethod = SIPMessageUtilKt.cseqMethod(this.$message);
                            var7_8 = cseqMethod;
                            if (var7_8 == null) break block13;
                            switch (var7_8.hashCode()) {
                                case 92413603: {
                                    if (!var7_8.equals("REGISTER")) {
                                        break;
                                    }
                                    ** GOTO lbl44
                                }
                                case 1672907751: {
                                    if (!var7_8.equals("MESSAGE")) {
                                        break;
                                    }
                                    ** GOTO lbl44
                                }
                                case -1986360503: {
                                    if (!var7_8.equals("NOTIFY")) {
                                        break;
                                    }
                                    ** GOTO lbl44
                                }
                                case -531492226: {
                                    if (!var7_8.equals("OPTIONS")) {
                                        break;
                                    }
                                    ** GOTO lbl44
                                }
                                case -993530582: {
                                    if (!var7_8.equals("SUBSCRIBE")) break;
lbl44:
                                    // 5 sources

                                    v1 = RoutesCE.Companion.getSip();
                                    v2 = cseqMethod.toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                                    v3 = v1 + "_" + v2;
                                    break block14;
                                }
                            }
                        }
                        v3 = RoutesCE.Companion.getSip() + "_call";
                    }
                    prefix = v3;
                    this.this$0.routeSipMessage(prefix, this.$packet, this.$message);
                    this.this$0.calculateSipMessageMetrics(prefix, this.$packet, this.$message);
                }
            }
        }));
    }

    public void routeSipMessage(@NotNull String prefix, @NotNull Packet packet, @NotNull SIPMessage message) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = SIPMessageUtilKt.callId(message);
        int index = string != null ? string.hashCode() : 0;
        String route = RoutesCE.Companion.getSip() + "_transaction_" + Math.abs(index % this.instances);
        this.writeToDatabase(prefix, packet, message);
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
        EventBusUtilKt.localSend$default((EventBus)eventBus, (String)route, (Object)new Pair((Object)packet, (Object)message), null, (int)4, null);
    }

    private final void handleUnparsed(Packet packet) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        if (packet.getAttributes() == null) {
            packet.setAttributes(new LinkedHashMap());
        }
        String[] stringArray = new String[]{"\n"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)new String(packet.getPayload(), Charsets.ISO_8859_1), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith((String)it, (String)"call-id:", (boolean)true) || StringsKt.startsWith$default((String)it, (String)"i:", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CallIDParser(it).parse());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SIPHeader)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        String callId = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (callId == null) {
            return;
        }
        Map<String, Object> map = packet.getAttributes();
        Intrinsics.checkNotNull(map);
        map.put("call_id", callId);
        this.writeToDatabase("unknown", packet, null);
    }

    public void calculateSipMessageMetrics(@NotNull String prefix, @NotNull Packet packet, @NotNull SIPMessage message) {
        String it;
        Map map;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Map map2 = packet.getAttributes();
        if (map2 == null) {
            map2 = new LinkedHashMap();
        }
        Map $this$calculateSipMessageMetrics_u24lambda_u2420 = map = AttributeUtilKt.toMetricsAttributes$default(map2, null, 1, null);
        boolean bl = false;
        String string = packet.getSrcAddr().getHost();
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$calculateSipMessageMetrics_u24lambda_u2420.put("src_host", it);
        }
        String string2 = packet.getDstAddr().getHost();
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$calculateSipMessageMetrics_u24lambda_u2420.put("dst_host", it);
        }
        Integer n = SIPMessageUtilKt.statusCode(message);
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl4 = false;
            $this$calculateSipMessageMetrics_u24lambda_u2420.put("status_type", it2 / 100 + "xx");
            $this$calculateSipMessageMetrics_u24lambda_u2420.put("status_code", it2);
        }
        String string3 = SIPMessageUtilKt.method(message);
        if (string3 != null) {
            String it3 = string3;
            boolean bl5 = false;
            $this$calculateSipMessageMetrics_u24lambda_u2420.put("method", it3);
        }
        String string4 = SIPMessageUtilKt.cseqMethod(message);
        if (string4 != null) {
            String it4 = string4;
            boolean bl6 = false;
            $this$calculateSipMessageMetrics_u24lambda_u2420.put("cseq_method", it4);
        }
        $this$calculateSipMessageMetrics_u24lambda_u2420.remove("caller");
        $this$calculateSipMessageMetrics_u24lambda_u2420.remove("callee");
        $this$calculateSipMessageMetrics_u24lambda_u2420.remove("x_call_id");
        $this$calculateSipMessageMetrics_u24lambda_u2420.remove("recording_mode");
        $this$calculateSipMessageMetrics_u24lambda_u2420.remove("debug");
        Map attributes = map;
        Metrics.INSTANCE.counter(prefix + "_messages", attributes).increment();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToDatabase(@NotNull String prefix, @NotNull Packet packet, @Nullable SIPMessage message) {
        Object object;
        void $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423;
        JsonObject jsonObject;
        JsonObject jsonObject2;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        String collection = prefix + "_raw_" + DateTimeFormatterUtilKt.format((DateTimeFormatter)this.timeSuffix, (long)packet.getCreatedAt());
        JsonObject $this$writeToDatabase_u24lambda_u2424 = jsonObject2 = new JsonObject();
        boolean bl = false;
        JsonObject jsonObject3 = jsonObject = new JsonObject();
        String string = "document";
        JsonObject jsonObject4 = $this$writeToDatabase_u24lambda_u2424;
        boolean bl2 = false;
        $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423.put("created_at", (Object)packet.getCreatedAt());
        $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423.put("nanos", (Object)packet.getNanos());
        Address src = packet.getSrcAddr();
        $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423.put("src_addr", (Object)src.getAddr());
        $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423.put("src_port", (Object)src.getPort());
        String string2 = src.getHost();
        if (string2 != null) {
            String it = string2;
            boolean bl3 = false;
            $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423.put("src_host", (Object)it);
        }
        Address dst = packet.getDstAddr();
        $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423.put("dst_addr", (Object)dst.getAddr());
        $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423.put("dst_port", (Object)dst.getPort());
        String string3 = dst.getHost();
        if (string3 != null) {
            String it = string3;
            boolean bl4 = false;
            $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423.put("dst_host", (Object)it);
        }
        if ((object = message) == null || (object = SIPMessageUtilKt.callId(object)) == null) {
            Map<String, Object> map = packet.getAttributes();
            Object object2 = map != null ? map.get("call_id") : null;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            object = (String)object2;
        }
        $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423.put("call_id", object);
        $this$writeToDatabase_u24lambda_u2424_u24lambda_u2423.put("raw_data", (Object)new String(packet.getPayload(), Charsets.ISO_8859_1));
        Unit unit = Unit.INSTANCE;
        jsonObject4.put(string, (Object)jsonObject);
        JsonObject operation = jsonObject2;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
        EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getMongo_bulk_writer(), (Object)new Pair((Object)collection, (Object)operation), null, (int)4, null);
    }

    private static final void start$lambda$9(SipMessageHandler this$0, Message event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Packet packet = (Packet)event.body();
        try {
            Intrinsics.checkNotNullExpressionValue((Object)packet, (String)"packet");
            this$0.handle(packet);
        }
        catch (Exception e) {
            this$0.logger.debug((Throwable)e, (Function0)start.4.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)packet, (String)"packet");
            this$0.handleUnparsed(packet);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        SipMethods[] $this$map$iv = SipMethods.values();
        boolean $i$f$map = false;
        SipMethods[] sipMethodsArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var8_8 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toString());
        }
        SUPPORTED_SIP_METHODS = CollectionsKt.toMutableSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/sip3/salto/ce/sip/SipMessageHandler$Companion;", "", "()V", "SUPPORTED_SIP_METHODS", "", "", "getSUPPORTED_SIP_METHODS", "()Ljava/util/Set;", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getSUPPORTED_SIP_METHODS() {
            return SUPPORTED_SIP_METHODS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

