/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.sip;

import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.ExtensionHeaderImpl;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.parser.CSeqParser;
import gov.nist.javax.sip.parser.CallIDParser;
import gov.nist.javax.sip.parser.ContactParser;
import gov.nist.javax.sip.parser.ContentLengthParser;
import gov.nist.javax.sip.parser.ContentTypeParser;
import gov.nist.javax.sip.parser.ExpiresParser;
import gov.nist.javax.sip.parser.FromParser;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.MaxForwardsParser;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.RecordRouteParser;
import gov.nist.javax.sip.parser.RouteParser;
import gov.nist.javax.sip.parser.StringMsgParser;
import gov.nist.javax.sip.parser.ToParser;
import gov.nist.javax.sip.parser.ViaParser;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.sip.SipMessageParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.sip.header.ContentLengthHeader;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00170\u00162\u0006\u0010\u001a\u001a\u00020\u0018J*\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u00182\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00170\u001dH\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006 "}, d2={"Lio/sip3/salto/ce/sip/SipMessageParser;", "", "supportedMethods", "", "", "mode", "", "extensionHeaders", "(Ljava/util/Set;ILjava/util/Set;)V", "getExtensionHeaders", "()Ljava/util/Set;", "logger", "Lmu/KLogger;", "getMode", "()I", "getSupportedMethods", "isCrLf", "", "offset", "payload", "", "parse", "", "Lkotlin/Pair;", "Lio/sip3/salto/ce/domain/Packet;", "Lgov/nist/javax/sip/message/SIPMessage;", "packet", "", "accumulator", "", "Companion", "StringMessageParser", "sip3-salto-ce"})
public final class SipMessageParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> supportedMethods;
    private final int mode;
    @NotNull
    private final Set<String> extensionHeaders;
    @NotNull
    private final KLogger logger;
    public static final int MODE_ALL = 0;
    public static final int MODE_EXTENSION_HEADERS = 1;
    public static final byte CR = 13;
    public static final byte LF = 10;
    @NotNull
    private static final Set<String> CONTENT_LENGTH_HEADERS;

    public SipMessageParser(@NotNull Set<String> supportedMethods, int mode, @NotNull Set<String> extensionHeaders) {
        Intrinsics.checkNotNullParameter(supportedMethods, (String)"supportedMethods");
        Intrinsics.checkNotNullParameter(extensionHeaders, (String)"extensionHeaders");
        this.supportedMethods = supportedMethods;
        this.mode = mode;
        this.extensionHeaders = extensionHeaders;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    public /* synthetic */ SipMessageParser(Set set, int n, Set set2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            set2 = SetsKt.emptySet();
        }
        this(set, n, set2);
    }

    @NotNull
    public final Set<String> getSupportedMethods() {
        return this.supportedMethods;
    }

    public final int getMode() {
        return this.mode;
    }

    @NotNull
    public final Set<String> getExtensionHeaders() {
        return this.extensionHeaders;
    }

    @NotNull
    public final List<Pair<Packet, SIPMessage>> parse(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        List result = new ArrayList();
        this.parse(packet, result);
        return result;
    }

    private final void parse(Packet packet, List<Pair<Packet, SIPMessage>> accumulator) {
        int n;
        int n2;
        byte[] byArray;
        int length;
        byte[] payload = packet.getPayload();
        int offset = 0;
        while (this.isCrLf(offset, payload)) {
            offset += 2;
        }
        StringMessageParser parser2 = new StringMessageParser();
        SIPMessage sIPMessage = parser2.parseSIPMessage(payload, false, false, null);
        if (sIPMessage == null) {
            return;
        }
        SIPMessage message = sIPMessage;
        offset += message.getSize();
        ContentLengthHeader contentLengthHeader = message.getContentLengthHeader();
        int n3 = length = contentLengthHeader != null ? contentLengthHeader.getContentLength() : 0;
        if (length > 0) {
            ContentType contentType = message.getContentTypeHeader();
            if ((contentType != null ? contentType.getContentType() : null) != null) {
                byArray = payload;
                n2 = offset;
                n = offset + length;
                message.setMessageContent(ArraysKt.copyOfRange((byte[])byArray, (int)n2, (int)n));
            }
        }
        offset += length;
        while (this.isCrLf(offset, payload)) {
            offset += 2;
        }
        if (!parser2.getSkipMessage()) {
            if (payload.length > offset) {
                byArray = payload;
                n2 = 0;
                n = offset;
                packet.setPayload(ArraysKt.copyOfRange((byte[])byArray, (int)n2, (int)n));
            }
            accumulator.add((Pair<Packet, SIPMessage>)new Pair((Object)packet, (Object)message));
        }
        if (payload.length > offset) {
            Packet packet2;
            Packet $this$parse_u24lambda_u240 = packet2 = new Packet();
            boolean bl = false;
            $this$parse_u24lambda_u240.setCreatedAt(packet.getCreatedAt());
            $this$parse_u24lambda_u240.setNanos(packet.getNanos());
            $this$parse_u24lambda_u240.setSrcAddr(packet.getSrcAddr());
            $this$parse_u24lambda_u240.setDstAddr(packet.getDstAddr());
            $this$parse_u24lambda_u240.setProtocolCode(packet.getProtocolCode());
            byte[] byArray2 = payload;
            int n4 = offset;
            int n5 = payload.length;
            $this$parse_u24lambda_u240.setPayload(ArraysKt.copyOfRange((byte[])byArray2, (int)n4, (int)n5));
            Packet pkt = packet2;
            this.parse(pkt, accumulator);
        }
    }

    private final boolean isCrLf(int offset, byte[] payload) {
        if (payload.length <= offset + 1) {
            return false;
        }
        return payload[offset] == 13 && payload[offset + 1] == 10;
    }

    static {
        Object[] objectArray = new String[]{"content-length", "l"};
        CONTENT_LENGTH_HEADERS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/sip3/salto/ce/sip/SipMessageParser$Companion;", "", "()V", "CONTENT_LENGTH_HEADERS", "", "", "getCONTENT_LENGTH_HEADERS", "()Ljava/util/Set;", "CR", "", "LF", "MODE_ALL", "", "MODE_EXTENSION_HEADERS", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getCONTENT_LENGTH_HEADERS() {
            return CONTENT_LENGTH_HEADERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J,\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0010H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/sip3/salto/ce/sip/SipMessageParser$StringMessageParser;", "Lgov/nist/javax/sip/parser/StringMsgParser;", "(Lio/sip3/salto/ce/sip/SipMessageParser;)V", "skipMessage", "", "getSkipMessage", "()Z", "setSkipMessage", "(Z)V", "processFirstLine", "Lgov/nist/javax/sip/message/SIPMessage;", "firstLine", "", "parseExceptionListener", "Lgov/nist/javax/sip/parser/ParseExceptionListener;", "msgBuffer", "", "processHeader", "", "header", "message", "rawMessage", "sip3-salto-ce"})
    public final class StringMessageParser
    extends StringMsgParser {
        private boolean skipMessage;

        public final boolean getSkipMessage() {
            return this.skipMessage;
        }

        public final void setSkipMessage(boolean bl) {
            this.skipMessage = bl;
        }

        @NotNull
        protected SIPMessage processFirstLine(@Nullable String firstLine, @Nullable ParseExceptionListener parseExceptionListener, @Nullable byte[] msgBuffer) {
            SIPMessage message = super.processFirstLine(firstLine, parseExceptionListener, msgBuffer);
            if (message instanceof SIPRequest) {
                this.skipMessage = !SipMessageParser.this.getSupportedMethods().contains(((SIPRequest)message).getMethod());
            }
            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
            return message;
        }

        protected void processHeader(@Nullable String header, @NotNull SIPMessage message, @Nullable ParseExceptionListener parseExceptionListener, @NotNull byte[] rawMessage) {
            block62: {
                SIPHeader hdr;
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)rawMessage, (String)"rawMessage");
                CharSequence charSequence = header;
                if (charSequence == null || charSequence.length() == 0) {
                    return;
                }
                String name = Lexer.getHeaderName((String)header);
                if (this.skipMessage) {
                    Set<String> set = Companion.getCONTENT_LENGTH_HEADERS();
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    String string = name.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    if (!set.contains(string)) {
                        return;
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                String string = name.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                SIPHeader sIPHeader = hdr = (switch (string) {
                    case "content-length", "l" -> new ContentLengthParser(header + "\n").parse();
                    case "cseq" -> {
                        ExtensionHeaderImpl var8_7 = new CSeqParser(header + "\n").parse();
                        SipMessageParser var9_8 = SipMessageParser.this;
                        ExtensionHeaderImpl cseq = var8_7;
                        boolean $i$a$-also-SipMessageParser$StringMessageParser$processHeader$hdr$1 = false;
                        Set<String> v4 = var9_8.getSupportedMethods();
                        Intrinsics.checkNotNull((Object)cseq, (String)"null cannot be cast to non-null type gov.nist.javax.sip.header.CSeq");
                        this.skipMessage = !v4.contains(((CSeq)cseq).getMethod());
                        yield var8_7;
                    }
                    case "t", "to" -> new ToParser(header + "\n").parse();
                    case "f", "from" -> new FromParser(header + "\n").parse();
                    case "via", "v" -> new ViaParser(header + "\n").parse();
                    case "m", "contact" -> new ContactParser(header + "\n").parse();
                    case "c", "content-type" -> new ContentTypeParser(header + "\n").parse();
                    case "i", "call-id" -> new CallIDParser(header + "\n").parse();
                    case "route" -> new RouteParser(header + "\n").parse();
                    case "record-route" -> new RecordRouteParser(header + "\n").parse();
                    case "max-forwards" -> new MaxForwardsParser(header + "\n").parse();
                    case "expires" -> new ExpiresParser(header + "\n").parse();
                    default -> {
                        ExtensionHeaderImpl v7;
                        ExtensionHeaderImpl var8_7;
                        if (SipMessageParser.this.getMode() == 0 || SipMessageParser.this.getExtensionHeaders().contains(name)) {
                            String v6;
                            String var11_13;
                            ExtensionHeaderImpl $this$processHeader_u24lambda_u241 = var8_7 = new ExtensionHeaderImpl();
                            boolean $i$a$-apply-SipMessageParser$StringMessageParser$processHeader$hdr$2 = false;
                            $this$processHeader_u24lambda_u241.setName(name);
                            String v5 = var11_13 = Lexer.getHeaderValue((String)header);
                            if (v5 != null) {
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getHeaderValue(header)");
                                v6 = ((Object)StringsKt.trim((CharSequence)var11_13)).toString();
                            } else {
                                v6 = null;
                            }
                            $this$processHeader_u24lambda_u241.setValue(v6);
                            v7 = var8_7;
                        } else {
                            v7 = null;
                        }
                        yield (SIPHeader)v7;
                    }
                });
                if (sIPHeader == null) break block62;
                SIPHeader it = sIPHeader;
                boolean bl = false;
                message.attachHeader(it, false);
            }
        }
    }
}

