/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.Handler;
import io.sip3.captain.ce.recording.RecordingManager;
import io.sip3.commons.domain.payload.ByteArrayPayload;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.domain.payload.RecordingPayload;
import io.sip3.commons.util.ByteBufUtilKt;
import io.sip3.commons.util.StringUtilKt;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/sip3/captain/ce/pipeline/RtcpHandler;", "Lio/sip3/captain/ce/pipeline/Handler;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lio/vertx/core/json/JsonObject;", "bulkOperationsEnabled", "", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;Z)V", "bulkSize", "", "packets", "", "Lio/sip3/captain/ce/domain/Packet;", "portRanges", "Lkotlin/ranges/IntRange;", "recordingManager", "Lio/sip3/captain/ce/recording/RecordingManager;", "onPacket", "", "packet", "sip3-captain-ce"})
public final class RtcpHandler
extends Handler {
    @NotNull
    private final List<Packet> packets;
    private int bulkSize;
    @NotNull
    private final List<IntRange> portRanges;
    @NotNull
    private final RecordingManager recordingManager;

    public RtcpHandler(@NotNull Vertx vertx, @NotNull JsonObject config, boolean bulkOperationsEnabled) {
        block4: {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            super(vertx, config, bulkOperationsEnabled);
            this.packets = new ArrayList();
            this.bulkSize = 1;
            this.portRanges = new ArrayList();
            this.recordingManager = RecordingManager.INSTANCE.getInstance(vertx, config);
            JsonObject jsonObject = config.getJsonObject("rtcp");
            if (jsonObject == null) break block4;
            JsonObject rtcpConfig = jsonObject;
            boolean bl = false;
            if (bulkOperationsEnabled) {
                Integer n2 = n = rtcpConfig.getInteger("bulk_size");
                if (n2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getInteger(\"bulk_size\")");
                    int it = ((Number)n).intValue();
                    boolean bl2 = false;
                    this.bulkSize = it;
                }
            }
            Integer n3 = n = rtcpConfig.getJsonArray("port_ranges");
            if (n3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getJsonArray(\"port_ranges\")");
                Iterable $this$forEach$iv = (Iterable)((Object)n);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object portRange = element$iv = iterator.next();
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(portRange, (String)"null cannot be cast to non-null type kotlin.String");
                    String cfr_ignored_0 = (String)portRange;
                    this.portRanges.add(StringUtilKt.toIntRange((String)((String)portRange)));
                }
            }
        }
    }

    @Override
    public void onPacket(@NotNull Packet packet) {
        Packet $i$f$none;
        Packet it;
        block16: {
            block17: {
                boolean bl;
                block15: {
                    int n;
                    int n2;
                    int n3;
                    boolean bl2;
                    boolean $i$f$none2;
                    Iterable $this$none$iv;
                    block14: {
                        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                        if (!(!((Collection)this.portRanges).isEmpty())) break block16;
                        $this$none$iv = this.portRanges;
                        $i$f$none2 = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                it = (IntRange)element$iv;
                                boolean bl3 = false;
                                n3 = it.getFirst();
                                n2 = it.getLast();
                                n = packet.getSrcPort();
                                boolean bl4 = n3 <= n ? n <= n2 : false;
                                if (!bl4) continue;
                                bl2 = false;
                                break block14;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) break block17;
                    $this$none$iv = this.portRanges;
                    $i$f$none2 = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (IntRange)element$iv;
                            boolean bl5 = false;
                            n3 = it.getFirst();
                            n2 = it.getLast();
                            n = packet.getDstPort();
                            boolean bl6 = n3 <= n ? n <= n2 : false;
                            if (!bl6) continue;
                            bl = false;
                            break block15;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block16;
            }
            return;
        }
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        ByteBuf buffer = ((Encodable)payload).encode();
        Packet $this$onPacket_u24lambda_u246 = $i$f$none = packet;
        boolean bl = false;
        $this$onPacket_u24lambda_u246.setProtocolCode((byte)1);
        it = $this$onPacket_u24lambda_u246;
        Packet bl5 = $this$onPacket_u24lambda_u246;
        boolean bl7 = false;
        byte[] bytes = ByteBufUtilKt.getBytes((ByteBuf)buffer);
        bl5.setPayload((Payload)ByteArrayPayload.box-impl((byte[])ByteArrayPayload.constructor-impl((byte[])bytes)));
        RecordingPayload recording = this.recordingManager.record(packet);
        if (recording != null) {
            Packet p;
            Packet packet2;
            Packet packet3 = packet.getRejected();
            if (packet3 == null) {
                packet3 = packet;
            }
            Packet $this$onPacket_u24lambda_u247 = packet2 = (p = packet3);
            boolean bl8 = false;
            $this$onPacket_u24lambda_u247.setProtocolCode((byte)7);
            $this$onPacket_u24lambda_u247.setPayload((Payload)recording);
            this.packets.add(p);
        } else {
            this.packets.add(packet);
        }
        if (this.packets.size() >= this.bulkSize) {
            EventBus eventBus = this.getVertx().eventBus();
            Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
            EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getEncoder(), (Object)CollectionsKt.toList((Iterable)this.packets), null, (int)4, null);
            this.packets.clear();
        }
    }
}

