/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.util;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lio/sip3/captain/ce/util/SmppUtil;", "", "()V", "COMMANDS", "", "", "getCOMMANDS", "()Ljava/util/Set;", "checkMinPduLength", "", "buffer", "Lio/netty/buffer/ByteBuf;", "isPdu", "isPduCommand", "commandId", "sip3-captain-ce"})
public final class SmppUtil {
    @NotNull
    public static final SmppUtil INSTANCE = new SmppUtil();
    @NotNull
    private static final Set<Long> COMMANDS;

    private SmppUtil() {
    }

    @NotNull
    public final Set<Long> getCOMMANDS() {
        return COMMANDS;
    }

    public final boolean isPdu(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!this.checkMinPduLength(buffer)) {
            return false;
        }
        int offset = buffer.readerIndex();
        int length = (int)buffer.getUnsignedInt(offset);
        long command = buffer.getUnsignedInt(offset + 4);
        return buffer.readableBytes() == length && this.isPduCommand(command);
    }

    public final boolean checkMinPduLength(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return buffer.readableBytes() >= 16;
    }

    public final boolean isPduCommand(long commandId) {
        return COMMANDS.contains(commandId);
    }

    static {
        Object[] objectArray = new Long[]{0x80000000L, 1L, 0x80000001L, 2L, 0x80000002L, 3L, 0x80000003L, 4L, 0x80000004L, 5L, 0x80000005L, 6L, 0x80000006L, 7L, 0x80000007L, 8L, 0x80000008L, 9L, 0x80000009L, 11L, 0x8000000BL, 21L, 2147483669L, 33L, 2147483681L, 258L, 2147483906L, 259L, 2147483907L, 273L, 0x80000111L, 274L, 2147483922L, 275L, 2147483923L};
        COMMANDS = SetsKt.setOf((Object[])objectArray);
    }
}

