/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.domain.SipConnection;
import io.sip3.captain.ce.domain.SmppConnection;
import io.sip3.captain.ce.domain.TcpConnection;
import io.sip3.captain.ce.domain.WebSocketConnection;
import io.sip3.captain.ce.pipeline.TcpHandler;
import io.sip3.commons.domain.payload.ByteBufPayload;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.util.IpUtil;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Instance(singleton=true)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/sip3/captain/ce/pipeline/TcpHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "aggregationTimeout", "", "connections", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "", "Lio/sip3/captain/ce/domain/TcpConnection;", "expirationDelay", "idleConnectionTimeout", "logger", "Lmu/KLogger;", "sipEnabled", "", "smppEnabled", "websocketEnabled", "onPacket", "", "packet", "Lio/sip3/captain/ce/domain/Packet;", "start", "sip3-captain-ce"})
public final class TcpHandler
extends AbstractVerticle {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private long expirationDelay = 100L;
    private long aggregationTimeout = 200L;
    private long idleConnectionTimeout = 300000L;
    private boolean sipEnabled = true;
    private boolean smppEnabled;
    private boolean websocketEnabled;
    private PeriodicallyExpiringHashMap<String, TcpConnection> connections;

    public void start() {
        Object object;
        Object object2;
        boolean it;
        Object object3;
        JsonObject jsonObject = this.config().getJsonObject("tcp");
        if (jsonObject != null) {
            long it2;
            Long l;
            JsonObject config = jsonObject;
            boolean bl = false;
            Long l2 = l = config.getLong("expiration_delay");
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getLong(\"expiration_delay\")");
                it2 = ((Number)l).longValue();
                boolean bl2 = false;
                this.expirationDelay = it2;
            }
            Long l3 = l = config.getLong("aggregation_timeout");
            if (l3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getLong(\"aggregation_timeout\")");
                it2 = ((Number)l).longValue();
                boolean bl3 = false;
                this.aggregationTimeout = it2;
            }
            Long l4 = l = config.getLong("idle_connection_timeout");
            if (l4 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l4, (String)"getLong(\"idle_connection_timeout\")");
                it2 = ((Number)l).longValue();
                boolean bl4 = false;
                this.idleConnectionTimeout = it2;
            }
        }
        if ((object3 = this.config().getJsonObject("sip")) != null && (object3 = object3.getBoolean("enabled")) != null) {
            it = (Boolean)object3;
            boolean bl = false;
            this.sipEnabled = it;
        }
        if ((object2 = this.config().getJsonObject("smpp")) != null && (object2 = object2.getBoolean("enabled")) != null) {
            it = (Boolean)object2;
            boolean bl = false;
            this.smppEnabled = it;
        }
        if ((object = this.config().getJsonObject("websocket")) != null && (object = object.getBoolean("enabled")) != null) {
            it = (Boolean)object;
            boolean bl = false;
            this.websocketEnabled = it;
        }
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, TcpConnection, Long>(this){
            final /* synthetic */ TcpHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull TcpConnection connection) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                return connection.getLastUpdated() + TcpHandler.access$getIdleConnectionTimeout$p(this.this$0);
            }
        }).onRemain((Function2)start.6.INSTANCE);
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
        this.connections = builder.build(vertx);
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getTcp(), arg_0 -> TcpHandler.start$lambda$8(this, arg_0));
    }

    public final void onPacket(@NotNull Packet packet) {
        TcpConnection connection;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        ByteBuf buffer = ((Encodable)payload).encode();
        int offset = buffer.readerIndex();
        packet.setSrcPort(buffer.readUnsignedShort());
        packet.setDstPort(buffer.readUnsignedShort());
        long sequenceNumber = buffer.readUnsignedInt();
        buffer.skipBytes(4);
        int headerLength = 4 * (buffer.readUnsignedByte() >> 4);
        buffer.readerIndex(offset + headerLength);
        if (buffer.readableBytes() <= 0) {
            return;
        }
        String srcAddr = IpUtil.INSTANCE.convertToString(packet.getSrcAddr());
        long srcPort = packet.getSrcPort();
        String dstAddr = IpUtil.INSTANCE.convertToString(packet.getDstAddr());
        long dstPort = packet.getDstPort();
        String connectionId = srcAddr + ":" + srcPort + ":" + dstAddr + ":" + dstPort;
        PeriodicallyExpiringHashMap<String, TcpConnection> periodicallyExpiringHashMap = this.connections;
        if (periodicallyExpiringHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connections");
            periodicallyExpiringHashMap = null;
        }
        if ((connection = (TcpConnection)periodicallyExpiringHashMap.get((Object)connectionId)) == null) {
            TcpConnection tcpConnection;
            if (this.sipEnabled && SipConnection.Companion.assert(buffer)) {
                Vertx vertx = this.vertx;
                Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
                JsonObject jsonObject = this.config();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"config()");
                tcpConnection = new SipConnection(vertx, jsonObject, this.aggregationTimeout);
            } else if (this.smppEnabled && SmppConnection.Companion.assert(buffer)) {
                Vertx vertx = this.vertx;
                Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
                JsonObject jsonObject = this.config();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"config()");
                tcpConnection = new SmppConnection(vertx, jsonObject, this.aggregationTimeout);
            } else if (this.websocketEnabled && WebSocketConnection.Companion.assert(buffer)) {
                Vertx vertx = this.vertx;
                Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
                JsonObject jsonObject = this.config();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"config()");
                tcpConnection = new WebSocketConnection(vertx, jsonObject, this.aggregationTimeout);
            } else {
                return;
            }
            connection = tcpConnection;
            PeriodicallyExpiringHashMap<String, TcpConnection> periodicallyExpiringHashMap2 = this.connections;
            if (periodicallyExpiringHashMap2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connections");
                periodicallyExpiringHashMap2 = null;
            }
            periodicallyExpiringHashMap2.put((Object)connectionId, (Object)connection);
        }
        packet.setPayload((Payload)new ByteBufPayload(buffer));
        connection.setLastUpdated(System.currentTimeMillis());
        connection.onTcpSegment(sequenceNumber, packet);
    }

    private static final void start$lambda$8(TcpHandler this$0, Message event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        List packets = (List)event.body();
        Intrinsics.checkNotNullExpressionValue((Object)packets, (String)"packets");
        Iterable $this$forEach$iv = packets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Packet packet = (Packet)element$iv;
            boolean bl = false;
            try {
                this$0.onPacket(packet);
            }
            catch (Exception e) {
                this$0.logger.error("TcpHandler 'onPacket()' failed.", (Throwable)e);
            }
        }
    }

    public static final /* synthetic */ long access$getIdleConnectionTimeout$p(TcpHandler $this) {
        return $this.idleConnectionTimeout;
    }
}

