/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.management;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.management.ManagementSocket;
import io.sip3.commons.domain.media.MediaControl;
import io.sip3.commons.vertx.annotations.ConditionalOnProperty;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.commons.vertx.util.VertxUtilKt;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.WebSocket;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.parsetools.RecordParser;
import java.net.URI;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance(singleton=true)
@ConditionalOnProperty(pointer="/management")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 @2\u00020\u0001:\u0001@B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000203H\u0016J\b\u00107\u001a\u000203H\u0016J\b\u00108\u001a\u000203H\u0016J\u001c\u00109\u001a\u0002032\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u0002030;H\u0016J\b\u0010=\u001a\u000203H\u0016J\b\u0010>\u001a\u00020?H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006A"}, d2={"Lio/sip3/captain/ce/management/ManagementSocket;", "Lio/vertx/core/AbstractVerticle;", "()V", "delimiter", "", "getDelimiter", "()Ljava/lang/String;", "setDelimiter", "(Ljava/lang/String;)V", "logger", "Lmu/KLogger;", "periodicStream", "", "getPeriodicStream", "()Ljava/lang/Long;", "setPeriodicStream", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "reconnectionTimeout", "getReconnectionTimeout", "()J", "setReconnectionTimeout", "(J)V", "registerDelay", "getRegisterDelay", "setRegisterDelay", "tcp", "Lio/vertx/core/net/NetSocket;", "getTcp", "()Lio/vertx/core/net/NetSocket;", "setTcp", "(Lio/vertx/core/net/NetSocket;)V", "udp", "Lio/vertx/core/datagram/DatagramSocket;", "getUdp", "()Lio/vertx/core/datagram/DatagramSocket;", "setUdp", "(Lio/vertx/core/datagram/DatagramSocket;)V", "uri", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "setUri", "(Ljava/net/URI;)V", "ws", "Lio/vertx/core/http/WebSocket;", "getWs", "()Lio/vertx/core/http/WebSocket;", "setWs", "(Lio/vertx/core/http/WebSocket;)V", "handle", "", "message", "Lio/vertx/core/json/JsonObject;", "openTcpConnection", "openUdpConnection", "openWsConnection", "sendRegister", "send", "Lkotlin/Function1;", "Lio/vertx/core/buffer/Buffer;", "start", "tcpConnectionOptions", "Lio/vertx/core/net/NetClientOptions;", "Companion", "sip3-captain-ce"})
public class ManagementSocket
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    public URI uri;
    private long registerDelay = 60000L;
    private long reconnectionTimeout = 1000L;
    @NotNull
    private String delimiter = "\r\n\r\n3PIS\r\n\r\n";
    @Nullable
    private DatagramSocket udp;
    @Nullable
    private NetSocket tcp;
    @Nullable
    private WebSocket ws;
    @Nullable
    private Long periodicStream;
    @NotNull
    public static final String TYPE_SHUTDOWN = "shutdown";
    @NotNull
    public static final String TYPE_REGISTER = "register";
    @NotNull
    public static final String TYPE_REGISTER_RESPONSE = "register_response";
    @NotNull
    public static final String TYPE_MEDIA_CONTROL = "media_control";
    @NotNull
    public static final String TYPE_MEDIA_RECORDING_RESET = "media_recording_reset";

    @NotNull
    public final URI getUri() {
        URI uRI = this.uri;
        if (uRI != null) {
            return uRI;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
        return null;
    }

    public final void setUri(@NotNull URI uRI) {
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"<set-?>");
        this.uri = uRI;
    }

    public final long getRegisterDelay() {
        return this.registerDelay;
    }

    public final void setRegisterDelay(long l) {
        this.registerDelay = l;
    }

    public final long getReconnectionTimeout() {
        return this.reconnectionTimeout;
    }

    public final void setReconnectionTimeout(long l) {
        this.reconnectionTimeout = l;
    }

    @NotNull
    public final String getDelimiter() {
        return this.delimiter;
    }

    public final void setDelimiter(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.delimiter = string;
    }

    @Nullable
    protected final DatagramSocket getUdp() {
        return this.udp;
    }

    protected final void setUdp(@Nullable DatagramSocket datagramSocket) {
        this.udp = datagramSocket;
    }

    @Nullable
    protected final NetSocket getTcp() {
        return this.tcp;
    }

    protected final void setTcp(@Nullable NetSocket netSocket) {
        this.tcp = netSocket;
    }

    @Nullable
    protected final WebSocket getWs() {
        return this.ws;
    }

    protected final void setWs(@Nullable WebSocket webSocket) {
        this.ws = webSocket;
    }

    @Nullable
    protected final Long getPeriodicStream() {
        return this.periodicStream;
    }

    protected final void setPeriodicStream(@Nullable Long l) {
        this.periodicStream = l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        String string;
        long it;
        JsonObject config = this.config().getJsonObject("management");
        boolean bl = false;
        Object object = config.getString("uri");
        String string2 = object;
        if (string2 == null) {
            throw new IllegalArgumentException("uri");
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.getString(\"uri\") \u2026lArgumentException(\"uri\")");
        this.setUri(new URI((String)object));
        Object object2 = object = config.getLong("register_delay");
        if (object2 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getLong(\"register_delay\")");
            it = ((Number)object).longValue();
            boolean bl2 = false;
            this.registerDelay = it;
        }
        Object object3 = object = config.getLong("reconnection_timeout");
        if (object3 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getLong(\"reconnection_timeout\")");
            it = ((Number)object).longValue();
            boolean bl3 = false;
            this.reconnectionTimeout = it;
        }
        Object object4 = object = config.getString("delimiter");
        if (object4 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getString(\"delimiter\")");
            Object it2 = object;
            boolean bl4 = false;
            this.delimiter = it2;
        }
        if ((string = this.getUri().getScheme()) == null) throw new NotImplementedError("Unknown protocol: " + this.getUri());
        int n = -1;
        switch (string.hashCode()) {
            case 115649: {
                if (string.equals("udp")) {
                    n = 1;
                }
                break;
            }
            case 114657: {
                if (string.equals("tcp")) {
                    n = 2;
                }
                break;
            }
            case 3804: {
                if (string.equals("ws")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                this.openUdpConnection();
                return;
            }
            case 2: {
                this.openTcpConnection();
                return;
            }
            case 3: {
                this.openWsConnection();
                return;
            }
            default: {
                throw new NotImplementedError("Unknown protocol: " + this.getUri());
            }
        }
    }

    public void openUdpConnection() {
        DatagramSocketOptions datagramSocketOptions;
        DatagramSocketOptions $this$openUdpConnection_u24lambda_u244 = datagramSocketOptions = new DatagramSocketOptions();
        boolean bl = false;
        String string = this.getUri().getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.host");
        CharSequence charSequence = string;
        $this$openUdpConnection_u24lambda_u244.setIpV6(new Regex("\\[.*]").matches(charSequence));
        DatagramSocketOptions options = datagramSocketOptions;
        this.udp = this.vertx.createDatagramSocket(options).handler(arg_0 -> ManagementSocket.openUdpConnection$lambda$5(this, arg_0));
        this.periodicStream = this.vertx.setPeriodic(0L, this.registerDelay, arg_0 -> ManagementSocket.openUdpConnection$lambda$6(this, arg_0));
    }

    public void openTcpConnection() {
        NetClientOptions options = this.tcpConnectionOptions();
        this.logger.info((Function0)new Function0<Object>(options){
            final /* synthetic */ NetClientOptions $options;
            {
                this.$options = $options;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Options: " + this.$options.toJson().encodePrettily();
            }
        });
        this.vertx.createNetClient(options).connect(this.getUri().getPort(), this.getUri().getHost()).onFailure(arg_0 -> ManagementSocket.openTcpConnection$lambda$9(this, arg_0)).onSuccess(arg_0 -> ManagementSocket.openTcpConnection$lambda$16(this, arg_0));
    }

    @NotNull
    public NetClientOptions tcpConnectionOptions() {
        return new NetClientOptions();
    }

    public void openWsConnection() {
        throw new NotImplementedError("WebSocket transport is available in EE version");
    }

    /*
     * WARNING - void declaration
     */
    public void sendRegister(@NotNull Function1<? super Buffer, Unit> send) {
        void $this$sendRegister_u24lambda_u2418_u24lambda_u2417;
        JsonObject jsonObject;
        JsonObject jsonObject2;
        Intrinsics.checkNotNullParameter(send, (String)"send");
        JsonObject $this$sendRegister_u24lambda_u2418 = jsonObject2 = new JsonObject();
        boolean bl = false;
        $this$sendRegister_u24lambda_u2418.put("type", (Object)TYPE_REGISTER);
        JsonObject jsonObject3 = jsonObject = new JsonObject();
        String string = "payload";
        JsonObject jsonObject4 = $this$sendRegister_u24lambda_u2418;
        boolean bl2 = false;
        $this$sendRegister_u24lambda_u2418_u24lambda_u2417.put("timestamp", (Object)System.currentTimeMillis());
        $this$sendRegister_u24lambda_u2418_u24lambda_u2417.put("deployment_id", (Object)this.deploymentID());
        $this$sendRegister_u24lambda_u2418_u24lambda_u2417.put("config", (Object)this.config());
        Unit unit = Unit.INSTANCE;
        jsonObject4.put(string, (Object)jsonObject);
        JsonObject registerMessage = jsonObject2;
        Buffer buffer = registerMessage.toBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"registerMessage.toBuffer()");
        send.invoke((Object)buffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handle(@NotNull JsonObject message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String type = message.getString("type");
        JsonObject payload = message.getJsonObject("payload");
        String string = type;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -850164954: {
                    if (!string.equals(TYPE_MEDIA_RECORDING_RESET)) break;
                    n = 1;
                    break;
                }
                case -443918334: {
                    if (!string.equals(TYPE_MEDIA_CONTROL)) break;
                    n = 2;
                    break;
                }
                case -824779171: {
                    if (!string.equals(TYPE_REGISTER_RESPONSE)) break;
                    n = 3;
                    break;
                }
                case -169343402: {
                    if (!string.equals(TYPE_SHUTDOWN)) break;
                    n = 4;
                    break;
                }
            }
            switch (n) {
                case 3: {
                    this.logger.debug((Function0)new Function0<Object>(payload){
                        final /* synthetic */ JsonObject $payload;
                        {
                            this.$payload = $payload;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Register response received: " + this.$payload;
                        }
                    });
                    this.logger.trace((Function0)new Function0<Object>(payload){
                        final /* synthetic */ JsonObject $payload;
                        {
                            this.$payload = $payload;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            long l = System.currentTimeMillis();
                            Long l2 = this.$payload.getLong("registered_at");
                            Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"payload.getLong(\"registered_at\")");
                            return "Time diff: " + (l - ((Number)l2).longValue()) + "ms";
                        }
                    });
                    return;
                }
                case 4: {
                    int exitCode;
                    Integer n2 = payload.getInteger("exit_code");
                    int n3 = exitCode = n2 == null ? -1 : n2;
                    if (Intrinsics.areEqual((Object)payload.getString("deployment_id"), (Object)this.deploymentID())) {
                        this.logger.warn((Function0)new Function0<Object>(message){
                            final /* synthetic */ JsonObject $message;
                            {
                                this.$message = $message;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Shutting down the process via management socket: " + this.$message;
                            }
                        });
                        Vertx vertx = this.vertx;
                        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
                        VertxUtilKt.closeAndExitProcess((Vertx)vertx, (int)exitCode);
                    }
                    String string2 = payload.getString("name");
                    if (string2 == null) return;
                    String name = string2;
                    boolean bl = false;
                    JsonObject jsonObject = this.config().getJsonObject("host");
                    if (!Intrinsics.areEqual((Object)name, (Object)(jsonObject != null ? jsonObject.getString("name") : null))) {
                        if (!Intrinsics.areEqual((Object)name, (Object)this.deploymentID())) return;
                    }
                    this.logger.warn((Function0)new Function0<Object>(message){
                        final /* synthetic */ JsonObject $message;
                        {
                            this.$message = $message;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Shutting down the process via management socket: " + this.$message;
                        }
                    });
                    Vertx vertx = this.vertx;
                    Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
                    VertxUtilKt.closeAndExitProcess((Vertx)vertx, (int)exitCode);
                    return;
                }
                case 2: {
                    MediaControl mediaControl = (MediaControl)payload.mapTo(MediaControl.class);
                    EventBus eventBus = this.vertx.eventBus();
                    Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
                    String string3 = RoutesCE.Companion.getMedia() + "_control";
                    Intrinsics.checkNotNullExpressionValue((Object)mediaControl, (String)"mediaControl");
                    EventBusUtilKt.localPublish$default((EventBus)eventBus, (String)string3, (Object)mediaControl, null, (int)4, null);
                    return;
                }
                case 1: {
                    this.logger.info((Function0)new Function0<Object>(message){
                        final /* synthetic */ JsonObject $message;
                        {
                            this.$message = $message;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Media recording reset via management socket: " + this.$message;
                        }
                    });
                    EventBus eventBus = this.vertx.eventBus();
                    Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
                    String string4 = RoutesCE.Companion.getMedia() + "_recording_reset";
                    Intrinsics.checkNotNullExpressionValue((Object)payload, (String)"payload");
                    EventBusUtilKt.localPublish$default((EventBus)eventBus, (String)string4, (Object)payload, null, (int)4, null);
                    return;
                }
            }
        }
        this.logger.debug((Function0)new Function0<Object>(type, message){
            final /* synthetic */ String $type;
            final /* synthetic */ JsonObject $message;
            {
                this.$type = $type;
                this.$message = $message;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Unknown message type '" + this.$type + "'. Message: " + this.$message.encodePrettily();
            }
        });
    }

    private static final void openUdpConnection$lambda$5(ManagementSocket this$0, DatagramPacket packet) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Buffer buffer = packet.data();
        try {
            JsonObject message = buffer.toJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
            this$0.handle(message);
        }
        catch (Exception e) {
            this$0.logger.error("ManagementSocket 'handle()' failed. Message: " + buffer.toString(Charset.defaultCharset()), (Throwable)e);
        }
    }

    private static final void openUdpConnection$lambda$6(ManagementSocket this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sendRegister((Function1<? super Buffer, Unit>)((Function1)new Function1<Buffer, Unit>(this$0){
            final /* synthetic */ ManagementSocket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Buffer buffer) {
                block0: {
                    Future future;
                    Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                    DatagramSocket datagramSocket = this.this$0.getUdp();
                    if (datagramSocket == null || (future = datagramSocket.send(buffer, this.this$0.getUri().getPort(), this.this$0.getUri().getHost())) == null) break block0;
                    future.onFailure(arg_0 -> openUdpConnection.2.1.invoke$lambda$0(this.this$0, arg_0));
                }
            }

            private static final void invoke$lambda$0(ManagementSocket this$0, Throwable it) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                ManagementSocket.access$getLogger$p(this$0).error(it, (Function0)openUdpConnection.2.1.1.INSTANCE);
            }
        }));
    }

    private static final void openTcpConnection$lambda$9$lambda$8(ManagementSocket this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.openTcpConnection();
    }

    private static final void openTcpConnection$lambda$9(ManagementSocket this$0, Throwable t) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logger.error(t, (Function0)new Function0<Object>(this$0){
            final /* synthetic */ ManagementSocket this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Failed to connect to " + this.this$0.getUri();
            }
        });
        this$0.tcp = null;
        Long l = this$0.periodicStream;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            this$0.vertx.cancelTimer(it);
            this$0.periodicStream = null;
        }
        this$0.vertx.setTimer(this$0.reconnectionTimeout, arg_0 -> ManagementSocket.openTcpConnection$lambda$9$lambda$8(this$0, arg_0));
    }

    private static final void openTcpConnection$lambda$16$lambda$10(ManagementSocket this$0, Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            JsonObject message = buffer.toJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
            this$0.handle(message);
        }
        catch (Exception e) {
            this$0.logger.error("ManagementSocket 'handle()' failed. Message: " + buffer.toString(Charset.defaultCharset()), (Throwable)e);
        }
    }

    private static final void openTcpConnection$lambda$16$lambda$11(RecordParser $parser, ManagementSocket this$0, Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            $parser.handle(buffer);
        }
        catch (Exception e) {
            this$0.logger.error((Throwable)e, (Function0)openTcpConnection.3.1.1.INSTANCE);
            this$0.logger.debug((Function0)new Function0<Object>(this$0, buffer){
                final /* synthetic */ ManagementSocket this$0;
                final /* synthetic */ Buffer $buffer;
                {
                    this.this$0 = $receiver;
                    this.$buffer = $buffer;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Sender: " + this.this$0.getUri() + ", buffer: " + ByteBufUtil.prettyHexDump((ByteBuf)this.$buffer.getByteBuf());
                }
            });
        }
    }

    private static final void openTcpConnection$lambda$16$lambda$14$lambda$13(ManagementSocket this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.openTcpConnection();
    }

    private static final void openTcpConnection$lambda$16$lambda$14(ManagementSocket this$0, Void it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logger.info("TCP connection closed: " + this$0.getUri());
        this$0.tcp = null;
        Long l = this$0.periodicStream;
        if (l != null) {
            long it2 = ((Number)l).longValue();
            boolean bl = false;
            this$0.vertx.cancelTimer(it2);
            this$0.periodicStream = null;
        }
        this$0.vertx.setTimer(this$0.reconnectionTimeout, arg_0 -> ManagementSocket.openTcpConnection$lambda$16$lambda$14$lambda$13(this$0, arg_0));
    }

    private static final void openTcpConnection$lambda$16$lambda$15(ManagementSocket this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sendRegister((Function1<? super Buffer, Unit>)((Function1)new Function1<Buffer, Unit>(this$0){
            final /* synthetic */ ManagementSocket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Buffer buffer) {
                block0: {
                    Future future;
                    Future future2;
                    Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                    NetSocket netSocket = this.this$0.getTcp();
                    Future future3 = future2 = netSocket != null && (future = netSocket.write((Object)buffer.appendString(this.this$0.getDelimiter()))) != null ? future.onFailure(arg_0 -> openTcpConnection.3.3.1.invoke$lambda$0(this.this$0, arg_0)) : null;
                    if (future2 != null) break block0;
                    ManagementSocket.access$getLogger$p(this.this$0).warn((Function0)openTcpConnection.3.3.2.INSTANCE);
                }
            }

            private static final void invoke$lambda$0(ManagementSocket this$0, Throwable it) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                ManagementSocket.access$getLogger$p(this$0).error(it, (Function0)openTcpConnection.3.3.1.1.INSTANCE);
            }
        }));
    }

    private static final void openTcpConnection$lambda$16(ManagementSocket this$0, NetSocket socket) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        RecordParser parser = RecordParser.newDelimited((String)this$0.delimiter, arg_0 -> ManagementSocket.openTcpConnection$lambda$16$lambda$10(this$0, arg_0));
        this$0.tcp = socket.handler(arg_0 -> ManagementSocket.openTcpConnection$lambda$16$lambda$11(parser, this$0, arg_0)).closeHandler(arg_0 -> ManagementSocket.openTcpConnection$lambda$16$lambda$14(this$0, arg_0));
        this$0.logger.info("TCP connection opened: " + this$0.getUri());
        this$0.periodicStream = this$0.vertx.setPeriodic(0L, this$0.registerDelay, arg_0 -> ManagementSocket.openTcpConnection$lambda$16$lambda$15(this$0, arg_0));
    }

    public static final /* synthetic */ KLogger access$getLogger$p(ManagementSocket $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sip3/captain/ce/management/ManagementSocket$Companion;", "", "()V", "TYPE_MEDIA_CONTROL", "", "TYPE_MEDIA_RECORDING_RESET", "TYPE_REGISTER", "TYPE_REGISTER_RESPONSE", "TYPE_SHUTDOWN", "sip3-captain-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

