/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.sender;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.sender.Sender;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.util.NetOptionsUtilKt;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.WebSocket;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.TCPSSLOptions;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000206H\u0016J\b\u00108\u001a\u000206H\u0016J\u0014\u00109\u001a\u0002062\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00040;J\b\u0010<\u001a\u000206H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006="}, d2={"Lio/sip3/captain/ce/sender/Sender;", "Lio/vertx/core/AbstractVerticle;", "()V", "delimiter", "Lio/vertx/core/buffer/Buffer;", "kotlin.jvm.PlatformType", "logger", "Lmu/KLogger;", "packetsSent", "Lio/micrometer/core/instrument/Counter;", "reconnectionTimeout", "", "getReconnectionTimeout", "()Ljava/lang/Long;", "setReconnectionTimeout", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "reusePort", "", "getReusePort", "()Z", "setReusePort", "(Z)V", "sslConfig", "Lio/vertx/core/json/JsonObject;", "getSslConfig", "()Lio/vertx/core/json/JsonObject;", "setSslConfig", "(Lio/vertx/core/json/JsonObject;)V", "tcp", "Lio/vertx/core/net/NetSocket;", "getTcp", "()Lio/vertx/core/net/NetSocket;", "setTcp", "(Lio/vertx/core/net/NetSocket;)V", "udp", "Lio/vertx/core/datagram/DatagramSocket;", "getUdp", "()Lio/vertx/core/datagram/DatagramSocket;", "setUdp", "(Lio/vertx/core/datagram/DatagramSocket;)V", "uri", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "setUri", "(Ljava/net/URI;)V", "ws", "Lio/vertx/core/http/WebSocket;", "getWs", "()Lio/vertx/core/http/WebSocket;", "setWs", "(Lio/vertx/core/http/WebSocket;)V", "openTcpConnection", "", "openUdpConnection", "openWsConnection", "send", "buffers", "", "start", "sip3-captain-ce"})
public class Sender
extends AbstractVerticle {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    public URI uri;
    @Nullable
    private Long reconnectionTimeout;
    private boolean reusePort = true;
    @Nullable
    private JsonObject sslConfig;
    private Buffer delimiter = Buffer.buffer((String)"\r\n\r\n3PIS\r\n\r\n");
    @Nullable
    private DatagramSocket udp;
    @Nullable
    private NetSocket tcp;
    @Nullable
    private WebSocket ws;
    private final Counter packetsSent = Metrics.counter((String)"packets_sent", (String[])new String[0]);

    @NotNull
    public final URI getUri() {
        URI uRI = this.uri;
        if (uRI != null) {
            return uRI;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
        return null;
    }

    public final void setUri(@NotNull URI uRI) {
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"<set-?>");
        this.uri = uRI;
    }

    @Nullable
    public final Long getReconnectionTimeout() {
        return this.reconnectionTimeout;
    }

    public final void setReconnectionTimeout(@Nullable Long l) {
        this.reconnectionTimeout = l;
    }

    public final boolean getReusePort() {
        return this.reusePort;
    }

    public final void setReusePort(boolean bl) {
        this.reusePort = bl;
    }

    @Nullable
    public final JsonObject getSslConfig() {
        return this.sslConfig;
    }

    public final void setSslConfig(@Nullable JsonObject jsonObject) {
        this.sslConfig = jsonObject;
    }

    @Nullable
    public final DatagramSocket getUdp() {
        return this.udp;
    }

    public final void setUdp(@Nullable DatagramSocket datagramSocket) {
        this.udp = datagramSocket;
    }

    @Nullable
    public final NetSocket getTcp() {
        return this.tcp;
    }

    public final void setTcp(@Nullable NetSocket netSocket) {
        this.tcp = netSocket;
    }

    @Nullable
    public final WebSocket getWs() {
        return this.ws;
    }

    public final void setWs(@Nullable WebSocket webSocket) {
        this.ws = webSocket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        String string;
        JsonObject config = this.config().getJsonObject("sender");
        boolean bl = false;
        Object object = config.getString("uri");
        String string2 = object;
        if (string2 == null) {
            throw new IllegalArgumentException("uri");
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.getString(\"uri\") \u2026lArgumentException(\"uri\")");
        this.setUri(new URI((String)object));
        this.sslConfig = config.getJsonObject("ssl");
        this.reconnectionTimeout = config.getLong("reconnection_timeout");
        Object object2 = object = config.getBoolean("reuse_port");
        if (object2 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getBoolean(\"reuse_port\")");
            boolean it = (Boolean)object;
            boolean bl2 = false;
            this.reusePort = it;
        }
        Object object3 = object = config.getString("delimiter");
        if (object3 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getString(\"delimiter\")");
            Object it = object;
            boolean bl3 = false;
            this.delimiter = Buffer.buffer((String)it);
        }
        if ((string = this.getUri().getScheme()) == null) throw new NotImplementedError("Unknown protocol: " + this.getUri());
        int n = -1;
        switch (string.hashCode()) {
            case 115649: {
                if (string.equals("udp")) {
                    n = 1;
                }
                break;
            }
            case 114657: {
                if (string.equals("tcp")) {
                    n = 2;
                }
                break;
            }
            case 118039: {
                if (string.equals("wss")) {
                    n = 3;
                }
                break;
            }
            case 3804: {
                if (string.equals("ws")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                this.openUdpConnection();
                break;
            }
            case 2: {
                this.openTcpConnection();
                break;
            }
            case 3: {
                this.openWsConnection();
                break;
            }
            default: {
                throw new NotImplementedError("Unknown protocol: " + this.getUri());
            }
        }
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getSender(), arg_0 -> Sender.start$lambda$3(this, arg_0));
    }

    public void openUdpConnection() {
        DatagramSocketOptions datagramSocketOptions;
        DatagramSocketOptions $this$openUdpConnection_u24lambda_u244 = datagramSocketOptions = new DatagramSocketOptions();
        boolean bl = false;
        String string = this.getUri().getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.host");
        CharSequence charSequence = string;
        $this$openUdpConnection_u24lambda_u244.setIpV6(new Regex("\\[.*]").matches(charSequence));
        $this$openUdpConnection_u24lambda_u244.setReusePort(this.reusePort);
        DatagramSocketOptions options = datagramSocketOptions;
        this.udp = this.vertx.createDatagramSocket(options);
        this.logger.info("UDP connection opened: " + this.getUri());
    }

    public void openTcpConnection() {
        NetClientOptions netClientOptions;
        NetClientOptions $this$openTcpConnection_u24lambda_u246 = netClientOptions = new NetClientOptions();
        boolean bl = false;
        $this$openTcpConnection_u24lambda_u246.setReusePort(this.reusePort);
        JsonObject jsonObject = this.sslConfig;
        if (jsonObject != null) {
            JsonObject config = jsonObject;
            boolean bl2 = false;
            $this$openTcpConnection_u24lambda_u246.setTrustAll(true);
            NetOptionsUtilKt.initSsl((TCPSSLOptions)((TCPSSLOptions)$this$openTcpConnection_u24lambda_u246), (JsonObject)config);
        }
        NetClientOptions options = netClientOptions;
        this.vertx.createNetClient(options).connect(this.getUri().getPort(), this.getUri().getHost(), arg_0 -> Sender.openTcpConnection$lambda$12(this, arg_0));
    }

    public void openWsConnection() {
        throw new NotImplementedError("WebSocket transport is available in EE version");
    }

    public final void send(@NotNull List<? extends Buffer> buffers) {
        block5: {
            Buffer it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            DatagramSocket socket;
            Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
            this.packetsSent.increment((double)buffers.size());
            DatagramSocket datagramSocket = this.udp;
            if (datagramSocket != null) {
                socket = datagramSocket;
                boolean bl = false;
                $this$forEach$iv = buffers;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Buffer)element$iv;
                    boolean bl2 = false;
                    socket.send(it, this.getUri().getPort(), this.getUri().getHost());
                }
            }
            NetSocket netSocket = this.tcp;
            if (netSocket != null) {
                socket = netSocket;
                boolean bl = false;
                $this$forEach$iv = buffers;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Buffer)element$iv;
                    boolean bl3 = false;
                    socket.write((Object)it.appendBuffer(this.delimiter));
                }
            }
            WebSocket webSocket = this.ws;
            if (webSocket == null) break block5;
            socket = webSocket;
            boolean bl = false;
            $this$forEach$iv = buffers;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Buffer)element$iv;
                boolean bl4 = false;
                socket.write((Object)it);
            }
        }
    }

    private static final void start$lambda$3(Sender this$0, Message event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            List buffers = (List)event.body();
            Intrinsics.checkNotNullExpressionValue((Object)buffers, (String)"buffers");
            this$0.send(buffers);
        }
        catch (Exception e) {
            this$0.logger.error("Sender 'send()' failed.", (Throwable)e);
        }
    }

    private static final void openTcpConnection$lambda$12$lambda$9$lambda$8$lambda$7(Sender this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.openTcpConnection();
    }

    private static final void openTcpConnection$lambda$12$lambda$9(Sender this$0, Void it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.logger.info("TCP connection closed: " + this$0.getUri());
            Long l = this$0.reconnectionTimeout;
            if (l == null) break block0;
            long timeout = ((Number)l).longValue();
            boolean bl = false;
            this$0.vertx.setTimer(timeout, arg_0 -> Sender.openTcpConnection$lambda$12$lambda$9$lambda$8$lambda$7(this$0, arg_0));
        }
    }

    private static final void openTcpConnection$lambda$12$lambda$11$lambda$10(Sender this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.openTcpConnection();
    }

    private static final void openTcpConnection$lambda$12(Sender this$0, AsyncResult asr) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                if (!asr.succeeded()) break block0;
                this$0.logger.info("TCP connection opened: " + this$0.getUri());
                this$0.tcp = ((NetSocket)asr.result()).closeHandler(arg_0 -> Sender.openTcpConnection$lambda$12$lambda$9(this$0, arg_0));
                break block1;
            }
            this$0.logger.error("Sender 'openTcpConnection()' failed.", asr.cause());
            Long l = this$0.reconnectionTimeout;
            if (l == null) break block1;
            long timeout = ((Number)l).longValue();
            boolean bl = false;
            this$0.vertx.setTimer(timeout, arg_0 -> Sender.openTcpConnection$lambda$12$lambda$11$lambda$10(this$0, arg_0));
        }
    }
}

