/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service.component;

import io.sip3.twig.ce.configuration.TwigApplicationProperties;
import io.sip3.twig.ce.domain.Component;
import io.sip3.twig.ce.service.component.ComponentRegistrationService;
import io.sip3.twig.ce.service.component.ComponentService;
import java.net.URI;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020\nH\u0016J\u0018\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020\u00162\u0006\u0010A\u001a\u00020\u0016H\u0002J\b\u0010B\u001a\u00020;H\u0017J\u0010\u0010C\u001a\u00020;2\u0006\u0010\t\u001a\u00020\nH\u0016R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u0004\u0018\u00010\u001b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00020\u00168\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010%R\u001e\u0010&\u001a\u00020'8\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001e\u0010,\u001a\u00020\u00168\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0019\"\u0004\b.\u0010%R\u001e\u0010/\u001a\u00020\u00168\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0019\"\u0004\b1\u0010%R\u0012\u00102\u001a\u0004\u0018\u00010\u00168\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00103\u001a\u0004\u0018\u00010\u00168\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u0002058\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006D"}, d2={"Lio/sip3/twig/ce/service/component/ComponentRegistrationService;", "", "()V", "buildProperties", "Lorg/springframework/boot/info/BuildProperties;", "getBuildProperties", "()Lorg/springframework/boot/info/BuildProperties;", "setBuildProperties", "(Lorg/springframework/boot/info/BuildProperties;)V", "component", "Lio/sip3/twig/ce/domain/Component;", "getComponent", "()Lio/sip3/twig/ce/domain/Component;", "setComponent", "(Lio/sip3/twig/ce/domain/Component;)V", "componentService", "Lio/sip3/twig/ce/service/component/ComponentService;", "getComponentService", "()Lio/sip3/twig/ce/service/component/ComponentService;", "setComponentService", "(Lio/sip3/twig/ce/service/component/ComponentService;)V", "contextPath", "", "deploymentId", "getDeploymentId", "()Ljava/lang/String;", "gitProperties", "Lorg/springframework/boot/info/GitProperties;", "getGitProperties", "()Lorg/springframework/boot/info/GitProperties;", "setGitProperties", "(Lorg/springframework/boot/info/GitProperties;)V", "logger", "Lmu/KLogger;", "mongoDb", "getMongoDb", "setMongoDb", "(Ljava/lang/String;)V", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "getMongoTemplate", "()Lorg/springframework/data/mongodb/core/MongoTemplate;", "setMongoTemplate", "(Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "mongoUri", "getMongoUri", "setMongoUri", "name", "getName", "setName", "serverAddress", "serverPort", "twigApplicationProperties", "Lio/sip3/twig/ce/configuration/TwigApplicationProperties;", "getTwigApplicationProperties", "()Lio/sip3/twig/ce/configuration/TwigApplicationProperties;", "setTwigApplicationProperties", "(Lio/sip3/twig/ce/configuration/TwigApplicationProperties;)V", "addBuildInfo", "", "config", "Lorg/bson/Document;", "init", "mongoConnectedTo", "uri", "db", "periodicRegistration", "update", "sip3-twig-ce"})
public class ComponentRegistrationService {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Autowired
    protected TwigApplicationProperties twigApplicationProperties;
    @Autowired
    @Nullable
    private BuildProperties buildProperties;
    @Autowired
    @Nullable
    private GitProperties gitProperties;
    @Autowired
    protected MongoTemplate mongoTemplate;
    @Autowired
    public ComponentService componentService;
    @Value(value="${name:sip3-twig-ce}")
    protected String name;
    @Value(value="${server.address:0.0.0.0}")
    @Nullable
    private final String serverAddress;
    @Value(value="${server.port:8080}")
    @Nullable
    private final String serverPort;
    @Value(value="${server.servlet.context_path:/api}")
    @Nullable
    private final String contextPath;
    @Value(value="${mongo.uri:mongodb://127.0.0.1:27017}")
    protected String mongoUri;
    @Value(value="${mongo.db:sip3}")
    protected String mongoDb;
    @NotNull
    private final String deploymentId;
    @Nullable
    private Component component;

    public ComponentRegistrationService() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.deploymentId = string;
    }

    @NotNull
    protected final TwigApplicationProperties getTwigApplicationProperties() {
        TwigApplicationProperties twigApplicationProperties = this.twigApplicationProperties;
        if (twigApplicationProperties != null) {
            return twigApplicationProperties;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"twigApplicationProperties");
        return null;
    }

    protected final void setTwigApplicationProperties(@NotNull TwigApplicationProperties twigApplicationProperties) {
        Intrinsics.checkNotNullParameter((Object)twigApplicationProperties, (String)"<set-?>");
        this.twigApplicationProperties = twigApplicationProperties;
    }

    @Nullable
    protected final BuildProperties getBuildProperties() {
        return this.buildProperties;
    }

    protected final void setBuildProperties(@Nullable BuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }

    @Nullable
    protected final GitProperties getGitProperties() {
        return this.gitProperties;
    }

    protected final void setGitProperties(@Nullable GitProperties gitProperties) {
        this.gitProperties = gitProperties;
    }

    @NotNull
    protected final MongoTemplate getMongoTemplate() {
        MongoTemplate mongoTemplate = this.mongoTemplate;
        if (mongoTemplate != null) {
            return mongoTemplate;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mongoTemplate");
        return null;
    }

    protected final void setMongoTemplate(@NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"<set-?>");
        this.mongoTemplate = mongoTemplate;
    }

    @NotNull
    public final ComponentService getComponentService() {
        ComponentService componentService = this.componentService;
        if (componentService != null) {
            return componentService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
        return null;
    }

    public final void setComponentService(@NotNull ComponentService componentService) {
        Intrinsics.checkNotNullParameter((Object)componentService, (String)"<set-?>");
        this.componentService = componentService;
    }

    @NotNull
    protected final String getName() {
        String string = this.name;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"name");
        return null;
    }

    protected final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    protected final String getMongoUri() {
        String string = this.mongoUri;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mongoUri");
        return null;
    }

    protected final void setMongoUri(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mongoUri = string;
    }

    @NotNull
    protected final String getMongoDb() {
        String string = this.mongoDb;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mongoDb");
        return null;
    }

    protected final void setMongoDb(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mongoDb = string;
    }

    @NotNull
    protected final String getDeploymentId() {
        return this.deploymentId;
    }

    @Nullable
    protected final Component getComponent() {
        return this.component;
    }

    protected final void setComponent(@Nullable Component component) {
        this.component = component;
    }

    @Scheduled(fixedRateString="${management.register_delay:60000}", timeUnit=TimeUnit.MILLISECONDS)
    public void periodicRegistration() {
        this.logger.debug((Function0)periodicRegistration.1.INSTANCE);
        if (this.component == null) {
            Component component = this.component = this.init();
            Intrinsics.checkNotNull((Object)component);
            this.addBuildInfo(component.getConfig());
        }
        Component component = this.component;
        Intrinsics.checkNotNull((Object)component);
        this.update(component);
        ComponentService componentService = this.getComponentService();
        Component component2 = this.component;
        Intrinsics.checkNotNull((Object)component2);
        this.component = componentService.register(component2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Component init() {
        Object object;
        Set set;
        Document config = new Document();
        try {
            this.getMongoTemplate().getConverter().write((Object)this.getTwigApplicationProperties(), (Object)config);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, (Function0)init.1.INSTANCE);
        }
        Set $this$init_u24lambda_u242 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$init_u24lambda_u242.add(this.mongoConnectedTo(this.getMongoUri(), this.getMongoDb()));
        Map<String, Object> map2 = this.getTwigApplicationProperties().getMongo();
        if (map2 != null && (object = map2.get("secondary")) != null) {
            Object it = object;
            boolean bl2 = false;
            Collection collection = it instanceof Collection ? (Collection)it : null;
            if (collection != null) {
                void $this$forEach$iv;
                Iterable iterable = collection;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object uri = element$iv = iterator.next();
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(uri, (String)"null cannot be cast to non-null type kotlin.String");
                    $this$init_u24lambda_u242.add(this.mongoConnectedTo((String)uri, this.getMongoDb()));
                }
            }
        }
        Set mongoConnections = set;
        return new Component(null, this.getName(), this.deploymentId, "twig", SetsKt.setOf((Object)("http://" + this.serverAddress + ":" + this.serverPort + this.contextPath)), mongoConnections, System.currentTimeMillis(), 0L, 0L, config);
    }

    public void addBuildInfo(@NotNull Document config) {
        block1: {
            BuildProperties props;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            BuildProperties buildProperties = this.buildProperties;
            if (buildProperties != null) {
                props = buildProperties;
                boolean bl = false;
                config.put("version", (Object)props.getVersion());
                config.put("project", (Object)props.getArtifact());
                config.put("build_at", (Object)props.getTime().atZone(ZoneId.of("UTC")).toString());
            }
            GitProperties gitProperties = this.gitProperties;
            if (gitProperties == null) break block1;
            props = gitProperties;
            boolean bl = false;
            config.put("git_commit_id", (Object)props.getShortCommitId());
        }
    }

    public void update(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        long now = System.currentTimeMillis();
        component.setUpdatedAt(now);
        component.setRemoteUpdatedAt(now);
    }

    private final String mongoConnectedTo(String uri, String db) {
        URI it = new URI(uri);
        boolean bl = false;
        return it.getScheme() + "://" + it.getAuthority() + "/" + db;
    }
}

