/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service.media;

import com.mongodb.client.model.Filters;
import io.sip3.twig.ce.domain.SessionRequest;
import io.sip3.twig.ce.mongo.MongoClient;
import io.sip3.twig.ce.service.media.MediaSessionService;
import io.sip3.twig.ce.service.media.domain.LegSession;
import io.sip3.twig.ce.service.media.domain.MediaSession;
import io.sip3.twig.ce.service.media.util.LegSessionUtil;
import io.sip3.twig.ce.util.IteratorUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J4\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\nH\u0016J:\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/sip3/twig/ce/service/media/MediaSessionService;", "", "()V", "logger", "Lmu/KLogger;", "mongoClient", "Lio/sip3/twig/ce/mongo/MongoClient;", "terminationTimeout", "", "details", "", "", "", "Lio/sip3/twig/ce/service/media/domain/LegSession;", "req", "Lio/sip3/twig/ce/domain/SessionRequest;", "dtmf", "", "Lorg/bson/Document;", "find", "prefix", "createdAt", "terminatedAt", "callId", "findLegSessions", "source", "sip3-twig-ce"})
public class MediaSessionService {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Value(value="${session.media.termination-timeout:${session.media.termination_timeout:60000}}")
    private long terminationTimeout = 60000L;
    @Autowired
    private MongoClient mongoClient;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Map<String, LegSession>> details(@NotNull SessionRequest req) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        if (req.getCreatedAt() == null) {
            boolean $i$a$-requireNotNull-MediaSessionService$details$42 = false;
            String $i$a$-requireNotNull-MediaSessionService$details$42 = "created_at";
            throw new IllegalArgumentException($i$a$-requireNotNull-MediaSessionService$details$42.toString());
        }
        if (req.getTerminatedAt() == null) {
            boolean $i$a$-requireNotNull-MediaSessionService$details$52 = false;
            String $i$a$-requireNotNull-MediaSessionService$details$52 = "terminated_at";
            throw new IllegalArgumentException($i$a$-requireNotNull-MediaSessionService$details$52.toString());
        }
        if (req.getCallId() == null) {
            boolean $i$a$-requireNotNull-MediaSessionService$details$62 = false;
            String $i$a$-requireNotNull-MediaSessionService$details$62 = "call_id";
            throw new IllegalArgumentException($i$a$-requireNotNull-MediaSessionService$details$62.toString());
        }
        Long l = req.getCreatedAt();
        Intrinsics.checkNotNull((Object)l);
        long l2 = l;
        Long l3 = req.getTerminatedAt();
        Intrinsics.checkNotNull((Object)l3);
        long l4 = l3;
        List<String> list = req.getCallId();
        Intrinsics.checkNotNull(list);
        Map<String, LegSession> rtp = this.findLegSessions("rtp", l2, l4, list);
        Long l5 = req.getCreatedAt();
        Intrinsics.checkNotNull((Object)l5);
        long l6 = l5;
        Long l7 = req.getTerminatedAt();
        Intrinsics.checkNotNull((Object)l7);
        long l8 = l7;
        List<String> list2 = req.getCallId();
        Intrinsics.checkNotNull(list2);
        Map<String, LegSession> rtcp = this.findLegSessions("rtcp", l6, l8, list2);
        Iterable iterable = SetsKt.plus(rtp.keySet(), (Iterable)rtcp.keySet());
        boolean $i$f$map = false;
        void var6_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"rtp", (Object)rtp.get(it)), TuplesKt.to((Object)"rtcp", (Object)rtcp.get(it))};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, LegSession> findLegSessions(String source, long createdAt, long terminatedAt, List<String> callId) {
        Object object;
        Object object2;
        Map sessions = new LinkedHashMap();
        List reports = new ArrayList();
        this.find("rtpr_" + source + "_index", createdAt, terminatedAt, callId).forEachRemaining(arg_0 -> MediaSessionService.findLegSessions$lambda$4((Function1)new Function1<Document, Unit>((Map<String, LegSession>)sessions){
            final /* synthetic */ Map<String, LegSession> $sessions;
            {
                this.$sessions = $sessions;
                super(1);
            }

            public final void invoke(@NotNull Document report) {
                LegSession legSession;
                Intrinsics.checkNotNullParameter((Object)report, (String)"report");
                String sessionId = LegSessionUtil.INSTANCE.generateLegId(report);
                Map<String, LegSession> $this$getOrPut$iv = this.$sessions;
                boolean $i$f$getOrPut = false;
                LegSession value$iv = $this$getOrPut$iv.get(sessionId);
                if (value$iv == null) {
                    boolean bl = false;
                    LegSession answer$iv = new LegSession();
                    $this$getOrPut$iv.put(sessionId, answer$iv);
                    legSession = answer$iv;
                } else {
                    legSession = value$iv;
                }
                legSession.add(report);
            }
        }, arg_0));
        Iterator iterator = ((Iterable)sessions.values()).iterator();
        if (!iterator.hasNext()) {
            object2 = null;
        } else {
            Object it = (LegSession)iterator.next();
            boolean bl = false;
            it = ((LegSession)it).getCreatedAt();
            while (iterator.hasNext()) {
                LegSession it2 = (LegSession)iterator.next();
                $i$a$-minOfOrNull-MediaSessionService$findLegSessions$createdAtFrom$1 = false;
                Comparable comparable = Long.valueOf(it2.getCreatedAt());
                if (it.compareTo(comparable) <= 0) continue;
                it = comparable;
            }
            object2 = it;
        }
        Long l = (Long)object2;
        long createdAtFrom = l != null ? l : createdAt;
        Iterator<Object> iterator2 = ((Iterable)sessions.values()).iterator();
        if (!iterator2.hasNext()) {
            object = null;
        } else {
            Object it = (LegSession)iterator2.next();
            boolean bl = false;
            it = ((LegSession)it).getTerminatedAt();
            while (iterator2.hasNext()) {
                Object it3 = (LegSession)iterator2.next();
                $i$a$-maxOfOrNull-MediaSessionService$findLegSessions$terminatedAtTo$1 = false;
                if (it.compareTo(it3 = (Comparable)Long.valueOf(((LegSession)it3).getTerminatedAt())) >= 0) continue;
                it = it3;
            }
            object = it;
        }
        Long l2 = (Long)object;
        long terminatedAtTo = l2 != null ? l2 : terminatedAt;
        this.find("rtpr_" + source + "_raw", createdAtFrom, terminatedAtTo, callId).forEachRemaining(arg_0 -> MediaSessionService.findLegSessions$lambda$7((Function1)new Function1<Document, Unit>((List<Document>)reports){
            final /* synthetic */ List<Document> $reports;
            {
                this.$reports = $reports;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                List list = document.getList((Object)"reports", Document.class);
                if (list != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list;
                    List<Document> list2 = this.$reports;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Document report = (Document)element$iv;
                        boolean bl = false;
                        report.put("src_addr", (Object)document.getString((Object)"src_addr"));
                        report.put("src_port", (Object)document.getInteger((Object)"src_port"));
                        report.put("dst_addr", (Object)document.getString((Object)"dst_addr"));
                        report.put("dst_port", (Object)document.getInteger((Object)"dst_port"));
                        report.put("call_id", (Object)document.getString((Object)"call_id"));
                        Intrinsics.checkNotNullExpressionValue((Object)report, (String)"report");
                        list2.add(report);
                    }
                } else {
                    this.$reports.add(document);
                }
            }
        }, arg_0));
        Object $this$forEach$iv = sessions;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object it;
            Map.Entry element$iv;
            Map.Entry it3 = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            String legId = (String)it3.getKey();
            LegSession legSession = (LegSession)it3.getValue();
            try {
                List it4;
                Document it5;
                boolean $i$f$filterTo;
                Collection destination$iv$iv;
                Iterable $this$filter$iv;
                MediaSession mediaSessionReport;
                void $this$sortedBy$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv2 = reports;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Document)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)LegSessionUtil.INSTANCE.generateLegId((Document)it), (Object)legId)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv2;
                boolean $i$f$sortedBy = false;
                List legReports = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Document it = (Document)a;
                        boolean bl = false;
                        Comparable comparable = it.getLong((Object)"created_at");
                        it = (Document)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getLong((Object)"created_at"));
                    }
                });
                boolean bl3 = false;
                Iterable $this$forEach$iv2 = legSession.getIn();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void $this$filterTo$iv$iv2;
                    mediaSessionReport = (MediaSession)element$iv2;
                    boolean bl4 = false;
                    $this$filter$iv = legReports;
                    boolean $i$f$filter2 = false;
                    Iterable iterable2 = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        it5 = (Document)element$iv$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)LegSessionUtil.INSTANCE.generatePartyId(it5, source), (Object)mediaSessionReport.getPartyId())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    it4 = (List)destination$iv$iv;
                    boolean bl6 = false;
                    mediaSessionReport.add(it4);
                }
                $this$forEach$iv2 = legSession.getOut();
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void $this$filterTo$iv$iv3;
                    mediaSessionReport = (MediaSession)element$iv2;
                    boolean bl7 = false;
                    $this$filter$iv = legReports;
                    boolean $i$f$filter3 = false;
                    Iterable bl6 = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                        it5 = (Document)element$iv$iv;
                        boolean bl8 = false;
                        if (!Intrinsics.areEqual((Object)LegSessionUtil.INSTANCE.generatePartyId(it5, source), (Object)mediaSessionReport.getPartyId())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    it4 = (List)destination$iv$iv;
                    boolean bl9 = false;
                    mediaSessionReport.add(it4);
                }
            }
            catch (Exception e) {
                legSession.setInvalid(true);
                this.logger.error((Throwable)e, (Function0)new Function0<Object>(legId){
                    final /* synthetic */ String $legId;
                    {
                        this.$legId = $legId;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "MediaSessionService `updateSession()` failed. LegId: " + this.$legId;
                    }
                });
            }
            Iterable $this$forEach$iv3 = sessions.values();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                LegSession session = (LegSession)element$iv3;
                boolean bl10 = false;
                MediaSession mediaSession = IteratorUtilKt.firstOrNull(IteratorUtilKt.merge(session.getIn().iterator(), session.getOut().iterator(), null), findLegSessions.3.5.1.INSTANCE);
                if (mediaSession == null) continue;
                it = mediaSession;
                boolean bl11 = false;
                session.setInvalid(true);
            }
        }
        $this$forEach$iv = sessions.values();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            LegSession it = (LegSession)element$iv;
            boolean bl = false;
            it.updateTimestamps();
        }
        return sessions;
    }

    @NotNull
    public Iterator<Document> dtmf(@NotNull SessionRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        if (req.getCreatedAt() == null) {
            boolean $i$a$-requireNotNull-MediaSessionService$dtmf$42 = false;
            String $i$a$-requireNotNull-MediaSessionService$dtmf$42 = "created_at";
            throw new IllegalArgumentException($i$a$-requireNotNull-MediaSessionService$dtmf$42.toString());
        }
        if (req.getTerminatedAt() == null) {
            boolean $i$a$-requireNotNull-MediaSessionService$dtmf$52 = false;
            String $i$a$-requireNotNull-MediaSessionService$dtmf$52 = "terminated_at";
            throw new IllegalArgumentException($i$a$-requireNotNull-MediaSessionService$dtmf$52.toString());
        }
        if (req.getCallId() == null) {
            boolean bl = false;
            String string = "call_id";
            throw new IllegalArgumentException(string.toString());
        }
        Long l = req.getCreatedAt();
        Intrinsics.checkNotNull((Object)l);
        long l2 = l;
        Long l3 = req.getTerminatedAt();
        Intrinsics.checkNotNull((Object)l3);
        long l4 = l3;
        List<String> list = req.getCallId();
        Intrinsics.checkNotNull(list);
        return this.find("dtmf_index", l2, l4, list);
    }

    @NotNull
    public Iterator<Document> find(@NotNull String prefix, long createdAt, long terminatedAt, @NotNull List<String> callId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(callId, (String)"callId");
        List $this$find_u24lambda_u2424 = list = (List)new ArrayList();
        boolean bl = false;
        Bson bson = Filters.gte((String)"created_at", (Object)createdAt);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"gte(\"created_at\", createdAt)");
        $this$find_u24lambda_u2424.add(bson);
        Bson bson2 = Filters.lte((String)"created_at", (Object)(terminatedAt + this.terminationTimeout));
        Intrinsics.checkNotNullExpressionValue((Object)bson2, (String)"lte(\"created_at\", termin\u2026dAt + terminationTimeout)");
        $this$find_u24lambda_u2424.add(bson2);
        Bson bson3 = Filters.in((String)"call_id", (Iterable)callId);
        Intrinsics.checkNotNullExpressionValue((Object)bson3, (String)"`in`(\"call_id\", callId)");
        $this$find_u24lambda_u2424.add(bson3);
        List filters2 = list;
        MongoClient mongoClient = this.mongoClient;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongoClient");
            mongoClient = null;
        }
        Pair pair = new Pair((Object)createdAt, (Object)(terminatedAt + this.terminationTimeout));
        Bson bson4 = Filters.and((Iterable)filters2);
        Intrinsics.checkNotNullExpressionValue((Object)bson4, (String)"and(filters)");
        return MongoClient.find$default(mongoClient, prefix, pair, bson4, null, null, 24, null);
    }

    private static final void findLegSessions$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void findLegSessions$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

