/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service.component;

import io.sip3.twig.ce.domain.Component;
import io.sip3.twig.ce.repository.ComponentRepository;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J$\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001dH\u0016J$\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001dH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lio/sip3/twig/ce/service/component/ComponentService;", "", "()V", "componentRepository", "Lio/sip3/twig/ce/repository/ComponentRepository;", "getComponentRepository", "()Lio/sip3/twig/ce/repository/ComponentRepository;", "setComponentRepository", "(Lio/sip3/twig/ce/repository/ComponentRepository;)V", "deleteByDeploymentId", "", "deploymentId", "", "deleteByName", "name", "findByNameIgnoreCase", "", "Lio/sip3/twig/ce/domain/Component;", "getByDeploymentId", "getByNameIgnoreCase", "list", "", "listLatest", "mediaRecordingReset", "mediaRecordingResetByName", "register", "component", "shutdown", "params", "", "shutdownByName", "sip3-twig-ce"})
public class ComponentService {
    @Autowired
    protected ComponentRepository componentRepository;

    @NotNull
    protected final ComponentRepository getComponentRepository() {
        ComponentRepository componentRepository = this.componentRepository;
        if (componentRepository != null) {
            return componentRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"componentRepository");
        return null;
    }

    protected final void setComponentRepository(@NotNull ComponentRepository componentRepository) {
        Intrinsics.checkNotNullParameter((Object)componentRepository, (String)"<set-?>");
        this.componentRepository = componentRepository;
    }

    @NotNull
    public Component register(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Object object = this.getComponentRepository().save(component);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"componentRepository.save(component)");
        return (Component)object;
    }

    @NotNull
    public List<Component> list() {
        Iterable iterable = this.getComponentRepository().findAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"componentRepository.findAll()");
        return CollectionsKt.toList((Iterable)iterable);
    }

    @NotNull
    public List<Component> listLatest() {
        Iterable iterable = this.getComponentRepository().findAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"componentRepository.findAll()");
        Iterable $this$sortedByDescending$iv = iterable;
        boolean $i$f$sortedByDescending = false;
        Iterable $this$distinctBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Component it = (Component)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getUpdatedAt());
                it = (Component)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getUpdatedAt()));
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Component it = (Component)e$iv;
            boolean bl = false;
            String key$iv = it.getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    @NotNull
    public Component getByDeploymentId(@NotNull String deploymentId) {
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        return this.getComponentRepository().getByDeploymentId(deploymentId);
    }

    @NotNull
    public Component getByNameIgnoreCase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getComponentRepository().getByNameIgnoreCase(name);
    }

    @NotNull
    public Set<Component> findByNameIgnoreCase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getComponentRepository().findByNameIgnoreCase(name);
    }

    public void deleteByDeploymentId(@NotNull String deploymentId) {
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        Component it = this.getComponentRepository().getByDeploymentId(deploymentId);
        boolean bl = false;
        this.getComponentRepository().delete(it);
    }

    public void deleteByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Set<Component> it = this.getComponentRepository().findByNameIgnoreCase(name);
        boolean bl = false;
        this.getComponentRepository().deleteAll(it);
    }

    public void mediaRecordingReset(@NotNull String deploymentId) {
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        throw new UnsupportedOperationException("Media Recording Reset is not supported in CE version");
    }

    public void mediaRecordingResetByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        throw new UnsupportedOperationException("Media Recording Reset is not supported in CE version");
    }

    public void shutdown(@NotNull String deploymentId, @NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        throw new UnsupportedOperationException("Shutdown is not supported in CE version");
    }

    public void shutdownByName(@NotNull String name, @NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        throw new UnsupportedOperationException("Shutdown is not supported in CE version");
    }
}

