/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service;

import com.mongodb.client.model.Filters;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.StringMsgParser;
import io.pkts.PcapOutputStream;
import io.pkts.buffer.Buffers;
import io.pkts.frame.PcapGlobalHeader;
import io.pkts.packet.Packet;
import io.pkts.packet.PacketFactory;
import io.pkts.packet.TransportPacketFactory;
import io.pkts.packet.UDPPacket;
import io.sip3.twig.ce.domain.SessionRequest;
import io.sip3.twig.ce.mongo.MongoClient;
import io.sip3.twig.ce.service.SessionService;
import io.sip3.twig.ce.service.host.HostService;
import io.sip3.twig.ce.util.IteratorUtil;
import io.sip3.twig.ce.util.SipMessageUtilKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 82\u00020\u0001:\u00018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00010%2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020 0*2\u0006\u0010!\u001a\u00020\"H&J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020 0*2\u0006\u0010!\u001a\u00020\"H\u0016J,\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020&2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020&0\u001f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020&0\u001fH\u0016J$\u00101\u001a\u00020-2\f\u00102\u001a\b\u0012\u0004\u0012\u00020&0\u001f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020&0\u001fH\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u00106\u001a\u0002072\u0006\u0010!\u001a\u00020\"H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00148\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\f\"\u0004\b\u001b\u0010\u000eR\u0012\u0010\u001c\u001a\u00020\u001d8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lio/sip3/twig/ce/service/SessionService;", "", "()V", "hostService", "Lio/sip3/twig/ce/service/host/HostService;", "getHostService", "()Lio/sip3/twig/ce/service/host/HostService;", "setHostService", "(Lio/sip3/twig/ce/service/host/HostService;)V", "ignoreNanos", "", "getIgnoreNanos", "()Z", "setIgnoreNanos", "(Z)V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "mongoClient", "Lio/sip3/twig/ce/mongo/MongoClient;", "getMongoClient", "()Lio/sip3/twig/ce/mongo/MongoClient;", "setMongoClient", "(Lio/sip3/twig/ce/mongo/MongoClient;)V", "showRetransmits", "getShowRetransmits", "setShowRetransmits", "terminationTimeout", "", "content", "", "Lorg/bson/Document;", "req", "Lio/sip3/twig/ce/domain/SessionRequest;", "details", "extendedParamsFrom", "", "", "message", "Lgov/nist/javax/sip/message/SIPMessage;", "findInRawBySessionRequest", "", "findRecInRawBySessionRequest", "hostOrAddrFilter", "Lorg/bson/conversions/Bson;", "prefix", "hosts", "ips", "legFilter", "srcAddr", "dstAddr", "pcap", "Ljava/io/ByteArrayOutputStream;", "stash", "", "Companion", "sip3-twig-ce"})
public abstract class SessionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Autowired
    protected MongoClient mongoClient;
    @Autowired
    protected HostService hostService;
    @Value(value="${session.show-retransmits:${session.show_retransmits:true}}")
    private boolean showRetransmits = true;
    @Value(value="${session.ignore-nanos:${session.ignore_nanos:true}}")
    private boolean ignoreNanos = true;
    @Value(value="${session.media.termination-timeout:${session.media.termination_timeout:60000}}")
    private long terminationTimeout = 60000L;
    @NotNull
    private static final Comparator<Document> CREATED_AT = new Comparator(){

        public final int compare(T a, T b) {
            Document document = (Document)a;
            boolean bl = false;
            Comparable comparable = document.getLong((Object)"created_at");
            document = (Document)b;
            Comparable comparable2 = comparable;
            bl = false;
            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)document.getLong((Object)"created_at"));
        }
    };
    @NotNull
    private static final Comparator<Document> CREATED_AT_WITH_NANOS;

    @NotNull
    protected final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final MongoClient getMongoClient() {
        MongoClient mongoClient = this.mongoClient;
        if (mongoClient != null) {
            return mongoClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mongoClient");
        return null;
    }

    protected final void setMongoClient(@NotNull MongoClient mongoClient) {
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"<set-?>");
        this.mongoClient = mongoClient;
    }

    @NotNull
    protected final HostService getHostService() {
        HostService hostService = this.hostService;
        if (hostService != null) {
            return hostService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"hostService");
        return null;
    }

    protected final void setHostService(@NotNull HostService hostService) {
        Intrinsics.checkNotNullParameter((Object)hostService, (String)"<set-?>");
        this.hostService = hostService;
    }

    protected final boolean getShowRetransmits() {
        return this.showRetransmits;
    }

    protected final void setShowRetransmits(boolean bl) {
        this.showRetransmits = bl;
    }

    protected final boolean getIgnoreNanos() {
        return this.ignoreNanos;
    }

    protected final void setIgnoreNanos(boolean bl) {
        this.ignoreNanos = bl;
    }

    @NotNull
    public abstract Iterator<Document> findInRawBySessionRequest(@NotNull SessionRequest var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Document> details(@NotNull SessionRequest req) {
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        List legs = new ArrayList();
        Sequence $this$groupBy$iv = SequencesKt.sortedWith((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence(this.findInRawBySessionRequest(req)), (Function1)((Function1)new Function1<Document, Boolean>(req){
            final /* synthetic */ SessionRequest $req;
            {
                this.$req = $req;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                String string = document.getString((Object)"raw_data");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getString(\"raw_data\")");
                List<String> list = this.$req.getMethod();
                String string2 = list != null ? (String)CollectionsKt.first(list) : null;
                Intrinsics.checkNotNull((Object)string2);
                return StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
            }
        })), this.ignoreNanos ? CREATED_AT : CREATED_AT_WITH_NANOS);
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Document document = (Document)element$iv$iv;
            boolean bl = false;
            key$iv$iv = document.getString((Object)"src_addr") + ":" + document.getString((Object)"dst_addr");
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Object it;
            Document document;
            void $this$details_u24lambda_u246_u24lambda_u245;
            Object v1;
            Iterable $this$firstOrNull$iv;
            block10: {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                List documents = (List)entry.getValue();
                $this$firstOrNull$iv = documents;
                boolean $i$f$firstOrNull = false;
                key$iv$iv = $this$firstOrNull$iv.iterator();
                while (key$iv$iv.hasNext()) {
                    Object element$iv2 = key$iv$iv.next();
                    Document it2 = (Document)element$iv2;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it2.getBoolean((Object)"parsed"), (Object)false))) continue;
                    v1 = element$iv2;
                    break block10;
                }
                v1 = null;
            }
            if ((Document)v1 == null) continue;
            Document document2 = new Document();
            $this$firstOrNull$iv = document2;
            List list = legs;
            boolean bl = false;
            $this$details_u24lambda_u246_u24lambda_u245.put("created_at", (Object)document.getLong((Object)"created_at"));
            $this$details_u24lambda_u246_u24lambda_u245.put("src_addr", (Object)document.getString((Object)"src_addr"));
            $this$details_u24lambda_u246_u24lambda_u245.put("src_port", (Object)document.getInteger((Object)"src_port"));
            Object object3 = key$iv$iv = document.getString((Object)"src_host");
            if (object3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getString(\"src_host\")");
                it = key$iv$iv;
                boolean bl4 = false;
                $this$details_u24lambda_u246_u24lambda_u245.put("src_host", it);
            }
            $this$details_u24lambda_u246_u24lambda_u245.put("dst_addr", (Object)document.getString((Object)"dst_addr"));
            $this$details_u24lambda_u246_u24lambda_u245.put("dst_port", (Object)document.getInteger((Object)"dst_port"));
            Object object4 = key$iv$iv = document.getString((Object)"dst_host");
            if (object4 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getString(\"dst_host\")");
                it = key$iv$iv;
                boolean bl5 = false;
                $this$details_u24lambda_u246_u24lambda_u245.put("dst_host", it);
            }
            String rawData = document.getString((Object)"raw_data");
            SIPMessage message = null;
            try {
                StringMsgParser stringMsgParser = new StringMsgParser();
                Intrinsics.checkNotNullExpressionValue((Object)rawData, (String)"rawData");
                byte[] byArray = rawData.getBytes(Charsets.ISO_8859_1);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                message = stringMsgParser.parseSIPMessage(byArray, true, false, null);
            }
            catch (Exception e) {
                this.logger.error("StringMsgParser 'parseSIPMessage()' failed.", (Throwable)e);
            }
            if (message != null) {
                boolean bl6 = false;
                $this$details_u24lambda_u246_u24lambda_u245.put("call_id", (Object)SipMessageUtilKt.callId(message));
                $this$details_u24lambda_u246_u24lambda_u245.put("request_uri", (Object)SipMessageUtilKt.requestUri(message));
                $this$details_u24lambda_u246_u24lambda_u245.put("from_uri", (Object)SipMessageUtilKt.fromUri(message));
                $this$details_u24lambda_u246_u24lambda_u245.put("to_uri", (Object)SipMessageUtilKt.toUri(message));
            }
            list.add(document2);
        }
        return legs;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Document> content(@NotNull SessionRequest req) {
        void $this$mapTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Object list$iv$iv;
        Object value$iv$iv$iv;
        Document document;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Sequence $this$groupBy$iv = SequencesKt.sortedWith((Sequence)SequencesKt.asSequence(this.findInRawBySessionRequest(req)), this.ignoreNanos ? CREATED_AT : CREATED_AT_WITH_NANOS);
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            element$iv$iv = iterator.next();
            document = (Document)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = document.getString((Object)"src_addr") + ":" + document.getString((Object)"dst_addr") + ":" + document.getString((Object)"raw_data");
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$flatMap$iv = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            list$iv$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            List documents = (List)list$iv$iv.getValue();
            list$iv$iv = this.showRetransmits ? documents : CollectionsKt.listOf((Object)CollectionsKt.first((List)documents));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            boolean parsed;
            Object it;
            Document document2;
            list$iv$iv = (Document)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Document $this$content_u24lambda_u2413_u24lambda_u2412 = document2 = new Document();
            boolean bl3 = false;
            $this$content_u24lambda_u2413_u24lambda_u2412.put("created_at", (Object)document.getLong((Object)"created_at"));
            $this$content_u24lambda_u2413_u24lambda_u2412.put("src_addr", (Object)document.getString((Object)"src_addr"));
            $this$content_u24lambda_u2413_u24lambda_u2412.put("src_port", (Object)document.getInteger((Object)"src_port"));
            Object object2 = value$iv$iv$iv = document.getString((Object)"src_host");
            if (object2 != null) {
                Intrinsics.checkNotNullExpressionValue(object2, (String)"getString(\"src_host\")");
                it = value$iv$iv$iv;
                boolean bl4 = false;
                $this$content_u24lambda_u2413_u24lambda_u2412.put("src_host", it);
            }
            $this$content_u24lambda_u2413_u24lambda_u2412.put("dst_addr", (Object)document.getString((Object)"dst_addr"));
            $this$content_u24lambda_u2413_u24lambda_u2412.put("dst_port", (Object)document.getInteger((Object)"dst_port"));
            Object object3 = value$iv$iv$iv = document.getString((Object)"dst_host");
            if (object3 != null) {
                Intrinsics.checkNotNullExpressionValue(object3, (String)"getString(\"dst_host\")");
                it = value$iv$iv$iv;
                boolean bl5 = false;
                $this$content_u24lambda_u2413_u24lambda_u2412.put("dst_host", it);
            }
            String rawData = document.getString((Object)"raw_data");
            boolean bl6 = parsed = !Intrinsics.areEqual((Object)document.getBoolean((Object)"parsed"), (Object)false);
            if (parsed) {
                try {
                    StringMsgParser stringMsgParser = new StringMsgParser();
                    Intrinsics.checkNotNullExpressionValue((Object)rawData, (String)"rawData");
                    byte[] byArray = rawData.getBytes(Charsets.ISO_8859_1);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    Object object4 = it = stringMsgParser.parseSIPMessage(byArray, true, false, null);
                    if (object4 != null) {
                        Intrinsics.checkNotNullExpressionValue(object4, (String)"parseSIPMessage(rawData.\u202659_1), true, false, null)");
                        Object message = it;
                        boolean bl7 = false;
                        $this$content_u24lambda_u2413_u24lambda_u2412.put("transaction_id", (Object)SipMessageUtilKt.transactionId(message));
                        $this$content_u24lambda_u2413_u24lambda_u2412.putAll(this.extendedParamsFrom((SIPMessage)message));
                    }
                }
                catch (Exception e) {
                    this.logger.error("StringMsgParser 'parseSIPMessage()' failed.", (Throwable)e);
                }
            }
            $this$content_u24lambda_u2413_u24lambda_u2412.put("parsed", (Object)parsed);
            $this$content_u24lambda_u2413_u24lambda_u2412.putIfAbsent((Object)"raw_data", (Object)rawData);
            object.add(document2);
        }
        List messages = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public ByteArrayOutputStream pcap(@NotNull SessionRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Closeable closeable = (Closeable)PcapOutputStream.create((PcapGlobalHeader)PcapGlobalHeader.createDefaultHeader(), (OutputStream)os);
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            PcapOutputStream pos = (PcapOutputStream)closeable;
            boolean bl = false;
            Sequence sequence = new Sequence[]{this.findInRawBySessionRequest(req), this.findRecInRawBySessionRequest(req)};
            sequence = SequencesKt.sortedWith((Sequence)SequencesKt.asSequence(IteratorUtil.INSTANCE.merge(sequence)), this.ignoreNanos ? CREATED_AT : CREATED_AT_WITH_NANOS);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                byte[] raw;
                Document document = (Document)element$iv;
                boolean bl2 = false;
                String string = document.getString((Object)"raw_data");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getString(\"raw_data\")");
                Intrinsics.checkNotNullExpressionValue((Object)string.getBytes(Charsets.ISO_8859_1), (String)"this as java.lang.String).getBytes(charset)");
                TransportPacketFactory transportPacketFactory = PacketFactory.getInstance().getTransportFactory();
                Long l = document.getLong((Object)"created_at");
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"document.getLong(\"created_at\")");
                UDPPacket packet = transportPacketFactory.createUDP(((Number)l).longValue(), Buffers.wrap((byte[])raw));
                packet.setDestinationIP(document.getString((Object)"dst_addr"));
                packet.setSourceIP(document.getString((Object)"src_addr"));
                Integer n = document.getInteger((Object)"dst_port");
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"document.getInteger(\"dst_port\")");
                packet.setDestinationPort(((Number)n).intValue());
                Integer n2 = document.getInteger((Object)"src_port");
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"document.getInteger(\"src_port\")");
                packet.setSourcePort(((Number)n2).intValue());
                packet.reCalculateChecksum();
                pos.write((Packet)packet);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return os;
    }

    public void stash(@NotNull SessionRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        throw new UnsupportedOperationException("Stash is not supported in CE version");
    }

    @NotNull
    public Iterator<Document> findRecInRawBySessionRequest(@NotNull SessionRequest req) {
        List list;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        if (req.getCreatedAt() == null) {
            boolean $i$a$-requireNotNull-SessionService$findRecInRawBySessionRequest$42 = false;
            String $i$a$-requireNotNull-SessionService$findRecInRawBySessionRequest$42 = "created_at";
            throw new IllegalArgumentException($i$a$-requireNotNull-SessionService$findRecInRawBySessionRequest$42.toString());
        }
        if (req.getTerminatedAt() == null) {
            boolean $i$a$-requireNotNull-SessionService$findRecInRawBySessionRequest$52 = false;
            String $i$a$-requireNotNull-SessionService$findRecInRawBySessionRequest$52 = "terminated_at";
            throw new IllegalArgumentException($i$a$-requireNotNull-SessionService$findRecInRawBySessionRequest$52.toString());
        }
        if (req.getCallId() == null) {
            boolean bl = false;
            String string = "call_id";
            throw new IllegalArgumentException(string.toString());
        }
        List $this$findRecInRawBySessionRequest_u24lambda_u2419 = list = (List)new ArrayList();
        boolean bl = false;
        Long l = req.getCreatedAt();
        Intrinsics.checkNotNull((Object)l);
        Bson bson = Filters.gte((String)"created_at", (Object)l);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"gte(\"created_at\", req.createdAt!!)");
        $this$findRecInRawBySessionRequest_u24lambda_u2419.add(bson);
        Long l2 = req.getTerminatedAt();
        Intrinsics.checkNotNull((Object)l2);
        Bson bson2 = Filters.lte((String)"created_at", (Object)(l2 + this.terminationTimeout));
        Intrinsics.checkNotNullExpressionValue((Object)bson2, (String)"lte(\"created_at\", req.te\u2026t!! + terminationTimeout)");
        $this$findRecInRawBySessionRequest_u24lambda_u2419.add(bson2);
        List<String> list2 = req.getCallId();
        Intrinsics.checkNotNull(list2);
        Bson bson3 = Filters.in((String)"call_id", (Iterable)list2);
        Intrinsics.checkNotNullExpressionValue((Object)bson3, (String)"`in`(\"call_id\", req.callId!!)");
        $this$findRecInRawBySessionRequest_u24lambda_u2419.add(bson3);
        if (req.getSrcAddr() != null && req.getDstAddr() != null) {
            List<String> list3 = req.getSrcAddr();
            Intrinsics.checkNotNull(list3);
            List<String> list4 = req.getDstAddr();
            Intrinsics.checkNotNull(list4);
            $this$findRecInRawBySessionRequest_u24lambda_u2419.add(this.legFilter(list3, list4));
        }
        List filters2 = list;
        MongoClient mongoClient = this.getMongoClient();
        Long l3 = req.getCreatedAt();
        Intrinsics.checkNotNull((Object)l3);
        Long l4 = req.getTerminatedAt();
        Intrinsics.checkNotNull((Object)l4);
        Pair pair = new Pair((Object)l3, (Object)(l4 + this.terminationTimeout));
        Bson bson4 = Filters.and((Iterable)filters2);
        Intrinsics.checkNotNullExpressionValue((Object)bson4, (String)"and(filters)");
        return SequencesKt.flatMapIterable((Sequence)SequencesKt.asSequence((Iterator)MongoClient.find$default(mongoClient, "rec_raw", pair, bson4, null, null, 24, null)), (Function1)findRecInRawBySessionRequest.4.INSTANCE).iterator();
    }

    @NotNull
    public Bson legFilter(@NotNull List<String> srcAddr, @NotNull List<String> dstAddr) {
        Intrinsics.checkNotNullParameter(srcAddr, (String)"srcAddr");
        Intrinsics.checkNotNullParameter(dstAddr, (String)"dstAddr");
        Iterable $this$partition$iv = srcAddr;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (this.getHostService().findByNameIgnoreCase(it) != null) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List srcHosts = (List)pair.component1();
        List srcIps = (List)pair.component2();
        Iterable $this$partition$iv2 = dstAddr;
        boolean $i$f$partition2 = false;
        ArrayList first$iv2 = new ArrayList();
        ArrayList second$iv2 = new ArrayList();
        for (Object element$iv : $this$partition$iv2) {
            String it = (String)element$iv;
            boolean bl = false;
            if (this.getHostService().findByNameIgnoreCase(it) != null) {
                first$iv2.add(element$iv);
                continue;
            }
            second$iv2.add(element$iv);
        }
        Pair pair2 = new Pair(first$iv2, second$iv2);
        List dstHosts = (List)pair2.component1();
        List dstIps = (List)pair2.component2();
        Bson[] bsonArray = new Bson[2];
        Bson[] bsonArray2 = new Bson[]{this.hostOrAddrFilter("src", srcHosts, srcIps), this.hostOrAddrFilter("dst", dstHosts, dstIps)};
        bsonArray[0] = Filters.and((Bson[])bsonArray2);
        bsonArray2 = new Bson[]{this.hostOrAddrFilter("src", dstHosts, dstIps), this.hostOrAddrFilter("dst", srcHosts, srcIps)};
        bsonArray[1] = Filters.and((Bson[])bsonArray2);
        Bson bson = Filters.or((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"or(\n            and(\n   \u2026)\n            )\n        )");
        return bson;
    }

    @NotNull
    public Bson hostOrAddrFilter(@NotNull String prefix, @NotNull List<String> hosts, @NotNull List<String> ips) {
        Bson bson;
        List list;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
        Intrinsics.checkNotNullParameter(ips, (String)"ips");
        List $this$hostOrAddrFilter_u24lambda_u2422 = list = (List)new ArrayList();
        boolean bl = false;
        if (!((Collection)hosts).isEmpty()) {
            Bson bson2 = Filters.in((String)(prefix + "_host"), (Iterable)hosts);
            Intrinsics.checkNotNullExpressionValue((Object)bson2, (String)"`in`(\"${prefix}_host\", hosts)");
            $this$hostOrAddrFilter_u24lambda_u2422.add(bson2);
        }
        if (!((Collection)ips).isEmpty()) {
            Bson bson3 = Filters.in((String)(prefix + "_addr"), (Iterable)ips);
            Intrinsics.checkNotNullExpressionValue((Object)bson3, (String)"`in`(\"${prefix}_addr\", ips)");
            $this$hostOrAddrFilter_u24lambda_u2422.add(bson3);
        }
        List filters2 = list;
        if (filters2.size() == 1) {
            bson = (Bson)CollectionsKt.first((List)filters2);
        } else {
            Bson bson4 = Filters.or((Iterable)filters2);
            bson = bson4;
            Intrinsics.checkNotNullExpressionValue((Object)bson4, (String)"{\n            or(filters)\n        }");
        }
        return bson;
    }

    @NotNull
    public Map<String, Object> extendedParamsFrom(@NotNull SIPMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return MapsKt.emptyMap();
    }

    static {
        Function1[] function1Array = new Function1[]{Companion.CREATED_AT_WITH_NANOS.1.INSTANCE, Companion.CREATED_AT_WITH_NANOS.2.INSTANCE};
        CREATED_AT_WITH_NANOS = ComparisonsKt.compareBy((Function1[])function1Array);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lio/sip3/twig/ce/service/SessionService$Companion;", "", "()V", "CREATED_AT", "Ljava/util/Comparator;", "Lorg/bson/Document;", "Lkotlin/Comparator;", "getCREATED_AT", "()Ljava/util/Comparator;", "CREATED_AT_WITH_NANOS", "getCREATED_AT_WITH_NANOS", "sip3-twig-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<Document> getCREATED_AT() {
            return CREATED_AT;
        }

        @NotNull
        public final Comparator<Document> getCREATED_AT_WITH_NANOS() {
            return CREATED_AT_WITH_NANOS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

