/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.controller;

import io.sip3.twig.ce.domain.Component;
import io.sip3.twig.ce.service.component.ComponentService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Components API", description="Components Controller")
@RestController
@RequestMapping(value={"/management/components"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\bH\u0007J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\r\u001a\u00020\f2\b\b\u0001\u0010\n\u001a\u00020\bH\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0007J\u0012\u0010\u0011\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\u0012\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\bH\u0007J*\u0010\u0013\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0016\b\u0001\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015H\u0007J*\u0010\u0016\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\b2\u0016\b\u0001\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015H\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/sip3/twig/ce/controller/ComponentController;", "", "()V", "componentService", "Lio/sip3/twig/ce/service/component/ComponentService;", "deleteByDeploymentId", "", "deploymentId", "", "deleteByName", "name", "getByDeploymentId", "Lio/sip3/twig/ce/domain/Component;", "getRegisteredByName", "listRegistered", "", "listWithExpired", "mediaRecordingReset", "mediaRecordingResetByName", "sendShutdown", "payload", "", "sendShutdownByName", "sip3-twig-ce"})
public final class ComponentController {
    @Autowired
    private ComponentService componentService;

    @Operation(summary="List components ")
    @ApiResponses(value={@ApiResponse(description="Returns components", responseCode="200"), @ApiResponse(description="InternalServerError", responseCode="500", content={@Content(mediaType="application/json")}), @ApiResponse(description="ConnectionTimeoutError", responseCode="504", content={@Content(mediaType="application/json")})})
    @GetMapping(produces={"application/json"})
    @NotNull
    public final List<Component> listWithExpired() {
        ComponentService componentService = this.componentService;
        if (componentService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
            componentService = null;
        }
        return componentService.list();
    }

    @Operation(summary="List latest components")
    @ApiResponses(value={@ApiResponse(description="Returns registered components only", responseCode="200"), @ApiResponse(description="InternalServerError", responseCode="500", content={@Content(mediaType="application/json")}), @ApiResponse(description="ConnectionTimeoutError", responseCode="504", content={@Content(mediaType="application/json")})})
    @GetMapping(path={"/latest"}, produces={"application/json"})
    @NotNull
    public final List<Component> listRegistered() {
        ComponentService componentService = this.componentService;
        if (componentService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
            componentService = null;
        }
        return componentService.listLatest();
    }

    @Operation(summary="Get component by Deployment ID")
    @ApiResponses(value={@ApiResponse(description="Returns component by Deployment ID", responseCode="200"), @ApiResponse(description="Component not found", responseCode="404", content={@Content(mediaType="application/json")}), @ApiResponse(description="InternalServerError", responseCode="500", content={@Content(mediaType="application/json")}), @ApiResponse(description="ConnectionTimeoutError", responseCode="504", content={@Content(mediaType="application/json")})})
    @GetMapping(path={"/{deploymentId}"}, produces={"application/json"})
    @NotNull
    public final Component getByDeploymentId(@PathVariable(value="deploymentId") @NotNull String deploymentId) {
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        ComponentService componentService = this.componentService;
        if (componentService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
            componentService = null;
        }
        return componentService.getByDeploymentId(deploymentId);
    }

    @Operation(summary="Get component by name")
    @ApiResponses(value={@ApiResponse(description="Returns component by name", responseCode="200"), @ApiResponse(description="InternalServerError", responseCode="500", content={@Content(mediaType="application/json")}), @ApiResponse(description="ConnectionTimeoutError", responseCode="504", content={@Content(mediaType="application/json")})})
    @GetMapping(path={"/name/{name}"}, produces={"application/json"})
    @NotNull
    public final Component getRegisteredByName(@PathVariable(value="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ComponentService componentService = this.componentService;
        if (componentService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
            componentService = null;
        }
        return componentService.getByNameIgnoreCase(name);
    }

    @Operation(summary="Send Media Recording Reset command to component")
    @ApiResponses(value={@ApiResponse(description="Media Recording Reset command sent", responseCode="204"), @ApiResponse(description="Component not found", responseCode="404", content={@Content(mediaType="application/json")}), @ApiResponse(description="InternalServerError", responseCode="500", content={@Content(mediaType="application/json")}), @ApiResponse(description="ConnectionTimeoutError", responseCode="504", content={@Content(mediaType="application/json")})})
    @PutMapping(path={"/{deploymentId}/recording-reset"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public final void mediaRecordingReset(@PathVariable(value="deploymentId") @NotNull String deploymentId) {
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        ComponentService componentService = this.componentService;
        if (componentService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
            componentService = null;
        }
        componentService.mediaRecordingReset(deploymentId);
    }

    @Operation(summary="Send Media Recording Reset command to component by Name")
    @ApiResponses(value={@ApiResponse(description="Media Recording Reset command sent", responseCode="204"), @ApiResponse(description="Component not found", responseCode="404", content={@Content(mediaType="application/json")}), @ApiResponse(description="InternalServerError", responseCode="500", content={@Content(mediaType="application/json")}), @ApiResponse(description="ConnectionTimeoutError", responseCode="504", content={@Content(mediaType="application/json")})})
    @PutMapping(path={"/name/{name}/recording-reset"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public final void mediaRecordingResetByName(@PathVariable(value="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ComponentService componentService = this.componentService;
        if (componentService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
            componentService = null;
        }
        componentService.mediaRecordingResetByName(name);
    }

    @Operation(summary="Send Shutdown command to component")
    @ApiResponses(value={@ApiResponse(description="Shutdown command sent", responseCode="204"), @ApiResponse(description="Component not found", responseCode="404", content={@Content(mediaType="application/json")}), @ApiResponse(description="InternalServerError", responseCode="500", content={@Content(mediaType="application/json")}), @ApiResponse(description="ConnectionTimeoutError", responseCode="504", content={@Content(mediaType="application/json")})})
    @PutMapping(path={"/{deploymentId}/shutdown"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public final void sendShutdown(@PathVariable(value="deploymentId") @NotNull String deploymentId, @RequestBody @Nullable Map<String, ? extends Object> payload) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        ComponentService componentService = this.componentService;
        if (componentService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
            componentService = null;
        }
        if ((map2 = payload) == null) {
            map2 = MapsKt.emptyMap();
        }
        componentService.shutdown(deploymentId, map2);
    }

    @Operation(summary="Send Shutdown command to component by Name")
    @ApiResponses(value={@ApiResponse(description="Shutdown command sent", responseCode="204"), @ApiResponse(description="Component not found", responseCode="404", content={@Content(mediaType="application/json")}), @ApiResponse(description="InternalServerError", responseCode="500", content={@Content(mediaType="application/json")}), @ApiResponse(description="ConnectionTimeoutError", responseCode="504", content={@Content(mediaType="application/json")})})
    @PutMapping(path={"/name/{name}/shutdown"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public final void sendShutdownByName(@PathVariable(value="name") @NotNull String name, @RequestBody @Nullable Map<String, ? extends Object> payload) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ComponentService componentService = this.componentService;
        if (componentService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
            componentService = null;
        }
        if ((map2 = payload) == null) {
            map2 = MapsKt.emptyMap();
        }
        componentService.shutdownByName(name, map2);
    }

    @Operation(summary="Delete component by Deployment ID")
    @ApiResponses(value={@ApiResponse(description="Component removed", responseCode="204"), @ApiResponse(description="Component not found", responseCode="404", content={@Content(mediaType="application/json")}), @ApiResponse(description="InternalServerError", responseCode="500", content={@Content(mediaType="application/json")}), @ApiResponse(description="ConnectionTimeoutError", responseCode="504", content={@Content(mediaType="application/json")})})
    @DeleteMapping(path={"/{deploymentId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public final void deleteByDeploymentId(@PathVariable(value="deploymentId") @NotNull String deploymentId) {
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        ComponentService componentService = this.componentService;
        if (componentService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
            componentService = null;
        }
        componentService.deleteByDeploymentId(deploymentId);
    }

    @Operation(summary="Delete component by name")
    @ApiResponses(value={@ApiResponse(description="Component removed", responseCode="204"), @ApiResponse(description="Component not found", responseCode="404", content={@Content(mediaType="application/json")}), @ApiResponse(description="InternalServerError", responseCode="500", content={@Content(mediaType="application/json")}), @ApiResponse(description="ConnectionTimeoutError", responseCode="504", content={@Content(mediaType="application/json")})})
    @DeleteMapping(path={"/name/{name}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public final void deleteByName(@PathVariable(value="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ComponentService componentService = this.componentService;
        if (componentService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"componentService");
            componentService = null;
        }
        componentService.deleteByName(name);
    }
}

