/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.sip3.commons.vertx.annotations.ConditionalOnProperty;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.server.AbstractServer;
import io.sip3.salto.ce.server.TcpServer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.parsetools.RecordParser;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConditionalOnProperty(pointer="/server", matcher=".*: ?\"?tcp://.*")
@Instance(worker=true)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/sip3/salto/ce/server/TcpServer;", "Lio/sip3/salto/ce/server/AbstractServer;", "()V", "bufferSize", "", "Ljava/lang/Integer;", "delimiter", "", "logger", "Lmu/KLogger;", "uri", "Ljava/net/URI;", "readConfig", "", "startServer", "tcpConnectionOptions", "Lio/vertx/core/net/NetServerOptions;", "sip3-salto-ce"})
public class TcpServer
extends AbstractServer {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private URI uri;
    @Nullable
    private Integer bufferSize;
    @NotNull
    private String delimiter = "\r\n\r\n3PIS\r\n\r\n";

    @Override
    public void readConfig() {
        block4: {
            JsonObject jsonObject;
            Object object;
            JsonObject jsonObject2 = this.config().getJsonObject("server");
            if (jsonObject2 == null) break block4;
            JsonObject server = jsonObject2;
            boolean bl = false;
            JsonObject jsonObject3 = object = server.getJsonObject("tcp");
            if (jsonObject3 == null) {
                jsonObject = server;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"server.getJsonObject(\"tcp\") ?: server");
                jsonObject = object;
            }
            JsonObject config = jsonObject;
            Object object2 = object = config.getString("uri");
            if (object2 == null) {
                throw new IllegalArgumentException("uri");
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"config.getString(\"uri\") \u2026lArgumentException(\"uri\")");
            this.uri = new URI((String)object);
            this.bufferSize = config.getInteger("buffer_size");
            Object object3 = object = config.getString("delimiter");
            if (object3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getString(\"delimiter\")");
                Object it = object;
                boolean bl2 = false;
                this.delimiter = it;
            }
        }
    }

    @Override
    public void startServer() {
        NetServerOptions options = this.tcpConnectionOptions();
        NetServer netServer = this.vertx.createNetServer(options).connectHandler(arg_0 -> TcpServer.startServer$lambda$5(this, arg_0));
        URI uRI = this.uri;
        if (uRI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
            uRI = null;
        }
        int n = uRI.getPort();
        URI uRI2 = this.uri;
        if (uRI2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
            uRI2 = null;
        }
        netServer.listen(n, uRI2.getHost()).onFailure(arg_0 -> TcpServer.startServer$lambda$6(this, arg_0)).onSuccess(arg_0 -> TcpServer.startServer$lambda$7(this, arg_0));
    }

    @NotNull
    public NetServerOptions tcpConnectionOptions() {
        NetServerOptions netServerOptions;
        block0: {
            NetServerOptions $this$tcpConnectionOptions_u24lambda_u249 = netServerOptions = new NetServerOptions();
            boolean bl = false;
            Integer n = this.bufferSize;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$tcpConnectionOptions_u24lambda_u249.setReceiveBufferSize(it);
        }
        return netServerOptions;
    }

    private static final void startServer$lambda$5$lambda$3(TcpServer this$0, Address $sender, Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sender, (String)"$sender");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            this$0.onRawPacket($sender, buffer);
        }
        catch (Exception e) {
            this$0.logger.error((Throwable)e, (Function0)startServer.1.parser.1.1.INSTANCE);
            this$0.logger.debug((Function0)new Function0<Object>($sender, buffer){
                final /* synthetic */ Address $sender;
                final /* synthetic */ Buffer $buffer;
                {
                    this.$sender = $sender;
                    this.$buffer = $buffer;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Sender: " + this.$sender + ", buffer: " + ByteBufUtil.prettyHexDump((ByteBuf)this.$buffer.getByteBuf());
                }
            });
        }
    }

    private static final void startServer$lambda$5$lambda$4(RecordParser $parser, TcpServer this$0, Address $sender, Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sender, (String)"$sender");
        try {
            $parser.handle(buffer);
        }
        catch (Exception e) {
            this$0.logger.error((Throwable)e, (Function0)startServer.1.2.1.INSTANCE);
            this$0.logger.debug((Function0)new Function0<Object>($sender, buffer){
                final /* synthetic */ Address $sender;
                final /* synthetic */ Buffer $buffer;
                {
                    this.$sender = $sender;
                    this.$buffer = $buffer;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Sender: " + this.$sender + ", buffer: " + ByteBufUtil.prettyHexDump((ByteBuf)this.$buffer.getByteBuf());
                }
            });
        }
    }

    private static final void startServer$lambda$5(TcpServer this$0, NetSocket socket) {
        Address address;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Address $this$startServer_u24lambda_u245_u24lambda_u242 = address = new Address();
        boolean bl = false;
        String string = socket.remoteAddress().host();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"socket.remoteAddress().host()");
        $this$startServer_u24lambda_u245_u24lambda_u242.setAddr(string);
        $this$startServer_u24lambda_u245_u24lambda_u242.setPort(socket.remoteAddress().port());
        Address sender = address;
        this$0.logger.debug((Function0)new Function0<Object>(sender){
            final /* synthetic */ Address $sender;
            {
                this.$sender = $sender;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "TCP connection established from " + this.$sender;
            }
        });
        RecordParser parser2 = RecordParser.newDelimited((String)this$0.delimiter, arg_0 -> TcpServer.startServer$lambda$5$lambda$3(this$0, sender, arg_0));
        socket.handler(arg_0 -> TcpServer.startServer$lambda$5$lambda$4(parser2, this$0, sender, arg_0));
    }

    private static final void startServer$lambda$6(TcpServer this$0, Throwable t) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logger.error(t, (Function0)new Function0<Object>(this$0){
            final /* synthetic */ TcpServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                URI uRI = TcpServer.access$getUri$p(this.this$0);
                if (uRI == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                    uRI = null;
                }
                return "TCP connection failed. URI: " + uRI;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
        throw t;
    }

    private static final void startServer$lambda$7(TcpServer this$0, NetServer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logger.info((Function0)new Function0<Object>(this$0){
            final /* synthetic */ TcpServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                URI uRI = TcpServer.access$getUri$p(this.this$0);
                if (uRI == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                    uRI = null;
                }
                return "Listening on " + uRI;
            }
        });
    }

    public static final /* synthetic */ URI access$getUri$p(TcpServer $this) {
        return $this.uri;
    }
}

