/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.rtpr;

import io.sip3.commons.domain.payload.RtpReportPayload;
import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.util.DateTimeFormatterUtilKt;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.attributes.AttributesRegistry;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.rtpr.RtprSession;
import io.sip3.salto.ce.rtpr.RtprSessionHandler;
import io.sip3.salto.ce.rtpr.RtprStream;
import io.sip3.salto.ce.util.AttributeUtilKt;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/sip3/salto/ce/rtpr/RtprSessionHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "attributesRegistry", "Lio/sip3/salto/ce/attributes/AttributesRegistry;", "logger", "Lmu/KLogger;", "minExpectedPackets", "", "recordIpAddressesAttributes", "", "timeSuffix", "Ljava/time/format/DateTimeFormatter;", "calculateMetrics", "", "prefix", "", "session", "Lio/sip3/salto/ce/rtpr/RtprSession;", "handle", "start", "writeAttributes", "writeToDatabase", "Companion", "sip3-salto-ce"})
public class RtprSessionHandler
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private DateTimeFormatter timeSuffix;
    private int minExpectedPackets;
    private boolean recordIpAddressesAttributes;
    private AttributesRegistry attributesRegistry;
    @NotNull
    public static final String REPORTS = "_reports";
    @NotNull
    public static final String BAD_REPORTS = "_bad-reports";
    @NotNull
    public static final String BAD_REPORTS_FRACTION = "_bad-reports-fraction";
    @NotNull
    public static final String DURATION = "_duration";

    public RtprSessionHandler() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyyMMdd\")");
        this.timeSuffix = dateTimeFormatter;
        this.minExpectedPackets = 100;
    }

    public void start() {
        Object object;
        JsonObject jsonObject;
        String string = this.config().getString("time_suffix");
        if (string != null) {
            String it = string;
            boolean bl = false;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(it);
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(it)");
            this.timeSuffix = dateTimeFormatter;
        }
        if ((jsonObject = this.config().getJsonObject("media")) != null && (jsonObject = jsonObject.getJsonObject("rtp_r")) != null) {
            Integer n;
            JsonObject config = jsonObject;
            boolean bl = false;
            Integer n2 = n = config.getInteger("min_expected_packets");
            if (n2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getInteger(\"min_expected_packets\")");
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                this.minExpectedPackets = it;
            }
        }
        if ((object = this.config().getJsonObject("attributes")) != null && (object = object.getBoolean("record_ip_addresses")) != null) {
            boolean it = (Boolean)object;
            boolean bl = false;
            this.recordIpAddressesAttributes = it;
        }
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
        JsonObject jsonObject2 = this.config();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"config()");
        this.attributesRegistry = new AttributesRegistry(vertx, jsonObject2);
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getRtpr() + "_session", arg_0 -> RtprSessionHandler.start$lambda$4(this, arg_0));
    }

    public void handle(@NotNull RtprSession session2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.writeAttributes(session2);
        byte by = session2.getSource();
        if (by == 0) {
            string = "rtpr_rtp";
        } else if (by == 1) {
            string = "rtpr_rtcp";
        } else {
            throw new IllegalArgumentException("Unsupported RtprSession source: '" + session2.getSource() + "'");
        }
        String prefix = string;
        this.writeToDatabase(prefix + "_index", session2);
        this.calculateMetrics(prefix, session2);
    }

    public void writeAttributes(@NotNull RtprSession session2) {
        String string;
        RtprStream rtprStream;
        Object it;
        Map map;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Map $this$writeAttributes_u24lambda_u2410 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        Address src = session2.getSrcAddr();
        $this$writeAttributes_u24lambda_u2410.put("src_addr", this.recordIpAddressesAttributes ? src.getAddr() : "");
        String string2 = src.getHost();
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            $this$writeAttributes_u24lambda_u2410.put("src_host", it);
        }
        Address dst = session2.getDstAddr();
        $this$writeAttributes_u24lambda_u2410.put("dst_addr", this.recordIpAddressesAttributes ? dst.getAddr() : "");
        String string3 = dst.getHost();
        if (string3 != null) {
            String it2 = string3;
            boolean bl3 = false;
            $this$writeAttributes_u24lambda_u2410.put("dst_host", it2);
        }
        if (session2.getRecorded()) {
            $this$writeAttributes_u24lambda_u2410.put("recorded", true);
        }
        if ((rtprStream = session2.getForward()) == null) {
            rtprStream = session2.getReverse();
        }
        if (rtprStream != null) {
            double it3;
            RtprStream stream2 = rtprStream;
            boolean bl4 = false;
            Double d = stream2.getMos();
            if (d != null) {
                it3 = ((Number)d).doubleValue();
                boolean bl5 = false;
                $this$writeAttributes_u24lambda_u2410.put("mos", it3);
            }
            Double d2 = stream2.getRFactor();
            if (d2 != null) {
                it3 = ((Number)d2).doubleValue();
                boolean bl6 = false;
                $this$writeAttributes_u24lambda_u2410.put("r_factor", it3);
            }
        }
        $this$writeAttributes_u24lambda_u2410.put("bad_report_fraction", session2.getBadReportFraction());
        if (session2.isOneWay()) {
            $this$writeAttributes_u24lambda_u2410.put("one_way", true);
        }
        Map attributes = map;
        Map $this$forEach$iv = AttributeUtilKt.toAttributes$default(session2.getAttributes(), null, 1, null);
        byte $i$f$forEach = 0;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            it = element$iv;
            boolean bl7 = false;
            String name = (String)it.getKey();
            Object value = it.getValue();
            attributes.put(name, value);
        }
        $i$f$forEach = session2.getSource();
        if ($i$f$forEach == 0) {
            string = "rtp";
        } else if ($i$f$forEach == 1) {
            string = "rtcp";
        } else {
            throw new IllegalArgumentException("Unsupported RtprSession source: '" + session2.getSource() + "'");
        }
        String prefix = string;
        AttributesRegistry attributesRegistry = this.attributesRegistry;
        if (attributesRegistry == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attributesRegistry");
            attributesRegistry = null;
        }
        attributesRegistry.handle(prefix, attributes);
        Iterable $this$forEach$iv2 = session2.getCodecs();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            String it4 = (String)element$iv;
            boolean bl8 = false;
            AttributesRegistry attributesRegistry2 = this.attributesRegistry;
            if (attributesRegistry2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attributesRegistry");
                attributesRegistry2 = null;
            }
            attributesRegistry2.handle(prefix, "codec", it4);
        }
    }

    public void calculateMetrics(@NotNull String prefix, @NotNull RtprSession session2) {
        String it;
        Map map;
        RtprSession rtprSession;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        RtprSession $this$calculateMetrics_u24lambda_u2417 = rtprSession = session2;
        boolean bl = false;
        Map $this$calculateMetrics_u24lambda_u2417_u24lambda_u2416 = map = AttributeUtilKt.toMetricsAttributes$default(session2.getAttributes(), null, 1, null);
        boolean bl2 = false;
        String string = $this$calculateMetrics_u24lambda_u2417.getSrcAddr().getHost();
        if (string != null) {
            it = string;
            boolean bl3 = false;
            $this$calculateMetrics_u24lambda_u2417_u24lambda_u2416.put("src_host", it);
        }
        String string2 = $this$calculateMetrics_u24lambda_u2417.getDstAddr().getHost();
        if (string2 != null) {
            it = string2;
            boolean bl4 = false;
            $this$calculateMetrics_u24lambda_u2417_u24lambda_u2416.put("dst_host", it);
        }
        String string3 = (String)CollectionsKt.firstOrNull((Iterable)$this$calculateMetrics_u24lambda_u2417.getCodecs());
        if (string3 != null) {
            it = string3;
            boolean bl5 = false;
            $this$calculateMetrics_u24lambda_u2417_u24lambda_u2416.put("codec", it);
        }
        Map attributes = map;
        Metrics.INSTANCE.summary(prefix + REPORTS, attributes).record((double)$this$calculateMetrics_u24lambda_u2417.getReportCount());
        Metrics.INSTANCE.summary(prefix + BAD_REPORTS, attributes).record((double)$this$calculateMetrics_u24lambda_u2417.getBadReportCount());
        Metrics.INSTANCE.summary(prefix + BAD_REPORTS_FRACTION, attributes).record($this$calculateMetrics_u24lambda_u2417.getBadReportFraction());
        Metrics.INSTANCE.timer(prefix + DURATION, attributes).record($this$calculateMetrics_u24lambda_u2417.getDuration(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToDatabase(@NotNull String prefix, @NotNull RtprSession session2) {
        void $this$forEach$iv;
        void $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2438;
        RtpReportPayload it;
        Collection<Integer> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2433;
        RtpReportPayload it2;
        Collection<Double> collection2;
        Iterable $this$mapTo$iv$iv2;
        Object $this$map$iv2;
        RtprStream rtprStream;
        RtprStream it3;
        Object it4;
        void $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441;
        JsonObject jsonObject;
        JsonObject jsonObject2;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        String collection3 = prefix + "_" + DateTimeFormatterUtilKt.format((DateTimeFormatter)this.timeSuffix, (long)session2.getCreatedAt());
        JsonObject $this$writeToDatabase_u24lambda_u2442 = jsonObject2 = new JsonObject();
        boolean bl = false;
        JsonObject jsonObject3 = jsonObject = new JsonObject();
        String string = "document";
        JsonObject jsonObject4 = $this$writeToDatabase_u24lambda_u2442;
        boolean bl2 = false;
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("created_at", (Object)session2.getCreatedAt());
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("terminated_at", (Object)session2.getTerminatedAt());
        Address src = session2.getSrcAddr();
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("src_addr", (Object)src.getAddr());
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("src_port", (Object)src.getPort());
        String string2 = src.getHost();
        if (string2 != null) {
            it4 = string2;
            boolean bl3 = false;
            v1 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("src_host", it4);
        } else {
            v1 = null;
        }
        Address dst = session2.getDstAddr();
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("dst_addr", (Object)dst.getAddr());
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("dst_port", (Object)dst.getPort());
        String string3 = dst.getHost();
        if (string3 != null) {
            String it5 = string3;
            boolean bl4 = false;
            v3 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("dst_host", (Object)it5);
        } else {
            v3 = null;
        }
        if (session2.getRecorded()) {
            $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("recorded", (Object)true);
        }
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("call_id", (Object)session2.getMediaControl().getCallId());
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("caller", (Object)session2.getMediaControl().getCaller());
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("callee", (Object)session2.getMediaControl().getCallee());
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("duration", (Object)session2.getDuration());
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("report_count", (Object)session2.getReportCount());
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("bad_report_count", (Object)session2.getBadReportCount());
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("bad_report_fraction", (Object)session2.getBadReportFraction());
        if (session2.isOneWay()) {
            $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("one_way", (Object)true);
        }
        Object $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2420 = it4 = (List)new ArrayList();
        boolean bl5 = false;
        if (session2.getForward() != null) {
            $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2420.add("out");
        }
        if (session2.getReverse() != null) {
            $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2420.add("in");
        }
        Object directions = it4;
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put("direction", directions);
        Object $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2423 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2420 = (List)new ArrayList();
        boolean $i$a$-apply-RtprSessionHandler$writeToDatabase$operation$1$1$reports$22 = false;
        RtprStream rtprStream2 = session2.getForward();
        if (rtprStream2 != null && (rtprStream2 = rtprStream2.getReport()) != null) {
            it3 = rtprStream2;
            boolean bl6 = false;
            v5 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2423.add(it3);
        } else {
            v5 = null;
        }
        if ((rtprStream = session2.getReverse()) != null && (rtprStream = rtprStream.getReport()) != null) {
            it3 = rtprStream;
            boolean bl7 = false;
            $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2423.add(it3);
            v7 = Unit.INSTANCE;
        } else {
            v7 = null;
        }
        Object reports = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2420;
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2420 = (Iterable)reports;
        String string4 = "mos";
        void var23_34 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441;
        boolean $i$f$map = false;
        void $i$a$-apply-RtprSessionHandler$writeToDatabase$operation$1$1$reports$22 = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            RtpReportPayload rtpReportPayload = (RtpReportPayload)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl8 = false;
            collection2.add(Double.valueOf(it2.getMos()));
        }
        collection2 = (List)destination$iv$iv;
        var23_34.put(string4, (Object)collection2);
        $this$map$iv2 = (Iterable)reports;
        string4 = "r_factor";
        var23_34 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it2 = (RtpReportPayload)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl9 = false;
            collection2.add(Double.valueOf(it2.getRFactor()));
        }
        collection2 = (List)destination$iv$iv;
        var23_34.put(string4, collection2);
        $this$map$iv2 = (Iterable)reports;
        string4 = "payload_type";
        var23_34 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it2 = (RtpReportPayload)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl10 = false;
            collection2.add((Double)((Object)Integer.valueOf(it2.getPayloadType())));
        }
        collection2 = (List)destination$iv$iv;
        var23_34.put(string4, collection2);
        $this$map$iv2 = (Iterable)reports;
        string4 = "codec";
        var23_34 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it2 = (RtpReportPayload)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl11 = false;
            Object object = it2.getCodecName();
            if (object == null) {
                object = "UNDEFINED(" + it2.getPayloadType() + ")";
            }
            collection2.add((Double)object);
        }
        collection2 = (List)destination$iv$iv;
        var23_34.put(string4, collection2);
        $this$map$iv2 = (Iterable)reports;
        string4 = "ssrc";
        var23_34 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it2 = (RtpReportPayload)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl12 = false;
            collection2.add((Double)it2.getSsrc());
        }
        collection2 = (List)destination$iv$iv;
        var23_34.put(string4, collection2);
        $this$map$iv2 = new JsonObject();
        Iterable $i$f$map2 = $this$map$iv2;
        string4 = "packets";
        var23_34 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441;
        boolean bl13 = false;
        destination$iv$iv = (Iterable)reports;
        String $i$f$mapTo2 = "expected";
        Iterator iterator = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2433;
        boolean $i$f$map3 = false;
        it2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RtpReportPayload rtpReportPayload = (RtpReportPayload)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl14 = false;
            collection.add(it.getExpectedPacketCount());
        }
        collection = (List)destination$iv$iv2;
        iterator.put($i$f$mapTo2, collection);
        $this$map$iv = (Iterable)reports;
        $i$f$mapTo2 = "received";
        iterator = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2433;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RtpReportPayload)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl15 = false;
            collection.add(it.getReceivedPacketCount());
        }
        collection = (List)destination$iv$iv2;
        iterator.put($i$f$mapTo2, collection);
        $this$map$iv = (Iterable)reports;
        $i$f$mapTo2 = "lost";
        iterator = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2433;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RtpReportPayload)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl16 = false;
            collection.add(it.getLostPacketCount());
        }
        collection = (List)destination$iv$iv2;
        iterator.put($i$f$mapTo2, collection);
        $this$map$iv = (Iterable)reports;
        $i$f$mapTo2 = "rejected";
        iterator = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2433;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RtpReportPayload)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl17 = false;
            collection.add(it.getRejectedPacketCount());
        }
        collection = (List)destination$iv$iv2;
        iterator.put($i$f$mapTo2, collection);
        collection2 = Unit.INSTANCE;
        var23_34.put(string4, $this$map$iv2);
        $this$map$iv2 = new JsonObject();
        $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2433 = $this$map$iv2;
        string4 = "jitter";
        var23_34 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441;
        boolean $i$a$-apply-RtprSessionHandler$writeToDatabase$operation$1$1$102 = false;
        $this$map$iv = (Iterable)reports;
        $i$f$mapTo2 = "last";
        iterator = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2438;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RtpReportPayload)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl18 = false;
            collection.add((Integer)((Object)Double.valueOf(it.getLastJitter())));
        }
        collection = (List)destination$iv$iv2;
        iterator.put($i$f$mapTo2, collection);
        $this$map$iv = (Iterable)reports;
        $i$f$mapTo2 = "avg";
        iterator = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2438;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RtpReportPayload)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl19 = false;
            collection.add((Integer)((Object)Double.valueOf(it.getAvgJitter())));
        }
        collection = (List)destination$iv$iv2;
        iterator.put($i$f$mapTo2, collection);
        $this$map$iv = (Iterable)reports;
        $i$f$mapTo2 = "min";
        iterator = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2438;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RtpReportPayload)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl20 = false;
            collection.add((Integer)((Object)Double.valueOf(it.getMinJitter())));
        }
        collection = (List)destination$iv$iv2;
        iterator.put($i$f$mapTo2, collection);
        $this$map$iv = (Iterable)reports;
        $i$f$mapTo2 = "max";
        iterator = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441_u24lambda_u2438;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RtpReportPayload)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl21 = false;
            collection.add((Integer)((Object)Double.valueOf(it.getMaxJitter())));
        }
        collection = (List)destination$iv$iv2;
        iterator.put($i$f$mapTo2, collection);
        collection2 = Unit.INSTANCE;
        var23_34.put(string4, $this$map$iv2);
        $this$map$iv2 = (Iterable)reports;
        string4 = "fraction_lost";
        var23_34 = $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441;
        $i$f$map = false;
        Iterable $i$a$-apply-RtprSessionHandler$writeToDatabase$operation$1$1$102 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            $this$mapTo$iv$iv = (RtpReportPayload)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl22 = false;
            collection2.add(Double.valueOf(it2.getFractionLost()));
        }
        collection2 = (List)destination$iv$iv;
        var23_34.put(string4, collection2);
        $this$map$iv2 = AttributeUtilKt.toAttributes$default(session2.getAttributes(), null, 1, null);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl23 = false;
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            $this$writeToDatabase_u24lambda_u2442_u24lambda_u2441.put(name, value);
        }
        Unit unit = Unit.INSTANCE;
        jsonObject4.put(string, (Object)jsonObject);
        JsonObject operation = jsonObject2;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
        EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getMongo_bulk_writer(), (Object)new Pair((Object)collection3, (Object)operation), null, (int)4, null);
    }

    private static final void start$lambda$4(RtprSessionHandler this$0, Message event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            RtprSession rtprSession = (RtprSession)event.body();
            Intrinsics.checkNotNullExpressionValue((Object)rtprSession, (String)"rtprSession");
            this$0.handle(rtprSession);
        }
        catch (Exception e) {
            this$0.logger.error((Throwable)e, (Function0)start.4.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/sip3/salto/ce/rtpr/RtprSessionHandler$Companion;", "", "()V", "BAD_REPORTS", "", "BAD_REPORTS_FRACTION", "DURATION", "REPORTS", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

