/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.management.host;

import io.sip3.salto.ce.management.host.HostRegistry;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.kotlin.ext.mongo.UpdateOptionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.commons.net.util.SubnetUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u0004J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nJ\b\u0010 \u001a\u00020\u0017H\u0002J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\nJ\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\u0006\u0010$\u001a\u00020\nJ\b\u0010&\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/sip3/salto/ce/management/host/HostRegistry;", "", "()V", "HOST_COLLECTION", "", "checkPeriod", "", "client", "Lio/vertx/ext/mongo/MongoClient;", "config", "Lio/vertx/core/json/JsonObject;", "features", "", "", "hosts", "logger", "Lmu/KLogger;", "mappings", "periodicTask", "Ljava/lang/Long;", "vertx", "Lio/vertx/core/Vertx;", "destroy", "", "getAddrMapping", "addr", "getFeatures", "name", "getHostName", "port", "", "getInstance", "init", "save", "Lio/vertx/core/Future;", "Lio/vertx/ext/mongo/MongoClientUpdateResult;", "host", "saveAndRemoveDuplicates", "updateHosts", "sip3-salto-ce"})
public final class HostRegistry {
    @NotNull
    public static final HostRegistry INSTANCE = new HostRegistry();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final String HOST_COLLECTION = "hosts";
    private static long checkPeriod = 30000L;
    @Nullable
    private static Vertx vertx;
    private static JsonObject config;
    private static MongoClient client;
    @Nullable
    private static Long periodicTask;
    @NotNull
    private static Map<String, String> hosts;
    @NotNull
    private static Map<String, String> mappings;
    @NotNull
    private static Map<String, ? extends Set<String>> features;

    private HostRegistry() {
    }

    @NotNull
    public final synchronized HostRegistry getInstance(@NotNull Vertx vertx, @NotNull JsonObject config) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (HostRegistry.vertx == null) {
            HostRegistry.vertx = vertx;
            HostRegistry.config = config;
            this.init();
        }
        return this;
    }

    public final synchronized void destroy() {
        Long l = periodicTask;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            Vertx vertx = HostRegistry.vertx;
            if (vertx != null) {
                vertx.cancelTimer(it);
            }
        }
        vertx = null;
        periodicTask = null;
        MongoClient mongoClient = client;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            mongoClient = null;
        }
        mongoClient.close();
    }

    private final void init() {
        JsonObject jsonObject;
        Object object;
        JsonObject jsonObject2 = config;
        if (jsonObject2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            jsonObject2 = null;
        }
        if ((object = jsonObject2.getJsonObject(HOST_COLLECTION)) != null && (object = object.getLong("check_period")) != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            checkPeriod = it;
        }
        if ((jsonObject = config) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            jsonObject = null;
        }
        JsonObject it = jsonObject.getJsonObject("mongo");
        boolean bl = false;
        Vertx vertx = HostRegistry.vertx;
        Intrinsics.checkNotNull((Object)vertx);
        JsonObject jsonObject3 = it.getJsonObject("management");
        if (jsonObject3 == null) {
            jsonObject3 = it;
        }
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"it.getJsonObject(\"management\") ?: it");
        client = io.sip3.commons.mongo.MongoClient.INSTANCE.createShared(vertx, jsonObject3);
        Vertx vertx2 = HostRegistry.vertx;
        Intrinsics.checkNotNull((Object)vertx2);
        periodicTask = vertx2.setPeriodic(0L, checkPeriod, HostRegistry::init$lambda$3);
    }

    @Nullable
    public final String getHostName(@NotNull String addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        return hosts.get(addr);
    }

    @Nullable
    public final String getHostName(@NotNull String addr, int port) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        String string = hosts.get(addr);
        if (string == null) {
            string = hosts.get(addr + ":" + port);
        }
        return string;
    }

    @Nullable
    public final String getAddrMapping(@NotNull String addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        return mappings.get(addr);
    }

    @Nullable
    public final Set<String> getFeatures(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return features.get(name);
    }

    @NotNull
    public final Future<MongoClientUpdateResult> save(@NotNull JsonObject host) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        JsonObject $this$save_u24lambda_u244 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$save_u24lambda_u244.put("name", (Object)host.getString("name"));
        JsonObject query = jsonObject;
        MongoClient mongoClient = client;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            mongoClient = null;
        }
        Future future = mongoClient.replaceDocumentsWithOptions(HOST_COLLECTION, query, host, UpdateOptionsKt.updateOptionsOf$default(null, null, null, null, null, null, (Boolean)true, null, (int)191, null)).onFailure(HostRegistry::save$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"client.replaceDocumentsW\u2026 failed.\" }\n            }");
        return future;
    }

    @NotNull
    public final Future<Long> saveAndRemoveDuplicates(@NotNull JsonObject host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Promise promise = Promise.promise();
        this.save(host).onFailure(arg_0 -> HostRegistry.saveAndRemoveDuplicates$lambda$6(promise, arg_0)).onSuccess(arg_0 -> HostRegistry.saveAndRemoveDuplicates$lambda$15(host, promise, arg_0));
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
        return future;
    }

    private final void updateHosts() {
        MongoClient mongoClient = client;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            mongoClient = null;
        }
        mongoClient.find(HOST_COLLECTION, new JsonObject()).onFailure(HostRegistry::updateHosts$lambda$16).onSuccess(HostRegistry::updateHosts$lambda$26);
    }

    private static final void init$lambda$3(Long it) {
        INSTANCE.updateHosts();
    }

    private static final void save$lambda$5(Throwable t) {
        logger.error(t, (Function0)save.1.1.INSTANCE);
    }

    private static final void saveAndRemoveDuplicates$lambda$6(Promise $promise, Throwable t) {
        logger.error(t, (Function0)saveAndRemoveDuplicates.1.1.INSTANCE);
        $promise.fail(t);
    }

    private static final void saveAndRemoveDuplicates$lambda$15$lambda$13(Promise $promise, Throwable t) {
        logger.error(t, (Function0)saveAndRemoveDuplicates.2.1.1.INSTANCE);
        $promise.fail(t);
    }

    private static final void saveAndRemoveDuplicates$lambda$15$lambda$14(Promise $promise, MongoClientDeleteResult result) {
        logger.trace((Function0)new Function0<Object>(result){
            final /* synthetic */ MongoClientDeleteResult $result;
            {
                this.$result = $result;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                MongoClientDeleteResult mongoClientDeleteResult = this.$result;
                return "Duplicates removed: " + (mongoClientDeleteResult != null ? Long.valueOf(mongoClientDeleteResult.getRemovedCount()) : null);
            }
        });
        MongoClientDeleteResult mongoClientDeleteResult = result;
        $promise.complete((Object)(mongoClientDeleteResult != null ? Long.valueOf(mongoClientDeleteResult.getRemovedCount()) : null));
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveAndRemoveDuplicates$lambda$15(JsonObject $host, Promise $promise, MongoClientUpdateResult mongoClientUpdateResult) {
        void $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249;
        void $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
        JsonObject $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411_u24lambda_u248_u24lambda_u247;
        JsonObject $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411_u24lambda_u248;
        JsonObject jsonObject;
        void $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411;
        JsonObject jsonObject2;
        JsonArray jsonArray;
        JsonObject jsonObject3;
        Intrinsics.checkNotNullParameter((Object)$host, (String)"$host");
        JsonObject $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412 = jsonObject3 = new JsonObject();
        boolean bl = false;
        JsonArray jsonArray2 = jsonArray = new JsonArray();
        String string = "$and";
        JsonObject jsonObject4 = $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412;
        boolean bl2 = false;
        JsonObject jsonObject5 = jsonObject2 = new JsonObject();
        void var14_13 = $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411;
        boolean bl3 = false;
        JsonObject jsonObject6 = jsonObject = new JsonObject();
        String string2 = "name";
        void var19_18 = $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411_u24lambda_u248;
        boolean bl4 = false;
        $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411_u24lambda_u248_u24lambda_u247.put("$ne", (Object)$host.getString("name"));
        Unit unit = Unit.INSTANCE;
        var19_18.put(string2, (Object)jsonObject);
        var14_13.add((Object)jsonObject2);
        $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411_u24lambda_u248 = jsonObject2 = new JsonObject();
        var14_13 = $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411;
        boolean bl5 = false;
        $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411_u24lambda_u248_u24lambda_u247 = jsonObject = new JsonObject();
        string2 = "addr";
        var19_18 = $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
        boolean bl6 = false;
        $this$saveAndRemoveDuplicates_u24lambda_u2415_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.put("$in", (Object)$host.getJsonArray("addr"));
        unit = Unit.INSTANCE;
        var19_18.put(string2, (Object)jsonObject);
        var14_13.add((Object)jsonObject2);
        Unit unit2 = Unit.INSTANCE;
        jsonObject4.put(string, (Object)jsonArray);
        JsonObject query = jsonObject3;
        MongoClient mongoClient = client;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            mongoClient = null;
        }
        mongoClient.removeDocuments(HOST_COLLECTION, query).onFailure(arg_0 -> HostRegistry.saveAndRemoveDuplicates$lambda$15$lambda$13($promise, arg_0)).onSuccess(arg_0 -> HostRegistry.saveAndRemoveDuplicates$lambda$15$lambda$14($promise, arg_0));
    }

    private static final void updateHosts$lambda$16(Throwable it) {
        logger.error(it, (Function0)updateHosts.1.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private static final void updateHosts$lambda$26(List result) {
        Map tmpHosts = new LinkedHashMap();
        Map tmpMappings = new LinkedHashMap();
        Map tmpFeatures = new LinkedHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        Iterable $this$forEach$iv = result;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonObject host = (JsonObject)element$iv;
            boolean bl = false;
            String name = host.getString("name");
            try {
                Object element$iv2;
                Iterable $this$forEach$iv2;
                boolean $i$f$forEach2;
                Collection collection;
                Iterator iterator;
                Iterator $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Collection destination$iv$iv;
                Iterable $this$map$iv;
                boolean $i$f$map;
                Iterable iterable;
                JsonArray jsonArray = host.getJsonArray("addr");
                if (jsonArray != null) {
                    iterable = (Iterable)jsonArray;
                    $i$f$map = false;
                    void var14_15 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Object item$iv$iv;
                        Object t = item$iv$iv = iterator.next();
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)it);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$forEach2 = false;
                    $this$mapTo$iv$iv = $this$forEach$iv2.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        void $this$forEach$iv3;
                        SubnetUtils item$iv$iv;
                        element$iv2 = $this$mapTo$iv$iv.next();
                        String addr = (String)element$iv2;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                        tmpHosts.put(addr, name);
                        if (!StringsKt.contains$default((CharSequence)addr, (CharSequence)"/", (boolean)false, (int)2, null)) continue;
                        SubnetUtils $this$updateHosts_u24lambda_u2426_u24lambda_u2425_u24lambda_u2420_u24lambda_u2418 = item$iv$iv = new SubnetUtils(addr);
                        int n = 0;
                        $this$updateHosts_u24lambda_u2426_u24lambda_u2425_u24lambda_u2420_u24lambda_u2418.setInclusiveHostCount(true);
                        String[] stringArray = item$iv$iv.getInfo().getAllAddresses();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"SubnetUtils(addr).apply \u2026            .allAddresses");
                        Object[] objectArray = stringArray;
                        boolean $i$f$forEach3 = false;
                        for (void element$iv3 : $this$forEach$iv3) {
                            String it = (String)element$iv3;
                            boolean bl4 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            tmpHosts.put(it, name);
                        }
                    }
                }
                if ((jsonArray = host.getJsonArray("mapping")) != null) {
                    $this$forEach$iv2 = (Iterable)jsonArray;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    Iterator bl3 = $this$mapTo$iv$iv.iterator();
                    while (bl3.hasNext()) {
                        void it;
                        Object item$iv$iv;
                        Object $this$updateHosts_u24lambda_u2426_u24lambda_u2425_u24lambda_u2420_u24lambda_u2418 = item$iv$iv = bl3.next();
                        collection = destination$iv$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type io.vertx.core.json.JsonObject");
                        collection.add((JsonObject)it);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$forEach2 = false;
                    $this$mapTo$iv$iv = $this$forEach$iv2.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        String bl5;
                        String it;
                        element$iv2 = $this$mapTo$iv$iv.next();
                        JsonObject it2 = (JsonObject)element$iv2;
                        boolean bl6 = false;
                        Map item$iv$iv = tmpMappings;
                        Intrinsics.checkNotNullExpressionValue((Object)it2.getString("source"), (String)"it.getString(\"source\")");
                        Intrinsics.checkNotNullExpressionValue((Object)it2.getString("target"), (String)"it.getString(\"target\")");
                        item$iv$iv.put(it, bl5);
                    }
                }
                if ((jsonArray = host.getJsonArray("feature")) == null) continue;
                $this$forEach$iv2 = (Iterable)jsonArray;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv;
                    Object it = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.String");
                    collection.add((String)it);
                }
                iterable = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (iterable == null) continue;
                Iterable it = iterable;
                boolean bl8 = false;
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                tmpFeatures.put(name, it);
            }
            catch (Exception e) {
                logger.error((Throwable)e, (Function0)new Function0<Object>(host){
                    final /* synthetic */ JsonObject $host;
                    {
                        this.$host = $host;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Router `mapHostToAddr()` failed. Host: " + this.$host;
                    }
                });
            }
        }
        hosts = tmpHosts;
        mappings = tmpMappings;
        features = tmpFeatures;
    }

    static {
        hosts = MapsKt.emptyMap();
        mappings = MapsKt.emptyMap();
        features = MapsKt.emptyMap();
    }
}

