/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.domain.IpHeader;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.Handler;
import io.sip3.commons.domain.payload.ByteArrayPayload;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.util.ByteBufUtilKt;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H&R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/sip3/captain/ce/pipeline/IpHandler;", "Lio/sip3/captain/ce/pipeline/Handler;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lio/vertx/core/json/JsonObject;", "bulkOperationsEnabled", "", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;Z)V", "bulkSize", "", "getBulkSize", "()I", "setBulkSize", "(I)V", "ipPackets", "", "Lkotlin/Pair;", "Lio/sip3/captain/ce/domain/IpHeader;", "Lio/sip3/captain/ce/domain/Packet;", "onPacket", "", "packet", "readIpHeader", "buffer", "Lio/netty/buffer/ByteBuf;", "routePacket", "sip3-captain-ce"})
public abstract class IpHandler
extends Handler {
    private int bulkSize;
    @NotNull
    private final List<Pair<IpHeader, Packet>> ipPackets;

    public IpHandler(@NotNull Vertx vertx, @NotNull JsonObject config, boolean bulkOperationsEnabled) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            super(vertx, config, bulkOperationsEnabled);
            this.bulkSize = 1;
            this.ipPackets = new ArrayList();
            if (!bulkOperationsEnabled) break block1;
            Object object = config.getJsonObject("ip");
            if (object != null && (object = object.getInteger("bulk_size")) != null) {
                int it = ((Number)object).intValue();
                boolean bl = false;
                this.bulkSize = it;
            }
        }
    }

    protected final int getBulkSize() {
        return this.bulkSize;
    }

    protected final void setBulkSize(int n) {
        this.bulkSize = n;
    }

    @NotNull
    public abstract IpHeader readIpHeader(@NotNull ByteBuf var1);

    public abstract void routePacket(@NotNull Packet var1);

    @Override
    public void onPacket(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        ByteBuf buffer = ((Encodable)payload).encode();
        int offset = buffer.readerIndex();
        IpHeader header = this.readIpHeader(buffer);
        int packetLength = offset + header.getTotalLength();
        if (buffer.writerIndex() < packetLength) {
            return;
        }
        buffer.readerIndex(offset + header.getHeaderLength());
        buffer.writerIndex(packetLength);
        if (header.getMoreFragments() || header.getFragmentOffset() > 0) {
            packet.setPayload((Payload)ByteArrayPayload.box-impl((byte[])ByteArrayPayload.constructor-impl((byte[])ByteBufUtilKt.getBytes((ByteBuf)buffer))));
            this.ipPackets.add((Pair<IpHeader, Packet>)new Pair((Object)header.copy(), (Object)packet));
            if (this.ipPackets.size() >= this.bulkSize) {
                EventBus eventBus = this.getVertx().eventBus();
                Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
                EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getFragment(), (Object)CollectionsKt.toList((Iterable)this.ipPackets), null, (int)4, null);
                this.ipPackets.clear();
            }
        } else {
            Packet packet2;
            Packet $this$onPacket_u24lambda_u241 = packet2 = packet;
            boolean bl = false;
            byte[] byArray = header.getSrcAddr();
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, size)");
            $this$onPacket_u24lambda_u241.setSrcAddr(byArray2);
            byte[] byArray3 = header.getDstAddr();
            byte[] byArray4 = Arrays.copyOf(byArray3, byArray3.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"copyOf(this, size)");
            $this$onPacket_u24lambda_u241.setDstAddr(byArray4);
            $this$onPacket_u24lambda_u241.setProtocolNumber(header.getProtocolNumber());
            this.routePacket(packet);
        }
    }
}

