/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.encoder;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.encoder.Encoder;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.domain.payload.RawPayload;
import io.sip3.commons.util.ByteBufUtilKt;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/sip3/captain/ce/encoder/Encoder;", "Lio/vertx/core/AbstractVerticle;", "()V", "buffers", "", "Lio/vertx/core/buffer/Buffer;", "bulkSize", "", "logger", "Lmu/KLogger;", "mtuSize", "encodeHeader", "Lio/netty/buffer/CompositeByteBuf;", "compressed", "encodePacket", "Lio/netty/buffer/ByteBuf;", "packet", "Lio/sip3/captain/ce/domain/Packet;", "encodeRawPacket", "encodeSip3Packet", "handle", "", "packets", "", "send", "buffer", "start", "Companion", "sip3-captain-ce"})
public final class Encoder
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private final List<Buffer> buffers = new ArrayList();
    private int bulkSize = 1;
    private int mtuSize = 1450;
    public static final int HEADER_LENGTH = 6;
    @NotNull
    private static final byte[] PREFIX;
    public static final int PROTO_VERSION = 2;
    public static final int PACKET_VERSION = 1;
    public static final int TAG_TIMESTAMP_TIME = 1;
    public static final int TAG_TIMESTAMP_NANOS = 2;
    public static final int TAG_SRC_ADDR = 3;
    public static final int TAG_DST_ADDR = 4;
    public static final int TAG_SRC_PORT = 5;
    public static final int TAG_DST_PORT = 6;
    public static final int TAG_PROTOCOL_CODE = 7;
    public static final int TAG_PAYLOAD = 8;

    public void start() {
        JsonObject jsonObject = this.config().getJsonObject("encoder");
        if (jsonObject != null) {
            int it;
            Integer n;
            JsonObject config = jsonObject;
            boolean bl = false;
            Integer n2 = n = config.getInteger("mtu_size");
            if (n2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getInteger(\"mtu_size\")");
                it = ((Number)n).intValue();
                boolean bl2 = false;
                this.mtuSize = it;
            }
            Integer n3 = n = config.getInteger("bulk_size");
            if (n3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getInteger(\"bulk_size\")");
                it = ((Number)n).intValue();
                boolean bl3 = false;
                this.bulkSize = it;
            }
        }
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getEncoder(), arg_0 -> Encoder.start$lambda$3(this, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void handle(@NotNull List<Packet> packets) {
        Closeable it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packets, (String)"packets");
        CompositeByteBuf cumulativeBuffer = null;
        cumulativeBuffer = Encoder.encodeHeader$default(this, 0, 1, null);
        Iterable $this$map$iv = packets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Packet packet = (Packet)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.encodePacket((Packet)((Object)it)));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ByteBuf packet = (ByteBuf)element$iv;
            boolean bl = false;
            if (packet.writerIndex() > this.mtuSize) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                it = new DeflaterOutputStream(os);
                Throwable throwable = null;
                try {
                    DeflaterOutputStream it2 = (DeflaterOutputStream)it;
                    boolean bl2 = false;
                    it2.write(ByteBufUtilKt.getBytes((ByteBuf)packet));
                    it2 = Unit.INSTANCE;
                }
                catch (Throwable it2) {
                    throwable = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)it, (Throwable)throwable);
                }
                Throwable $this$handle_u24lambda_u247_u24lambda_u246 = throwable = this.encodeHeader(1);
                boolean bl3 = false;
                $this$handle_u24lambda_u247_u24lambda_u246.addComponent(true, Unpooled.wrappedBuffer((byte[])os.toByteArray()));
                Throwable compressedBuffer = throwable;
                this.send((ByteBuf)compressedBuffer);
                continue;
            }
            if (cumulativeBuffer.writerIndex() + packet.writerIndex() - 6 > this.mtuSize) {
                this.send((ByteBuf)cumulativeBuffer);
                cumulativeBuffer = Encoder.encodeHeader$default(this, 0, 1, null);
            }
            cumulativeBuffer.addComponent(true, packet);
        }
        if (cumulativeBuffer.writerIndex() > 6) {
            this.send((ByteBuf)cumulativeBuffer);
        }
    }

    private final CompositeByteBuf encodeHeader(int compressed) {
        CompositeByteBuf compositeByteBuf;
        ByteBuf byteBuf;
        ByteBuf $this$encodeHeader_u24lambda_u248 = byteBuf = Unpooled.buffer((int)6);
        boolean bl = false;
        $this$encodeHeader_u24lambda_u248.writeBytes(PREFIX);
        $this$encodeHeader_u24lambda_u248.writeByte(2);
        $this$encodeHeader_u24lambda_u248.writeByte(compressed);
        ByteBuf header = byteBuf;
        CompositeByteBuf $this$encodeHeader_u24lambda_u249 = compositeByteBuf = Unpooled.compositeBuffer();
        boolean bl2 = false;
        $this$encodeHeader_u24lambda_u249.addComponent(true, header);
        CompositeByteBuf compositeByteBuf2 = compositeByteBuf;
        Intrinsics.checkNotNullExpressionValue((Object)compositeByteBuf2, (String)"compositeBuffer().apply \u2026t(true, header)\n        }");
        return compositeByteBuf2;
    }

    static /* synthetic */ CompositeByteBuf encodeHeader$default(Encoder encoder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return encoder.encodeHeader(n);
    }

    private final ByteBuf encodePacket(Packet packet) {
        return packet.getPayload() instanceof RawPayload ? this.encodeRawPacket(packet) : this.encodeSip3Packet(packet);
    }

    private final ByteBuf encodeSip3Packet(Packet packet) {
        ByteBuf byteBuf;
        int srcAddrLength = packet.getSrcAddr().length;
        int dstAddrLength = packet.getDstAddr().length;
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        byte[] payload2 = ByteBufUtilKt.getBytes((ByteBuf)((Encodable)payload).encode());
        int payloadLength = payload2.length;
        int packetLength = 45 + srcAddrLength + dstAddrLength + payloadLength;
        ByteBuf $this$encodeSip3Packet_u24lambda_u2410 = byteBuf = Unpooled.buffer((int)packetLength);
        boolean bl = false;
        $this$encodeSip3Packet_u24lambda_u2410.writeByte(1);
        $this$encodeSip3Packet_u24lambda_u2410.writeByte(1);
        $this$encodeSip3Packet_u24lambda_u2410.writeShort(packetLength);
        Intrinsics.checkNotNullExpressionValue((Object)$this$encodeSip3Packet_u24lambda_u2410, (String)"encodeSip3Packet$lambda$10");
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeSip3Packet_u24lambda_u2410, (int)1, (Object)packet.getTimestamp());
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeSip3Packet_u24lambda_u2410, (int)2, (Object)packet.getNanos());
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeSip3Packet_u24lambda_u2410, (int)3, (Object)packet.getSrcAddr());
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeSip3Packet_u24lambda_u2410, (int)4, (Object)packet.getDstAddr());
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeSip3Packet_u24lambda_u2410, (int)5, (Object)((short)packet.getSrcPort()));
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeSip3Packet_u24lambda_u2410, (int)6, (Object)((short)packet.getDstPort()));
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeSip3Packet_u24lambda_u2410, (int)7, (Object)packet.getProtocolCode());
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeSip3Packet_u24lambda_u2410, (int)8, (Object)payload2);
        ByteBuf byteBuf2 = byteBuf;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"buffer(packetLength).app\u2026YLOAD, payload)\n        }");
        return byteBuf2;
    }

    private final ByteBuf encodeRawPacket(Packet packet) {
        ByteBuf byteBuf;
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        byte[] payload2 = ByteBufUtilKt.getBytes((ByteBuf)((Encodable)payload).encode());
        int payloadLength = payload2.length;
        int packetLength = 25 + payloadLength;
        ByteBuf $this$encodeRawPacket_u24lambda_u2411 = byteBuf = Unpooled.buffer((int)packetLength);
        boolean bl = false;
        $this$encodeRawPacket_u24lambda_u2411.writeByte(2);
        $this$encodeRawPacket_u24lambda_u2411.writeByte(1);
        $this$encodeRawPacket_u24lambda_u2411.writeShort(packetLength);
        Intrinsics.checkNotNullExpressionValue((Object)$this$encodeRawPacket_u24lambda_u2411, (String)"encodeRawPacket$lambda$11");
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeRawPacket_u24lambda_u2411, (int)1, (Object)packet.getTimestamp());
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeRawPacket_u24lambda_u2411, (int)2, (Object)packet.getNanos());
        ByteBufUtilKt.writeTlv((ByteBuf)$this$encodeRawPacket_u24lambda_u2411, (int)8, (Object)payload2);
        ByteBuf byteBuf2 = byteBuf;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"buffer(packetLength).app\u2026YLOAD, payload)\n        }");
        return byteBuf2;
    }

    private final void send(ByteBuf buffer) {
        Buffer buffer2 = Buffer.buffer((ByteBuf)buffer);
        Intrinsics.checkNotNullExpressionValue((Object)buffer2, (String)"buffer(buffer)");
        this.buffers.add(buffer2);
        if (this.buffers.size() >= this.bulkSize) {
            EventBus eventBus = this.vertx.eventBus();
            Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
            EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getSender(), (Object)CollectionsKt.toList((Iterable)this.buffers), null, (int)4, null);
            this.buffers.clear();
        }
    }

    private static final void start$lambda$3(Encoder this$0, Message event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            List packets = (List)event.body();
            Intrinsics.checkNotNullExpressionValue((Object)packets, (String)"packets");
            this$0.handle(packets);
        }
        catch (Exception e) {
            this$0.logger.error("Encoder 'handle()' failed.", (Throwable)e);
        }
    }

    static {
        byte[] byArray = new byte[]{83, 73, 80, 51};
        PREFIX = byArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/sip3/captain/ce/encoder/Encoder$Companion;", "", "()V", "HEADER_LENGTH", "", "PACKET_VERSION", "PREFIX", "", "getPREFIX", "()[B", "PROTO_VERSION", "TAG_DST_ADDR", "TAG_DST_PORT", "TAG_PAYLOAD", "TAG_PROTOCOL_CODE", "TAG_SRC_ADDR", "TAG_SRC_PORT", "TAG_TIMESTAMP_NANOS", "TAG_TIMESTAMP_TIME", "sip3-captain-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getPREFIX() {
            return PREFIX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

