/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.capturing;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.sip3.captain.ce.capturing.PacketHandle;
import io.sip3.captain.ce.capturing.PcapEngine;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.EthernetHandler;
import io.sip3.captain.ce.pipeline.Ipv4Handler;
import io.sip3.captain.ce.pipeline.Ipv6Handler;
import io.sip3.commons.domain.payload.ByteBufPayload;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.vertx.annotations.ConditionalOnProperty;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.util.VertxUtilKt;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.sql.Timestamp;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNetworkInterface;

@Instance(singleton=true)
@ConditionalOnProperty(pointer="/pcap")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020,H\u0002J\b\u00100\u001a\u00020,H\u0016J\n\u00101\u001a\u00020,*\u000202R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\f\"\u0004\b%\u0010\u000eR\u001a\u0010&\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\f\"\u0004\b(\u0010\u000eR\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lio/sip3/captain/ce/capturing/PcapEngine;", "Lio/vertx/core/AbstractVerticle;", "()V", "bpfFilter", "", "getBpfFilter", "()Ljava/lang/String;", "setBpfFilter", "(Ljava/lang/String;)V", "bufferSize", "", "getBufferSize", "()I", "setBufferSize", "(I)V", "bulkSize", "getBulkSize", "setBulkSize", "dev", "getDev", "setDev", "dlt", "getDlt", "setDlt", "ethernetHandler", "Lio/sip3/captain/ce/pipeline/EthernetHandler;", "ipv4Handler", "Lio/sip3/captain/ce/pipeline/Ipv4Handler;", "ipv6Handler", "Lio/sip3/captain/ce/pipeline/Ipv6Handler;", "logger", "Lmu/KLogger;", "packetsCaptured", "Lio/micrometer/core/instrument/Counter;", "kotlin.jvm.PlatformType", "snaplen", "getSnaplen", "setSnaplen", "timeoutMillis", "getTimeoutMillis", "setTimeoutMillis", "useJniLib", "", "handle", "", "packet", "Lio/sip3/captain/ce/domain/Packet;", "online", "start", "loop", "Lorg/pcap4j/core/PcapHandle;", "Companion", "sip3-captain-ce"})
public final class PcapEngine
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Nullable
    private String dev;
    @NotNull
    private String dlt = "EN10MB";
    private int bulkSize = 256;
    private int snaplen = 65535;
    private int bufferSize = 0x200000;
    private int timeoutMillis = 1;
    @NotNull
    private String bpfFilter = "";
    private boolean useJniLib;
    private EthernetHandler ethernetHandler;
    private Ipv4Handler ipv4Handler;
    private Ipv6Handler ipv6Handler;
    private final Counter packetsCaptured;
    @NotNull
    private static final Set<String> DATA_LINK_TYPES;

    public PcapEngine() {
        String[] stringArray = new String[]{"source", "pcap"};
        this.packetsCaptured = Metrics.counter((String)"packets_captured", (String[])stringArray);
        try {
            System.loadLibrary("sip3-libpcap");
            this.useJniLib = true;
            this.logger.info("Loaded `sip3-libpcap` JNI library.");
        }
        catch (Throwable throwable) {
        }
    }

    @Nullable
    public final String getDev() {
        return this.dev;
    }

    public final void setDev(@Nullable String string) {
        this.dev = string;
    }

    @NotNull
    public final String getDlt() {
        return this.dlt;
    }

    public final void setDlt(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dlt = string;
    }

    public final int getBulkSize() {
        return this.bulkSize;
    }

    public final void setBulkSize(int n) {
        this.bulkSize = n;
    }

    public final int getSnaplen() {
        return this.snaplen;
    }

    public final void setSnaplen(int n) {
        this.snaplen = n;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public final int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public final void setTimeoutMillis(int n) {
        this.timeoutMillis = n;
    }

    @NotNull
    public final String getBpfFilter() {
        return this.bpfFilter;
    }

    public final void setBpfFilter(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.bpfFilter = string;
    }

    public void start() {
        block8: {
            String it;
            JsonObject config = this.config().getJsonObject("pcap");
            boolean bl = false;
            Object object = config.getString("dev");
            String string = object;
            if (string != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(\"dev\")");
                it = object;
                boolean bl2 = false;
                this.dev = it;
            }
            object = config.getString("dlt");
            String string2 = object;
            if (string2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(\"dlt\")");
                it = object;
                boolean bl3 = false;
                if (!DATA_LINK_TYPES.contains(it)) {
                    boolean bl4 = false;
                    String string3 = "Unsupported datalink type: " + it;
                    throw new IllegalArgumentException(string3.toString());
                }
                this.dlt = it;
            }
            object = config.getString("bpf_filter");
            String string4 = object;
            if (string4 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(\"bpf_filter\")");
                it = object;
                boolean bl5 = false;
                this.bpfFilter = it;
            }
            Object object2 = object = config.getInteger("bulk_size");
            if (object2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getInteger(\"bulk_size\")");
                int it2 = ((Number)object).intValue();
                boolean bl6 = false;
                this.bulkSize = it2;
            }
            Object object3 = object = config.getInteger("snaplen");
            if (object3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getInteger(\"snaplen\")");
                int it3 = ((Number)object).intValue();
                boolean bl7 = false;
                this.snaplen = it3;
            }
            Object object4 = object = config.getInteger("buffer_size");
            if (object4 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getInteger(\"buffer_size\")");
                int it4 = ((Number)object).intValue();
                boolean bl8 = false;
                this.bufferSize = it4;
            }
            Object object5 = object = config.getInteger("timeout_millis");
            if (object5 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"getInteger(\"timeout_millis\")");
                int it5 = ((Number)object).intValue();
                boolean bl9 = false;
                this.timeoutMillis = it5;
            }
            Vertx vertx = this.vertx;
            Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
            JsonObject jsonObject = this.config();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"config()");
            this.ethernetHandler = new EthernetHandler(vertx, jsonObject, true);
            Vertx vertx2 = this.vertx;
            Intrinsics.checkNotNullExpressionValue((Object)vertx2, (String)"vertx");
            JsonObject jsonObject2 = this.config();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"config()");
            this.ipv4Handler = new Ipv4Handler(vertx2, jsonObject2, true);
            Vertx vertx3 = this.vertx;
            Intrinsics.checkNotNullExpressionValue((Object)vertx3, (String)"vertx");
            JsonObject jsonObject3 = this.config();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"config()");
            this.ipv6Handler = new Ipv6Handler(vertx3, jsonObject3, true);
            String string5 = this.dev;
            if (string5 == null) break block8;
            String it6 = string5;
            boolean bl10 = false;
            this.logger.info("Listening network interface: " + it6);
            this.online();
        }
    }

    private final void online() {
        if (this.useJniLib) {
            PacketHandle handle2 = new PacketHandle(this){
                final /* synthetic */ PcapEngine this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onPacket(@NotNull Packet packet) {
                    Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                    PcapEngine.access$getPacketsCaptured$p(this.this$0).increment();
                    PcapEngine.access$handle(this.this$0, packet);
                }
            };
            Executors.newSingleThreadExecutor().execute(() -> PcapEngine.online$lambda$10(handle2, this));
        } else {
            PcapHandle handle3 = new PcapHandle.Builder(this.dev).promiscuousMode(PcapNetworkInterface.PromiscuousMode.PROMISCUOUS).snaplen(this.snaplen).bufferSize(this.bufferSize).timeoutMillis(this.timeoutMillis).build();
            Executors.newSingleThreadExecutor().execute(() -> PcapEngine.online$lambda$11(this, handle3));
        }
    }

    public final void loop(@NotNull PcapHandle $this$loop) {
        Intrinsics.checkNotNullParameter((Object)$this$loop, (String)"<this>");
        if (((CharSequence)this.bpfFilter).length() > 0) {
            $this$loop.setFilter(this.bpfFilter, BpfProgram.BpfCompileMode.OPTIMIZE);
        }
        $this$loop.loop(0, arg_0 -> PcapEngine.loop$lambda$13(this, $this$loop, arg_0), (Executor)Executors.newSingleThreadExecutor());
    }

    private final void handle(Packet packet) {
        String string = this.dlt;
        if (Intrinsics.areEqual((Object)string, (Object)"EN10MB")) {
            EthernetHandler ethernetHandler2 = this.ethernetHandler;
            if (ethernetHandler2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ethernetHandler");
                ethernetHandler2 = null;
            }
            ethernetHandler2.handle(packet);
        } else if (Intrinsics.areEqual((Object)string, (Object)"RAW")) {
            Payload payload = packet.getPayload();
            Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
            byte version = ((Encodable)payload).encode().getByte(0);
            switch (version) {
                case 4: {
                    Ipv4Handler ipv4Handler2 = this.ipv4Handler;
                    if (ipv4Handler2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"ipv4Handler");
                        ipv4Handler2 = null;
                    }
                    ipv4Handler2.handle(packet);
                    break;
                }
                case 6: {
                    Ipv6Handler ipv6Handler2 = this.ipv6Handler;
                    if (ipv6Handler2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"ipv6Handler");
                        ipv6Handler2 = null;
                    }
                    ipv6Handler2.handle(packet);
                }
            }
        }
    }

    private static final void online$lambda$10(online.handle.1 $handle, PcapEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)$handle, (String)"$handle");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            String string = this$0.dev;
            Intrinsics.checkNotNull((Object)string);
            $handle.loop(string, this$0.bulkSize, this$0.snaplen, this$0.bufferSize, this$0.timeoutMillis, this$0.bpfFilter);
        }
        catch (Throwable t) {
            this$0.logger.error("Got exception...", t);
            Vertx vertx = this$0.vertx;
            Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
            VertxUtilKt.closeAndExitProcess$default((Vertx)vertx, (int)0, (int)1, null);
        }
    }

    private static final void online$lambda$11(PcapEngine this$0, PcapHandle $handle) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)$handle, (String)"handle");
            this$0.loop($handle);
        }
        catch (Exception e) {
            this$0.logger.error("Got exception...", (Throwable)e);
            Vertx vertx = this$0.vertx;
            Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
            VertxUtilKt.closeAndExitProcess$default((Vertx)vertx, (int)0, (int)1, null);
        }
    }

    private static final void loop$lambda$13(PcapEngine this$0, PcapHandle $this_loop, byte[] buffer) {
        Packet packet;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_loop, (String)"$this_loop");
        this$0.packetsCaptured.increment();
        Timestamp timestamp = $this_loop.getTimestamp();
        Packet $this$loop_u24lambda_u2413_u24lambda_u2412 = packet = new Packet();
        boolean bl = false;
        $this$loop_u24lambda_u2413_u24lambda_u2412.setTimestamp(timestamp.getTime());
        $this$loop_u24lambda_u2413_u24lambda_u2412.setNanos(timestamp.getNanos() % 1000000);
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])buffer);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"wrappedBuffer(buffer)");
        $this$loop_u24lambda_u2413_u24lambda_u2412.setPayload((Payload)new ByteBufPayload(byteBuf));
        Packet packet2 = packet;
        this$0.handle(packet2);
    }

    public static final /* synthetic */ Counter access$getPacketsCaptured$p(PcapEngine $this) {
        return $this.packetsCaptured;
    }

    public static final /* synthetic */ void access$handle(PcapEngine $this, Packet packet) {
        $this.handle(packet);
    }

    static {
        Object[] objectArray = new String[]{"EN10MB", "RAW"};
        DATA_LINK_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/sip3/captain/ce/capturing/PcapEngine$Companion;", "", "()V", "DATA_LINK_TYPES", "", "", "getDATA_LINK_TYPES", "()Ljava/util/Set;", "sip3-captain-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getDATA_LINK_TYPES() {
            return DATA_LINK_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

