/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.recording;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.recording.RecordingManager;
import io.sip3.captain.ce.recording.Stream;
import io.sip3.commons.domain.media.MediaAddress;
import io.sip3.commons.domain.media.MediaControl;
import io.sip3.commons.domain.media.Recording;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.domain.payload.RecordingPayload;
import io.sip3.commons.util.ByteBufUtilKt;
import io.sip3.commons.util.MediaUtil;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/sip3/captain/ce/recording/RecordingManager;", "", "()V", "aggregationTimeout", "", "durationTimeout", "expirationDelay", "logger", "Lmu/KLogger;", "streams", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "", "Lio/sip3/captain/ce/recording/Stream;", "vertx", "Lio/vertx/core/Vertx;", "getInstance", "config", "Lio/vertx/core/json/JsonObject;", "handleMediaControl", "", "mediaControl", "Lio/sip3/commons/domain/media/MediaControl;", "init", "record", "Lio/sip3/commons/domain/payload/RecordingPayload;", "packet", "Lio/sip3/captain/ce/domain/Packet;", "reset", "sip3-captain-ce"})
public final class RecordingManager {
    @NotNull
    public static final RecordingManager INSTANCE = new RecordingManager();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static long expirationDelay = 1000L;
    private static long aggregationTimeout = 30000L;
    private static long durationTimeout = 60000L;
    @Nullable
    private static Vertx vertx;
    private static PeriodicallyExpiringHashMap<String, Stream> streams;

    private RecordingManager() {
    }

    @NotNull
    public final synchronized RecordingManager getInstance(@NotNull Vertx vertx, @NotNull JsonObject config) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (RecordingManager.vertx == null) {
            RecordingManager.vertx = vertx;
            this.init(config);
        }
        return this;
    }

    private final void init(JsonObject config) {
        JsonObject jsonObject = config.getJsonObject("recording");
        if (jsonObject != null) {
            long it;
            Long l;
            JsonObject recordingConfig = jsonObject;
            boolean bl = false;
            Long l2 = l = recordingConfig.getLong("expiration_delay");
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getLong(\"expiration_delay\")");
                it = ((Number)l).longValue();
                boolean bl2 = false;
                expirationDelay = it;
            }
            Long l3 = l = recordingConfig.getLong("aggregation_timeout");
            if (l3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getLong(\"aggregation_timeout\")");
                it = ((Number)l).longValue();
                boolean bl3 = false;
                aggregationTimeout = it;
            }
            Long l4 = l = recordingConfig.getLong("duration_timeout");
            if (l4 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)l4, (String)"getLong(\"duration_timeout\")");
                it = ((Number)l).longValue();
                boolean bl4 = false;
                durationTimeout = it;
            }
        }
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(expirationDelay).period((int)(aggregationTimeout / expirationDelay)).expireAt((Function2)init.2.INSTANCE);
        Vertx vertx = RecordingManager.vertx;
        Intrinsics.checkNotNull((Object)vertx);
        streams = builder.build(vertx);
        Vertx vertx2 = RecordingManager.vertx;
        Intrinsics.checkNotNull((Object)vertx2);
        vertx2.eventBus().localConsumer(RoutesCE.Companion.getMedia() + "_control", RecordingManager::init$lambda$4);
        Vertx vertx3 = RecordingManager.vertx;
        Intrinsics.checkNotNull((Object)vertx3);
        vertx3.eventBus().localConsumer(RoutesCE.Companion.getMedia() + "_recording_reset", RecordingManager::init$lambda$5);
    }

    private final void handleMediaControl(MediaControl mediaControl) {
        block4: {
            Stream stream;
            Recording recording = mediaControl.getRecording();
            if (recording == null) break block4;
            Recording recording2 = recording;
            boolean bl = false;
            Stream $this$handleMediaControl_u24lambda_u247_u24lambda_u246 = stream = new Stream();
            boolean bl2 = false;
            $this$handleMediaControl_u24lambda_u247_u24lambda_u246.setMode(recording2.getMode());
            $this$handleMediaControl_u24lambda_u247_u24lambda_u246.setCallId(mediaControl.getCallId());
            Stream stream2 = stream;
            MediaAddress src = mediaControl.getSdpSession().getSrc();
            PeriodicallyExpiringHashMap<String, Stream> periodicallyExpiringHashMap = streams;
            if (periodicallyExpiringHashMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"streams");
                periodicallyExpiringHashMap = null;
            }
            periodicallyExpiringHashMap.put((Object)src.getRtpId(), (Object)stream2);
            PeriodicallyExpiringHashMap<String, Stream> periodicallyExpiringHashMap2 = streams;
            if (periodicallyExpiringHashMap2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"streams");
                periodicallyExpiringHashMap2 = null;
            }
            periodicallyExpiringHashMap2.put((Object)src.getRtcpId(), (Object)stream2);
            MediaAddress dst = mediaControl.getSdpSession().getDst();
            PeriodicallyExpiringHashMap<String, Stream> periodicallyExpiringHashMap3 = streams;
            if (periodicallyExpiringHashMap3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"streams");
                periodicallyExpiringHashMap3 = null;
            }
            periodicallyExpiringHashMap3.put((Object)dst.getRtpId(), (Object)stream2);
            PeriodicallyExpiringHashMap<String, Stream> periodicallyExpiringHashMap4 = streams;
            if (periodicallyExpiringHashMap4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"streams");
                periodicallyExpiringHashMap4 = null;
            }
            Stream cfr_ignored_0 = (Stream)periodicallyExpiringHashMap4.put((Object)dst.getRtcpId(), (Object)stream2);
        }
    }

    @Nullable
    public final RecordingPayload record(@NotNull Packet packet) {
        byte[] byArray;
        RecordingPayload recordingPayload;
        Stream stream;
        Stream stream2;
        Stream stream3;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        PeriodicallyExpiringHashMap<String, Stream> periodicallyExpiringHashMap = streams;
        if (periodicallyExpiringHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streams");
            periodicallyExpiringHashMap = null;
        }
        if (periodicallyExpiringHashMap.isEmpty()) {
            return null;
        }
        PeriodicallyExpiringHashMap<String, Stream> periodicallyExpiringHashMap2 = streams;
        if (periodicallyExpiringHashMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streams");
            periodicallyExpiringHashMap2 = null;
        }
        if ((stream3 = (Stream)periodicallyExpiringHashMap2.get((Object)MediaUtil.INSTANCE.sdpSessionId(packet.getSrcAddr(), packet.getSrcPort()))) == null) {
            PeriodicallyExpiringHashMap<String, Stream> periodicallyExpiringHashMap3 = streams;
            if (periodicallyExpiringHashMap3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"streams");
                periodicallyExpiringHashMap3 = null;
            }
            if ((stream3 = (Stream)periodicallyExpiringHashMap3.get((Object)MediaUtil.INSTANCE.sdpSessionId(packet.getDstAddr(), packet.getDstPort()))) == null) {
                return null;
            }
        }
        Stream $this$record_u24lambda_u248 = stream2 = (stream = stream3);
        boolean bl = false;
        $this$record_u24lambda_u248.setUpdatedAt(System.currentTimeMillis());
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        ByteBuf buffer = ((Encodable)payload).encode();
        RecordingPayload $this$record_u24lambda_u249 = recordingPayload = new RecordingPayload();
        boolean bl2 = false;
        Packet packet2 = packet.getRejected();
        $this$record_u24lambda_u249.setType(packet2 != null ? packet2.getProtocolCode() : packet.getProtocolCode());
        $this$record_u24lambda_u249.setMode(stream.getMode());
        $this$record_u24lambda_u249.setCallId(stream.getCallId());
        byte by = packet.getProtocolCode();
        if (by == 2) {
            int recordingMark;
            Packet packet3 = packet.getRejected();
            int n = recordingMark = packet3 != null ? packet3.getRecordingMark() : packet.getRecordingMark();
            byArray = stream.getMode() == 1 ? ByteBufUtilKt.getBytes((ByteBuf)buffer, (int)recordingMark, (int)(buffer.readerIndex() - recordingMark)) : ByteBufUtilKt.getBytes((ByteBuf)buffer, (int)recordingMark, (int)(buffer.writerIndex() - recordingMark));
        } else if (by == 1) {
            Packet packet4 = packet.getRejected();
            int recordingMark = packet4 != null ? packet4.getRecordingMark() : buffer.readerIndex();
            byArray = ByteBufUtilKt.getBytes((ByteBuf)buffer, (int)recordingMark, (int)(buffer.writerIndex() - recordingMark));
        } else {
            return null;
        }
        $this$record_u24lambda_u249.setPayload(byArray);
        return recordingPayload;
    }

    public final void reset() {
        PeriodicallyExpiringHashMap<String, Stream> periodicallyExpiringHashMap = streams;
        if (periodicallyExpiringHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streams");
            periodicallyExpiringHashMap = null;
        }
        periodicallyExpiringHashMap.clear();
    }

    private static final void init$lambda$4(Message event) {
        try {
            MediaControl mediaControl = (MediaControl)event.body();
            Intrinsics.checkNotNullExpressionValue((Object)mediaControl, (String)"mediaControl");
            INSTANCE.handleMediaControl(mediaControl);
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Function0)init.3.1.INSTANCE);
        }
    }

    private static final void init$lambda$5(Message it) {
        try {
            INSTANCE.reset();
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Function0)init.4.1.INSTANCE);
        }
    }

    public static final /* synthetic */ long access$getAggregationTimeout$p() {
        return aggregationTimeout;
    }

    public static final /* synthetic */ long access$getDurationTimeout$p() {
        return durationTimeout;
    }
}

