/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.Handler;
import io.sip3.captain.ce.pipeline.RtcpHandler;
import io.sip3.captain.ce.pipeline.RtpHandler;
import io.sip3.captain.ce.pipeline.SipHandler;
import io.sip3.captain.ce.pipeline.TzspHandler;
import io.sip3.captain.ce.pipeline.VxlanHandler;
import io.sip3.captain.ce.util.SipUtil;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000f\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000f\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000f\u001a\u0004\b\u001f\u0010 R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000f\u001a\u0004\b%\u0010&\u00a8\u0006-"}, d2={"Lio/sip3/captain/ce/pipeline/UdpHandler;", "Lio/sip3/captain/ce/pipeline/Handler;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lio/vertx/core/json/JsonObject;", "bulkOperationsEnabled", "", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;Z)V", "rtcpEnabled", "rtcpHandler", "Lio/sip3/captain/ce/pipeline/RtcpHandler;", "getRtcpHandler", "()Lio/sip3/captain/ce/pipeline/RtcpHandler;", "rtcpHandler$delegate", "Lkotlin/Lazy;", "rtpEnabled", "rtpHandler", "Lio/sip3/captain/ce/pipeline/RtpHandler;", "getRtpHandler", "()Lio/sip3/captain/ce/pipeline/RtpHandler;", "rtpHandler$delegate", "sipEnabled", "sipHandler", "Lio/sip3/captain/ce/pipeline/SipHandler;", "getSipHandler", "()Lio/sip3/captain/ce/pipeline/SipHandler;", "sipHandler$delegate", "tzspEnabled", "tzspHandler", "Lio/sip3/captain/ce/pipeline/TzspHandler;", "getTzspHandler", "()Lio/sip3/captain/ce/pipeline/TzspHandler;", "tzspHandler$delegate", "vxlanEnabled", "vxlanHandler", "Lio/sip3/captain/ce/pipeline/VxlanHandler;", "getVxlanHandler", "()Lio/sip3/captain/ce/pipeline/VxlanHandler;", "vxlanHandler$delegate", "onPacket", "", "packet", "Lio/sip3/captain/ce/domain/Packet;", "Companion", "sip3-captain-ce"})
public final class UdpHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean rtcpEnabled;
    private boolean rtpEnabled;
    private boolean sipEnabled;
    private boolean vxlanEnabled;
    private boolean tzspEnabled;
    @NotNull
    private final Lazy rtcpHandler$delegate;
    @NotNull
    private final Lazy rtpHandler$delegate;
    @NotNull
    private final Lazy sipHandler$delegate;
    @NotNull
    private final Lazy vxlanHandler$delegate;
    @NotNull
    private final Lazy tzspHandler$delegate;
    public static final int TYPE_VXLAN = 2048;

    public UdpHandler(@NotNull Vertx vertx, @NotNull JsonObject config, boolean bulkOperationsEnabled) {
        block4: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            boolean it;
            Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            super(vertx, config, bulkOperationsEnabled);
            this.sipEnabled = true;
            this.rtcpHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RtcpHandler>(vertx, config, bulkOperationsEnabled){
                final /* synthetic */ Vertx $vertx;
                final /* synthetic */ JsonObject $config;
                final /* synthetic */ boolean $bulkOperationsEnabled;
                {
                    this.$vertx = $vertx;
                    this.$config = $config;
                    this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                    super(0);
                }

                @NotNull
                public final RtcpHandler invoke() {
                    return new RtcpHandler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
                }
            }));
            this.rtpHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RtpHandler>(vertx, config, bulkOperationsEnabled){
                final /* synthetic */ Vertx $vertx;
                final /* synthetic */ JsonObject $config;
                final /* synthetic */ boolean $bulkOperationsEnabled;
                {
                    this.$vertx = $vertx;
                    this.$config = $config;
                    this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                    super(0);
                }

                @NotNull
                public final RtpHandler invoke() {
                    return new RtpHandler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
                }
            }));
            this.sipHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SipHandler>(vertx, config, bulkOperationsEnabled){
                final /* synthetic */ Vertx $vertx;
                final /* synthetic */ JsonObject $config;
                final /* synthetic */ boolean $bulkOperationsEnabled;
                {
                    this.$vertx = $vertx;
                    this.$config = $config;
                    this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                    super(0);
                }

                @NotNull
                public final SipHandler invoke() {
                    return new SipHandler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
                }
            }));
            this.vxlanHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VxlanHandler>(vertx, config, bulkOperationsEnabled){
                final /* synthetic */ Vertx $vertx;
                final /* synthetic */ JsonObject $config;
                final /* synthetic */ boolean $bulkOperationsEnabled;
                {
                    this.$vertx = $vertx;
                    this.$config = $config;
                    this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                    super(0);
                }

                @NotNull
                public final VxlanHandler invoke() {
                    return new VxlanHandler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
                }
            }));
            this.tzspHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TzspHandler>(vertx, config, bulkOperationsEnabled){
                final /* synthetic */ Vertx $vertx;
                final /* synthetic */ JsonObject $config;
                final /* synthetic */ boolean $bulkOperationsEnabled;
                {
                    this.$vertx = $vertx;
                    this.$config = $config;
                    this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                    super(0);
                }

                @NotNull
                public final TzspHandler invoke() {
                    return new TzspHandler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
                }
            }));
            Object object5 = config.getJsonObject("rtcp");
            if (object5 != null && (object5 = object5.getBoolean("enabled")) != null) {
                it = (Boolean)object5;
                boolean bl = false;
                this.rtcpEnabled = it;
            }
            if ((object4 = config.getJsonObject("rtp")) != null && (object4 = object4.getBoolean("enabled")) != null) {
                it = (Boolean)object4;
                boolean bl = false;
                this.rtpEnabled = it;
            }
            if ((object3 = config.getJsonObject("sip")) != null && (object3 = object3.getBoolean("enabled")) != null) {
                it = (Boolean)object3;
                boolean bl = false;
                this.sipEnabled = it;
            }
            if ((object2 = config.getJsonObject("vxlan")) != null && (object2 = object2.getBoolean("enabled")) != null) {
                it = (Boolean)object2;
                boolean bl = false;
                this.vxlanEnabled = it;
            }
            if ((object = config.getJsonObject("tzsp")) == null || (object = object.getBoolean("enabled")) == null) break block4;
            it = (Boolean)object;
            boolean bl = false;
            this.tzspEnabled = it;
        }
    }

    private final RtcpHandler getRtcpHandler() {
        Lazy lazy = this.rtcpHandler$delegate;
        return (RtcpHandler)lazy.getValue();
    }

    private final RtpHandler getRtpHandler() {
        Lazy lazy = this.rtpHandler$delegate;
        return (RtpHandler)lazy.getValue();
    }

    private final SipHandler getSipHandler() {
        Lazy lazy = this.sipHandler$delegate;
        return (SipHandler)lazy.getValue();
    }

    private final VxlanHandler getVxlanHandler() {
        Lazy lazy = this.vxlanHandler$delegate;
        return (VxlanHandler)lazy.getValue();
    }

    private final TzspHandler getTzspHandler() {
        Lazy lazy = this.tzspHandler$delegate;
        return (TzspHandler)lazy.getValue();
    }

    @Override
    public void onPacket(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        ByteBuf buffer = ((Encodable)payload).encode();
        packet.setSrcPort(buffer.readUnsignedShort());
        packet.setDstPort(buffer.readUnsignedShort());
        buffer.skipBytes(2);
        buffer.skipBytes(2);
        if (buffer.readableBytes() < 8) {
            return;
        }
        int offset = buffer.readerIndex();
        if (buffer.getUnsignedByte(offset) >> 6 == 2) {
            short packetType = buffer.getUnsignedByte(offset + 1);
            boolean bl = 200 <= packetType ? packetType < 212 : false;
            if (bl) {
                if (this.rtcpEnabled && packet.getRejected() == null) {
                    this.getRtcpHandler().handle(packet);
                }
            } else if (this.rtpEnabled) {
                this.getRtpHandler().handle(packet);
            }
        } else if (this.sipEnabled && SipUtil.startsWithSipWord$default(SipUtil.INSTANCE, buffer, 0, 2, null)) {
            if (packet.getRejected() == null) {
                this.getSipHandler().handle(packet);
            }
        } else if (this.vxlanEnabled && buffer.getUnsignedShort(offset) == 2048) {
            if (packet.getRejected() == null) {
                this.getVxlanHandler().handle(packet);
            }
        } else if (this.tzspEnabled && buffer.getByte(offset) == 1 && packet.getRejected() == null) {
            this.getTzspHandler().handle(packet);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sip3/captain/ce/pipeline/UdpHandler$Companion;", "", "()V", "TYPE_VXLAN", "", "sip3-captain-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

