/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.Handler;
import io.sip3.captain.ce.util.SmppUtil;
import io.sip3.commons.domain.payload.ByteArrayPayload;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.util.ByteBufUtilKt;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/sip3/captain/ce/pipeline/SmppHandler;", "Lio/sip3/captain/ce/pipeline/Handler;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lio/vertx/core/json/JsonObject;", "bulkOperationsEnabled", "", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;Z)V", "bulkSize", "", "packets", "", "Lio/sip3/captain/ce/domain/Packet;", "onPacket", "", "packet", "sip3-captain-ce"})
public final class SmppHandler
extends Handler {
    @NotNull
    private final List<Packet> packets;
    private int bulkSize;

    public SmppHandler(@NotNull Vertx vertx, @NotNull JsonObject config, boolean bulkOperationsEnabled) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            super(vertx, config, bulkOperationsEnabled);
            this.packets = new ArrayList();
            this.bulkSize = 1;
            if (!bulkOperationsEnabled) break block2;
            JsonObject jsonObject = config.getJsonObject("smpp");
            if (jsonObject != null) {
                Integer n;
                JsonObject smppConfig = jsonObject;
                boolean bl = false;
                Integer n2 = n = smppConfig.getInteger("bulk_size");
                if (n2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getInteger(\"bulk_size\")");
                    int it = ((Number)n).intValue();
                    boolean bl2 = false;
                    this.bulkSize = it;
                }
            }
        }
    }

    @Override
    public void onPacket(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        ByteBuf buffer = ((Encodable)payload).encode();
        if (SmppUtil.INSTANCE.checkMinPduLength(buffer)) {
            long command;
            int offset = buffer.readerIndex();
            int length = (int)buffer.getUnsignedInt(offset);
            if (buffer.readableBytes() >= length && SmppUtil.INSTANCE.isPduCommand(command = buffer.getUnsignedInt(offset + 4))) {
                Packet p;
                Packet packet2;
                Packet $this$onPacket_u24lambda_u243 = packet2 = (p = packet.clone());
                boolean bl = false;
                $this$onPacket_u24lambda_u243.setProtocolCode((byte)6);
                Packet packet3 = $this$onPacket_u24lambda_u243;
                Packet packet4 = $this$onPacket_u24lambda_u243;
                boolean bl2 = false;
                byte[] bytes = ByteBufUtilKt.getBytes((ByteBuf)buffer, (int)offset, (int)length);
                packet4.setPayload((Payload)ByteArrayPayload.box-impl((byte[])ByteArrayPayload.constructor-impl((byte[])bytes)));
                this.packets.add(p);
                if (this.packets.size() >= this.bulkSize) {
                    EventBus eventBus = this.getVertx().eventBus();
                    Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
                    EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getEncoder(), (Object)CollectionsKt.toList((Iterable)this.packets), null, (int)4, null);
                    this.packets.clear();
                }
                buffer.readerIndex(offset + length);
                if (buffer.readableBytes() > 0) {
                    this.onPacket(packet);
                }
            }
        }
    }
}

