/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.domain.IpHeader;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.GreHandler;
import io.sip3.captain.ce.pipeline.IpHandler;
import io.sip3.captain.ce.pipeline.UdpHandler;
import io.sip3.commons.domain.payload.ByteArrayPayload;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.util.ByteBufUtilKt;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0016R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000e\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lio/sip3/captain/ce/pipeline/Ipv4Handler;", "Lio/sip3/captain/ce/pipeline/IpHandler;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lio/vertx/core/json/JsonObject;", "bulkOperationsEnabled", "", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;Z)V", "greHandler", "Lio/sip3/captain/ce/pipeline/GreHandler;", "getGreHandler", "()Lio/sip3/captain/ce/pipeline/GreHandler;", "greHandler$delegate", "Lkotlin/Lazy;", "header", "Lio/sip3/captain/ce/domain/IpHeader;", "sctpPackets", "", "Lio/sip3/captain/ce/domain/Packet;", "tcpPackets", "udpHandler", "Lio/sip3/captain/ce/pipeline/UdpHandler;", "getUdpHandler", "()Lio/sip3/captain/ce/pipeline/UdpHandler;", "udpHandler$delegate", "readIpHeader", "buffer", "Lio/netty/buffer/ByteBuf;", "routePacket", "", "packet", "Companion", "sip3-captain-ce"})
public final class Ipv4Handler
extends IpHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IpHeader header;
    @NotNull
    private final List<Packet> tcpPackets;
    @NotNull
    private final List<Packet> sctpPackets;
    @NotNull
    private final Lazy udpHandler$delegate;
    @NotNull
    private final Lazy greHandler$delegate;
    public static final int TYPE_ICMP = 1;
    public static final int TYPE_IPV4 = 4;
    public static final int TYPE_TCP = 6;
    public static final int TYPE_UDP = 17;
    public static final int TYPE_GRE = 47;
    public static final int TYPE_SCTP = 132;

    public Ipv4Handler(@NotNull Vertx vertx, @NotNull JsonObject config, boolean bulkOperationsEnabled) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(vertx, config, bulkOperationsEnabled);
        this.header = new IpHeader(0, 1, null);
        this.tcpPackets = new ArrayList();
        this.sctpPackets = new ArrayList();
        this.udpHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UdpHandler>(vertx, config, bulkOperationsEnabled){
            final /* synthetic */ Vertx $vertx;
            final /* synthetic */ JsonObject $config;
            final /* synthetic */ boolean $bulkOperationsEnabled;
            {
                this.$vertx = $vertx;
                this.$config = $config;
                this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                super(0);
            }

            @NotNull
            public final UdpHandler invoke() {
                return new UdpHandler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
            }
        }));
        this.greHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GreHandler>(vertx, config, bulkOperationsEnabled){
            final /* synthetic */ Vertx $vertx;
            final /* synthetic */ JsonObject $config;
            final /* synthetic */ boolean $bulkOperationsEnabled;
            {
                this.$vertx = $vertx;
                this.$config = $config;
                this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                super(0);
            }

            @NotNull
            public final GreHandler invoke() {
                return new GreHandler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
            }
        }));
    }

    private final UdpHandler getUdpHandler() {
        Lazy lazy = this.udpHandler$delegate;
        return (UdpHandler)lazy.getValue();
    }

    private final GreHandler getGreHandler() {
        Lazy lazy = this.greHandler$delegate;
        return (GreHandler)lazy.getValue();
    }

    @Override
    @NotNull
    public IpHeader readIpHeader(@NotNull ByteBuf buffer) {
        IpHeader ipHeader;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        IpHeader $this$readIpHeader_u24lambda_u240 = ipHeader = this.header;
        boolean bl = false;
        $this$readIpHeader_u24lambda_u240.setHeaderLength(4 * (buffer.readUnsignedByte() & 0xF));
        buffer.skipBytes(1);
        $this$readIpHeader_u24lambda_u240.setTotalLength(buffer.readUnsignedShort());
        $this$readIpHeader_u24lambda_u240.setIdentification(buffer.readUnsignedShort());
        int flagsAndFragmentOffset = buffer.readUnsignedShort();
        $this$readIpHeader_u24lambda_u240.setMoreFragments((flagsAndFragmentOffset & 0x2000) != 0);
        $this$readIpHeader_u24lambda_u240.setFragmentOffset(flagsAndFragmentOffset & 0x1FFF);
        buffer.skipBytes(1);
        $this$readIpHeader_u24lambda_u240.setProtocolNumber(buffer.readUnsignedByte());
        buffer.skipBytes(2);
        buffer.readBytes($this$readIpHeader_u24lambda_u240.getSrcAddr());
        buffer.readBytes($this$readIpHeader_u24lambda_u240.getDstAddr());
        return ipHeader;
    }

    @Override
    public void routePacket(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        switch (packet.getProtocolNumber()) {
            case 17: {
                this.getUdpHandler().handle(packet);
                break;
            }
            case 6: {
                Ipv4Handler ipv4Handler2 = this;
                Packet packet2 = packet;
                boolean bl = false;
                Payload payload = packet.getPayload();
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
                ByteBuf buffer = ((Encodable)payload).encode();
                packet2.setPayload((Payload)ByteArrayPayload.box-impl((byte[])ByteArrayPayload.constructor-impl((byte[])ByteBufUtilKt.getBytes((ByteBuf)buffer))));
                this.tcpPackets.add(packet);
                if (this.tcpPackets.size() < this.getBulkSize()) break;
                EventBus eventBus = this.getVertx().eventBus();
                Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
                EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getTcp(), (Object)CollectionsKt.toList((Iterable)this.tcpPackets), null, (int)4, null);
                this.tcpPackets.clear();
                break;
            }
            case 1: {
                Packet packet3;
                Packet $this$routePacket_u24lambda_u241;
                Payload payload = packet.getPayload();
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
                ByteBuf buffer = ((Encodable)payload).encode();
                Packet $this$routePacket_u24lambda_u242 = $this$routePacket_u24lambda_u241 = packet;
                boolean bl = false;
                $this$routePacket_u24lambda_u242.setProtocolCode((byte)4);
                $this$routePacket_u24lambda_u242.setRecordingMark(buffer.readerIndex());
                byte type = buffer.readByte();
                byte code = buffer.readByte();
                buffer.skipBytes(6);
                if (type != 3 || code != 3) break;
                Packet $this$routePacket_u24lambda_u243 = packet3 = new Packet();
                boolean bl2 = false;
                $this$routePacket_u24lambda_u243.setTimestamp(packet.getTimestamp());
                $this$routePacket_u24lambda_u243.setNanos(packet.getNanos());
                $this$routePacket_u24lambda_u243.setPayload(packet.getPayload());
                $this$routePacket_u24lambda_u243.setRejected(packet);
                Packet p = packet3;
                this.onPacket(p);
                break;
            }
            case 4: {
                this.onPacket(packet);
                break;
            }
            case 47: {
                this.getGreHandler().handle(packet);
                break;
            }
            case 132: {
                Ipv4Handler type = this;
                Packet packet4 = packet;
                boolean bl = false;
                Payload payload = packet.getPayload();
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
                ByteBuf buffer = ((Encodable)payload).encode();
                packet4.setPayload((Payload)ByteArrayPayload.box-impl((byte[])ByteArrayPayload.constructor-impl((byte[])ByteBufUtilKt.getBytes((ByteBuf)buffer))));
                this.sctpPackets.add(packet);
                if (this.sctpPackets.size() < this.getBulkSize()) break;
                EventBus eventBus = this.getVertx().eventBus();
                Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"vertx.eventBus()");
                EventBusUtilKt.localSend$default((EventBus)eventBus, (String)RoutesCE.Companion.getSctp(), (Object)CollectionsKt.toList((Iterable)this.sctpPackets), null, (int)4, null);
                this.sctpPackets.clear();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/sip3/captain/ce/pipeline/Ipv4Handler$Companion;", "", "()V", "TYPE_GRE", "", "TYPE_ICMP", "TYPE_IPV4", "TYPE_SCTP", "TYPE_TCP", "TYPE_UDP", "sip3-captain-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

