/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.ErspanHandler;
import io.sip3.captain.ce.pipeline.EthernetHandler;
import io.sip3.captain.ce.pipeline.Handler;
import io.sip3.captain.ce.pipeline.Ipv4Handler;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lio/sip3/captain/ce/pipeline/GreHandler;", "Lio/sip3/captain/ce/pipeline/Handler;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lio/vertx/core/json/JsonObject;", "bulkOperationsEnabled", "", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;Z)V", "erspanHandler", "Lio/sip3/captain/ce/pipeline/ErspanHandler;", "getErspanHandler", "()Lio/sip3/captain/ce/pipeline/ErspanHandler;", "erspanHandler$delegate", "Lkotlin/Lazy;", "ethernetHandler", "Lio/sip3/captain/ce/pipeline/EthernetHandler;", "getEthernetHandler", "()Lio/sip3/captain/ce/pipeline/EthernetHandler;", "ethernetHandler$delegate", "ipv4Handler", "Lio/sip3/captain/ce/pipeline/Ipv4Handler;", "getIpv4Handler", "()Lio/sip3/captain/ce/pipeline/Ipv4Handler;", "ipv4Handler$delegate", "onPacket", "", "packet", "Lio/sip3/captain/ce/domain/Packet;", "Companion", "sip3-captain-ce"})
public final class GreHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy erspanHandler$delegate;
    @NotNull
    private final Lazy ipv4Handler$delegate;
    @NotNull
    private final Lazy ethernetHandler$delegate;
    public static final int TYPE_ERSPAN = 35006;
    public static final int TYPE_IPV4 = 2048;
    public static final int TYPE_TEB = 25944;

    public GreHandler(@NotNull Vertx vertx, @NotNull JsonObject config, boolean bulkOperationsEnabled) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(vertx, config, bulkOperationsEnabled);
        this.erspanHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ErspanHandler>(vertx, config, bulkOperationsEnabled){
            final /* synthetic */ Vertx $vertx;
            final /* synthetic */ JsonObject $config;
            final /* synthetic */ boolean $bulkOperationsEnabled;
            {
                this.$vertx = $vertx;
                this.$config = $config;
                this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                super(0);
            }

            @NotNull
            public final ErspanHandler invoke() {
                return new ErspanHandler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
            }
        }));
        this.ipv4Handler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Ipv4Handler>(vertx, config, bulkOperationsEnabled){
            final /* synthetic */ Vertx $vertx;
            final /* synthetic */ JsonObject $config;
            final /* synthetic */ boolean $bulkOperationsEnabled;
            {
                this.$vertx = $vertx;
                this.$config = $config;
                this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                super(0);
            }

            @NotNull
            public final Ipv4Handler invoke() {
                return new Ipv4Handler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
            }
        }));
        this.ethernetHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EthernetHandler>(vertx, config, bulkOperationsEnabled){
            final /* synthetic */ Vertx $vertx;
            final /* synthetic */ JsonObject $config;
            final /* synthetic */ boolean $bulkOperationsEnabled;
            {
                this.$vertx = $vertx;
                this.$config = $config;
                this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                super(0);
            }

            @NotNull
            public final EthernetHandler invoke() {
                return new EthernetHandler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
            }
        }));
    }

    private final ErspanHandler getErspanHandler() {
        Lazy lazy = this.erspanHandler$delegate;
        return (ErspanHandler)lazy.getValue();
    }

    private final Ipv4Handler getIpv4Handler() {
        Lazy lazy = this.ipv4Handler$delegate;
        return (Ipv4Handler)lazy.getValue();
    }

    private final EthernetHandler getEthernetHandler() {
        Lazy lazy = this.ethernetHandler$delegate;
        return (EthernetHandler)lazy.getValue();
    }

    @Override
    public void onPacket(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        ByteBuf buffer = ((Encodable)payload).encode();
        byte flags = buffer.readByte();
        boolean checksumFlag = (flags & 0x80) > 0;
        boolean keyFlag = (flags & 0x20) > 0;
        boolean sequenceNumberFlag = (flags & 0x10) > 0;
        buffer.skipBytes(1);
        int protocolType = buffer.readUnsignedShort();
        if (checksumFlag) {
            buffer.skipBytes(4);
        }
        if (keyFlag) {
            buffer.skipBytes(4);
        }
        if (sequenceNumberFlag) {
            buffer.skipBytes(4);
        }
        switch (protocolType) {
            case 35006: {
                this.getErspanHandler().handle(packet);
                break;
            }
            case 2048: {
                this.getIpv4Handler().handle(packet);
                break;
            }
            case 25944: {
                this.getEthernetHandler().handle(packet);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/sip3/captain/ce/pipeline/GreHandler$Companion;", "", "()V", "TYPE_ERSPAN", "", "TYPE_IPV4", "TYPE_TEB", "sip3-captain-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

