/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service.media.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J4\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lio/sip3/twig/ce/service/media/util/ReportUtil;", "", "()V", "reduceReport", "Lorg/bson/Document;", "report", "fraction", "", "splitReport", "", "chunks", "", "remainingDuration", "", "blockDuration", "blockCount", "sip3-twig-ce"})
public final class ReportUtil {
    @NotNull
    public static final ReportUtil INSTANCE = new ReportUtil();

    private ReportUtil() {
    }

    public final void splitReport(@NotNull List<Document> chunks, @NotNull Document report, int remainingDuration, int blockDuration, int blockCount) {
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Integer reportDuration = report.getInteger((Object)"duration");
        double d = remainingDuration;
        Intrinsics.checkNotNullExpressionValue((Object)reportDuration, (String)"reportDuration");
        double firstFraction = d / (double)reportDuration.intValue();
        double secondFraction = 1.0 - firstFraction;
        Document firstReport = this.reduceReport(report, firstFraction);
        Document remainingReport = this.reduceReport(report, secondFraction);
        chunks.add(firstReport);
        Integer n = remainingReport.getInteger((Object)"duration");
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"remainingReport.getInteger(\"duration\")");
        if (((Number)n).intValue() <= blockDuration) {
            chunks.add(remainingReport);
        } else if (chunks.size() >= blockCount) {
            chunks.add(remainingReport);
        } else {
            this.splitReport(chunks, remainingReport, blockDuration, blockDuration, blockCount);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Document reduceReport(Document report, double fraction) {
        void $this$reduceReport_u24lambda_u242_u24lambda_u241;
        void $this$reduceReport_u24lambda_u242_u24lambda_u240;
        Document document;
        Document document2;
        Document $this$reduceReport_u24lambda_u242 = document2 = new Document();
        boolean bl = false;
        $this$reduceReport_u24lambda_u242.put("mos", (Object)report.getDouble((Object)"mos"));
        $this$reduceReport_u24lambda_u242.put("r_factor", (Object)report.getDouble((Object)"r_factor"));
        $this$reduceReport_u24lambda_u242.put("duration", (Object)MathKt.roundToInt((double)((double)report.getInteger((Object)"duration").intValue() * fraction)));
        Object object = report.get((Object)"packets");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.Document");
        Document packets = (Document)object;
        int packetsExpected = MathKt.roundToInt((double)((double)packets.getInteger((Object)"expected").intValue() * fraction));
        int packetsReceived = MathKt.roundToInt((double)((double)packets.getInteger((Object)"received").intValue() * fraction));
        int packetsRejected = MathKt.roundToInt((double)((double)packets.getInteger((Object)"rejected").intValue() * fraction));
        Document document3 = document = new Document();
        String string = "packets";
        Document document4 = $this$reduceReport_u24lambda_u242;
        boolean $i$a$-apply-ReportUtil$reduceReport$1$32 = false;
        $this$reduceReport_u24lambda_u242_u24lambda_u240.put("expected", (Object)packetsExpected);
        $this$reduceReport_u24lambda_u242_u24lambda_u240.put("received", (Object)packetsReceived);
        $this$reduceReport_u24lambda_u242_u24lambda_u240.put("rejected", (Object)packetsRejected);
        $this$reduceReport_u24lambda_u242_u24lambda_u240.put("lost", (Object)(packetsExpected - packetsReceived - packetsRejected));
        Unit unit = Unit.INSTANCE;
        document4.put(string, (Object)document);
        Object object2 = report.get((Object)"jitter");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.bson.Document");
        Document jitter = (Document)object2;
        Document $i$a$-apply-ReportUtil$reduceReport$1$32 = document3 = new Document();
        string = "jitter";
        document4 = $this$reduceReport_u24lambda_u242;
        boolean bl2 = false;
        $this$reduceReport_u24lambda_u242_u24lambda_u241.put("min", (Object)jitter.getDouble((Object)"min"));
        $this$reduceReport_u24lambda_u242_u24lambda_u241.put("max", (Object)jitter.getDouble((Object)"max"));
        $this$reduceReport_u24lambda_u242_u24lambda_u241.put("avg", (Object)jitter.getDouble((Object)"avg"));
        unit = Unit.INSTANCE;
        document4.put(string, (Object)document3);
        return document2;
    }
}

