/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.controller;

import io.sip3.twig.ce.controller.SessionController;
import io.sip3.twig.ce.controller.SessionController$flow$;
import io.sip3.twig.ce.domain.Event;
import io.sip3.twig.ce.domain.SessionRequest;
import io.sip3.twig.ce.service.ServiceLocator;
import io.sip3.twig.ce.service.SessionService;
import io.sip3.twig.ce.service.media.MediaSessionService;
import io.sip3.twig.ce.service.media.domain.LegSession;
import io.sip3.twig.ce.service.participant.ParticipantService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Session API", description="Session Controller")
@RestController
@RequestMapping(value={"/session"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\f2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u00020\u00012\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\f2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0014\u001a\u00020\u00012\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0007J\u001a\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0012\u0010\u0019\u001a\u00020\u00162\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/sip3/twig/ce/controller/SessionController;", "", "()V", "logger", "Lmu/KLogger;", "mediaSessionService", "Lio/sip3/twig/ce/service/media/MediaSessionService;", "participantService", "Lio/sip3/twig/ce/service/participant/ParticipantService;", "serviceLocator", "Lio/sip3/twig/ce/service/ServiceLocator;", "content", "", "", "req", "Lio/sip3/twig/ce/domain/SessionRequest;", "details", "flow", "getSessionService", "Lio/sip3/twig/ce/service/SessionService;", "media", "pcap", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "stash", "sip3-twig-ce"})
public final class SessionController {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Autowired
    private ServiceLocator serviceLocator;
    @Autowired
    private MediaSessionService mediaSessionService;
    @Autowired
    private ParticipantService participantService;

    @Operation(summary="List session details")
    @ApiResponses(value={@ApiResponse(description="Returns session details", responseCode="200"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PostMapping(value={"/details"}, consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public final Object details(@RequestBody @NotNull SessionRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        return this.getSessionService(req).details(req);
    }

    @Operation(summary="List session content")
    @ApiResponses(value={@ApiResponse(description="Returns session messages and host list", responseCode="200"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PostMapping(value={"/content"}, consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public final Map<String, Object> content(@RequestBody @NotNull SessionRequest req) {
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        List messages = this.getSessionService(req).content(req);
        Pair[] $this$content_u24lambda_u241 = pairArray = (Pair[])new LinkedHashSet();
        boolean bl = false;
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Document message = (Document)element$iv;
            boolean bl2 = false;
            String string = message.getString((Object)"src_host");
            if (string == null) {
                string = message.getString((Object)"src_addr");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.getString(\"src_h\u2026age.getString(\"src_addr\")");
            $this$content_u24lambda_u241.add(string);
            String string2 = message.getString((Object)"dst_host");
            if (string2 == null) {
                string2 = message.getString((Object)"dst_addr");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message.getString(\"dst_h\u2026age.getString(\"dst_addr\")");
            $this$content_u24lambda_u241.add(string2);
        }
        Pair[] hosts = pairArray;
        pairArray = new Pair[]{TuplesKt.to((Object)"hosts", (Object)hosts), TuplesKt.to((Object)"messages", (Object)messages)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Build session flow")
    @ApiResponses(value={@ApiResponse(description="Returns session events and participants info", responseCode="200"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PostMapping(value={"/flow"}, consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public final Map<String, Object> flow(@RequestBody @NotNull SessionRequest req) {
        ParticipantService participantService;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        List events = new ArrayList();
        Iterable $this$map$iv = this.getSessionService(req).content(req);
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void message;
            Document document = (Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = message.getLong((Object)"created_at");
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"message.getLong(\"created_at\")");
            long l2 = ((Number)l).longValue();
            String string = message.getString((Object)"src_host");
            if (string == null) {
                string = message.getString((Object)"src_addr");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.getString(\"src_h\u2026age.getString(\"src_addr\")");
            String string2 = message.getString((Object)"dst_host");
            if (string2 == null) {
                string2 = message.getString((Object)"dst_addr");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message.getString(\"dst_h\u2026age.getString(\"dst_addr\")");
            Object object2 = message.remove((Object)"transaction_id");
            collection.add(events.add(new Event(l2, string, string2, "SIP", object2 instanceof String ? (String)object2 : null, (Object)message, null, 64, null)));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        List list = req.getMethod();
        if (Intrinsics.areEqual((Object)(list != null ? (String)CollectionsKt.firstOrNull((List)list) : null), (Object)"INVITE")) {
            Object element$iv;
            boolean $i$f$forEach;
            Object $this$forEach$iv;
            try {
                MediaSessionService mediaSessionService = this.mediaSessionService;
                if (mediaSessionService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mediaSessionService");
                    mediaSessionService = null;
                }
                $this$forEach$iv = mediaSessionService.details(req);
                $i$f$forEach = false;
                object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    String string;
                    LegSession legSession;
                    Object v6;
                    element$iv = object.next();
                    Map rtpr = (Map)element$iv;
                    boolean bl = false;
                    Iterable $this$minByOrNull$iv = CollectionsKt.filterNotNull((Iterable)rtpr.values());
                    boolean $i$f$minByOrNull = false;
                    Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v6 = null;
                    } else {
                        Object minElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v6 = minElem$iv;
                        } else {
                            LegSession it = (LegSession)minElem$iv;
                            boolean bl2 = false;
                            long minValue$iv = it.getCreatedAt();
                            do {
                                Object e$iv = iterator$iv.next();
                                LegSession it2 = (LegSession)e$iv;
                                $i$a$-minByOrNull-SessionController$flow$2$1 = false;
                                long v$iv = it2.getCreatedAt();
                                if (minValue$iv <= v$iv) continue;
                                minElem$iv = e$iv;
                                minValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v6 = minElem$iv;
                        }
                    }
                    if ((LegSession)v6 == null) continue;
                    boolean bl3 = false;
                    long l = legSession.getCreatedAt();
                    String string3 = legSession.getSrcHost();
                    if (string3 == null) {
                        string3 = legSession.getSrcAddr();
                    }
                    if ((string = legSession.getDstHost()) == null) {
                        string = legSession.getDstAddr();
                    }
                    events.add(new Event(l, string3, string, "RTPR", null, (Object)rtpr, null, 64, null));
                }
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
            }
            try {
                MediaSessionService mediaSessionService = this.mediaSessionService;
                if (mediaSessionService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mediaSessionService");
                    mediaSessionService = null;
                }
                $this$forEach$iv = mediaSessionService.dtmf(req);
                $i$f$forEach = false;
                object = $this$forEach$iv;
                while (object.hasNext()) {
                    element$iv = object.next();
                    Document dtmf = (Document)element$iv;
                    boolean bl = false;
                    Long l = dtmf.getLong((Object)"created_at");
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"dtmf.getLong(\"created_at\")");
                    long l3 = ((Number)l).longValue();
                    String string = dtmf.getString((Object)"src_host");
                    if (string == null) {
                        string = dtmf.getString((Object)"src_addr");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dtmf.getString(\"src_host\u2026tmf.getString(\"src_addr\")");
                    String string4 = dtmf.getString((Object)"dst_host");
                    if (string4 == null) {
                        string4 = dtmf.getString((Object)"dst_addr");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"dtmf.getString(\"dst_host\u2026tmf.getString(\"dst_addr\")");
                    events.add(new Event(l3, string, string4, "DTMF", null, (Object)dtmf, null, 64, null));
                }
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        List $this$sortBy$iv = events;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)((Comparator)new flow$$inlined$sortBy$1()));
        }
        if ((participantService = this.participantService) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"participantService");
            participantService = null;
        }
        List participants = participantService.collectParticipants(events);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"participants", (Object)participants), TuplesKt.to((Object)"events", (Object)events)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Operation(summary="Get media session statistics")
    @ApiResponses(value={@ApiResponse(description="Returns media session statistics", responseCode="200"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PostMapping(value={"/media"}, consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public final Object media(@RequestBody @NotNull SessionRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        MediaSessionService mediaSessionService = this.mediaSessionService;
        if (mediaSessionService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaSessionService");
            mediaSessionService = null;
        }
        return mediaSessionService.details(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Get PCAP for session")
    @ApiResponses(value={@ApiResponse(description="Returns session PCAP file", responseCode="200"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PostMapping(value={"/pcap"}, consumes={"application/json"}, produces={"application/octet-stream"})
    public final void pcap(@RequestBody @NotNull SessionRequest req, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("application/vnd.tcpdump.pcapOutputStream");
        response.setHeader("Content-Disposition", "attachment; filename=\"SIP3_" + UUID.randomUUID() + ".pcapOutputStream\"");
        Closeable closeable = this.getSessionService(req).pcap(req);
        Throwable throwable = null;
        try {
            ByteArrayOutputStream content = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)response.getOutputStream();
            Throwable throwable2 = null;
            try {
                ServletOutputStream response2 = (ServletOutputStream)closeable2;
                boolean bl2 = false;
                content.writeTo((OutputStream)response2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Operation(summary="Stash session")
    @ApiResponses(value={@ApiResponse(description="Session stashed", responseCode="204"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PostMapping(value={"/stash"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public final void stash(@RequestBody @NotNull SessionRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        this.getSessionService(req).stash(req);
    }

    private final SessionService getSessionService(SessionRequest req) {
        Object object = req.getMethod();
        if (object == null || (object = (String)CollectionsKt.firstOrNull((List)object)) == null) {
            throw new IllegalArgumentException("method");
        }
        Object method = object;
        ServiceLocator serviceLocator = this.serviceLocator;
        if (serviceLocator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serviceLocator");
            serviceLocator = null;
        }
        return serviceLocator.sessionService((String)method);
    }
}

