/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.controller;

import io.sip3.twig.ce.controller.SearchController;
import io.sip3.twig.ce.controller.SearchRequestValidator;
import io.sip3.twig.ce.domain.SearchRequest;
import io.sip3.twig.ce.domain.SearchResponse;
import io.sip3.twig.ce.service.ServiceLocator;
import io.sip3.twig.ce.util.IteratorUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Search API", description="Search Controller")
@RestController
@RequestMapping(value={"/search"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0001\u0010\f\u001a\u00020\rH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/sip3/twig/ce/controller/SearchController;", "", "()V", "defaultLimit", "", "searchRequestValidator", "Lio/sip3/twig/ce/controller/SearchRequestValidator;", "serviceLocator", "Lio/sip3/twig/ce/service/ServiceLocator;", "search", "", "Lio/sip3/twig/ce/domain/SearchResponse;", "request", "Lio/sip3/twig/ce/domain/SearchRequest;", "Companion", "sip3-twig-ce"})
public final class SearchController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Value(value="${session.default-limit:${session.default_limit:50}}")
    private int defaultLimit = 50;
    @Autowired
    private ServiceLocator serviceLocator;
    @Autowired
    private SearchRequestValidator searchRequestValidator;
    @NotNull
    private static final Regex SIP_METHOD_REGEX = new Regex("sip.method=(\\w*)");

    @Operation(summary="Search sessions")
    @ApiResponses(value={@ApiResponse(description="Returns search results", responseCode="200"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PostMapping(consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public final List<SearchResponse> search(@Valid @RequestBody @NotNull SearchRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        SearchRequestValidator searchRequestValidator = this.searchRequestValidator;
        if (searchRequestValidator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchRequestValidator");
            searchRequestValidator = null;
        }
        searchRequestValidator.validate(request);
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.ifEmpty((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)SIP_METHOD_REGEX, (CharSequence)request.getQuery(), (int)0, (int)2, null), (Function1)((Function1)search.searches.1.INSTANCE)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Iterator[] searches2 = thisCollection$iv.toArray(new Iterator[0]);
        Integer n = request.getLimit();
        Sequence $this$sortedBy$iv = SequencesKt.take((Sequence)SequencesKt.asSequence((Iterator)IteratorUtil.INSTANCE.merge(Arrays.copyOf(searches2, searches2.length))), (int)(n != null ? n : this.defaultLimit));
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */)));
    }

    public static final /* synthetic */ Regex access$getSIP_METHOD_REGEX$cp() {
        return SIP_METHOD_REGEX;
    }

    public static final /* synthetic */ ServiceLocator access$getServiceLocator$p(SearchController $this) {
        return $this.serviceLocator;
    }
}

