/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.controller;

import com.mongodb.MongoExecutionTimeoutException;
import io.sip3.twig.ce.controller.ExceptionController;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ValidationException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/sip3/twig/ce/controller/ExceptionController;", "", "()V", "logger", "Lmu/KLogger;", "exception", "Lorg/springframework/http/ResponseEntity;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "req", "Ljakarta/servlet/http/HttpServletRequest;", "sip3-twig-ce"})
public final class ExceptionController {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    @ExceptionHandler(value={Exception.class})
    @NotNull
    public final ResponseEntity<?> exception(@NotNull Exception e, @NotNull HttpServletRequest req) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        this.logger.error(req + " failed.", (Throwable)e);
        Exception exception = e;
        if (exception instanceof HttpMessageNotReadableException) {
            ResponseEntity responseEntity2 = ResponseEntity.badRequest().body((Object)"HttpMessageNotReadableError: Check your HTTP request.");
            responseEntity = responseEntity2;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"badRequest()\n           \u2026heck your HTTP request.\")");
        } else if (exception instanceof IllegalArgumentException) {
            ResponseEntity responseEntity3 = ResponseEntity.badRequest().body((Object)("IllegalArgumentError: Check `" + e.getMessage() + "` parameter."));
            responseEntity = responseEntity3;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity3, (String)"badRequest()\n           \u2026{e.message}` parameter.\")");
        } else if (exception instanceof IllegalStateException) {
            ResponseEntity responseEntity4 = ResponseEntity.badRequest().body((Object)("IllegalStateException: `" + e.getMessage() + "`."));
            responseEntity = responseEntity4;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity4, (String)"badRequest()\n           \u2026eption: `${e.message}`.\")");
        } else if (exception instanceof EmptyResultDataAccessException) {
            ResponseEntity responseEntity5 = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)"DataAccessException: Entity not found");
            responseEntity = responseEntity5;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity5, (String)"status(HttpStatus.NOT_FO\u2026ption: Entity not found\")");
        } else if (exception instanceof DuplicateKeyException) {
            ResponseEntity responseEntity6 = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CONFLICT)).body((Object)("DuplicateKeyException: `" + e.getMessage() + "`."));
            responseEntity = responseEntity6;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity6, (String)"status(HttpStatus.CONFLI\u2026eption: `${e.message}`.\")");
        } else if (exception instanceof UnsupportedOperationException) {
            ResponseEntity responseEntity7 = ResponseEntity.badRequest().body((Object)("UnsupportedOperationException: `" + e.getMessage() + "`."));
            responseEntity = responseEntity7;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity7, (String)"badRequest()\n           \u2026eption: `${e.message}`.\")");
        } else if (exception instanceof ValidationException) {
            ResponseEntity responseEntity8 = ResponseEntity.badRequest().body((Object)("ValidationException: `" + e.getMessage() + "`."));
            responseEntity = responseEntity8;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity8, (String)"badRequest()\n           \u2026eption: `${e.message}`.\")");
        } else if (exception instanceof MethodArgumentNotValidException) {
            ResponseEntity responseEntity9 = ResponseEntity.badRequest().body((Object)"MethodArgumentNotValidException: Invalid input data");
            responseEntity = responseEntity9;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity9, (String)"badRequest()\n           \u2026ion: Invalid input data\")");
        } else if (exception instanceof MongoExecutionTimeoutException) {
            ResponseEntity responseEntity10 = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT)).body((Object)"GatewayTimeoutError: Try to repeat your request or adjust request params.");
            responseEntity = responseEntity10;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity10, (String)"status(HttpStatus.GATEWA\u2026 adjust request params.\")");
        } else {
            ResponseEntity responseEntity11 = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR)).body((Object)"InternalServerError: Try to check service logs and contact with Support team if needed");
            responseEntity = responseEntity11;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity11, (String)"status(HttpStatus.INTERN\u2026 Support team if needed\")");
        }
        return responseEntity;
    }
}

