/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.ice.attributes.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.ice.attributes.IcePwdAttribute;

public class IcePwdAttributeParser
implements SdpParser<IcePwdAttribute> {
    private static final String REGEX = "^a=ice-pwd\\S+$";
    private static final Pattern PATTERN = Pattern.compile("^a=ice-pwd\\S+$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public IcePwdAttribute parse(String sdp) throws SdpException {
        try {
            int separator = sdp.indexOf(":");
            if (separator == -1) {
                throw new IllegalArgumentException("Attribute has no value");
            }
            String password = sdp.trim().substring(separator + 1);
            if (password.isEmpty()) {
                throw new IllegalArgumentException("Value is empty");
            }
            return new IcePwdAttribute(password);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(IcePwdAttribute field, String sdp) throws SdpException {
        try {
            int separator = sdp.indexOf(":");
            if (separator == -1) {
                throw new IllegalArgumentException("Attribute has no value");
            }
            String password = sdp.trim().substring(separator + 1);
            if (password.isEmpty()) {
                throw new IllegalArgumentException("Value is empty");
            }
            field.setPassword(password);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

