/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.pointer.impl;

import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.core.json.pointer.JsonPointerIterator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class JsonPointerImpl
implements JsonPointer {
    public static final Pattern VALID_POINTER_PATTERN = Pattern.compile("^(/(([^/~])|(~[01]))*)*$");
    URI startingUri;
    List<String> decodedTokens;

    public JsonPointerImpl(URI uri) {
        this.startingUri = this.removeFragment(uri);
        this.decodedTokens = this.parse(uri.getFragment());
    }

    public JsonPointerImpl(String pointer) {
        this.startingUri = URI.create("#");
        this.decodedTokens = this.parse(pointer);
    }

    public JsonPointerImpl() {
        this.startingUri = URI.create("#");
        this.decodedTokens = this.parse(null);
    }

    protected JsonPointerImpl(URI startingUri, List<String> decodedTokens) {
        this.startingUri = startingUri;
        this.decodedTokens = new ArrayList<String>(decodedTokens);
    }

    private ArrayList<String> parse(String pointer) {
        if (pointer == null || "".equals(pointer)) {
            return new ArrayList<String>();
        }
        if (VALID_POINTER_PATTERN.matcher(pointer).matches()) {
            return Arrays.stream(pointer.split("\\/", -1)).skip(1L).map(this::unescape).collect(Collectors.toCollection(ArrayList::new));
        }
        throw new IllegalArgumentException("The provided pointer is not a valid JSON Pointer");
    }

    private String escape(String path) {
        return path.replace("~", "~0").replace("/", "~1");
    }

    private String unescape(String path) {
        return path.replace("~1", "/").replace("~0", "~");
    }

    @Override
    public boolean isRootPointer() {
        return this.decodedTokens.size() == 0;
    }

    @Override
    public boolean isLocalPointer() {
        return this.startingUri == null || this.startingUri.getSchemeSpecificPart() == null || this.startingUri.getSchemeSpecificPart().isEmpty();
    }

    @Override
    public boolean isParent(JsonPointer c) {
        JsonPointerImpl child = (JsonPointerImpl)c;
        return child != null && (child.getURIWithoutFragment() == null && this.getURIWithoutFragment() == null || child.getURIWithoutFragment().equals(this.getURIWithoutFragment())) && this.decodedTokens.size() < child.decodedTokens.size() && IntStream.range(0, this.decodedTokens.size()).mapToObj(i2 -> this.decodedTokens.get(i2).equals(child.decodedTokens.get(i2))).reduce(Boolean::logicalAnd).orElse(true) != false;
    }

    @Override
    public String toString() {
        if (this.isRootPointer()) {
            return "";
        }
        return "/" + String.join((CharSequence)"/", this.decodedTokens.stream().map(this::escape).collect(Collectors.toList()));
    }

    @Override
    public URI toURI() {
        if (this.isRootPointer()) {
            return this.replaceFragment(this.startingUri, "");
        }
        return this.replaceFragment(this.startingUri, "/" + String.join((CharSequence)"/", this.decodedTokens.stream().map(this::escape).collect(Collectors.toList())));
    }

    @Override
    public URI getURIWithoutFragment() {
        return this.startingUri;
    }

    @Override
    public JsonPointer append(String path) {
        this.decodedTokens.add(path);
        return this;
    }

    @Override
    public JsonPointer append(int i2) {
        return this.append(Integer.toString(i2));
    }

    @Override
    public JsonPointer append(List<String> paths) {
        this.decodedTokens.addAll(paths);
        return this;
    }

    @Override
    public JsonPointer append(JsonPointer pointer) {
        this.decodedTokens.addAll(((JsonPointerImpl)pointer).decodedTokens);
        return this;
    }

    @Override
    public JsonPointer parent() {
        if (!this.isRootPointer()) {
            this.decodedTokens.remove(this.decodedTokens.size() - 1);
        }
        return this;
    }

    @Override
    public JsonPointer copy() {
        return new JsonPointerImpl(this.startingUri, this.decodedTokens);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPointerImpl that = (JsonPointerImpl)o;
        return Objects.equals(this.startingUri, that.startingUri) && Objects.equals(this.decodedTokens, that.decodedTokens);
    }

    public int hashCode() {
        return Objects.hash(this.startingUri, this.decodedTokens);
    }

    @Override
    public Object queryOrDefault(Object value, JsonPointerIterator iterator2, Object defaultValue) {
        if (this.isRootPointer()) {
            return iterator2.isNull(value) ? defaultValue : value;
        }
        value = this.walkTillLastElement(value, iterator2, false, null);
        String lastKey = this.decodedTokens.get(this.decodedTokens.size() - 1);
        if (iterator2.isObject(value)) {
            Object finalValue = iterator2.getObjectParameter(value, lastKey, false);
            return !iterator2.isNull(finalValue) ? finalValue : defaultValue;
        }
        if (iterator2.isArray(value) && !"-".equals(lastKey)) {
            try {
                Object finalValue = iterator2.getArrayElement(value, Integer.parseInt(lastKey));
                return !iterator2.isNull(finalValue) ? finalValue : defaultValue;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    @Override
    public List<Object> tracedQuery(Object objectToQuery, JsonPointerIterator iterator2) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.isRootPointer() && !iterator2.isNull(objectToQuery)) {
            list.add(objectToQuery);
        } else {
            Object lastValue = this.walkTillLastElement(objectToQuery, iterator2, false, list::add);
            if (!iterator2.isNull(lastValue)) {
                list.add(lastValue);
            }
            String lastKey = this.decodedTokens.get(this.decodedTokens.size() - 1);
            if (iterator2.isObject(lastValue)) {
                lastValue = iterator2.getObjectParameter(lastValue, lastKey, false);
            } else if (iterator2.isArray(lastValue) && !"-".equals(lastKey)) {
                try {
                    lastValue = iterator2.getArrayElement(lastValue, Integer.parseInt(lastKey));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!iterator2.isNull(lastValue)) {
                list.add(lastValue);
            }
        }
        return list;
    }

    @Override
    public Object write(Object valueToWrite, JsonPointerIterator iterator2, Object newElement, boolean createOnMissing) {
        if (this.isRootPointer()) {
            return iterator2.isNull(valueToWrite) ? null : newElement;
        }
        Object walkedValue = this.walkTillLastElement(valueToWrite, iterator2, createOnMissing, null);
        if (this.writeLastElement(walkedValue, iterator2, newElement)) {
            return valueToWrite;
        }
        return null;
    }

    private Object walkTillLastElement(Object value, JsonPointerIterator iterator2, boolean createOnMissing, Consumer<Object> onNewValue) {
        for (int i2 = 0; i2 < this.decodedTokens.size() - 1; ++i2) {
            String k = this.decodedTokens.get(i2);
            if (i2 == 0 && "".equals(k)) continue;
            if (iterator2.isObject(value)) {
                if (onNewValue != null) {
                    onNewValue.accept(value);
                }
                value = iterator2.getObjectParameter(value, k, createOnMissing);
                continue;
            }
            if (iterator2.isArray(value)) {
                if (onNewValue != null) {
                    onNewValue.accept(value);
                }
                try {
                    value = iterator2.getArrayElement(value, Integer.parseInt(k));
                    if (!iterator2.isNull(value) || !createOnMissing) continue;
                    value = iterator2.getObjectParameter(value, k, true);
                }
                catch (NumberFormatException e) {
                    value = null;
                }
                continue;
            }
            return null;
        }
        return value;
    }

    private boolean writeLastElement(Object valueToWrite, JsonPointerIterator iterator2, Object newElement) {
        String lastKey = this.decodedTokens.get(this.decodedTokens.size() - 1);
        if (iterator2.isObject(valueToWrite)) {
            return iterator2.writeObjectParameter(valueToWrite, lastKey, newElement);
        }
        if (iterator2.isArray(valueToWrite)) {
            if ("-".equals(lastKey)) {
                return iterator2.appendArrayElement(valueToWrite, newElement);
            }
            try {
                return iterator2.writeArrayElement(valueToWrite, Integer.parseInt(lastKey), newElement);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private URI removeFragment(URI oldURI) {
        return this.replaceFragment(oldURI, null);
    }

    private URI replaceFragment(URI oldURI, String fragment) {
        try {
            if (oldURI != null) {
                return new URI(oldURI.getScheme(), oldURI.getSchemeSpecificPart(), fragment);
            }
            return new URI(null, null, fragment);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

