/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.sip;

import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.util.DateTimeFormatterUtilKt;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.attributes.AttributesRegistry;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.sip.SipTransaction;
import io.sip3.salto.ce.sip.SipTransactionHandler;
import io.sip3.salto.ce.util.AttributeUtilKt;
import io.sip3.salto.ce.util.SIPMessageUtilKt;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Counter;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010#\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/sip3/salto/ce/sip/SipTransactionHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "aggregationTimeout", "", "allowEmptyUser", "", "attributesRegistry", "Lio/sip3/salto/ce/attributes/AttributesRegistry;", "expirationDelay", "instances", "", "logger", "Lmu/KLogger;", "recordCallUsersAttributes", "recordIpAddressesAttributes", "responseTimeout", "saveSipMessagePayloadMode", "terminationTimeout", "timeSuffix", "Ljava/time/format/DateTimeFormatter;", "transactions", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "", "Lio/sip3/salto/ce/sip/SipTransaction;", "calculateTransactionMetrics", "", "prefix", "transaction", "handle", "packet", "Lio/sip3/salto/ce/domain/Packet;", "message", "Lgov/nist/javax/sip/message/SIPMessage;", "routeTransaction", "start", "terminateTransactionAt", "writeAttributes", "writeToDatabase", "Companion", "sip3-salto-ce"})
public class SipTransactionHandler
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private DateTimeFormatter timeSuffix;
    private long expirationDelay;
    private long responseTimeout;
    private long aggregationTimeout;
    private long terminationTimeout;
    private int saveSipMessagePayloadMode;
    private boolean allowEmptyUser;
    private boolean recordIpAddressesAttributes;
    private boolean recordCallUsersAttributes;
    private int instances;
    private PeriodicallyExpiringHashMap<String, SipTransaction> transactions;
    private AttributesRegistry attributesRegistry;
    @NotNull
    private static final List<String> EXCLUDED_ATTRIBUTES;
    @NotNull
    private static final String PREFIX;
    @NotNull
    public static final String RESPONSE_DELAY = "response-delay";
    @NotNull
    private static final List<String> EXCLUDED_METHODS;

    public SipTransactionHandler() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(\"yyyyMMdd\")");
        this.timeSuffix = dateTimeFormatter;
        this.expirationDelay = 1000L;
        this.responseTimeout = 3000L;
        this.aggregationTimeout = 60000L;
        this.terminationTimeout = 4500L;
        this.instances = 1;
    }

    @Override
    public void start() {
        Object object;
        JsonObject jsonObject;
        Comparable<Boolean> comparable;
        JsonObject jsonObject2;
        String string = this.config().getString("time_suffix");
        if (string != null) {
            String it = string;
            boolean bl = false;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(it);
            Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(it)");
            this.timeSuffix = dateTimeFormatter;
        }
        if ((jsonObject2 = this.config().getJsonObject("sip")) != null && (jsonObject2 = jsonObject2.getJsonObject("message")) != null) {
            JsonObject config2 = jsonObject2;
            boolean bl = false;
            Boolean bl2 = comparable = config2.getBoolean("allow_empty_user");
            if (bl2 != null) {
                Intrinsics.checkNotNullExpressionValue(bl2, "getBoolean(\"allow_empty_user\")");
                boolean it = comparable;
                boolean bl3 = false;
                this.allowEmptyUser = it;
            }
        }
        if ((jsonObject = this.config().getJsonObject("sip")) != null && (jsonObject = jsonObject.getJsonObject("transaction")) != null) {
            JsonObject config3 = jsonObject;
            boolean bl = false;
            Comparable<Boolean> comparable2 = comparable = config3.getLong("expiration_delay");
            if (comparable2 != null) {
                Intrinsics.checkNotNullExpressionValue(comparable2, "getLong(\"expiration_delay\")");
                long it = ((Number)((Object)comparable)).longValue();
                boolean bl4 = false;
                this.expirationDelay = it;
            }
            Comparable<Boolean> comparable3 = comparable = config3.getLong("response_timeout");
            if (comparable3 != null) {
                Intrinsics.checkNotNullExpressionValue(comparable3, "getLong(\"response_timeout\")");
                long it = ((Number)((Object)comparable)).longValue();
                boolean bl5 = false;
                this.responseTimeout = it;
            }
            Comparable<Boolean> comparable4 = comparable = config3.getLong("aggregation_timeout");
            if (comparable4 != null) {
                Intrinsics.checkNotNullExpressionValue(comparable4, "getLong(\"aggregation_timeout\")");
                long it = ((Number)((Object)comparable)).longValue();
                boolean bl6 = false;
                this.aggregationTimeout = it;
            }
            Comparable<Boolean> comparable5 = comparable = config3.getLong("termination_timeout");
            if (comparable5 != null) {
                Intrinsics.checkNotNullExpressionValue(comparable5, "getLong(\"termination_timeout\")");
                long it = ((Number)((Object)comparable)).longValue();
                boolean bl7 = false;
                this.terminationTimeout = it;
            }
            Comparable<Boolean> comparable6 = comparable = config3.getInteger("save_sip_message_payload_mode");
            if (comparable6 != null) {
                Intrinsics.checkNotNullExpressionValue(comparable6, "getInteger(\"save_sip_message_payload_mode\")");
                int it = ((Number)((Object)comparable)).intValue();
                boolean bl8 = false;
                this.saveSipMessagePayloadMode = it;
            }
        }
        JsonObject jsonObject3 = this.config().getJsonObject("attributes");
        if (jsonObject3 != null) {
            Boolean bl;
            JsonObject config4 = jsonObject3;
            boolean bl9 = false;
            Boolean bl10 = bl = config4.getBoolean("record_ip_addresses");
            if (bl10 != null) {
                Intrinsics.checkNotNullExpressionValue(bl10, "getBoolean(\"record_ip_addresses\")");
                boolean it = bl;
                boolean bl11 = false;
                this.recordIpAddressesAttributes = it;
            }
            Boolean bl12 = bl = config4.getBoolean("record_call_users");
            if (bl12 != null) {
                Intrinsics.checkNotNullExpressionValue(bl12, "getBoolean(\"record_call_users\")");
                boolean it = bl;
                boolean bl13 = false;
                this.recordCallUsersAttributes = it;
            }
        }
        if ((object = this.config().getJsonObject("vertx")) != null && (object = ((JsonObject)object).getInteger("instances")) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            this.instances = it;
        }
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
        JsonObject jsonObject4 = this.config();
        Intrinsics.checkNotNullExpressionValue(jsonObject4, "config()");
        this.attributesRegistry = new AttributesRegistry(vertx, jsonObject4);
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, SipTransaction, Long>(this){
            final /* synthetic */ SipTransactionHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull SipTransaction transaction2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(transaction2, "transaction");
                return this.this$0.terminateTransactionAt(transaction2);
            }
        }).onExpire((Function2)new Function2<String, SipTransaction, Unit>(this){
            final /* synthetic */ SipTransactionHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull SipTransaction transaction2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(transaction2, "transaction");
                this.this$0.routeTransaction(transaction2);
            }
        });
        Vertx vertx2 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx2, "vertx");
        this.transactions = builder.build(vertx2);
        CoroutineScope coroutineScope = GlobalScope.INSTANCE;
        Vertx vertx3 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx3, "vertx");
        CoroutineDispatcher coroutineDispatcher = VertxCoroutineKt.dispatcher(vertx3);
        Intrinsics.checkNotNull(coroutineDispatcher, "null cannot be cast to non-null type kotlin.coroutines.CoroutineContext");
        BuildersKt.launch$default(coroutineScope, coroutineDispatcher, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ SipTransactionHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        v0 = SipTransactionHandler.access$getVertx$p$s-2076259098(this.this$0).sharedData().getLocalCounter(SipTransactionHandler.Companion.getPREFIX());
                        Intrinsics.checkNotNullExpressionValue(v0, "vertx.sharedData().getLocalCounter(PREFIX)");
                        this.label = 1;
                        v1 = VertxCoroutineKt.coAwait(v0, this);
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        index = (Counter)v1;
                        var5_4 = SipTransactionHandler.Companion.getPREFIX();
                        var4_5 = SipTransactionHandler.access$getVertx$p$s-2076259098(this.this$0).eventBus();
                        var3_6 = index.getAndIncrement();
                        Intrinsics.checkNotNullExpressionValue(var3_6, "index.andIncrement");
                        this.L$0 = var4_5;
                        this.L$1 = var5_4;
                        this.label = 2;
                        v2 = VertxCoroutineKt.coAwait(var3_6, this);
                        if (v2 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        var5_4 = (String)this.L$1;
                        var4_5 = (EventBus)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        var6_7 = v2;
                        var4_5.localConsumer(var5_4 + "_" + var6_7, (Handler<Message<T>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$0(io.sip3.salto.ce.sip.SipTransactionHandler io.vertx.core.eventbus.Message ), (Lio/vertx/core/eventbus/Message;)V)((SipTransactionHandler)this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(SipTransactionHandler this$0, Message event) {
                try {
                    Pair pair = (Pair)event.body();
                    Packet packet = (Packet)pair.component1();
                    SIPMessage message = (SIPMessage)pair.component2();
                    this$0.handle(packet, message);
                }
                catch (Exception e) {
                    SipTransactionHandler.access$getLogger$p(this$0).error("SipTransactionHandler 'handle()' failed.", e);
                }
            }
        }, 2, null);
    }

    public void handle(@NotNull Packet packet, @NotNull SIPMessage message) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(message, "message");
        if (CollectionsKt.contains((Iterable)EXCLUDED_METHODS, SIPMessageUtilKt.cseqMethod(message))) {
            return;
        }
        String transactionId = SIPMessageUtilKt.transactionId(message);
        PeriodicallyExpiringHashMap<String, SipTransaction> periodicallyExpiringHashMap = this.transactions;
        if (periodicallyExpiringHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transactions");
            periodicallyExpiringHashMap = null;
        }
        SipTransaction transaction2 = periodicallyExpiringHashMap.getOrPut(transactionId, handle.transaction.1.INSTANCE);
        PeriodicallyExpiringHashMap<String, SipTransaction> periodicallyExpiringHashMap2 = this.transactions;
        if (periodicallyExpiringHashMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transactions");
            periodicallyExpiringHashMap2 = null;
        }
        periodicallyExpiringHashMap2.touch(transactionId);
        boolean extend = this.saveSipMessagePayloadMode == 0 || this.saveSipMessagePayloadMode == 1 && message instanceof SIPRequest;
        transaction2.addMessage(packet, message, extend, this.allowEmptyUser);
        if (Intrinsics.areEqual(transaction2.getCseqMethod(), "INVITE")) {
            SIPRequest sIPRequest = transaction2.getRequest();
            boolean bl = sIPRequest != null ? SIPMessageUtilKt.hasSdp(sIPRequest) : false;
            if (bl) {
                SIPResponse sIPResponse = transaction2.getResponse();
                boolean bl2 = sIPResponse != null ? SIPMessageUtilKt.hasSdp(sIPResponse) : false;
                if (bl2) {
                    EventBus eventBus = this.vertx.eventBus();
                    Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
                    EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getMedia() + "_sdp", transaction2, null, 4, null);
                }
            }
        }
    }

    public long terminateTransactionAt(@NotNull SipTransaction transaction2) {
        long l;
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        Long l2 = transaction2.getTerminatedAt();
        if (l2 != null) {
            long it = ((Number)l2).longValue();
            boolean bl = false;
            l = it + this.terminationTimeout;
        } else {
            long l3;
            long l4 = transaction2.getCreatedAt();
            Long l5 = transaction2.getEstablishedAt();
            if (l5 != null) {
                long l6 = ((Number)l5).longValue();
                long l7 = l4;
                boolean bl = false;
                long l8 = this.aggregationTimeout;
                l4 = l7;
                l3 = l8;
            } else {
                l3 = this.responseTimeout;
            }
            l = l4 + l3;
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    public void routeTransaction(@NotNull SipTransaction transaction) {
        block13: {
            Intrinsics.checkNotNullParameter(transaction, "transaction");
            var3_2 = transaction.getCseqMethod();
            switch (var3_2.hashCode()) {
                case 92413603: {
                    if (!var3_2.equals("REGISTER")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case 1672907751: {
                    if (!var3_2.equals("MESSAGE")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case -1986360503: {
                    if (!var3_2.equals("NOTIFY")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case -531492226: {
                    if (!var3_2.equals("OPTIONS")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case -993530582: {
                    if (!var3_2.equals("SUBSCRIBE")) break;
lbl22:
                    // 5 sources

                    v0 = RoutesCE.Companion.getSip();
                    v1 = transaction.getCseqMethod().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(v1, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    v2 = v0 + "_" + v1;
                    break block13;
                }
            }
            v2 = RoutesCE.Companion.getSip() + "_call";
        }
        prefix = v2;
        var3_2 = prefix;
        if (Intrinsics.areEqual(var3_2, RoutesCE.Companion.getSip() + "_call") != false ? true : Intrinsics.areEqual(var3_2, RoutesCE.Companion.getSip() + "_register")) {
            index = transaction.getCallId().hashCode();
            route = prefix + "_" + Math.abs(index % this.instances);
            v3 = this.vertx.eventBus();
            Intrinsics.checkNotNullExpressionValue(v3, "vertx.eventBus()");
            EventBusUtilKt.localSend$default(v3, route, transaction, null, 4, null);
        } else {
            this.writeAttributes(transaction);
            this.writeToDatabase(prefix, transaction);
            this.calculateTransactionMetrics(prefix, transaction);
        }
    }

    private final void calculateTransactionMetrics(String prefix, SipTransaction transaction2) {
        block2: {
            String it;
            Map<String, Object> map2;
            Long l = transaction2.getTerminatedAt();
            if (l == null) break block2;
            long terminatedAt = ((Number)l).longValue();
            boolean bl = false;
            Map<String, Object> $this$calculateTransactionMetrics_u24lambda_u2418_u24lambda_u2417 = map2 = AttributeUtilKt.toMetricsAttributes(transaction2.getAttributes(), EXCLUDED_ATTRIBUTES);
            boolean bl2 = false;
            String string = transaction2.getSrcAddr().getHost();
            if (string != null) {
                it = string;
                boolean bl3 = false;
                $this$calculateTransactionMetrics_u24lambda_u2418_u24lambda_u2417.put("src_host", it);
            }
            String string2 = transaction2.getDstAddr().getHost();
            if (string2 != null) {
                it = string2;
                boolean bl4 = false;
                $this$calculateTransactionMetrics_u24lambda_u2418_u24lambda_u2417.put("dst_host", it);
            }
            Map<String, Object> attributes = map2;
            Metrics.INSTANCE.timer(prefix + "_response-delay", attributes).record(terminatedAt - transaction2.getCreatedAt(), TimeUnit.MILLISECONDS);
        }
    }

    public void writeAttributes(@NotNull SipTransaction transaction2) {
        String it;
        Object object;
        Map map2;
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        Map $this$writeAttributes_u24lambda_u2423 = map2 = AttributeUtilKt.toAttributes$default(transaction2.getAttributes(), null, 1, null);
        boolean bl = false;
        $this$writeAttributes_u24lambda_u2423.put("method", transaction2.getCseqMethod());
        $this$writeAttributes_u24lambda_u2423.put("state", transaction2.getState());
        Address src = transaction2.getSrcAddr();
        $this$writeAttributes_u24lambda_u2423.put("src_addr", this.recordIpAddressesAttributes ? src.getAddr() : "");
        String string = src.getHost();
        if (string != null) {
            String it2 = string;
            boolean bl2 = false;
            $this$writeAttributes_u24lambda_u2423.put("src_host", it2);
        }
        Address dst = transaction2.getDstAddr();
        $this$writeAttributes_u24lambda_u2423.put("dst_addr", this.recordIpAddressesAttributes ? dst.getAddr() : "");
        String string2 = dst.getHost();
        if (string2 != null) {
            String it3 = string2;
            boolean bl3 = false;
            $this$writeAttributes_u24lambda_u2423.put("dst_host", it3);
        }
        if ((object = $this$writeAttributes_u24lambda_u2423.get("caller")) == null) {
            object = transaction2.getCaller();
        }
        Object caller = object;
        $this$writeAttributes_u24lambda_u2423.put("caller", this.recordCallUsersAttributes ? caller : "");
        Object object2 = $this$writeAttributes_u24lambda_u2423.get("callee");
        if (object2 == null) {
            object2 = transaction2.getCallee();
        }
        Object callee = object2;
        $this$writeAttributes_u24lambda_u2423.put("callee", this.recordCallUsersAttributes ? callee : "");
        $this$writeAttributes_u24lambda_u2423.put("call_id", "");
        String string3 = transaction2.getErrorCode();
        if (string3 != null) {
            it = string3;
            boolean bl4 = false;
            $this$writeAttributes_u24lambda_u2423.put("error_code", it);
        }
        String string4 = transaction2.getErrorType();
        if (string4 != null) {
            it = string4;
            boolean bl5 = false;
            $this$writeAttributes_u24lambda_u2423.put("error_type", it);
        }
        $this$writeAttributes_u24lambda_u2423.put("retransmits", transaction2.getRetransmits());
        $this$writeAttributes_u24lambda_u2423.remove("x_call_id");
        $this$writeAttributes_u24lambda_u2423.remove("recording_mode");
        Map attributes = map2;
        AttributesRegistry attributesRegistry = this.attributesRegistry;
        if (attributesRegistry == null) {
            Intrinsics.throwUninitializedPropertyAccessException("attributesRegistry");
            attributesRegistry = null;
        }
        attributesRegistry.handle("sip", attributes);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToDatabase(@NotNull String prefix, @NotNull SipTransaction transaction2) {
        void $this$forEach$iv;
        Object object;
        void $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429;
        JsonObject jsonObject;
        JsonObject jsonObject2;
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        String collection = prefix + "_index_" + DateTimeFormatterUtilKt.format(this.timeSuffix, transaction2.getCreatedAt());
        JsonObject $this$writeToDatabase_u24lambda_u2430 = jsonObject2 = new JsonObject();
        boolean bl = false;
        JsonObject jsonObject3 = jsonObject = new JsonObject();
        String string = "document";
        JsonObject jsonObject4 = $this$writeToDatabase_u24lambda_u2430;
        boolean bl2 = false;
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("state", transaction2.getState());
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("created_at", transaction2.getCreatedAt());
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("terminated_at", transaction2.getTerminatedAt());
        Address src = transaction2.getSrcAddr();
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("src_addr", src.getAddr());
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("src_port", src.getPort());
        String string2 = src.getHost();
        if (string2 != null) {
            String it = string2;
            boolean bl3 = false;
            $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("src_host", it);
        }
        Address dst = transaction2.getDstAddr();
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("dst_addr", dst.getAddr());
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("dst_port", dst.getPort());
        String string3 = dst.getHost();
        if (string3 != null) {
            String it = string3;
            boolean bl4 = false;
            $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("dst_host", it);
        }
        if ((object = transaction2.getAttributes().remove("caller")) == null) {
            object = transaction2.getCaller();
        }
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("caller", object);
        Object object2 = transaction2.getAttributes().remove("callee");
        if (object2 == null) {
            object2 = transaction2.getCallee();
        }
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("callee", object2);
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("call_id", transaction2.getCallId());
        String string4 = transaction2.getErrorCode();
        if (string4 != null) {
            String it = string4;
            boolean bl5 = false;
            $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("error_code", it);
        }
        String string5 = transaction2.getErrorType();
        if (string5 != null) {
            String it = string5;
            boolean bl6 = false;
            $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("error_type", it);
        }
        $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put("retransmits", transaction2.getRetransmits());
        Map map2 = AttributeUtilKt.toDatabaseAttributes$default(transaction2.getAttributes(), null, 1, null);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl7 = false;
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            $this$writeToDatabase_u24lambda_u2430_u24lambda_u2429.put(name, value);
        }
        Unit unit = Unit.INSTANCE;
        jsonObject4.put(string, jsonObject);
        JsonObject document = jsonObject2;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getMongo_bulk_writer(), new Pair<CallSite, JsonObject>((CallSite)((Object)collection), document), null, 4, null);
    }

    public static final /* synthetic */ Vertx access$getVertx$p$s-2076259098(SipTransactionHandler $this) {
        return $this.vertx;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(SipTransactionHandler $this) {
        return $this.logger;
    }

    static {
        String[] stringArray = new String[]{"caller", "callee", "x_call_id", "recording_mode", "debug"};
        EXCLUDED_ATTRIBUTES = CollectionsKt.listOf(stringArray);
        PREFIX = RoutesCE.Companion.getSip() + "_transaction";
        stringArray = new String[]{"ACK", "CANCEL"};
        EXCLUDED_METHODS = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/sip3/salto/ce/sip/SipTransactionHandler$Companion;", "", "()V", "EXCLUDED_ATTRIBUTES", "", "", "getEXCLUDED_ATTRIBUTES", "()Ljava/util/List;", "EXCLUDED_METHODS", "getEXCLUDED_METHODS", "PREFIX", "getPREFIX", "()Ljava/lang/String;", "RESPONSE_DELAY", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getEXCLUDED_ATTRIBUTES() {
            return EXCLUDED_ATTRIBUTES;
        }

        @NotNull
        public final String getPREFIX() {
            return PREFIX;
        }

        @NotNull
        public final List<String> getEXCLUDED_METHODS() {
            return EXCLUDED_METHODS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

