/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.attributes;

import io.sip3.commons.domain.Attribute;
import io.sip3.commons.util.DateTimeFormatterUtilKt;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonObject;
import java.lang.invoke.CallSite;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0001J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0018J,\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/sip3/salto/ce/attributes/AttributesRegistry;", "", "vertx", "Lio/vertx/core/Vertx;", "config", "Lio/vertx/core/json/JsonObject;", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;)V", "checkPeriod", "", "currentTimeSuffix", "", "registry", "", "Lio/sip3/commons/domain/Attribute;", "timeSuffix", "Ljava/time/format/DateTimeFormatter;", "getVertx", "()Lio/vertx/core/Vertx;", "handle", "", "prefix", "key", "value", "attributes", "", "writeToDatabase", "name", "type", "option", "Companion", "sip3-salto-ce"})
public final class AttributesRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vertx vertx;
    @NotNull
    private DateTimeFormatter timeSuffix;
    private long checkPeriod;
    @NotNull
    private String currentTimeSuffix;
    @NotNull
    private final Map<String, Attribute> registry;
    @NotNull
    public static final String PREFIX = "attributes";

    public AttributesRegistry(@NotNull Vertx vertx, @NotNull JsonObject config2) {
        Object object;
        Intrinsics.checkNotNullParameter(vertx, "vertx");
        Intrinsics.checkNotNullParameter(config2, "config");
        this.vertx = vertx;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(\"yyyyMMdd\")");
        this.timeSuffix = dateTimeFormatter;
        this.checkPeriod = 5000L;
        this.registry = new LinkedHashMap();
        String string = config2.getString("time_suffix");
        if (string != null) {
            String it = string;
            boolean bl = false;
            DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern(it);
            Intrinsics.checkNotNullExpressionValue(dateTimeFormatter2, "ofPattern(it)");
            this.timeSuffix = dateTimeFormatter2;
        }
        if ((object = config2.getJsonObject(PREFIX)) != null && (object = ((JsonObject)object).getLong("check_period")) != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            this.checkPeriod = it;
        }
        this.currentTimeSuffix = DateTimeFormatterUtilKt.format(this.timeSuffix, System.currentTimeMillis());
        this.vertx.setPeriodic(this.checkPeriod, arg_0 -> AttributesRegistry._init_$lambda$2(this, arg_0));
    }

    @NotNull
    public final Vertx getVertx() {
        return this.vertx;
    }

    public final void handle(@NotNull String prefix, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(attributes, PREFIX);
        Map<String, ? extends Object> $this$forEach$iv = attributes;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> entry = element$iv = iterator2.next();
            boolean bl = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            this.handle(prefix, key, value);
        }
    }

    public final void handle(@NotNull String prefix, @NotNull String key, @NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        String name = prefix + "." + key;
        Object object = value;
        if (object instanceof String) {
            string = "string";
        } else if (object instanceof Number) {
            string = "number";
        } else if (object instanceof Boolean) {
            string = "boolean";
        } else {
            return;
        }
        String type = string;
        Attribute attribute = this.registry.get(name);
        if (attribute == null) {
            Attribute attribute2;
            Attribute $this$handle_u24lambda_u244 = attribute2 = new Attribute();
            boolean bl = false;
            $this$handle_u24lambda_u244.setName(name);
            $this$handle_u24lambda_u244.setType(type);
            attribute = attribute2;
            this.registry.put(name, attribute);
            if (!(value instanceof String) || ((CharSequence)value).length() == 0) {
                AttributesRegistry.writeToDatabase$default(this, PREFIX, name, type, null, 8, null);
                return;
            }
        }
        if (value instanceof String && ((CharSequence)value).length() > 0) {
            Set options = attribute.getOptions();
            if (options == null) {
                options = new LinkedHashSet();
                attribute.setOptions(options);
            }
            if (options.add((String)value)) {
                this.writeToDatabase(PREFIX, name, type, (String)value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeToDatabase(String prefix, String name, String type, String option) {
        JsonObject $this$writeToDatabase_u24lambda_u249_u24lambda_u248_u24lambda_u246;
        void $this$writeToDatabase_u24lambda_u249_u24lambda_u248;
        JsonObject jsonObject;
        JsonObject $this$writeToDatabase_u24lambda_u249_u24lambda_u245;
        JsonObject jsonObject2;
        JsonObject jsonObject3;
        String collection = prefix + "_" + this.currentTimeSuffix;
        JsonObject $this$writeToDatabase_u24lambda_u249 = jsonObject3 = new JsonObject();
        boolean bl = false;
        $this$writeToDatabase_u24lambda_u249.put("type", "UPDATE");
        $this$writeToDatabase_u24lambda_u249.put("upsert", true);
        JsonObject jsonObject4 = jsonObject2 = new JsonObject();
        String string = "filter";
        JsonObject jsonObject5 = $this$writeToDatabase_u24lambda_u249;
        boolean bl2 = false;
        $this$writeToDatabase_u24lambda_u249_u24lambda_u245.put("name", name);
        Unit unit = Unit.INSTANCE;
        jsonObject5.put(string, jsonObject2);
        $this$writeToDatabase_u24lambda_u249_u24lambda_u245 = jsonObject2 = new JsonObject();
        string = "document";
        jsonObject5 = $this$writeToDatabase_u24lambda_u249;
        boolean bl3 = false;
        JsonObject jsonObject6 = jsonObject = new JsonObject();
        String string2 = "$setOnInsert";
        void var19_18 = $this$writeToDatabase_u24lambda_u249_u24lambda_u248;
        boolean bl4 = false;
        $this$writeToDatabase_u24lambda_u249_u24lambda_u248_u24lambda_u246.put("type", type);
        Unit unit2 = Unit.INSTANCE;
        var19_18.put(string2, jsonObject);
        if (option != null) {
            void $this$writeToDatabase_u24lambda_u249_u24lambda_u248_u24lambda_u247;
            $this$writeToDatabase_u24lambda_u249_u24lambda_u248_u24lambda_u246 = jsonObject = new JsonObject();
            string2 = "$addToSet";
            var19_18 = $this$writeToDatabase_u24lambda_u249_u24lambda_u248;
            boolean bl5 = false;
            $this$writeToDatabase_u24lambda_u249_u24lambda_u248_u24lambda_u247.put("options", option);
            unit2 = Unit.INSTANCE;
            var19_18.put(string2, jsonObject);
        }
        unit = Unit.INSTANCE;
        jsonObject5.put(string, jsonObject2);
        JsonObject operation = jsonObject3;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getMongo_bulk_writer(), new Pair<CallSite, JsonObject>((CallSite)((Object)collection), operation), null, 4, null);
    }

    static /* synthetic */ void writeToDatabase$default(AttributesRegistry attributesRegistry, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        attributesRegistry.writeToDatabase(string, string2, string3, string4);
    }

    private static final void _init_$lambda$2(AttributesRegistry this$0, Long it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        String newTimeSuffix = DateTimeFormatterUtilKt.format(this$0.timeSuffix, System.currentTimeMillis());
        if (this$0.currentTimeSuffix.compareTo(newTimeSuffix) < 0) {
            this$0.currentTimeSuffix = newTimeSuffix;
            this$0.registry.clear();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sip3/salto/ce/attributes/AttributesRegistry$Companion;", "", "()V", "PREFIX", "", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

