/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.SIPObject;
import gov.nist.javax.sip.header.SipRequestLine;
import javax.sip.address.URI;

public class RequestLine
extends SIPObject
implements SipRequestLine {
    private static final long serialVersionUID = -3286426172326043129L;
    protected GenericURI uri;
    protected String method;
    protected String sipVersion;

    public RequestLine() {
        this.sipVersion = "SIP/2.0";
    }

    @Override
    public String encode() {
        return this.encode(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder encode(StringBuilder buffer) {
        if (this.method != null) {
            buffer.append(this.method);
            buffer.append(" ");
        }
        if (this.uri != null) {
            this.uri.encode(buffer);
            buffer.append(" ");
        }
        buffer.append(this.sipVersion);
        buffer.append("\r\n");
        return buffer;
    }

    @Override
    public GenericURI getUri() {
        return this.uri;
    }

    public RequestLine(GenericURI requestURI, String method) {
        this.uri = requestURI;
        this.method = method;
        this.sipVersion = "SIP/2.0";
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getSipVersion() {
        return this.sipVersion;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = (GenericURI)uri;
    }

    @Override
    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public void setSipVersion(String version) {
        this.sipVersion = version;
    }

    @Override
    public String getVersionMajor() {
        if (this.sipVersion == null) {
            return null;
        }
        String major = null;
        boolean slash = false;
        for (int i2 = 0; i2 < this.sipVersion.length() && this.sipVersion.charAt(i2) != '.'; ++i2) {
            if (slash) {
                major = major == null ? "" + this.sipVersion.charAt(i2) : major + this.sipVersion.charAt(i2);
            }
            if (this.sipVersion.charAt(i2) != '/') continue;
            slash = true;
        }
        return major;
    }

    @Override
    public String getVersionMinor() {
        if (this.sipVersion == null) {
            return null;
        }
        String minor = null;
        boolean dot = false;
        for (int i2 = 0; i2 < this.sipVersion.length(); ++i2) {
            if (dot) {
                minor = minor == null ? "" + this.sipVersion.charAt(i2) : minor + this.sipVersion.charAt(i2);
            }
            if (this.sipVersion.charAt(i2) != '.') continue;
            dot = true;
        }
        return minor;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        RequestLine that = (RequestLine)other;
        if (this.method == null ? that.method != null : !this.method.equals(that.method)) {
            return false;
        }
        if (this.sipVersion == null ? that.sipVersion != null : !this.sipVersion.equals(that.sipVersion)) {
            return false;
        }
        return !(this.uri == null ? that.uri != null : !this.uri.equals(that.uri));
    }

    @Override
    public Object clone() {
        RequestLine retval = (RequestLine)super.clone();
        if (this.uri != null) {
            retval.uri = (GenericURI)this.uri.clone();
        }
        return retval;
    }
}

