/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control.messages;

import java.io.PrintWriter;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.syntax.CSTNode;

public class LocatedMessage
extends SimpleMessage {
    private CSTNode context;

    public LocatedMessage(String message, CSTNode context, SourceUnit source2) {
        super(message, source2);
        this.context = context;
    }

    public LocatedMessage(String message, Object data, CSTNode context, SourceUnit source2) {
        super(message, data, source2);
        this.context = context;
    }

    public CSTNode getContext() {
        return this.context;
    }

    @Override
    public void write(PrintWriter writer, Janitor janitor) {
        if (this.owner instanceof SourceUnit) {
            int column;
            SourceUnit source2 = (SourceUnit)this.owner;
            String name = source2.getName();
            int line = this.context.getStartLine();
            String sample2 = source2.getSample(line, column = this.context.getStartColumn(), janitor);
            if (sample2 != null) {
                writer.println(source2.getSample(line, column, janitor));
            }
            writer.println(name + ": " + line + ": " + this.message);
            writer.println("");
        } else {
            writer.println("<No Relevant Source>: " + this.message);
            writer.println("");
        }
    }
}

