/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.codec.json.JsonObjectCodec;
import io.vertx.ext.mongo.impl.config.ClusterSettingsParser;
import io.vertx.ext.mongo.impl.config.CompressorListParser;
import io.vertx.ext.mongo.impl.config.ConnectionPoolSettingsParser;
import io.vertx.ext.mongo.impl.config.CredentialListParser;
import io.vertx.ext.mongo.impl.config.ReadConcernLevelParser;
import io.vertx.ext.mongo.impl.config.ReadPreferenceParser;
import io.vertx.ext.mongo.impl.config.SSLSettingsParser;
import io.vertx.ext.mongo.impl.config.ServerSettingsParser;
import io.vertx.ext.mongo.impl.config.SocketSettingsParser;
import io.vertx.ext.mongo.impl.config.StreamTypeParser;
import io.vertx.ext.mongo.impl.config.WriteConcernParser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bson.codecs.BooleanCodec;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.DoubleCodec;
import org.bson.codecs.IntegerCodec;
import org.bson.codecs.LongCodec;
import org.bson.codecs.StringCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class MongoClientOptionsParser {
    private static final CodecRegistry commonCodecRegistry = CodecRegistries.fromCodecs(new StringCodec(), new IntegerCodec(), new BooleanCodec(), new DoubleCodec(), new LongCodec(), new BsonDocumentCodec(), new DocumentCodec());
    private final MongoClientSettings settings;
    private final String database;

    public MongoClientOptionsParser(Vertx vertx, JsonObject config2) {
        ReadPreference readPreference;
        ReadConcern readConcern;
        Objects.requireNonNull(config2);
        MongoClientSettings.Builder options = MongoClientSettings.builder();
        options.codecRegistry(CodecRegistries.fromRegistries(commonCodecRegistry, CodecRegistries.fromCodecs(new JsonObjectCodec(config2))));
        String cs = config2.getString("connection_string");
        ConnectionString connectionString = cs == null ? null : new ConnectionString(cs);
        String csDatabase = connectionString != null ? connectionString.getDatabase() : null;
        this.database = config2.getString("db_name", csDatabase != null ? csDatabase : "DEFAULT_DB");
        ClusterSettings clusterSettings = new ClusterSettingsParser(connectionString, config2).settings();
        options.applyToClusterSettings(builder -> builder.applySettings(clusterSettings));
        ConnectionPoolSettings connectionPoolSettings = new ConnectionPoolSettingsParser(connectionString, config2).settings();
        options.applyToConnectionPoolSettings(builder -> builder.applySettings(connectionPoolSettings));
        List<MongoCredential> credentials = new CredentialListParser(connectionString, config2).credentials();
        if (!credentials.isEmpty()) {
            options.credential(credentials.get(credentials.size() - 1));
        }
        SocketSettings socketSettings = new SocketSettingsParser(connectionString, config2).settings();
        options.applyToSocketSettings(builder -> builder.applySettings(socketSettings));
        new StreamTypeParser(config2).streamFactory().ifPresent(options::streamFactoryFactory);
        SslSettings sslSettings = new SSLSettingsParser(connectionString, config2).settings(vertx);
        options.applyToSslSettings(builder -> builder.applySettings(sslSettings));
        WriteConcern writeConcern = new WriteConcernParser(connectionString, config2).writeConcern();
        if (writeConcern != null) {
            options.writeConcern(writeConcern);
        }
        if ((readConcern = new ReadConcernLevelParser(connectionString, config2).readConcern()) != null) {
            options.readConcern(readConcern);
        }
        if ((readPreference = new ReadPreferenceParser(connectionString, config2).readPreference()) != null) {
            options.readPreference(readPreference);
        }
        ServerSettings serverSettings = new ServerSettingsParser(config2).settings();
        options.applyToServerSettings(builder -> builder.applySettings(serverSettings));
        List<MongoCompressor> compressorList = new CompressorListParser(connectionString, config2).compressorList();
        if (compressorList != null) {
            options.compressorList(compressorList);
        }
        this.applyRetryableSetting(options, connectionString, config2);
        this.settings = options.build();
    }

    public void applyRetryableSetting(MongoClientSettings.Builder options, ConnectionString connectionString, JsonObject config2) {
        Boolean retryReads;
        Boolean retryWrites = Optional.ofNullable(connectionString).flatMap(cs -> Optional.ofNullable(cs.getRetryWritesValue())).orElse(config2.getBoolean("retryWrites"));
        if (retryWrites != null) {
            options.retryWrites(retryWrites);
        }
        if ((retryReads = Optional.ofNullable(connectionString).flatMap(cs -> Optional.ofNullable(cs.getRetryReads())).orElse(config2.getBoolean("retryReads"))) != null) {
            options.retryReads(retryReads);
        }
    }

    public MongoClientSettings settings() {
        return this.settings;
    }

    public String database() {
        return this.database;
    }
}

