/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.Authorizations;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AuthorizationsImpl
implements Authorizations {
    private final Map<String, Set<Authorization>> authorizations = new ConcurrentHashMap<String, Set<Authorization>>();

    @Override
    public Authorizations add(String providerId, Authorization authorization) {
        Objects.requireNonNull(authorization);
        return this.add(providerId, Collections.singleton(authorization));
    }

    @Override
    public Authorizations add(String providerId, Set<Authorization> authorizations) {
        Objects.requireNonNull(providerId);
        Objects.requireNonNull(authorizations);
        ConcurrentHashMap.KeySetView<Authorization, Boolean> concurrentAuthorizations = ConcurrentHashMap.newKeySet();
        concurrentAuthorizations.addAll((Collection<Authorization>)authorizations);
        this.getOrCreateAuthorizations(providerId).addAll(concurrentAuthorizations);
        return this;
    }

    @Override
    public Authorizations clear(String providerId) {
        Objects.requireNonNull(providerId);
        this.authorizations.remove(providerId);
        return this;
    }

    @Override
    public Authorizations clear() {
        this.authorizations.clear();
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthorizationsImpl)) {
            return false;
        }
        AuthorizationsImpl other = (AuthorizationsImpl)obj;
        return this.authorizations.equals(other.authorizations);
    }

    @Override
    public Set<Authorization> get(String providerId) {
        Objects.requireNonNull(providerId);
        Set<Authorization> set = this.authorizations.get(providerId);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    private Set<Authorization> getOrCreateAuthorizations(String providerId) {
        return this.authorizations.computeIfAbsent(providerId, k -> ConcurrentHashMap.newKeySet());
    }

    @Override
    public Set<String> getProviderIds() {
        return this.authorizations.keySet();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.authorizations.hashCode();
        return result2;
    }
}

