/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConversionHelper {
    public static Object toObject(Object obj) {
        if (obj instanceof Map) {
            return ConversionHelper.toJsonObject((Map)obj);
        }
        if (obj instanceof List) {
            return ConversionHelper.toJsonArray((List)obj);
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        return obj;
    }

    private static Object toJsonElement(Object obj) {
        if (obj instanceof Map) {
            return ConversionHelper.toJsonObject((Map)obj);
        }
        if (obj instanceof List) {
            return ConversionHelper.toJsonArray((List)obj);
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        if (obj instanceof Buffer) {
            return JsonUtil.BASE64_ENCODER.encodeToString(((Buffer)obj).getBytes());
        }
        return obj;
    }

    public static JsonObject toJsonObject(Map<String, Object> map2) {
        if (map2 == null) {
            return null;
        }
        map2 = new LinkedHashMap<String, Object>(map2);
        map2.entrySet().forEach(e -> e.setValue(ConversionHelper.toJsonElement(e.getValue())));
        return new JsonObject(map2);
    }

    public static JsonArray toJsonArray(List<Object> list) {
        if (list == null) {
            return null;
        }
        list = new ArrayList<Object>(list);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            list.set(i2, ConversionHelper.toJsonElement(list.get(i2)));
        }
        return new JsonArray(list);
    }

    public static <T> T fromObject(Object obj) {
        if (obj instanceof JsonObject) {
            return (T)ConversionHelper.fromJsonObject((JsonObject)obj);
        }
        if (obj instanceof JsonArray) {
            return (T)ConversionHelper.fromJsonArray((JsonArray)obj);
        }
        if (obj instanceof Instant) {
            return (T)DateTimeFormatter.ISO_INSTANT.format((Instant)obj);
        }
        if (obj instanceof byte[]) {
            return (T)JsonUtil.BASE64_ENCODER.encodeToString((byte[])obj);
        }
        if (obj instanceof Enum) {
            return (T)((Enum)obj).name();
        }
        return (T)obj;
    }

    public static Map<String, Object> fromJsonObject(JsonObject json) {
        if (json == null) {
            return null;
        }
        LinkedHashMap<String, Object> map2 = new LinkedHashMap<String, Object>(json.getMap());
        map2.entrySet().forEach(entry -> entry.setValue(ConversionHelper.fromObject(entry.getValue())));
        return map2;
    }

    public static List<Object> fromJsonArray(JsonArray json) {
        if (json == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(json.getList());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            list.set(i2, ConversionHelper.fromObject(list.get(i2)));
        }
        return list;
    }
}

