/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.rtpr;

import io.sip3.commons.domain.payload.RtpReportPayload;
import io.sip3.commons.util.DateTimeFormatterUtilKt;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.rtpr.RtprBulkWriter;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Counter;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\r2\n\u0010\u001a\u001a\u00060\u000eR\u00020\u0000H\u0002J\u001c\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\r2\n\u0010\u001a\u001a\u00060\u000eR\u00020\u0000H\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u001c\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\r2\n\u0010\u001a\u001a\u00060\u000eR\u00020\u0000H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u000eR\u00020\u00000\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u000eR\u00020\u00000\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/sip3/salto/ce/rtpr/RtprBulkWriter;", "Lio/vertx/core/AbstractVerticle;", "()V", "aggregationTimeout", "", "bulkPacketLimit", "", "expirationDelay", "instances", "logger", "Lmu/KLogger;", "rtcp", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "", "Lio/sip3/salto/ce/rtpr/RtprBulkWriter$RtprBulk;", "rtp", "timeSuffix", "Ljava/time/format/DateTimeFormatter;", "handle", "", "packet", "Lio/sip3/salto/ce/domain/Packet;", "report", "Lio/sip3/commons/domain/payload/RtpReportPayload;", "onExpire", "source", "bulk", "onRemain", "route", "start", "writeToDatabase", "prefix", "RtprBulk", "sip3-salto-ce"})
public class RtprBulkWriter
extends AbstractVerticle {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private DateTimeFormatter timeSuffix;
    private long expirationDelay;
    private long aggregationTimeout;
    private int bulkPacketLimit;
    private int instances;
    private PeriodicallyExpiringHashMap<String, RtprBulk> rtp;
    private PeriodicallyExpiringHashMap<String, RtprBulk> rtcp;

    public RtprBulkWriter() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(\"yyyyMMdd\")");
        this.timeSuffix = dateTimeFormatter;
        this.expirationDelay = 4000L;
        this.aggregationTimeout = 30000L;
        this.bulkPacketLimit = 1024;
        this.instances = 1;
    }

    @Override
    public void start() {
        Object object;
        JsonObject jsonObject;
        String string = this.config().getString("time_suffix");
        if (string != null) {
            String it = string;
            boolean bl = false;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(it);
            Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(it)");
            this.timeSuffix = dateTimeFormatter;
        }
        if ((jsonObject = this.config().getJsonObject("media")) != null && (jsonObject = jsonObject.getJsonObject("rtp_r")) != null) {
            long it;
            Number number;
            JsonObject config2 = jsonObject;
            boolean bl = false;
            Long l = number = config2.getLong("expiration_delay");
            if (l != null) {
                Intrinsics.checkNotNullExpressionValue(l, "getLong(\"expiration_delay\")");
                it = ((Number)number).longValue();
                boolean bl2 = false;
                this.expirationDelay = it;
            }
            Long l2 = number = config2.getLong("aggregation_timeout");
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue(l2, "getLong(\"aggregation_timeout\")");
                it = ((Number)number).longValue();
                boolean bl3 = false;
                this.aggregationTimeout = it;
            }
            Number number2 = number = config2.getInteger("bulk_packet_limit");
            if (number2 != null) {
                Intrinsics.checkNotNullExpressionValue(number2, "getInteger(\"bulk_packet_limit\")");
                int it2 = ((Number)number).intValue();
                boolean bl4 = false;
                this.bulkPacketLimit = it2;
            }
        }
        if ((object = this.config().getJsonObject("vertx")) != null && (object = ((JsonObject)object).getInteger("instances")) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            this.instances = it;
        }
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, RtprBulk, Long>(this){
            final /* synthetic */ RtprBulkWriter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull RtprBulk bulk) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(bulk, "bulk");
                return bulk.getUpdatedAt() + RtprBulkWriter.access$getAggregationTimeout$p(this.this$0);
            }
        }).onRemain((Function2)new Function2<String, RtprBulk, Unit>(this){
            final /* synthetic */ RtprBulkWriter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull RtprBulk bulk) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(bulk, "bulk");
                RtprBulkWriter.access$onRemain(this.this$0, "rtp", bulk);
            }
        }).onExpire((Function2)new Function2<String, RtprBulk, Unit>(this){
            final /* synthetic */ RtprBulkWriter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull RtprBulk bulk) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(bulk, "bulk");
                RtprBulkWriter.access$onExpire(this.this$0, "rtp", bulk);
            }
        });
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
        this.rtp = builder.build(vertx);
        PeriodicallyExpiringHashMap.Builder builder2 = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, RtprBulk, Long>(this){
            final /* synthetic */ RtprBulkWriter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull RtprBulk bulk) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(bulk, "bulk");
                return bulk.getUpdatedAt() + RtprBulkWriter.access$getAggregationTimeout$p(this.this$0);
            }
        }).onRemain((Function2)new Function2<String, RtprBulk, Unit>(this){
            final /* synthetic */ RtprBulkWriter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull RtprBulk bulk) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(bulk, "bulk");
                RtprBulkWriter.access$onRemain(this.this$0, "rtcp", bulk);
            }
        }).onExpire((Function2)new Function2<String, RtprBulk, Unit>(this){
            final /* synthetic */ RtprBulkWriter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull RtprBulk bulk) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(bulk, "bulk");
                RtprBulkWriter.access$onExpire(this.this$0, "rtcp", bulk);
            }
        });
        Vertx vertx2 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx2, "vertx");
        this.rtcp = builder2.build(vertx2);
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getRtpr() + "_bulk_writer", arg_0 -> RtprBulkWriter.start$lambda$6(this, arg_0));
        CoroutineScope coroutineScope = GlobalScope.INSTANCE;
        Vertx vertx3 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx3, "vertx");
        CoroutineDispatcher coroutineDispatcher = VertxCoroutineKt.dispatcher(vertx3);
        Intrinsics.checkNotNull(coroutineDispatcher, "null cannot be cast to non-null type kotlin.coroutines.CoroutineContext");
        BuildersKt.launch$default(coroutineScope, coroutineDispatcher, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ RtprBulkWriter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        v0 = RtprBulkWriter.access$getVertx$p$s1616290601(this.this$0).sharedData().getLocalCounter(RoutesCE.Companion.getRtpr() + "_bulk_writer");
                        Intrinsics.checkNotNullExpressionValue(v0, "vertx.sharedData().getLo\u2026CE.rtpr + \"_bulk_writer\")");
                        this.label = 1;
                        v1 = VertxCoroutineKt.coAwait(v0, this);
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        index = (Counter)v1;
                        var5_4 = RoutesCE.Companion.getRtpr();
                        var4_5 = RtprBulkWriter.access$getVertx$p$s1616290601(this.this$0).eventBus();
                        var3_6 = index.getAndIncrement();
                        Intrinsics.checkNotNullExpressionValue(var3_6, "index.andIncrement");
                        this.L$0 = var4_5;
                        this.L$1 = var5_4;
                        this.label = 2;
                        v2 = VertxCoroutineKt.coAwait(var3_6, this);
                        if (v2 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        var5_4 = (String)this.L$1;
                        var4_5 = (EventBus)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        var6_7 = v2;
                        var4_5.localConsumer(var5_4 + "_bulk_writer_" + var6_7, (Handler<Message<T>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$0(io.sip3.salto.ce.rtpr.RtprBulkWriter io.vertx.core.eventbus.Message ), (Lio/vertx/core/eventbus/Message;)V)((RtprBulkWriter)this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(RtprBulkWriter this$0, Message event) {
                try {
                    Pair pair = (Pair)event.body();
                    Packet packet = (Packet)pair.component1();
                    RtpReportPayload report = (RtpReportPayload)pair.component2();
                    RtprBulkWriter.access$handle(this$0, packet, report);
                }
                catch (Exception e) {
                    RtprBulkWriter.access$getLogger$p(this$0).error(e, (Function0<? extends Object>)start.1.1.INSTANCE);
                }
            }
        }, 2, null);
    }

    private final void onRemain(String source2, RtprBulk bulk) {
        if (bulk.getExpectedPackets() >= this.bulkPacketLimit) {
            this.writeToDatabase("rtpr_" + source2 + "_raw", bulk);
            bulk.clear();
        }
    }

    private final void onExpire(String source2, RtprBulk bulk) {
        if (bulk.getExpectedPackets() > 0) {
            this.writeToDatabase("rtpr_" + source2 + "_raw", bulk);
        }
    }

    public void route(@NotNull Packet packet, @NotNull RtpReportPayload report) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(report, "report");
        int index = Integer.hashCode(packet.getSrcAddr().getPort() + packet.getDstAddr().getPort()) % this.instances;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRtpr() + "_bulk_writer_" + index, new Pair<Packet, RtpReportPayload>(packet, report), null, 4, null);
    }

    private final void handle(Packet packet, RtpReportPayload report) {
        PeriodicallyExpiringHashMap<String, RtprBulk> periodicallyExpiringHashMap;
        String bulkId = packet.getSrcAddr().getPort() + ":" + packet.getDstAddr().getPort() + ":" + report.getCallId();
        byte by = report.getSource();
        if (by == 0) {
            periodicallyExpiringHashMap = this.rtp;
            if (periodicallyExpiringHashMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException("rtp");
                periodicallyExpiringHashMap = null;
            }
        } else if (by == 1) {
            periodicallyExpiringHashMap = this.rtcp;
            if (periodicallyExpiringHashMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException("rtcp");
                periodicallyExpiringHashMap = null;
            }
        } else {
            throw new IllegalArgumentException("Unsupported RTP Report source: '" + report.getSource() + "'");
        }
        PeriodicallyExpiringHashMap<String, RtprBulk> bulks = periodicallyExpiringHashMap;
        RtprBulk rtprBulk2 = bulks.getOrPut(bulkId, new Function0<RtprBulk>(this, packet){
            final /* synthetic */ RtprBulkWriter this$0;
            final /* synthetic */ Packet $packet;
            {
                this.this$0 = $receiver;
                this.$packet = $packet;
                super(0);
            }

            @NotNull
            public final RtprBulk invoke() {
                return this.this$0.new RtprBulk(this.$packet.getSrcAddr(), this.$packet.getDstAddr());
            }
        });
        rtprBulk2.add(report);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToDatabase(@NotNull String prefix, @NotNull RtprBulk bulk) {
        List list;
        void $this$mapTo$iv$iv;
        void $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415;
        JsonObject jsonObject;
        JsonObject jsonObject2;
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(bulk, "bulk");
        RtpReportPayload firstReport = CollectionsKt.first(bulk.getReports());
        String collection = prefix + "_" + DateTimeFormatterUtilKt.format(this.timeSuffix, firstReport.getCreatedAt());
        JsonObject $this$writeToDatabase_u24lambda_u2416 = jsonObject2 = new JsonObject();
        boolean bl = false;
        JsonObject jsonObject3 = jsonObject = new JsonObject();
        String string = "document";
        JsonObject jsonObject4 = $this$writeToDatabase_u24lambda_u2416;
        boolean bl2 = false;
        $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415.put("reported_at", firstReport.getReportedAt());
        $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415.put("created_at", firstReport.getCreatedAt());
        String string2 = firstReport.getCallId();
        if (string2 != null) {
            String it = string2;
            boolean bl3 = false;
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415.put("call_id", it);
        }
        Address src = bulk.getSrcAddr();
        $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415.put("src_addr", src.getAddr());
        $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415.put("src_port", src.getPort());
        String string3 = src.getHost();
        if (string3 != null) {
            String it = string3;
            boolean bl4 = false;
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415.put("src_host", it);
        }
        Address dst = bulk.getDstAddr();
        $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415.put("dst_addr", dst.getAddr());
        $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415.put("dst_port", dst.getPort());
        String string4 = dst.getHost();
        if (string4 != null) {
            String it = string4;
            boolean bl5 = false;
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415.put("dst_host", it);
        }
        Iterable $this$map$iv = bulk.getReports();
        boolean $i$f$map = false;
        Iterable it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411;
            JsonObject $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410;
            JsonObject jsonObject5;
            void report;
            JsonObject jsonObject6;
            RtpReportPayload rtpReportPayload = (RtpReportPayload)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl6 = false;
            JsonObject $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412 = jsonObject6 = new JsonObject();
            boolean bl7 = false;
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.put("reported_at", report.getReportedAt());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.put("created_at", report.getCreatedAt());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.put("payload_type", report.getPayloadType());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.put("ssrc", report.getSsrc());
            Object object = report.getCodecName();
            if (object == null) {
                object = "UNDEFINED(" + report.getPayloadType() + ")";
            }
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.put("codec", object);
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.put("duration", report.getDuration());
            JsonObject jsonObject7 = jsonObject5 = new JsonObject();
            String string5 = "packets";
            JsonObject jsonObject8 = $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412;
            boolean bl8 = false;
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410.put("expected", report.getExpectedPacketCount());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410.put("received", report.getReceivedPacketCount());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410.put("lost", report.getLostPacketCount());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410.put("rejected", report.getRejectedPacketCount());
            Unit unit = Unit.INSTANCE;
            jsonObject8.put(string5, jsonObject5);
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410 = jsonObject5 = new JsonObject();
            string5 = "jitter";
            jsonObject8 = $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412;
            boolean bl9 = false;
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.put("last", report.getLastJitter());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.put("avg", report.getAvgJitter());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.put("min", report.getMinJitter());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.put("max", report.getMaxJitter());
            unit = Unit.INSTANCE;
            jsonObject8.put(string5, jsonObject5);
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.put("r_factor", report.getRFactor());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.put("mos", report.getMos());
            $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.put("fraction_lost", report.getFractionLost());
            collection2.add(jsonObject6);
        }
        List it2 = list = (List)destination$iv$iv;
        boolean bl10 = false;
        $this$writeToDatabase_u24lambda_u2416_u24lambda_u2415.put("reports", it2);
        Unit unit = Unit.INSTANCE;
        jsonObject4.put(string, jsonObject);
        JsonObject operation = jsonObject2;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getMongo_bulk_writer(), new Pair<CallSite, JsonObject>((CallSite)((Object)collection), operation), null, 4, null);
    }

    private static final void start$lambda$6(RtprBulkWriter this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            Pair pair = (Pair)event.body();
            Packet packet = (Packet)pair.component1();
            RtpReportPayload report = (RtpReportPayload)pair.component2();
            this$0.route(packet, report);
        }
        catch (Exception e) {
            this$0.logger.error(e, (Function0<? extends Object>)start.10.1.INSTANCE);
        }
    }

    public static final /* synthetic */ long access$getAggregationTimeout$p(RtprBulkWriter $this) {
        return $this.aggregationTimeout;
    }

    public static final /* synthetic */ void access$onRemain(RtprBulkWriter $this, String source2, RtprBulk bulk) {
        $this.onRemain(source2, bulk);
    }

    public static final /* synthetic */ void access$onExpire(RtprBulkWriter $this, String source2, RtprBulk bulk) {
        $this.onExpire(source2, bulk);
    }

    public static final /* synthetic */ Vertx access$getVertx$p$s1616290601(RtprBulkWriter $this) {
        return $this.vertx;
    }

    public static final /* synthetic */ void access$handle(RtprBulkWriter $this, Packet packet, RtpReportPayload report) {
        $this.handle(packet, report);
    }

    public static final /* synthetic */ KLogger access$getLogger$p(RtprBulkWriter $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010J\u0006\u0010\u001d\u001a\u00020\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lio/sip3/salto/ce/rtpr/RtprBulkWriter$RtprBulk;", "", "srcAddr", "Lio/sip3/salto/ce/domain/Address;", "dstAddr", "(Lio/sip3/salto/ce/rtpr/RtprBulkWriter;Lio/sip3/salto/ce/domain/Address;Lio/sip3/salto/ce/domain/Address;)V", "getDstAddr", "()Lio/sip3/salto/ce/domain/Address;", "expectedPackets", "", "getExpectedPackets", "()I", "setExpectedPackets", "(I)V", "reports", "", "Lio/sip3/commons/domain/payload/RtpReportPayload;", "getReports", "()Ljava/util/List;", "getSrcAddr", "updatedAt", "", "getUpdatedAt", "()J", "setUpdatedAt", "(J)V", "add", "", "report", "clear", "sip3-salto-ce"})
    public final class RtprBulk {
        @NotNull
        private final Address srcAddr;
        @NotNull
        private final Address dstAddr;
        private long updatedAt;
        @NotNull
        private final List<RtpReportPayload> reports;
        private int expectedPackets;

        public RtprBulk(@NotNull Address srcAddr, Address dstAddr) {
            Intrinsics.checkNotNullParameter(srcAddr, "srcAddr");
            Intrinsics.checkNotNullParameter(dstAddr, "dstAddr");
            this.srcAddr = srcAddr;
            this.dstAddr = dstAddr;
            this.updatedAt = System.currentTimeMillis();
            this.reports = new ArrayList();
        }

        @NotNull
        public final Address getSrcAddr() {
            return this.srcAddr;
        }

        @NotNull
        public final Address getDstAddr() {
            return this.dstAddr;
        }

        public final long getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(long l) {
            this.updatedAt = l;
        }

        @NotNull
        public final List<RtpReportPayload> getReports() {
            return this.reports;
        }

        public final int getExpectedPackets() {
            return this.expectedPackets;
        }

        public final void setExpectedPackets(int n) {
            this.expectedPackets = n;
        }

        public final void add(@NotNull RtpReportPayload report) {
            Intrinsics.checkNotNullParameter(report, "report");
            this.reports.add(report);
            this.expectedPackets += report.getExpectedPacketCount();
            this.updatedAt = System.currentTimeMillis();
        }

        public final void clear() {
            this.reports.clear();
            this.expectedPackets = 0;
            this.updatedAt = System.currentTimeMillis();
        }
    }
}

